; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-linux-gnu < %s 2>&1 | FileCheck %s --check-prefix=X86ASM

%struct.T = type { i32, i32 }

define i32 @freeze_int() {
; X86ASM-LABEL: freeze_int:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    imull %eax, %eax
; X86ASM-NEXT:    retq
  %y1 = freeze i32 undef
  %t1 = mul i32 %y1, %y1
  ret i32 %t1
}

define i5 @freeze_int2() {
; X86ASM-LABEL: freeze_int2:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    mulb %al
; X86ASM-NEXT:    retq
  %y1 = freeze i5 undef
  %t1 = mul i5 %y1, %y1
  ret i5 %t1
}

define float @freeze_float() {
; X86ASM-LABEL: freeze_float:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    addss %xmm0, %xmm0
; X86ASM-NEXT:    retq
  %y1 = freeze float undef
  %t1 = fadd float %y1, %y1
  ret float %t1
}

define half @freeze_half() {
; X86ASM-LABEL: freeze_half:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    pushq %rax
; X86ASM-NEXT:    .cfi_def_cfa_offset 16
; X86ASM-NEXT:    callq __extendhfsf2@PLT
; X86ASM-NEXT:    addss %xmm0, %xmm0
; X86ASM-NEXT:    callq __truncsfhf2@PLT
; X86ASM-NEXT:    popq %rax
; X86ASM-NEXT:    .cfi_def_cfa_offset 8
; X86ASM-NEXT:    retq
  %y1 = freeze half undef
  %t1 = fadd half %y1, %y1
  ret half %t1
}

define <2 x i32> @freeze_ivec() {
; X86ASM-LABEL: freeze_ivec:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    paddd %xmm0, %xmm0
; X86ASM-NEXT:    retq
  %y1 = freeze <2 x i32> undef
  %t1 = add <2 x i32> %y1, %y1
  ret <2 x i32> %t1
}

define ptr @freeze_ptr() {
; X86ASM-LABEL: freeze_ptr:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    addq $4, %rax
; X86ASM-NEXT:    retq
  %y1 = freeze ptr undef
  %t1 = getelementptr i8, ptr %y1, i64 4
  ret ptr %t1
}

define i32 @freeze_struct() {
; X86ASM-LABEL: freeze_struct:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    addl %eax, %eax
; X86ASM-NEXT:    retq
  %y1 = freeze %struct.T undef
  %v1 = extractvalue %struct.T %y1, 0
  %v2 = extractvalue %struct.T %y1, 1
  %t1 = add i32 %v1, %v2
  ret i32 %t1
}

define i32 @freeze_anonstruct() {
; X86ASM-LABEL: freeze_anonstruct:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    addl %eax, %eax
; X86ASM-NEXT:    retq
  %y1 = freeze {i32, i32} undef
  %v1 = extractvalue {i32, i32} %y1, 0
  %v2 = extractvalue {i32, i32} %y1, 1
  %t1 = add i32 %v1, %v2
  ret i32 %t1
}

define i32 @freeze_anonstruct2() {
; X86ASM-LABEL: freeze_anonstruct2:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    movzwl %ax, %eax
; X86ASM-NEXT:    addl %eax, %eax
; X86ASM-NEXT:    retq
  %y1 = freeze {i32, i16} undef
  %v1 = extractvalue {i32, i16} %y1, 0
  %v2 = extractvalue {i32, i16} %y1, 1
  %z2 = zext i16 %v2 to i32
  %t1 = add i32 %v1, %z2
  ret i32 %t1
}

define i64 @freeze_array() {
; X86ASM-LABEL: freeze_array:
; X86ASM:       # %bb.0:
; X86ASM-NEXT:    addq %rax, %rax
; X86ASM-NEXT:    retq
  %y1 = freeze [2 x i64] undef
  %v1 = extractvalue [2 x i64] %y1, 0
  %v2 = extractvalue [2 x i64] %y1, 1
  %t1 = add i64 %v1, %v2
  ret i64 %t1
}

; Make sure we emit a movl to zext the input before the imulq. This previously
; failed because freeze was not listed in the instructions that don't zext their
; result in the def32 pattern X86InstrCompiler.td.
define i32 @freeze_zext(i64 %a) nounwind {
; X86ASM-LABEL: freeze_zext:
; X86ASM:       # %bb.0: # %entry
; X86ASM-NEXT:    movq %rdi, %rax
; X86ASM-NEXT:    movl %eax, %ecx
; X86ASM-NEXT:    movl $3435973837, %edx # imm = 0xCCCCCCCD
; X86ASM-NEXT:    imulq %rcx, %rdx
; X86ASM-NEXT:    shrq $35, %rdx
; X86ASM-NEXT:    addl %edx, %edx
; X86ASM-NEXT:    leal (%rdx,%rdx,4), %ecx
; X86ASM-NEXT:    subl %ecx, %eax
; X86ASM-NEXT:    # kill: def $eax killed $eax killed $rax
; X86ASM-NEXT:    retq
entry:
  %x = trunc i64 %a to i32
  %y = freeze i32 %x
  %z = urem i32 %y, 10
  ret i32 %z
}
