; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv6m-none-eabi %s -o - | FileCheck %s -check-prefix=CHECK -check-prefix=CHECK-T1
; RUN: llc -mtriple=thumbv7m-none-eabi %s -o - | FileCheck %s -check-prefix=CHECK -check-prefix=CHECK-T2
; RUN: llc -mtriple=armv7a-none-eabi %s -o - | FileCheck %s -check-prefix=CHECK -check-prefix=CHECK-ARM

define ptr @i32_0(ptr %p, i32 %v) {
; CHECK-LABEL: i32_0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    str r1, [r0]
; CHECK-NEXT:    bx lr
  store i32 %v, ptr %p, align 4
  ret ptr %p
}

define ptr @i32_3(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_3:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #3
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, #3
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_3:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #3]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_3:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #3]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 3
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_4(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    str r1, [r0, #4]
; CHECK-T1-NEXT:    adds r0, r0, #4
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #4]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #4]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_8(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_8:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    str r1, [r0, #8]
; CHECK-T1-NEXT:    adds r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_8:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #8]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_8:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #8]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 8
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_m1(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_m1:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, r0, #1
; CHECK-T1-NEXT:    str r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_m1:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #-1]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_m1:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #-1]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -1
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_m4(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_m4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, r0, #4
; CHECK-T1-NEXT:    str r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_m4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #-4]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_m4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #-4]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_252(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_252:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #252
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, #252
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_252:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #252]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_252:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #252]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 252
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_255(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_255:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #255
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, #255
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_255:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #255]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_255:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #255]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 255
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_256(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_256:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #1
; CHECK-T1-NEXT:    lsls r2, r2, #8
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_256:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str.w r1, [r0, #256]
; CHECK-T2-NEXT:    add.w r0, r0, #256
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_256:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #256]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 256
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_m252(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_m252:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, #252
; CHECK-T1-NEXT:    str r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_m252:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #-252]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_m252:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #-252]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -252
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_m255(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_m255:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, #255
; CHECK-T1-NEXT:    str r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_m255:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r1, [r0, #-255]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_m255:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #-255]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -255
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_m256(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_m256:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #255
; CHECK-T1-NEXT:    mvns r2, r2
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_m256:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    mvn r2, #255
; CHECK-T2-NEXT:    str r1, [r0, r2]
; CHECK-T2-NEXT:    sub.w r0, r0, #256
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_m256:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #-256]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -256
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_4095(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_4095:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI12_0
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI12_0:
; CHECK-T1-NEXT:    .long 4095 @ 0xfff
;
; CHECK-T2-LABEL: i32_4095:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str.w r1, [r0, #4095]
; CHECK-T2-NEXT:    addw r0, r0, #4095
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_4095:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #4095]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4095
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_4096(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_4096:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #1
; CHECK-T1-NEXT:    lsls r2, r2, #12
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i32_4096:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    mov.w r2, #4096
; CHECK-T2-NEXT:    str r1, [r0, r2]
; CHECK-T2-NEXT:    add.w r0, r0, #4096
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_4096:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    mov r2, #4096
; CHECK-ARM-NEXT:    str r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4096
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_m4095(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_m4095:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI14_0
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI14_0:
; CHECK-T1-NEXT:    .long 4294963201 @ 0xfffff001
;
; CHECK-T2-LABEL: i32_m4095:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r2, #61441
; CHECK-T2-NEXT:    movt r2, #65535
; CHECK-T2-NEXT:    str r1, [r0, r2]
; CHECK-T2-NEXT:    subw r0, r0, #4095
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_m4095:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r1, [r0, #-4095]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4095
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i32_m4096(ptr %p, i32 %v) {
; CHECK-T1-LABEL: i32_m4096:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI15_0
; CHECK-T1-NEXT:    str r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI15_0:
; CHECK-T1-NEXT:    .long 4294963200 @ 0xfffff000
;
; CHECK-T2-LABEL: i32_m4096:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r2, #61440
; CHECK-T2-NEXT:    movt r2, #65535
; CHECK-T2-NEXT:    str r1, [r0, r2]
; CHECK-T2-NEXT:    sub.w r0, r0, #4096
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i32_m4096:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    movw r2, #61440
; CHECK-ARM-NEXT:    movt r2, #65535
; CHECK-ARM-NEXT:    str r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4096
  store i32 %v, ptr %o, align 4
  ret ptr %o
}

define ptr @i64_0(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_0:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    stm r0!, {r2, r3}
; CHECK-T1-NEXT:    subs r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_0:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strd r2, r3, [r0]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_0:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    mov r1, r3
; CHECK-ARM-NEXT:    str r2, [r0]
; CHECK-ARM-NEXT:    str r1, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  store i64 %v, ptr %p, align 8
  ret ptr %p
}

define ptr @i64_3(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_3:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r1, #3
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, r0, #3
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_3:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #3]!
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_3:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #3]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 3
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_4(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    str r2, [r0, #4]
; CHECK-T1-NEXT:    str r3, [r0, #8]
; CHECK-T1-NEXT:    adds r0, r0, #4
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #4]!
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #4]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_8(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_8:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    str r2, [r0, #8]
; CHECK-T1-NEXT:    str r3, [r0, #12]
; CHECK-T1-NEXT:    adds r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_8:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #8]!
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_8:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #8]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 8
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_m1(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_m1:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, r0, #1
; CHECK-T1-NEXT:    stm r0!, {r2, r3}
; CHECK-T1-NEXT:    subs r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_m1:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #-1]!
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_m1:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #-1]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -1
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_m4(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_m4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    str r3, [r0]
; CHECK-T1-NEXT:    subs r0, r0, #4
; CHECK-T1-NEXT:    str r2, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_m4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r3, [r0]
; CHECK-T2-NEXT:    str r2, [r0, #-4]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_m4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r3, [r0]
; CHECK-ARM-NEXT:    str r2, [r0, #-4]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_252(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_252:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r1, #252
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, #252
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_252:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #252]!
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_252:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #252]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 252
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_255(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_255:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r1, #255
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, #255
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_255:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #255]!
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_255:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #255]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 255
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_256(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_256:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r1, #1
; CHECK-T1-NEXT:    lsls r1, r1, #8
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, r0, r1
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_256:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strd r2, r3, [r0, #256]
; CHECK-T2-NEXT:    add.w r0, r0, #256
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_256:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #256]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 256
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_m252(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_m252:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, #252
; CHECK-T1-NEXT:    stm r0!, {r2, r3}
; CHECK-T1-NEXT:    subs r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_m252:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #-252]!
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_m252:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #-252]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -252
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_m255(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_m255:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, #255
; CHECK-T1-NEXT:    stm r0!, {r2, r3}
; CHECK-T1-NEXT:    subs r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_m255:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #-255]!
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_m255:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #-255]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -255
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_m256(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_m256:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r1, #255
; CHECK-T1-NEXT:    mvns r1, r1
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, r0, r1
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_m256:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    mvn r1, #255
; CHECK-T2-NEXT:    str r3, [r0, #-252]
; CHECK-T2-NEXT:    str r2, [r0, r1]
; CHECK-T2-NEXT:    sub.w r0, r0, #256
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_m256:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #-256]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -256
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_4095(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_4095:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r1, .LCPI28_0
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, r0, r1
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI28_0:
; CHECK-T1-NEXT:    .long 4095 @ 0xfff
;
; CHECK-T2-LABEL: i64_4095:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str.w r2, [r0, #4095]
; CHECK-T2-NEXT:    addw r0, r0, #4095
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_4095:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #4095]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4095
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_4096(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_4096:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r1, #1
; CHECK-T1-NEXT:    lsls r1, r1, #12
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, r0, r1
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i64_4096:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    mov.w r1, #4096
; CHECK-T2-NEXT:    str r2, [r0, r1]
; CHECK-T2-NEXT:    add.w r0, r0, #4096
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_4096:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    mov r1, #4096
; CHECK-ARM-NEXT:    str r2, [r0, r1]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4096
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_m4095(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_m4095:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r1, .LCPI30_0
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, r0, r1
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI30_0:
; CHECK-T1-NEXT:    .long 4294963201 @ 0xfffff001
;
; CHECK-T2-LABEL: i64_m4095:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r1, #61441
; CHECK-T2-NEXT:    movt r1, #65535
; CHECK-T2-NEXT:    str r2, [r0, r1]
; CHECK-T2-NEXT:    subw r0, r0, #4095
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_m4095:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #-4095]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4095
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i64_m4096(ptr %p, i64 %v) {
; CHECK-T1-LABEL: i64_m4096:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r1, .LCPI31_0
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, r0, r1
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI31_0:
; CHECK-T1-NEXT:    .long 4294963200 @ 0xfffff000
;
; CHECK-T2-LABEL: i64_m4096:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r1, #61440
; CHECK-T2-NEXT:    movt r1, #65535
; CHECK-T2-NEXT:    str r2, [r0, r1]
; CHECK-T2-NEXT:    sub.w r0, r0, #4096
; CHECK-T2-NEXT:    str r3, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i64_m4096:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    movw r1, #61440
; CHECK-ARM-NEXT:    movt r1, #65535
; CHECK-ARM-NEXT:    str r2, [r0, r1]!
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4096
  store i64 %v, ptr %o, align 8
  ret ptr %o
}

define ptr @i128_0(ptr %p, i128 %v) {
; CHECK-T1-LABEL: i128_0:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r1, [sp, #4]
; CHECK-T1-NEXT:    str r1, [r0, #12]
; CHECK-T1-NEXT:    ldr r1, [sp]
; CHECK-T1-NEXT:    str r1, [r0, #8]
; CHECK-T1-NEXT:    stm r0!, {r2, r3}
; CHECK-T1-NEXT:    subs r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i128_0:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    ldr r1, [sp, #4]
; CHECK-T2-NEXT:    str r1, [r0, #12]
; CHECK-T2-NEXT:    ldr r1, [sp]
; CHECK-T2-NEXT:    str r1, [r0, #8]
; CHECK-T2-NEXT:    strd r2, r3, [r0]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i128_0:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    ldm sp, {r1, r12}
; CHECK-ARM-NEXT:    stm r0, {r2, r3}
; CHECK-ARM-NEXT:    str r1, [r0, #8]
; CHECK-ARM-NEXT:    str r12, [r0, #12]
; CHECK-ARM-NEXT:    bx lr
  store i128 %v, ptr %p, align 16
  ret ptr %p
}

define ptr @i128_3(ptr %p, i128 %v) {
; CHECK-T1-LABEL: i128_3:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r1, #3
; CHECK-T1-NEXT:    str r2, [r0, r1]
; CHECK-T1-NEXT:    adds r0, r0, #3
; CHECK-T1-NEXT:    ldr r1, [sp, #4]
; CHECK-T1-NEXT:    str r1, [r0, #12]
; CHECK-T1-NEXT:    ldr r1, [sp]
; CHECK-T1-NEXT:    str r1, [r0, #8]
; CHECK-T1-NEXT:    str r3, [r0, #4]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i128_3:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #3]!
; CHECK-T2-NEXT:    ldr r1, [sp, #4]
; CHECK-T2-NEXT:    str r1, [r0, #12]
; CHECK-T2-NEXT:    ldr r1, [sp]
; CHECK-T2-NEXT:    strd r3, r1, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i128_3:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #3]!
; CHECK-ARM-NEXT:    ldm sp, {r1, r12}
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    str r1, [r0, #8]
; CHECK-ARM-NEXT:    str r12, [r0, #12]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 3
  store i128 %v, ptr %o, align 16
  ret ptr %o
}

define ptr @i128_4(ptr %p, i128 %v) {
; CHECK-T1-LABEL: i128_4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r1, [sp, #4]
; CHECK-T1-NEXT:    str r1, [r0, #16]
; CHECK-T1-NEXT:    ldr r1, [sp]
; CHECK-T1-NEXT:    str r1, [r0, #12]
; CHECK-T1-NEXT:    str r3, [r0, #8]
; CHECK-T1-NEXT:    str r2, [r0, #4]
; CHECK-T1-NEXT:    adds r0, r0, #4
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i128_4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #4]!
; CHECK-T2-NEXT:    ldr r1, [sp, #4]
; CHECK-T2-NEXT:    str r1, [r0, #12]
; CHECK-T2-NEXT:    ldr r1, [sp]
; CHECK-T2-NEXT:    strd r3, r1, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i128_4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #4]!
; CHECK-ARM-NEXT:    ldm sp, {r1, r12}
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    str r1, [r0, #8]
; CHECK-ARM-NEXT:    str r12, [r0, #12]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4
  store i128 %v, ptr %o, align 16
  ret ptr %o
}

define ptr @i128_8(ptr %p, i128 %v) {
; CHECK-T1-LABEL: i128_8:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r1, [sp, #4]
; CHECK-T1-NEXT:    str r1, [r0, #20]
; CHECK-T1-NEXT:    ldr r1, [sp]
; CHECK-T1-NEXT:    str r1, [r0, #16]
; CHECK-T1-NEXT:    str r3, [r0, #12]
; CHECK-T1-NEXT:    str r2, [r0, #8]
; CHECK-T1-NEXT:    adds r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i128_8:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #8]!
; CHECK-T2-NEXT:    ldr r1, [sp, #4]
; CHECK-T2-NEXT:    str r1, [r0, #12]
; CHECK-T2-NEXT:    ldr r1, [sp]
; CHECK-T2-NEXT:    strd r3, r1, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i128_8:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #8]!
; CHECK-ARM-NEXT:    ldm sp, {r1, r12}
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    str r1, [r0, #8]
; CHECK-ARM-NEXT:    str r12, [r0, #12]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 8
  store i128 %v, ptr %o, align 16
  ret ptr %o
}

define ptr @i128_16(ptr %p, i128 %v) {
; CHECK-T1-LABEL: i128_16:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r1, [sp, #4]
; CHECK-T1-NEXT:    str r1, [r0, #28]
; CHECK-T1-NEXT:    ldr r1, [sp]
; CHECK-T1-NEXT:    str r1, [r0, #24]
; CHECK-T1-NEXT:    str r3, [r0, #20]
; CHECK-T1-NEXT:    str r2, [r0, #16]
; CHECK-T1-NEXT:    adds r0, #16
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i128_16:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #16]!
; CHECK-T2-NEXT:    ldr r1, [sp, #4]
; CHECK-T2-NEXT:    str r1, [r0, #12]
; CHECK-T2-NEXT:    ldr r1, [sp]
; CHECK-T2-NEXT:    strd r3, r1, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i128_16:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #16]!
; CHECK-ARM-NEXT:    ldm sp, {r1, r12}
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    str r1, [r0, #8]
; CHECK-ARM-NEXT:    str r12, [r0, #12]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 16
  store i128 %v, ptr %o, align 16
  ret ptr %o
}

define ptr @i128_m1(ptr %p, i128 %v) {
; CHECK-T1-LABEL: i128_m1:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, r0, #1
; CHECK-T1-NEXT:    ldr r1, [sp, #4]
; CHECK-T1-NEXT:    str r1, [r0, #12]
; CHECK-T1-NEXT:    ldr r1, [sp]
; CHECK-T1-NEXT:    str r1, [r0, #8]
; CHECK-T1-NEXT:    stm r0!, {r2, r3}
; CHECK-T1-NEXT:    subs r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i128_m1:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    str r2, [r0, #-1]!
; CHECK-T2-NEXT:    ldr r1, [sp, #4]
; CHECK-T2-NEXT:    str r1, [r0, #12]
; CHECK-T2-NEXT:    ldr r1, [sp]
; CHECK-T2-NEXT:    strd r3, r1, [r0, #4]
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i128_m1:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    str r2, [r0, #-1]!
; CHECK-ARM-NEXT:    ldm sp, {r1, r12}
; CHECK-ARM-NEXT:    str r3, [r0, #4]
; CHECK-ARM-NEXT:    str r1, [r0, #8]
; CHECK-ARM-NEXT:    str r12, [r0, #12]
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -1
  store i128 %v, ptr %o, align 16
  ret ptr %o
}

define ptr @i128_m4(ptr %p, i128 %v) {
; CHECK-T1-LABEL: i128_m4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r1, [sp, #4]
; CHECK-T1-NEXT:    str r1, [r0, #8]
; CHECK-T1-NEXT:    ldr r1, [sp]
; CHECK-T1-NEXT:    str r1, [r0, #4]
; CHECK-T1-NEXT:    str r3, [r0]
; CHECK-T1-NEXT:    subs r0, r0, #4
; CHECK-T1-NEXT:    str r2, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i128_m4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    ldr r1, [sp, #4]
; CHECK-T2-NEXT:    str r1, [r0, #8]
; CHECK-T2-NEXT:    ldr r1, [sp]
; CHECK-T2-NEXT:    strd r3, r1, [r0]
; CHECK-T2-NEXT:    str r2, [r0, #-4]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i128_m4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    ldm sp, {r1, r12}
; CHECK-ARM-NEXT:    str r3, [r0]
; CHECK-ARM-NEXT:    stmib r0, {r1, r12}
; CHECK-ARM-NEXT:    str r2, [r0, #-4]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4
  store i128 %v, ptr %o, align 16
  ret ptr %o
}

define ptr @i16_0(ptr %p, i16 %v) {
; CHECK-LABEL: i16_0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    strh r1, [r0]
; CHECK-NEXT:    bx lr
  store i16 %v, ptr %p, align 2
  ret ptr %p
}

define ptr @i16_3(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_3:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #3
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, #3
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_3:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #3]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_3:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #3]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 3
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_4(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    strh r1, [r0, #4]
; CHECK-T1-NEXT:    adds r0, r0, #4
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #4]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #4]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_8(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_8:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    strh r1, [r0, #8]
; CHECK-T1-NEXT:    adds r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_8:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #8]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_8:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #8]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 8
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_m1(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_m1:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, r0, #1
; CHECK-T1-NEXT:    strh r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_m1:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #-1]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_m1:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #-1]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -1
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_m4(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_m4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, r0, #4
; CHECK-T1-NEXT:    strh r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_m4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #-4]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_m4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #-4]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_252(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_252:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #252
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, #252
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_252:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #252]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_252:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #252]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 252
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_255(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_255:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #255
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, #255
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_255:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #255]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_255:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #255]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 255
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_256(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_256:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #1
; CHECK-T1-NEXT:    lsls r2, r2, #8
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_256:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh.w r1, [r0, #256]
; CHECK-T2-NEXT:    add.w r0, r0, #256
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_256:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    mov r2, #256
; CHECK-ARM-NEXT:    strh r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 256
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_m252(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_m252:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, #252
; CHECK-T1-NEXT:    strh r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_m252:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #-252]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_m252:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #-252]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -252
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_m255(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_m255:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, #255
; CHECK-T1-NEXT:    strh r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_m255:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh r1, [r0, #-255]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_m255:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strh r1, [r0, #-255]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -255
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_m256(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_m256:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #255
; CHECK-T1-NEXT:    mvns r2, r2
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_m256:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    mvn r2, #255
; CHECK-T2-NEXT:    strh r1, [r0, r2]
; CHECK-T2-NEXT:    sub.w r0, r0, #256
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_m256:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    mvn r2, #255
; CHECK-ARM-NEXT:    strh r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -256
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_4095(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_4095:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI51_0
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI51_0:
; CHECK-T1-NEXT:    .long 4095 @ 0xfff
;
; CHECK-T2-LABEL: i16_4095:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strh.w r1, [r0, #4095]
; CHECK-T2-NEXT:    addw r0, r0, #4095
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_4095:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    movw r2, #4095
; CHECK-ARM-NEXT:    strh r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4095
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_4096(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_4096:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #1
; CHECK-T1-NEXT:    lsls r2, r2, #12
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i16_4096:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    mov.w r2, #4096
; CHECK-T2-NEXT:    strh r1, [r0, r2]
; CHECK-T2-NEXT:    add.w r0, r0, #4096
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_4096:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    mov r2, #4096
; CHECK-ARM-NEXT:    strh r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4096
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_m4095(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_m4095:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI53_0
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI53_0:
; CHECK-T1-NEXT:    .long 4294963201 @ 0xfffff001
;
; CHECK-T2-LABEL: i16_m4095:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r2, #61441
; CHECK-T2-NEXT:    movt r2, #65535
; CHECK-T2-NEXT:    strh r1, [r0, r2]
; CHECK-T2-NEXT:    subw r0, r0, #4095
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_m4095:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    movw r2, #61441
; CHECK-ARM-NEXT:    movt r2, #65535
; CHECK-ARM-NEXT:    strh r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4095
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i16_m4096(ptr %p, i16 %v) {
; CHECK-T1-LABEL: i16_m4096:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI54_0
; CHECK-T1-NEXT:    strh r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI54_0:
; CHECK-T1-NEXT:    .long 4294963200 @ 0xfffff000
;
; CHECK-T2-LABEL: i16_m4096:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r2, #61440
; CHECK-T2-NEXT:    movt r2, #65535
; CHECK-T2-NEXT:    strh r1, [r0, r2]
; CHECK-T2-NEXT:    sub.w r0, r0, #4096
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i16_m4096:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    movw r2, #61440
; CHECK-ARM-NEXT:    movt r2, #65535
; CHECK-ARM-NEXT:    strh r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4096
  store i16 %v, ptr %o, align 2
  ret ptr %o
}

define ptr @i8_0(ptr %p, i8 %v) {
; CHECK-LABEL: i8_0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    strb r1, [r0]
; CHECK-NEXT:    bx lr
  store i8 %v, ptr %p, align 1
  ret ptr %p
}

define ptr @i8_3(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_3:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    strb r1, [r0, #3]
; CHECK-T1-NEXT:    adds r0, r0, #3
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_3:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #3]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_3:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #3]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 3
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_4(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    strb r1, [r0, #4]
; CHECK-T1-NEXT:    adds r0, r0, #4
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #4]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #4]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_8(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_8:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    strb r1, [r0, #8]
; CHECK-T1-NEXT:    adds r0, #8
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_8:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #8]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_8:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #8]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 8
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_m1(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_m1:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, r0, #1
; CHECK-T1-NEXT:    strb r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_m1:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #-1]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_m1:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #-1]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -1
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_m4(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_m4:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, r0, #4
; CHECK-T1-NEXT:    strb r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_m4:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #-4]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_m4:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #-4]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_252(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_252:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #252
; CHECK-T1-NEXT:    strb r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, #252
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_252:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #252]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_252:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #252]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 252
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_255(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_255:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #255
; CHECK-T1-NEXT:    strb r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, #255
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_255:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #255]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_255:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #255]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 255
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_256(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_256:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #1
; CHECK-T1-NEXT:    lsls r2, r2, #8
; CHECK-T1-NEXT:    strb r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_256:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb.w r1, [r0, #256]
; CHECK-T2-NEXT:    add.w r0, r0, #256
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_256:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #256]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 256
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_m252(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_m252:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, #252
; CHECK-T1-NEXT:    strb r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_m252:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #-252]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_m252:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #-252]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -252
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_m255(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_m255:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    subs r0, #255
; CHECK-T1-NEXT:    strb r1, [r0]
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_m255:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb r1, [r0, #-255]!
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_m255:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #-255]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -255
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_m256(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_m256:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #255
; CHECK-T1-NEXT:    mvns r2, r2
; CHECK-T1-NEXT:    strb r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_m256:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    mvn r2, #255
; CHECK-T2-NEXT:    strb r1, [r0, r2]
; CHECK-T2-NEXT:    sub.w r0, r0, #256
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_m256:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #-256]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -256
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_4095(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_4095:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI67_0
; CHECK-T1-NEXT:    strb r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI67_0:
; CHECK-T1-NEXT:    .long 4095 @ 0xfff
;
; CHECK-T2-LABEL: i8_4095:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    strb.w r1, [r0, #4095]
; CHECK-T2-NEXT:    addw r0, r0, #4095
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_4095:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #4095]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4095
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_4096(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_4096:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    movs r2, #1
; CHECK-T1-NEXT:    lsls r2, r2, #12
; CHECK-T1-NEXT:    strb r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i8_4096:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    mov.w r2, #4096
; CHECK-T2-NEXT:    strb r1, [r0, r2]
; CHECK-T2-NEXT:    add.w r0, r0, #4096
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_4096:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    mov r2, #4096
; CHECK-ARM-NEXT:    strb r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 4096
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_m4095(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_m4095:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI69_0
; CHECK-T1-NEXT:    strb r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI69_0:
; CHECK-T1-NEXT:    .long 4294963201 @ 0xfffff001
;
; CHECK-T2-LABEL: i8_m4095:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r2, #61441
; CHECK-T2-NEXT:    movt r2, #65535
; CHECK-T2-NEXT:    strb r1, [r0, r2]
; CHECK-T2-NEXT:    subw r0, r0, #4095
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_m4095:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    strb r1, [r0, #-4095]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4095
  store i8 %v, ptr %o, align 1
  ret ptr %o
}

define ptr @i8_m4096(ptr %p, i8 %v) {
; CHECK-T1-LABEL: i8_m4096:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI70_0
; CHECK-T1-NEXT:    strb r1, [r0, r2]
; CHECK-T1-NEXT:    adds r0, r0, r2
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI70_0:
; CHECK-T1-NEXT:    .long 4294963200 @ 0xfffff000
;
; CHECK-T2-LABEL: i8_m4096:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r2, #61440
; CHECK-T2-NEXT:    movt r2, #65535
; CHECK-T2-NEXT:    strb r1, [r0, r2]
; CHECK-T2-NEXT:    sub.w r0, r0, #4096
; CHECK-T2-NEXT:    bx lr
;
; CHECK-ARM-LABEL: i8_m4096:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    movw r2, #61440
; CHECK-ARM-NEXT:    movt r2, #65535
; CHECK-ARM-NEXT:    strb r1, [r0, r2]!
; CHECK-ARM-NEXT:    bx lr
  %o = getelementptr inbounds i8, ptr %p, i32 -4096
  store i8 %v, ptr %o, align 1
  ret ptr %o
}
