; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX942 %s


define void @v_shuffle_v2i32_v8i32__u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i32_v8i32__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> poison
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i32_v8i32__8_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 poison>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v8
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v9, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[8:9], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[8:9], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v9
; GFX900-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v9
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v9
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v1, v10
; GFX900-NEXT:    global_store_dwordx2 v11, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[10:11], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v12, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[10:11], v[2:3] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v12, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v11
; GFX900-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v11
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v11
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, v12
; GFX900-NEXT:    global_store_dwordx2 v13, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[12:13], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v14, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[12:13], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v14, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v13
; GFX900-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, v13
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v13
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, v14
; GFX900-NEXT:    global_store_dwordx2 v15, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[14:15], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v16, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[14:15], v[6:7] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v16, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v15
; GFX900-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, v15
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v15
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v7
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v7
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[6:7] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__15_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__15_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__15_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__15_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> zeroinitializer
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v7
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v7
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v0
; GFX900-NEXT:    global_store_dwordx2 v9, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    global_store_dwordx2 v9, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v0
; GFX90A-NEXT:    global_store_dwordx2 v10, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v0
; GFX942-NEXT:    global_store_dwordx2 v10, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v0
; GFX900-NEXT:    global_store_dwordx2 v9, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v0
; GFX900-NEXT:    global_store_dwordx2 v9, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v0
; GFX90A-NEXT:    global_store_dwordx2 v10, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v0
; GFX942-NEXT:    global_store_dwordx2 v10, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v0
; GFX900-NEXT:    global_store_dwordx2 v9, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v0
; GFX900-NEXT:    global_store_dwordx2 v9, v[7:8], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v0
; GFX90A-NEXT:    global_store_dwordx2 v10, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v9, v0
; GFX942-NEXT:    global_store_dwordx2 v10, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 0>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v1
; GFX900-NEXT:    global_store_dwordx2 v10, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx2 v10, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx2 v10, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v1
; GFX942-NEXT:    global_store_dwordx2 v10, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v1
; GFX900-NEXT:    global_store_dwordx2 v10, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v1
; GFX900-NEXT:    global_store_dwordx2 v10, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx2 v10, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v1
; GFX942-NEXT:    global_store_dwordx2 v10, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v1
; GFX900-NEXT:    global_store_dwordx2 v10, v[7:8], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v9, v1
; GFX900-NEXT:    global_store_dwordx2 v10, v[8:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v1
; GFX90A-NEXT:    global_store_dwordx2 v10, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v9, v1
; GFX942-NEXT:    global_store_dwordx2 v10, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 1>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[2:3] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v2
; GFX900-NEXT:    global_store_dwordx2 v11, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v12, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[2:3] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v12, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v2
; GFX900-NEXT:    global_store_dwordx2 v11, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v2
; GFX90A-NEXT:    global_store_dwordx2 v12, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v2
; GFX942-NEXT:    global_store_dwordx2 v12, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v2
; GFX900-NEXT:    global_store_dwordx2 v11, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v12, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[2:3] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v12, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v2
; GFX900-NEXT:    global_store_dwordx2 v11, v[7:8], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v2
; GFX90A-NEXT:    global_store_dwordx2 v12, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v9, v2
; GFX942-NEXT:    global_store_dwordx2 v12, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v9, v2
; GFX900-NEXT:    global_store_dwordx2 v11, v[8:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[8:9], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v12, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[8:9], v[2:3] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v12, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v2
; GFX900-NEXT:    global_store_dwordx2 v11, v[9:10], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v11, v2
; GFX90A-NEXT:    global_store_dwordx2 v12, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v11, v2
; GFX942-NEXT:    global_store_dwordx2 v12, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 2>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v3
; GFX900-NEXT:    global_store_dwordx2 v12, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v3
; GFX900-NEXT:    global_store_dwordx2 v12, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    global_store_dwordx2 v12, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v3
; GFX942-NEXT:    global_store_dwordx2 v12, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v3
; GFX900-NEXT:    global_store_dwordx2 v12, v[7:8], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v7
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v7
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v9, v3
; GFX900-NEXT:    global_store_dwordx2 v12, v[8:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v3
; GFX90A-NEXT:    global_store_dwordx2 v12, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v9, v3
; GFX942-NEXT:    global_store_dwordx2 v12, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v3
; GFX900-NEXT:    global_store_dwordx2 v12, v[9:10], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v9
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v9
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v11, v3
; GFX900-NEXT:    global_store_dwordx2 v12, v[10:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v11, v3
; GFX90A-NEXT:    global_store_dwordx2 v12, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v11, v3
; GFX942-NEXT:    global_store_dwordx2 v12, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 3>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v4
; GFX900-NEXT:    global_store_dwordx2 v13, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v14, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v14, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v4
; GFX900-NEXT:    global_store_dwordx2 v13, v[7:8], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v4
; GFX90A-NEXT:    global_store_dwordx2 v14, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v9, v4
; GFX942-NEXT:    global_store_dwordx2 v14, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v9, v4
; GFX900-NEXT:    global_store_dwordx2 v13, v[8:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[8:9], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v14, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[8:9], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v14, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v4
; GFX900-NEXT:    global_store_dwordx2 v13, v[9:10], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v11, v4
; GFX90A-NEXT:    global_store_dwordx2 v14, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v11, v4
; GFX942-NEXT:    global_store_dwordx2 v14, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v11, v4
; GFX900-NEXT:    global_store_dwordx2 v13, v[10:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[10:11], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v14, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[10:11], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v14, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v4
; GFX900-NEXT:    global_store_dwordx2 v13, v[11:12], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v13, v4
; GFX90A-NEXT:    global_store_dwordx2 v14, v[12:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v13, v4
; GFX942-NEXT:    global_store_dwordx2 v14, v[12:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 4>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v5
; GFX900-NEXT:    global_store_dwordx2 v14, v[7:8], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, v7
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v7
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v9, v5
; GFX900-NEXT:    global_store_dwordx2 v14, v[8:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v5
; GFX90A-NEXT:    global_store_dwordx2 v14, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v9, v5
; GFX942-NEXT:    global_store_dwordx2 v14, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v5
; GFX900-NEXT:    global_store_dwordx2 v14, v[9:10], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, v9
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v9
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v11, v5
; GFX900-NEXT:    global_store_dwordx2 v14, v[10:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v11, v5
; GFX90A-NEXT:    global_store_dwordx2 v14, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v11, v5
; GFX942-NEXT:    global_store_dwordx2 v14, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v5
; GFX900-NEXT:    global_store_dwordx2 v14, v[11:12], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, v11
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v11
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v13, v5
; GFX900-NEXT:    global_store_dwordx2 v14, v[12:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v13, v5
; GFX90A-NEXT:    global_store_dwordx2 v14, v[12:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v13, v5
; GFX942-NEXT:    global_store_dwordx2 v14, v[12:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 5>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[6:7] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v9, v6
; GFX900-NEXT:    global_store_dwordx2 v15, v[8:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[8:9], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v16, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[8:9], v[6:7] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v16, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v6
; GFX900-NEXT:    global_store_dwordx2 v15, v[9:10], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v11, v6
; GFX90A-NEXT:    global_store_dwordx2 v16, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v11, v6
; GFX942-NEXT:    global_store_dwordx2 v16, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v11, v6
; GFX900-NEXT:    global_store_dwordx2 v15, v[10:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[10:11], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v16, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[10:11], v[6:7] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v16, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v6
; GFX900-NEXT:    global_store_dwordx2 v15, v[11:12], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v13, v6
; GFX90A-NEXT:    global_store_dwordx2 v16, v[12:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v13, v6
; GFX942-NEXT:    global_store_dwordx2 v16, v[12:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v13, v6
; GFX900-NEXT:    global_store_dwordx2 v15, v[12:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[12:13], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v16, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[12:13], v[6:7] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v16, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v6
; GFX900-NEXT:    global_store_dwordx2 v15, v[13:14], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v15, v6
; GFX90A-NEXT:    global_store_dwordx2 v16, v[14:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v15, v6
; GFX942-NEXT:    global_store_dwordx2 v16, v[14:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 6>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[9:10], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, v9
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v9
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[10:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v11, v7
; GFX90A-NEXT:    global_store_dwordx2 v16, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v11, v7
; GFX942-NEXT:    global_store_dwordx2 v16, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[11:12], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, v11
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v11
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[12:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v13, v7
; GFX90A-NEXT:    global_store_dwordx2 v16, v[12:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v13, v7
; GFX942-NEXT:    global_store_dwordx2 v16, v[12:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[13:14], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, v13
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v13
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[14:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v15, v7
; GFX90A-NEXT:    global_store_dwordx2 v16, v[14:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v15, v7
; GFX942-NEXT:    global_store_dwordx2 v16, v[14:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 7>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_8(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i32_v8i32__u_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_8(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i32_v8i32__8_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v0
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v0
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v0
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 8>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx2 v9, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v3
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx2 v10, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v10, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx2 v10, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx2 v11, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v5
; GFX900-NEXT:    global_store_dwordx2 v12, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v3
; GFX90A-NEXT:    global_store_dwordx2 v12, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v3
; GFX942-NEXT:    global_store_dwordx2 v12, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v6
; GFX900-NEXT:    global_store_dwordx2 v13, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v7
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v7
; GFX900-NEXT:    global_store_dwordx2 v14, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v5
; GFX90A-NEXT:    global_store_dwordx2 v14, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v5
; GFX942-NEXT:    global_store_dwordx2 v14, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v8
; GFX900-NEXT:    global_store_dwordx2 v15, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v9
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v9
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[8:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, v7
; GFX90A-NEXT:    global_store_dwordx2 v16, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v7
; GFX942-NEXT:    global_store_dwordx2 v16, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v1
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 9>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx2 v9, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx2 v10, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx2 v11, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v6
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v6
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    global_store_dwordx2 v12, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v12, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[6:7] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v12, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx2 v13, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, v8
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v8
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v8
; GFX900-NEXT:    global_store_dwordx2 v14, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[8:9] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v14, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[8:9] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v14, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v9
; GFX900-NEXT:    global_store_dwordx2 v15, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v10
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v10
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[9:10], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[10:11] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v16, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[10:11] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v16, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[2:3] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v2
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v2
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 10>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    global_store_dwordx2 v9, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v5
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v5
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v5
; GFX900-NEXT:    global_store_dwordx2 v10, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v1
; GFX90A-NEXT:    global_store_dwordx2 v10, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v1
; GFX942-NEXT:    global_store_dwordx2 v10, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v6
; GFX900-NEXT:    global_store_dwordx2 v11, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v7
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v7
; GFX900-NEXT:    global_store_dwordx2 v12, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v3
; GFX90A-NEXT:    global_store_dwordx2 v12, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v3
; GFX942-NEXT:    global_store_dwordx2 v12, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v8
; GFX900-NEXT:    global_store_dwordx2 v13, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, v9
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v9
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v9
; GFX900-NEXT:    global_store_dwordx2 v14, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v5
; GFX90A-NEXT:    global_store_dwordx2 v14, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v5
; GFX942-NEXT:    global_store_dwordx2 v14, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v10
; GFX900-NEXT:    global_store_dwordx2 v15, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v11
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v11
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[10:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, v7
; GFX90A-NEXT:    global_store_dwordx2 v16, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v7
; GFX942-NEXT:    global_store_dwordx2 v16, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 11>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx2 v9, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    global_store_dwordx2 v10, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[6:7] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx2 v11, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v8
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v8
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v8
; GFX900-NEXT:    global_store_dwordx2 v12, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[8:9] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v12, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[8:9] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v12, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v9
; GFX900-NEXT:    global_store_dwordx2 v13, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, v10
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v10
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v10
; GFX900-NEXT:    global_store_dwordx2 v14, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[10:11] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v14, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[10:11] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v14, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v11
; GFX900-NEXT:    global_store_dwordx2 v15, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v12
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v12
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[11:12], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[12:13] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v16, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[12:13] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v16, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v4
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v4
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 12>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    global_store_dwordx2 v9, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v7
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v7
; GFX900-NEXT:    global_store_dwordx2 v10, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v1
; GFX90A-NEXT:    global_store_dwordx2 v10, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v1
; GFX942-NEXT:    global_store_dwordx2 v10, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v8
; GFX900-NEXT:    global_store_dwordx2 v11, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v9
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v9
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v9
; GFX900-NEXT:    global_store_dwordx2 v12, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v3
; GFX90A-NEXT:    global_store_dwordx2 v12, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v3
; GFX942-NEXT:    global_store_dwordx2 v12, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v10
; GFX900-NEXT:    global_store_dwordx2 v13, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, v11
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v11
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v11
; GFX900-NEXT:    global_store_dwordx2 v14, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v5
; GFX90A-NEXT:    global_store_dwordx2 v14, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v5
; GFX942-NEXT:    global_store_dwordx2 v14, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v12
; GFX900-NEXT:    global_store_dwordx2 v15, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v13
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v13
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[12:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, v7
; GFX90A-NEXT:    global_store_dwordx2 v16, v[12:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v7
; GFX942-NEXT:    global_store_dwordx2 v16, v[12:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v5
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 13>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx2 v9, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v8
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v8
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v8
; GFX900-NEXT:    global_store_dwordx2 v10, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[8:9] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[8:9] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v9
; GFX900-NEXT:    global_store_dwordx2 v11, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v10
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v10
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v10
; GFX900-NEXT:    global_store_dwordx2 v12, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[10:11] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v12, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[10:11] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v12, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v11
; GFX900-NEXT:    global_store_dwordx2 v13, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, v12
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v12
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v12
; GFX900-NEXT:    global_store_dwordx2 v14, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[12:13] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v14, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[12:13] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v14, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v13
; GFX900-NEXT:    global_store_dwordx2 v15, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v14
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v14
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[13:14], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[14:15] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v16, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[14:15] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx2 v16, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v6
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v6
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 14>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__u_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__u_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__u_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__u_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__0_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__0_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:8]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v9, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v8
; GFX900-NEXT:    global_store_dwordx2 v9, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__0_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v9
; GFX90A-NEXT:    global_store_dwordx2 v10, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__0_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v9
; GFX942-NEXT:    global_store_dwordx2 v10, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__1_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__1_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v9
; GFX900-NEXT:    global_store_dwordx2 v10, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__1_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v1
; GFX90A-NEXT:    global_store_dwordx2 v10, v[8:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__1_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v1
; GFX942-NEXT:    global_store_dwordx2 v10, v[8:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__2_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__2_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v11, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v10
; GFX900-NEXT:    global_store_dwordx2 v11, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__2_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v11
; GFX90A-NEXT:    global_store_dwordx2 v12, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__2_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v11
; GFX942-NEXT:    global_store_dwordx2 v12, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__3_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__3_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v11
; GFX900-NEXT:    global_store_dwordx2 v12, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__3_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v3
; GFX90A-NEXT:    global_store_dwordx2 v12, v[10:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__3_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v12, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v3
; GFX942-NEXT:    global_store_dwordx2 v12, v[10:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__4_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__4_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:12]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v13, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v12
; GFX900-NEXT:    global_store_dwordx2 v13, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__4_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, v13
; GFX90A-NEXT:    global_store_dwordx2 v14, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__4_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v13
; GFX942-NEXT:    global_store_dwordx2 v14, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__5_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__5_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v13
; GFX900-NEXT:    global_store_dwordx2 v14, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__5_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v5
; GFX90A-NEXT:    global_store_dwordx2 v14, v[12:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__5_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:13]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v5
; GFX942-NEXT:    global_store_dwordx2 v14, v[12:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__6_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__6_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[7:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v15, 0
; GFX900-NEXT:    v_mov_b32_e32 v7, v14
; GFX900-NEXT:    global_store_dwordx2 v15, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__6_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v15
; GFX90A-NEXT:    global_store_dwordx2 v16, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__6_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v7, v15
; GFX942-NEXT:    global_store_dwordx2 v16, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__7_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__7_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v7
; GFX900-NEXT:    global_store_dwordx2 v16, v[14:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__7_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, v7
; GFX90A-NEXT:    global_store_dwordx2 v16, v[14:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__7_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v7
; GFX942-NEXT:    global_store_dwordx2 v16, v[14:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__8_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__8_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__8_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__8_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__9_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__9_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__9_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v1
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__9_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v1
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__10_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__10_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__10_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__10_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__11_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__11_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__11_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__11_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v3
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__12_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__12_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__12_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__12_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, v7
; GFX942-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__13_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__13_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__13_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__13_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v5
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2i32_v8i32__14_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i32_v8i32__14_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i32_v8i32__14_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i32_v8i32__14_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v8, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=v"()
  %vec1 = call <8 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 15>
  store <2 x i32> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_u() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> poison
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_u() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__8_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_u() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s11
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s11
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s11
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s15
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s19
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s19
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s15
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s15
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_9() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__15_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_13() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__15_13:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__15_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__15_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__15_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__15_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 15, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_0() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__0_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> zeroinitializer
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s0
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_0() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__4_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s4
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s0
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s0
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s9
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_0() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s15, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s15, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_1() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_1() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__3_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_1() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__4_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_1() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__5_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_1() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__7_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_1() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s15, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s15, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_2() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__0_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s2
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_2() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__4_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s6
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s2
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s2
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s9
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_2() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s15, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s15, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_3() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__0_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_3() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__4_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s9
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_3() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s15, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s15, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s11, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s8
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s8
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_4() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__0_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s12
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s8
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s8
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s4
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_4() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s8
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s8
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s4
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s8
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s8
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s9
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s15, s8
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s15, s8
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s11, s4
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s11
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s12
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s13
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_4() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s19, s8
; GFX900-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s19, s8
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s15, s4
; GFX942-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_5() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__0_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_5() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__1_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_5() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__3_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_5() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_5() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__7_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s15, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s15, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_5() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s19, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s19, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s15, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_6() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__0_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s14
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s10
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s10
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s6
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_6() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__4_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s6
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s9
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s15, s10
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s15, s10
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s11, s6
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s11
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s14
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s17
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s17
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s13
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_6() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s19, s10
; GFX900-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s19, s10
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s15, s6
; GFX942-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_7() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__0_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_7() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__4_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s9
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s15, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s15, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s11, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s11
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s17
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s17
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s13
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_7() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s19, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s19, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s15, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_8() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__u_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 poison, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 0, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 1, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 2, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 3, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 4, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 5, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 6, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 7, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_8() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__8_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> poison, <2 x i32> <i32 8, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s0
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_8() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__12_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s4
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_8() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s0
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 8>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s9
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__8_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__8_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__8_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_9() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__9_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_9() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__11_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_9() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__12_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_9() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__13_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_9() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 9>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s10
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s10
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s6
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s14
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s14
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s10
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_10() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__8_10:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s2
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_10() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__12_10:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s6
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_10() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s2
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 10>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s11
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_11() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__8_11:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_11() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__12_11:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_11() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 11>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s8
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s8
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s12
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s12
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s12
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s8
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s12
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s12
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s16
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s16
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s12
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s12
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_12() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__8_12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s12
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s8
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s8
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s4
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_12() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__12_12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_12() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s8
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s8
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s4
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 12>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s9
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s13
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_13() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__8_13:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_13() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__9_13:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_13() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__11_13:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__12_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__12_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__12_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_13() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__13_13:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_13() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 13>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s18
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s18
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s14
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s14
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s10
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s18
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s18
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s18
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s18
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s14
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s18
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s18
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s14
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s18
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s18
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s7
; GFX942-NEXT:    s_mov_b32 s9, s14
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_14() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__8_14:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s14
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s10
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s10
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s6
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_14() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__12_14:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_14() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s6
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 14>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__u_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__u_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__u_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__u_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 poison, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__0_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__0_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__0_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__0_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 0, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__1_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__1_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__1_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__1_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 1, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__2_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__2_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__2_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__2_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s11
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 2, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__3_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__3_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__3_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__3_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 3, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__4_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__4_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__4_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__4_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 4, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__5_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__5_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__5_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__5_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 5, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__6_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__6_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__6_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__6_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s7, s15
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 6, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__7_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__7_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__7_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__7_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 7, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__8_15() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__8_15:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 8, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__9_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__9_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__9_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__9_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 9, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__10_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__10_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__10_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__10_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s3, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 10, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__11_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__11_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__11_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__11_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 11, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__12_15() {
; GFX9-LABEL: s_shuffle_v2i32_v8i32__12_15:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 12, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__13_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__13_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__13_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__13_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s6, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 13, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}

define void @s_shuffle_v2i32_v8i32__14_15() {
; GFX900-LABEL: s_shuffle_v2i32_v8i32__14_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i32_v8i32__14_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i32_v8i32__14_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:7]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i32> asm "; def $0", "=s"()
  %vec1 = call <8 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i32> %vec0, <8 x i32> %vec1, <2 x i32> <i32 14, i32 15>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x i32> %shuf)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX90APLUS: {{.*}}
