; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn -mcpu=gfx950 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,GFX950-SDAG %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx950 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,GFX950-GISEL %s

declare i32 @llvm.amdgcn.bitop3.i32(i32, i32, i32, i32)
declare i16 @llvm.amdgcn.bitop3.i16(i16, i16, i16, i32)

define amdgpu_ps float @bitop3_b32_vvv(i32 %a, i32 %b, i32 %c) {
; GCN-LABEL: bitop3_b32_vvv:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_bitop3_b32 v0, v0, v1, v2 bitop3:0xf
; GCN-NEXT:    ; return to shader part epilog
  %ret = call i32 @llvm.amdgcn.bitop3.i32(i32 %a, i32 %b, i32 %c, i32 15)
  %ret_cast = bitcast i32 %ret to float
  ret float %ret_cast
}

define amdgpu_ps float @bitop3_b32_svv(i32 inreg %a, i32 %b, i32 %c) {
; GCN-LABEL: bitop3_b32_svv:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_bitop3_b32 v0, s0, v0, v1 bitop3:0x10
; GCN-NEXT:    ; return to shader part epilog
  %ret = call i32 @llvm.amdgcn.bitop3.i32(i32 %a, i32 %b, i32 %c, i32 16)
  %ret_cast = bitcast i32 %ret to float
  ret float %ret_cast
}

define amdgpu_ps float @bitop3_b32_ssv(i32 inreg %a, i32 inreg %b, i32 %c) {
; GCN-LABEL: bitop3_b32_ssv:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_bitop3_b32 v0, s0, v1, v0 bitop3:0x11
; GCN-NEXT:    ; return to shader part epilog
  %ret = call i32 @llvm.amdgcn.bitop3.i32(i32 %a, i32 %b, i32 %c, i32 17)
  %ret_cast = bitcast i32 %ret to float
  ret float %ret_cast
}

define amdgpu_ps float @bitop3_b32_sss(i32 inreg %a, i32 inreg %b, i32 inreg %c) {
; GCN-LABEL: bitop3_b32_sss:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    v_mov_b32_e32 v1, s2
; GCN-NEXT:    v_bitop3_b32 v0, s0, v0, v1 bitop3:0x12
; GCN-NEXT:    ; return to shader part epilog
  %ret = call i32 @llvm.amdgcn.bitop3.i32(i32 %a, i32 %b, i32 %c, i32 18)
  %ret_cast = bitcast i32 %ret to float
  ret float %ret_cast
}

define amdgpu_ps float @bitop3_b32_vvi(i32 %a, i32 %b) {
; GFX950-SDAG-LABEL: bitop3_b32_vvi:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_movk_i32 s0, 0x3e8
; GFX950-SDAG-NEXT:    v_bitop3_b32 v0, v0, v1, s0 bitop3:0x13
; GFX950-SDAG-NEXT:    ; return to shader part epilog
;
; GFX950-GISEL-LABEL: bitop3_b32_vvi:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v2, 0x3e8
; GFX950-GISEL-NEXT:    v_bitop3_b32 v0, v0, v1, v2 bitop3:0x13
; GFX950-GISEL-NEXT:    ; return to shader part epilog
  %ret = call i32 @llvm.amdgcn.bitop3.i32(i32 %a, i32 %b, i32 1000, i32 19)
  %ret_cast = bitcast i32 %ret to float
  ret float %ret_cast
}

define amdgpu_ps float @bitop3_b32_vii(i32 %a) {
; GFX950-SDAG-LABEL: bitop3_b32_vii:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_movk_i32 s0, 0x7d0
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v1, 0x3e8
; GFX950-SDAG-NEXT:    v_bitop3_b32 v0, v0, s0, v1 bitop3:0x14
; GFX950-SDAG-NEXT:    ; return to shader part epilog
;
; GFX950-GISEL-LABEL: bitop3_b32_vii:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7d0
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v2, 0x3e8
; GFX950-GISEL-NEXT:    v_bitop3_b32 v0, v0, v1, v2 bitop3:0x14
; GFX950-GISEL-NEXT:    ; return to shader part epilog
  %ret = call i32 @llvm.amdgcn.bitop3.i32(i32 %a, i32 2000, i32 1000, i32 20)
  %ret_cast = bitcast i32 %ret to float
  ret float %ret_cast
}

; FIXME: Constant fold this

define amdgpu_ps float @bitop3_b32_iii() {
; GFX950-SDAG-LABEL: bitop3_b32_iii:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_movk_i32 s0, 0xbb8
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v0, 0x7d0
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v1, 0x3e8
; GFX950-SDAG-NEXT:    v_bitop3_b32 v0, s0, v0, v1 bitop3:0x15
; GFX950-SDAG-NEXT:    ; return to shader part epilog
;
; GFX950-GISEL-LABEL: bitop3_b32_iii:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v0, 0xbb8
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7d0
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v2, 0x3e8
; GFX950-GISEL-NEXT:    v_bitop3_b32 v0, v0, v1, v2 bitop3:0x15
; GFX950-GISEL-NEXT:    ; return to shader part epilog
  %ret = call i32 @llvm.amdgcn.bitop3.i32(i32 3000, i32 2000, i32 1000, i32 21)
  %ret_cast = bitcast i32 %ret to float
  ret float %ret_cast
}

define amdgpu_ps half @bitop3_b16_vvv(i16 %a, i16 %b, i16 %c) {
; GCN-LABEL: bitop3_b16_vvv:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_bitop3_b16 v0, v0, v1, v2 bitop3:0xf
; GCN-NEXT:    ; return to shader part epilog
  %ret = call i16 @llvm.amdgcn.bitop3.i16(i16 %a, i16 %b, i16 %c, i32 15)
  %ret_cast = bitcast i16 %ret to half
  ret half %ret_cast
}

define amdgpu_ps half @bitop3_b16_svv(i16 inreg %a, i16 %b, i16 %c) {
; GCN-LABEL: bitop3_b16_svv:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_bitop3_b16 v0, s0, v0, v1 bitop3:0x10
; GCN-NEXT:    ; return to shader part epilog
  %ret = call i16 @llvm.amdgcn.bitop3.i16(i16 %a, i16 %b, i16 %c, i32 16)
  %ret_cast = bitcast i16 %ret to half
  ret half %ret_cast
}

define amdgpu_ps half @bitop3_b16_ssv(i16 inreg %a, i16 inreg %b, i16 %c) {
; GCN-LABEL: bitop3_b16_ssv:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_bitop3_b16 v0, s0, v1, v0 bitop3:0x11
; GCN-NEXT:    ; return to shader part epilog
  %ret = call i16 @llvm.amdgcn.bitop3.i16(i16 %a, i16 %b, i16 %c, i32 17)
  %ret_cast = bitcast i16 %ret to half
  ret half %ret_cast
}

define amdgpu_ps half @bitop3_b16_sss(i16 inreg %a, i16 inreg %b, i16 inreg %c) {
; GCN-LABEL: bitop3_b16_sss:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    v_mov_b32_e32 v1, s2
; GCN-NEXT:    v_bitop3_b16 v0, s0, v0, v1 bitop3:0x12
; GCN-NEXT:    ; return to shader part epilog
  %ret = call i16 @llvm.amdgcn.bitop3.i16(i16 %a, i16 %b, i16 %c, i32 18)
  %ret_cast = bitcast i16 %ret to half
  ret half %ret_cast
}

define amdgpu_ps half @bitop3_b16_vvi(i16 %a, i16 %b) {
; GFX950-SDAG-LABEL: bitop3_b16_vvi:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_movk_i32 s0, 0x3e8
; GFX950-SDAG-NEXT:    v_bitop3_b16 v0, v0, v1, s0 bitop3:0x13
; GFX950-SDAG-NEXT:    ; return to shader part epilog
;
; GFX950-GISEL-LABEL: bitop3_b16_vvi:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v2, 0x3e8
; GFX950-GISEL-NEXT:    v_bitop3_b16 v0, v0, v1, v2 bitop3:0x13
; GFX950-GISEL-NEXT:    ; return to shader part epilog
  %ret = call i16 @llvm.amdgcn.bitop3.i16(i16 %a, i16 %b, i16 1000, i32 19)
  %ret_cast = bitcast i16 %ret to half
  ret half %ret_cast
}

define amdgpu_ps half @bitop3_b16_vii(i16 %a) {
; GFX950-SDAG-LABEL: bitop3_b16_vii:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_movk_i32 s0, 0x7d0
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v1, 0x3e8
; GFX950-SDAG-NEXT:    v_bitop3_b16 v0, v0, s0, v1 bitop3:0x14
; GFX950-SDAG-NEXT:    ; return to shader part epilog
;
; GFX950-GISEL-LABEL: bitop3_b16_vii:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7d0
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v2, 0x3e8
; GFX950-GISEL-NEXT:    v_bitop3_b16 v0, v0, v1, v2 bitop3:0x14
; GFX950-GISEL-NEXT:    ; return to shader part epilog
  %ret = call i16 @llvm.amdgcn.bitop3.i16(i16 %a, i16 2000, i16 1000, i32 20)
  %ret_cast = bitcast i16 %ret to half
  ret half %ret_cast
}

; FIXME: Constant fold this
define amdgpu_ps half @bitop3_b16_iii() {
; GFX950-SDAG-LABEL: bitop3_b16_iii:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_movk_i32 s0, 0xbb8
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v0, 0x7d0
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v1, 0x3e8
; GFX950-SDAG-NEXT:    v_bitop3_b16 v0, s0, v0, v1 bitop3:0x15
; GFX950-SDAG-NEXT:    ; return to shader part epilog
;
; GFX950-GISEL-LABEL: bitop3_b16_iii:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v0, 0xbb8
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7d0
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v2, 0x3e8
; GFX950-GISEL-NEXT:    v_bitop3_b16 v0, v0, v1, v2 bitop3:0x15
; GFX950-GISEL-NEXT:    ; return to shader part epilog
  %ret = call i16 @llvm.amdgcn.bitop3.i16(i16 3000, i16 2000, i16 1000, i32 21)
  %ret_cast = bitcast i16 %ret to half
  ret half %ret_cast
}
