; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; PR129363

; ext split from i32 to i128
define i128 @i128_ext_split(i32 noundef %x) {
; CHECK-LABEL: define i128 @i128_ext_split(
; CHECK-SAME: i32 noundef [[X:%.*]]) {
; CHECK-NEXT:    [[XX:%.*]] = sext i32 [[X]] to i128
; CHECK-NEXT:    ret i128 [[XX]]
;
  %LowerSrc = sext i32 %x to i64
  %sign = ashr i32 %x, 31
  %UpperSrc = sext i32 %sign to i64
  %widen = zext i64 %UpperSrc to i128
  %hi = shl nuw i128 %widen, 64
  %lo = zext i64 %LowerSrc to i128
  %res = or disjoint i128 %hi, %lo
  ret i128 %res
}

; ext split from i32 to i128
define void @i128_ext_split_store(i32 %x, ptr %out)  {
; CHECK-LABEL: define void @i128_ext_split_store(
; CHECK-SAME: i32 [[X:%.*]], ptr [[OUT:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[RES:%.*]] = sext i32 [[X]] to i128
; CHECK-NEXT:    store i128 [[RES]], ptr [[OUT]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %LowerSrc = sext i32 %x to i64
  %lo = zext i64 %LowerSrc to i128

  %sign = ashr i32 %x, 31
  %UpperSrc = sext i32 %sign to i64
  %widen = zext i64 %UpperSrc to i128
  %hi = shl nuw i128 %widen, 64

  %res = or disjoint i128 %hi, %lo
  store i128 %res, ptr %out, align 16
  ret void
}

; ext split from i16 to i64
define void @i64_ext_split_store(i16 %x, ptr %out)  {
; CHECK-LABEL: define void @i64_ext_split_store(
; CHECK-SAME: i16 [[X:%.*]], ptr [[OUT:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[RES:%.*]] = sext i16 [[X]] to i64
; CHECK-NEXT:    store i64 [[RES]], ptr [[OUT]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %LowerSrc = sext i16 %x to i32
  %lo = zext i32 %LowerSrc to i64

  %sign = ashr i16 %x, 15
  %UpperSrc = sext i16 %sign to i32
  %widen = zext i32 %UpperSrc to i64
  %hi = shl nuw i64 %widen, 32

  %res = or disjoint i64 %hi, %lo
  store i64 %res, ptr %out, align 16
  ret void
}

; ext split from i16 to i128
define void @i128_ext_split_store_i16(i16 %x, ptr %out)  {
; CHECK-LABEL: define void @i128_ext_split_store_i16(
; CHECK-SAME: i16 [[X:%.*]], ptr [[OUT:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[RES:%.*]] = sext i16 [[X]] to i128
; CHECK-NEXT:    store i128 [[RES]], ptr [[OUT]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %LowerSrc = sext i16 %x to i64
  %lo = zext i64 %LowerSrc to i128

  %sign = ashr i16 %x, 15
  %UpperSrc = sext i16 %sign to i64
  %widen = zext i64 %UpperSrc to i128
  %hi = shl nuw i128 %widen, 64

  %res = or disjoint i128 %hi, %lo
  store i128 %res, ptr %out, align 16
  ret void
}

; (non)ext split from i64 to i128
define void @i128_ext_split_store_i64(i64 %x, ptr %out)  {
; CHECK-LABEL: define void @i128_ext_split_store_i64(
; CHECK-SAME: i64 [[X:%.*]], ptr [[OUT:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[RES:%.*]] = sext i64 [[X]] to i128
; CHECK-NEXT:    store i128 [[RES]], ptr [[OUT]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %lo = zext i64 %x to i128

  %sign = ashr i64 %x, 63
  %widen = zext i64 %sign to i128
  %hi = shl nuw i128 %widen, 64

  %res = or disjoint i128 %hi, %lo
  store i128 %res, ptr %out, align 16
  ret void
}

; negative test - wrong constant value
define i128 @i128_ext_split_neg1(i32 %x) {
; CHECK-LABEL: define i128 @i128_ext_split_neg1(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[LOWERSRC:%.*]] = sext i32 [[X]] to i64
; CHECK-NEXT:    [[LO:%.*]] = zext i64 [[LOWERSRC]] to i128
; CHECK-NEXT:    [[SIGN:%.*]] = ashr i32 [[X]], 31
; CHECK-NEXT:    [[UPPERSRC:%.*]] = sext i32 [[SIGN]] to i64
; CHECK-NEXT:    [[WIDEN:%.*]] = zext i64 [[UPPERSRC]] to i128
; CHECK-NEXT:    [[HI:%.*]] = shl nuw i128 [[WIDEN]], 65
; CHECK-NEXT:    [[RES:%.*]] = or disjoint i128 [[HI]], [[LO]]
; CHECK-NEXT:    ret i128 [[RES]]
;
entry:
  %LowerSrc = sext i32 %x to i64
  %lo = zext i64 %LowerSrc to i128

  %sign = ashr i32 %x, 31
  %UpperSrc = sext i32 %sign to i64
  %widen = zext i64 %UpperSrc to i128
  %hi = shl nuw i128 %widen, 65

  %res = or disjoint i128 %hi, %lo
  ret i128 %res
}

; negative test - wrong shift value
define i128 @i128_ext_split_neg2(i32 %x) {
; CHECK-LABEL: define i128 @i128_ext_split_neg2(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[LOWERSRC:%.*]] = sext i32 [[X]] to i64
; CHECK-NEXT:    [[LO:%.*]] = zext i64 [[LOWERSRC]] to i128
; CHECK-NEXT:    [[SIGN:%.*]] = ashr i32 [[X]], 3
; CHECK-NEXT:    [[UPPERSRC:%.*]] = sext i32 [[SIGN]] to i64
; CHECK-NEXT:    [[WIDEN:%.*]] = zext i64 [[UPPERSRC]] to i128
; CHECK-NEXT:    [[HI:%.*]] = shl nuw i128 [[WIDEN]], 64
; CHECK-NEXT:    [[RES:%.*]] = or disjoint i128 [[HI]], [[LO]]
; CHECK-NEXT:    ret i128 [[RES]]
;
entry:
  %LowerSrc = sext i32 %x to i64
  %lo = zext i64 %LowerSrc to i128

  %sign = ashr i32 %x, 3
  %UpperSrc = sext i32 %sign to i64
  %widen = zext i64 %UpperSrc to i128
  %hi = shl nuw i128 %widen, 64

  %res = or disjoint i128 %hi, %lo
  ret i128 %res
}

; negative test - wrong ext instruction
define i128 @i128_ext_split_neg3(i32 %x) {
; CHECK-LABEL: define i128 @i128_ext_split_neg3(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[LO:%.*]] = zext i32 [[X]] to i128
; CHECK-NEXT:    [[SIGN:%.*]] = ashr i32 [[X]], 31
; CHECK-NEXT:    [[UPPERSRC:%.*]] = sext i32 [[SIGN]] to i64
; CHECK-NEXT:    [[WIDEN:%.*]] = zext i64 [[UPPERSRC]] to i128
; CHECK-NEXT:    [[HI:%.*]] = shl nuw i128 [[WIDEN]], 64
; CHECK-NEXT:    [[RES:%.*]] = or disjoint i128 [[HI]], [[LO]]
; CHECK-NEXT:    ret i128 [[RES]]
;
entry:
  %LowerSrc = zext i32 %x to i64
  %lo = zext i64 %LowerSrc to i128

  %sign = ashr i32 %x, 31
  %UpperSrc = sext i32 %sign to i64
  %widen = zext i64 %UpperSrc to i128
  %hi = shl nuw i128 %widen, 64

  %res = or disjoint i128 %hi, %lo
  ret i128 %res
}

; negative test - wrong shift
define i128 @i128_ext_split_neg4(i32 %x) {
; CHECK-LABEL: define i128 @i128_ext_split_neg4(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[LOWERSRC:%.*]] = sext i32 [[X]] to i64
; CHECK-NEXT:    [[LO:%.*]] = zext i64 [[LOWERSRC]] to i128
; CHECK-NEXT:    [[SIGN:%.*]] = lshr i32 [[X]], 31
; CHECK-NEXT:    [[WIDEN:%.*]] = zext nneg i32 [[SIGN]] to i128
; CHECK-NEXT:    [[HI:%.*]] = shl nuw nsw i128 [[WIDEN]], 64
; CHECK-NEXT:    [[RES:%.*]] = or disjoint i128 [[HI]], [[LO]]
; CHECK-NEXT:    ret i128 [[RES]]
;
entry:
  %LowerSrc = sext i32 %x to i64
  %lo = zext i64 %LowerSrc to i128

  %sign = lshr i32 %x, 31
  %UpperSrc = sext i32 %sign to i64
  %widen = zext i64 %UpperSrc to i128
  %hi = shl nuw i128 %widen, 64

  %res = or disjoint i128 %hi, %lo
  ret i128 %res
}
