; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC
; FIXME: Figure out why we need 16 iterations here.

declare void @deref_phi_user(ptr %a);

; TEST 1
; take mininimum of return values
;
;.
; CHECK: @g = global i64 0
;.
define ptr @test1(ptr dereferenceable(4) %0, ptr dereferenceable(8) %1, i1 zeroext %2) local_unnamed_addr {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@test1
; CHECK-SAME: (ptr nofree noundef nonnull readnone dereferenceable(4) "no-capture-maybe-returned" [[TMP0:%.*]], ptr nofree noundef nonnull readnone dereferenceable(8) "no-capture-maybe-returned" [[TMP1:%.*]], i1 zeroext [[TMP2:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[TMP4:%.*]] = select i1 [[TMP2]], ptr [[TMP0]], ptr [[TMP1]]
; CHECK-NEXT:    ret ptr [[TMP4]]
;
  %4 = select i1 %2, ptr %0, ptr %1
  ret ptr %4
}

; TEST 2
define ptr @test2(ptr dereferenceable_or_null(4) %0, ptr dereferenceable(8) %1, i1 zeroext %2) local_unnamed_addr {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@test2
; CHECK-SAME: (ptr nofree noundef readnone dereferenceable_or_null(4) "no-capture-maybe-returned" [[TMP0:%.*]], ptr nofree noundef nonnull readnone dereferenceable(8) "no-capture-maybe-returned" [[TMP1:%.*]], i1 zeroext [[TMP2:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    [[TMP4:%.*]] = select i1 [[TMP2]], ptr [[TMP0]], ptr [[TMP1]]
; CHECK-NEXT:    ret ptr [[TMP4]]
;
  %4 = select i1 %2, ptr %0, ptr %1
  ret ptr %4
}

; TEST 3
; GEP inbounds
define ptr @test3_1(ptr dereferenceable(8) %0) local_unnamed_addr {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@test3_1
; CHECK-SAME: (ptr nofree noundef nonnull readnone dereferenceable(8) "no-capture-maybe-returned" [[TMP0:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 1
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = getelementptr inbounds i32, ptr %0, i64 1
  ret ptr %ret
}

define ptr @test3_2(ptr dereferenceable_or_null(32) %0) local_unnamed_addr {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@test3_2
; CHECK-SAME: (ptr nofree noundef readnone dereferenceable_or_null(32) "no-capture-maybe-returned" [[TMP0:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 4
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = getelementptr inbounds i32, ptr %0, i64 4
  ret ptr %ret
}

define ptr @test3_3(ptr dereferenceable(8) %0, ptr dereferenceable(16) %1, i1 %2) local_unnamed_addr {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@test3_3
; CHECK-SAME: (ptr nofree noundef nonnull readnone dereferenceable(8) "no-capture-maybe-returned" [[TMP0:%.*]], ptr nofree noundef nonnull readnone dereferenceable(16) "no-capture-maybe-returned" [[TMP1:%.*]], i1 [[TMP2:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    [[RET1:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 1
; CHECK-NEXT:    [[RET2:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 2
; CHECK-NEXT:    [[RET:%.*]] = select i1 [[TMP2]], ptr [[RET1]], ptr [[RET2]]
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret1 = getelementptr inbounds i32, ptr %0, i64 1
  %ret2 = getelementptr inbounds i32, ptr %1, i64 2
  %ret = select i1 %2, ptr %ret1, ptr %ret2
  ret ptr %ret
}

; TEST 4
; Better than known in IR.

define dereferenceable(4) ptr @test4(ptr dereferenceable(8) %0) local_unnamed_addr {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@test4
; CHECK-SAME: (ptr nofree noundef nonnull readnone returned dereferenceable(8) "no-capture-maybe-returned" [[TMP0:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    ret ptr [[TMP0]]
;
  ret ptr %0
}

; TEST 5
; loop in which dereferenceabily "grows"
define void @deref_phi_growing(ptr dereferenceable(4000) %a) {
; CHECK-LABEL: define {{[^@]+}}@deref_phi_growing
; CHECK-SAME: (ptr noundef nonnull dereferenceable(4000) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_INC:%.*]] ]
; CHECK-NEXT:    [[A_ADDR_0:%.*]] = phi ptr [ [[A]], [[ENTRY]] ], [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ]
; CHECK-NEXT:    call void @deref_phi_user(ptr nonnull [[A_ADDR_0]])
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[A_ADDR_0]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], [[VAL]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    br label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    br label [[FOR_INC]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i32, ptr [[A_ADDR_0]], i64 -1
; CHECK-NEXT:    [[INC]] = add nuw nsw i32 [[I_0]], 1
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.inc ]
  %a.addr.0 = phi ptr [ %a, %entry ], [ %incdec.ptr, %for.inc ]
  call void @deref_phi_user(ptr %a.addr.0)
  %val = load i32, ptr %a.addr.0, align 4
  %cmp = icmp slt i32 %i.0, %val
  br i1 %cmp, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  br label %for.end

for.body:                                         ; preds = %for.cond
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %incdec.ptr = getelementptr inbounds i32, ptr %a.addr.0, i64 -1
  %inc = add nuw nsw i32 %i.0, 1
  br label %for.cond

for.end:                                          ; preds = %for.cond.cleanup
  ret void
}

; TEST 6
; loop in which dereferenceabily "shrinks"
define void @deref_phi_shrinking(ptr dereferenceable(4000) %a) {
; CHECK-LABEL: define {{[^@]+}}@deref_phi_shrinking
; CHECK-SAME: (ptr noundef nonnull dereferenceable(4000) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_INC:%.*]] ]
; CHECK-NEXT:    [[A_ADDR_0:%.*]] = phi ptr [ [[A]], [[ENTRY]] ], [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ]
; CHECK-NEXT:    call void @deref_phi_user(ptr nonnull [[A_ADDR_0]])
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[A_ADDR_0]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], [[VAL]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    br label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    br label [[FOR_INC]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i32, ptr [[A_ADDR_0]], i64 1
; CHECK-NEXT:    [[INC]] = add nuw nsw i32 [[I_0]], 1
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.inc ]
  %a.addr.0 = phi ptr [ %a, %entry ], [ %incdec.ptr, %for.inc ]
  call void @deref_phi_user(ptr %a.addr.0)
  %val = load i32, ptr %a.addr.0, align 4
  %cmp = icmp slt i32 %i.0, %val
  br i1 %cmp, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  br label %for.end

for.body:                                         ; preds = %for.cond
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %incdec.ptr = getelementptr inbounds i32, ptr %a.addr.0, i64 1
  %inc = add nuw nsw i32 %i.0, 1
  br label %for.cond

for.end:                                          ; preds = %for.cond.cleanup
  ret void
}

; TEST 7
; share known infomation in must-be-executed-context
declare ptr @unkown_ptr() willreturn nounwind
declare i32 @unkown_f(ptr) willreturn nounwind
define ptr @f7_0(ptr %ptr) {
; CHECK: Function Attrs: mustprogress nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@f7_0
; CHECK-SAME: (ptr noundef nonnull returned dereferenceable(8) [[PTR:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[T:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull dereferenceable(8) [[PTR]]) #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    ret ptr [[PTR]]
;
  %T = tail call i32 @unkown_f(ptr dereferenceable(8) %ptr)
  ret ptr %ptr
}

define void @f7_1(ptr %ptr, i1 %cnd) {
; CHECK: Function Attrs: mustprogress nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@f7_1
; CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[PTR:%.*]], i1 noundef [[CND:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[A:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(4) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    [[B:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(4) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    br i1 [[CND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    [[C:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(8) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    [[D:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(8) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    [[E:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(8) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    ret void
; CHECK:       if.false:
; CHECK-NEXT:    ret void
;
  %A = tail call i32 @unkown_f(ptr %ptr)
  %ptr.0 = load i32, ptr %ptr
  ; deref 4 hold
; FIXME: this should be %B = tail call i32 @unkown_f(ptr nonnull dereferenceable(4) %ptr)
  %B = tail call i32 @unkown_f(ptr dereferenceable(1) %ptr)
  br i1%cnd, label %if.true, label %if.false
if.true:
  %C = tail call i32 @unkown_f(ptr %ptr)
  %D = tail call i32 @unkown_f(ptr dereferenceable(8) %ptr)
  %E = tail call i32 @unkown_f(ptr %ptr)
  ret void
if.false:
  ret void
}

define void @f7_2(i1 %cnd) {
; CHECK: Function Attrs: mustprogress nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@f7_2
; CHECK-SAME: (i1 noundef [[CND:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[PTR:%.*]] = tail call nonnull align 4 dereferenceable(4) ptr @unkown_ptr() #[[ATTR1]]
; CHECK-NEXT:    [[A:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(4) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    [[ARG_A_0:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    [[B:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(4) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    br i1 [[CND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    [[C:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(8) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    [[D:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(8) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    [[E:%.*]] = tail call i32 @unkown_f(ptr noundef nonnull align 4 dereferenceable(8) [[PTR]]) #[[ATTR1]]
; CHECK-NEXT:    ret void
; CHECK:       if.false:
; CHECK-NEXT:    ret void
;
  %ptr =  tail call ptr @unkown_ptr()
  %A = tail call i32 @unkown_f(ptr %ptr)
  %arg_a.0 = load i32, ptr %ptr
  ; deref 4 hold
  %B = tail call i32 @unkown_f(ptr dereferenceable(1) %ptr)
  br i1%cnd, label %if.true, label %if.false
if.true:
  %C = tail call i32 @unkown_f(ptr %ptr)
  %D = tail call i32 @unkown_f(ptr dereferenceable(8) %ptr)
  %E = tail call i32 @unkown_f(ptr %ptr)
  ret void
if.false:
  ret void
}

define ptr @f7_3() {
; CHECK: Function Attrs: mustprogress nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@f7_3
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[PTR:%.*]] = tail call noundef nonnull align 16 dereferenceable(4) ptr @unkown_ptr() #[[ATTR1]]
; CHECK-NEXT:    store i32 10, ptr [[PTR]], align 16
; CHECK-NEXT:    ret ptr [[PTR]]
;
  %ptr = tail call ptr @unkown_ptr()
  store i32 10, ptr %ptr, align 16
  ret ptr %ptr
}

; FIXME: This should have a return dereferenceable(8) but we need to make sure it will work in loops as well.
define ptr @test_for_minus_index(ptr %p) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write)
; CHECK-LABEL: define {{[^@]+}}@test_for_minus_index
; CHECK-SAME: (ptr nofree nonnull writeonly align 4 "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, ptr [[P]], i32 -2
; CHECK-NEXT:    store i32 1, ptr [[Q]], align 4
; CHECK-NEXT:    ret ptr [[Q]]
;
  %q = getelementptr inbounds i32, ptr %p, i32 -2
  store i32 1, ptr %q
  ret ptr %q
}

define void @deref_or_null_and_nonnull(ptr dereferenceable_or_null(100) %0) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write)
; CHECK-LABEL: define {{[^@]+}}@deref_or_null_and_nonnull
; CHECK-SAME: (ptr nofree noundef nonnull writeonly align 4 captures(none) dereferenceable(100) [[TMP0:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    store i32 1, ptr [[TMP0]], align 4
; CHECK-NEXT:    ret void
;
  store i32 1, ptr %0
  ret void
}

; TEST 8
; Use Constant range in deereferenceable
; void g(int *p, long long int *range){
;   int r = *range ; // [10, 99]
;   fill_range(p, *range);
; }

; FIXME: %ptr should be dereferenceable(31)
define void @test8(ptr %ptr) #0 {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write)
; CHECK-LABEL: define {{[^@]+}}@test8
; CHECK-SAME: (ptr nofree nonnull writeonly captures(none) dereferenceable(21) [[PTR:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    br label [[TMP1:%.*]]
; CHECK:       1:
; CHECK-NEXT:    [[I_0:%.*]] = phi i32 [ 20, [[TMP0:%.*]] ], [ [[TMP4:%.*]], [[TMP5:%.*]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = sext i32 [[I_0]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[PTR]], i64 [[TMP2]]
; CHECK-NEXT:    store i8 32, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP4]] = add nsw i32 [[I_0]], 1
; CHECK-NEXT:    br label [[TMP5]]
; CHECK:       5:
; CHECK-NEXT:    [[TMP6:%.*]] = icmp slt i32 [[TMP4]], 30
; CHECK-NEXT:    br i1 [[TMP6]], label [[TMP1]], label [[TMP7:%.*]]
; CHECK:       7:
; CHECK-NEXT:    ret void
;
  br label %1
1:                                                ; preds = %5, %0
  %i.0 = phi i32 [ 20, %0 ], [ %4, %5 ]
  %2 = sext i32 %i.0 to i64
  %3 = getelementptr inbounds i8, ptr %ptr, i64 %2
  store i8 32, ptr %3, align 1
  %4 = add nsw i32 %i.0, 1
  br label %5
5:                                                ; preds = %1
  %6 = icmp slt i32 %4, 30
  br i1 %6, label %1, label %7

7:                                                ; preds = %5
  ret void
}

; 8.2 (negative case)
define void @test8_neg(i32 %i, ptr %ptr) #0 {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write)
; CHECK-LABEL: define {{[^@]+}}@test8_neg
; CHECK-SAME: (i32 [[I:%.*]], ptr nofree nonnull writeonly captures(none) [[PTR:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[TMP1:%.*]] = sext i32 [[I]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i8, ptr [[PTR]], i64 [[TMP1]]
; CHECK-NEXT:    store i8 65, ptr [[TMP2]], align 1
; CHECK-NEXT:    ret void
;
  %1 = sext i32 %i to i64
  %2 = getelementptr inbounds i8, ptr %ptr, i64 %1
  store i8 65, ptr %2, align 1
  ret void
}

; void fill_range(int* p, long long int start){
;   for(long long int i = start;i<start+10;i++){
;     // If p[i] is inbounds, p is dereferenceable(40) at least.
;     p[i] = i;
;   }
; }

; NOTE: %p should not be dereferenceable
define internal void @fill_range_not_inbounds(ptr %p, i64 %start){
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write)
; CHECK-LABEL: define {{[^@]+}}@fill_range_not_inbounds
; CHECK-SAME: (ptr nofree writeonly captures(none) [[P:%.*]], i64 [[START:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 [[START]], 9
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    ret void
; CHECK:       for.body:
; CHECK-NEXT:    [[I_06:%.*]] = phi i64 [ [[START]], [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[CONV:%.*]] = trunc i64 [[I_06]] to i32
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr i32, ptr [[P]], i64 [[I_06]]
; CHECK-NEXT:    store i32 [[CONV]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[INC]] = add nsw i64 [[I_06]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[I_06]], [[TMP0]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
;
entry:
  %0 = add nsw i64 %start, 9
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %i.06 = phi i64 [ %start, %entry ], [ %inc, %for.body ]
  %conv = trunc i64 %i.06 to i32
  %arrayidx = getelementptr i32, ptr %p, i64 %i.06
  store i32 %conv, ptr %arrayidx, align 4
  %inc = add nsw i64 %i.06, 1
  %cmp = icmp slt i64 %i.06, %0
  br i1 %cmp, label %for.body, label %for.cond.cleanup
}

; FIXME: %p should be dereferenceable(40)
define internal void @fill_range_inbounds(ptr %p, i64 %start){
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write)
; CHECK-LABEL: define {{[^@]+}}@fill_range_inbounds
; CHECK-SAME: (ptr nofree writeonly captures(none) [[P:%.*]], i64 [[START:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 [[START]], 9
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    ret void
; CHECK:       for.body:
; CHECK-NEXT:    [[I_06:%.*]] = phi i64 [ [[START]], [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[CONV:%.*]] = trunc i64 [[I_06]] to i32
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[P]], i64 [[I_06]]
; CHECK-NEXT:    store i32 [[CONV]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[INC]] = add nsw i64 [[I_06]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[I_06]], [[TMP0]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
;
entry:
  %0 = add nsw i64 %start, 9
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %i.06 = phi i64 [ %start, %entry ], [ %inc, %for.body ]
  %conv = trunc i64 %i.06 to i32
  %arrayidx = getelementptr inbounds i32, ptr %p, i64 %i.06
  store i32 %conv, ptr %arrayidx, align 4
  %inc = add nsw i64 %i.06, 1
  %cmp = icmp slt i64 %i.06, %0
  br i1 %cmp, label %for.body, label %for.cond.cleanup
}

define void @call_fill_range(ptr nocapture %p, ptr nocapture readonly %range) {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite)
; TUNIT-LABEL: define {{[^@]+}}@call_fill_range
; TUNIT-SAME: (ptr nofree writeonly captures(none) [[P:%.*]], ptr nofree noundef nonnull readonly align 8 captures(none) dereferenceable(8) [[RANGE:%.*]]) #[[ATTR4:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TMP0:%.*]] = load i64, ptr [[RANGE]], align 8, !range [[RNG0:![0-9]+]]
; TUNIT-NEXT:    tail call void @fill_range_inbounds(ptr nofree writeonly captures(none) [[P]], i64 [[TMP0]]) #[[ATTR7:[0-9]+]]
; TUNIT-NEXT:    tail call void @fill_range_not_inbounds(ptr nofree writeonly captures(none) [[P]], i64 [[TMP0]]) #[[ATTR7]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@call_fill_range
; CGSCC-SAME: (ptr nofree writeonly captures(none) [[P:%.*]], ptr nofree noundef nonnull readonly align 8 captures(none) dereferenceable(8) [[RANGE:%.*]]) #[[ATTR4:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TMP0:%.*]] = load i64, ptr [[RANGE]], align 8, !range [[RNG0:![0-9]+]]
; CGSCC-NEXT:    tail call void @fill_range_inbounds(ptr nofree writeonly captures(none) [[P]], i64 [[TMP0]]) #[[ATTR7:[0-9]+]]
; CGSCC-NEXT:    tail call void @fill_range_not_inbounds(ptr nofree writeonly captures(none) [[P]], i64 [[TMP0]]) #[[ATTR7]]
; CGSCC-NEXT:    ret void
;
entry:
  %0 = load i64, ptr %range, align 8, !range !0
  tail call void @fill_range_inbounds(ptr %p, i64 %0)
  tail call void @fill_range_not_inbounds(ptr %p, i64 %0)
  ret void
}

declare void @use0() willreturn nounwind
declare void @use1(ptr) willreturn nounwind
declare void @use2(ptr, ptr) willreturn nounwind
declare void @use3(ptr, ptr, ptr) willreturn nounwind

; simple path test
; if(..)
;   fun2(dereferenceable(8) %a, dereferenceable(8) %b)
; else
;   fun2(dereferenceable(4) %a, %b)
; We can say that %a is dereferenceable(4) but %b is not.
define void @simple-path(ptr %a, ptr %b, i8 %c) {
; CHECK: Function Attrs: mustprogress nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@simple-path
; CHECK-SAME: (ptr nonnull dereferenceable(4) [[A:%.*]], ptr [[B:%.*]], i8 [[C:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    tail call void @use2(ptr nonnull dereferenceable(8) [[A]], ptr nonnull dereferenceable(8) [[B]]) #[[ATTR1]]
; CHECK-NEXT:    ret void
; CHECK:       if.else:
; CHECK-NEXT:    tail call void @use2(ptr nonnull dereferenceable(4) [[A]], ptr [[B]]) #[[ATTR1]]
; CHECK-NEXT:    ret void
;
  %cmp = icmp eq i8 %c, 0
  br i1 %cmp, label %if.then, label %if.else
if.then:
  tail call void @use2(ptr dereferenceable(8) %a, ptr dereferenceable(8) %b)
  ret void
if.else:
  tail call void @use2(ptr dereferenceable(4) %a, ptr %b)
  ret void
}

; More complex test
; {
; fun1(dereferenceable(4) %a)
; if(..)
;    ... (willreturn & nounwind)
;    fun1(dereferenceable(12) %a)
; else
;    ... (willreturn & nounwind)
;    fun1(dereferenceable(16) %a)
; fun1(dereferenceable(8) %a)
; }
; %a is dereferenceable(12)
define void @complex-path(ptr %a, ptr %b, i8 %c) {
; CHECK: Function Attrs: mustprogress nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@complex-path
; CHECK-SAME: (ptr noundef nonnull dereferenceable(12) [[A:%.*]], ptr nofree readnone captures(none) [[B:%.*]], i8 [[C:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; CHECK-NEXT:    tail call void @use1(ptr noundef nonnull dereferenceable(12) [[A]]) #[[ATTR1]]
; CHECK-NEXT:    br i1 [[CMP]], label [[CONT_THEN:%.*]], label [[CONT_ELSE:%.*]]
; CHECK:       cont.then:
; CHECK-NEXT:    tail call void @use1(ptr noundef nonnull dereferenceable(12) [[A]]) #[[ATTR1]]
; CHECK-NEXT:    br label [[CONT2:%.*]]
; CHECK:       cont.else:
; CHECK-NEXT:    tail call void @use1(ptr noundef nonnull dereferenceable(16) [[A]]) #[[ATTR1]]
; CHECK-NEXT:    br label [[CONT2]]
; CHECK:       cont2:
; CHECK-NEXT:    tail call void @use1(ptr noundef nonnull dereferenceable(12) [[A]]) #[[ATTR1]]
; CHECK-NEXT:    ret void
;
  %cmp = icmp eq i8 %c, 0
  tail call void @use1(ptr dereferenceable(4) %a)
  br i1 %cmp, label %cont.then, label %cont.else
cont.then:
  tail call void @use1(ptr dereferenceable(12) %a)
  br label %cont2
cont.else:
  tail call void @use1(ptr dereferenceable(16) %a)
  br label %cont2
cont2:
  tail call void @use1(ptr dereferenceable(8) %a)
  ret void
}

;  void rec-branch-1(int a, int b, int c, int *ptr) {
;    if (a) {
;      if (b)
;        *ptr = 1;
;      else
;        *ptr = 2;
;    } else {
;      if (c)
;        *ptr = 3;
;      else
;        *ptr = 4;
;    }
;  }
;
; FIXME: %ptr should be dereferenceable(4)
define dso_local void @rec-branch-1(i32 %a, i32 %b, i32 %c, ptr %ptr) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write)
; CHECK-LABEL: define {{[^@]+}}@rec-branch-1
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], ptr nofree writeonly captures(none) [[PTR:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[A]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_ELSE3:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TOBOOL1:%.*]] = icmp eq i32 [[B]], 0
; CHECK-NEXT:    br i1 [[TOBOOL1]], label [[IF_ELSE:%.*]], label [[IF_THEN2:%.*]]
; CHECK:       if.then2:
; CHECK-NEXT:    store i32 1, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[IF_END8:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    store i32 2, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[IF_END8]]
; CHECK:       if.else3:
; CHECK-NEXT:    [[TOBOOL4:%.*]] = icmp eq i32 [[C]], 0
; CHECK-NEXT:    br i1 [[TOBOOL4]], label [[IF_ELSE6:%.*]], label [[IF_THEN5:%.*]]
; CHECK:       if.then5:
; CHECK-NEXT:    store i32 3, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[IF_END8]]
; CHECK:       if.else6:
; CHECK-NEXT:    store i32 4, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[IF_END8]]
; CHECK:       if.end8:
; CHECK-NEXT:    ret void
;
entry:
  %tobool = icmp eq i32 %a, 0
  br i1 %tobool, label %if.else3, label %if.then

if.then:                                          ; preds = %entry
  %tobool1 = icmp eq i32 %b, 0
  br i1 %tobool1, label %if.else, label %if.then2

if.then2:                                         ; preds = %if.then
  store i32 1, ptr %ptr, align 4
  br label %if.end8

if.else:                                          ; preds = %if.then
  store i32 2, ptr %ptr, align 4
  br label %if.end8

if.else3:                                         ; preds = %entry
  %tobool4 = icmp eq i32 %c, 0
  br i1 %tobool4, label %if.else6, label %if.then5

if.then5:                                         ; preds = %if.else3
  store i32 3, ptr %ptr, align 4
  br label %if.end8

if.else6:                                         ; preds = %if.else3
  store i32 4, ptr %ptr, align 4
  br label %if.end8

if.end8:                                          ; preds = %if.then5, %if.else6, %if.then2, %if.else
  ret void
}

;  void rec-branch-2(int a, int b, int c, int *ptr) {
;    if (a) {
;      if (b)
;        *ptr = 1;
;      else
;        *ptr = 2;
;    } else {
;      if (c)
;        *ptr = 3;
;      else
;        rec-branch-2(1, 1, 1, ptr);
;    }
;  }
; FIXME: %ptr should be dereferenceable(4)
define dso_local void @rec-branch-2(i32 %a, i32 %b, i32 %c, ptr %ptr) {
; CHECK: Function Attrs: nofree nosync nounwind memory(argmem: write)
; CHECK-LABEL: define {{[^@]+}}@rec-branch-2
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], ptr nofree writeonly captures(none) [[PTR:%.*]]) #[[ATTR5:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[A]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_ELSE3:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TOBOOL1:%.*]] = icmp eq i32 [[B]], 0
; CHECK-NEXT:    br i1 [[TOBOOL1]], label [[IF_ELSE:%.*]], label [[IF_THEN2:%.*]]
; CHECK:       if.then2:
; CHECK-NEXT:    store i32 1, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[IF_END8:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    store i32 2, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[IF_END8]]
; CHECK:       if.else3:
; CHECK-NEXT:    [[TOBOOL4:%.*]] = icmp eq i32 [[C]], 0
; CHECK-NEXT:    br i1 [[TOBOOL4]], label [[IF_ELSE6:%.*]], label [[IF_THEN5:%.*]]
; CHECK:       if.then5:
; CHECK-NEXT:    store i32 3, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[IF_END8]]
; CHECK:       if.else6:
; CHECK-NEXT:    tail call void @rec-branch-2(i32 noundef 1, i32 noundef 1, i32 noundef 1, ptr nofree writeonly captures(none) [[PTR]]) #[[ATTR8:[0-9]+]]
; CHECK-NEXT:    br label [[IF_END8]]
; CHECK:       if.end8:
; CHECK-NEXT:    ret void
;
entry:
  %tobool = icmp eq i32 %a, 0
  br i1 %tobool, label %if.else3, label %if.then

if.then:                                          ; preds = %entry
  %tobool1 = icmp eq i32 %b, 0
  br i1 %tobool1, label %if.else, label %if.then2

if.then2:                                         ; preds = %if.then
  store i32 1, ptr %ptr, align 4
  br label %if.end8

if.else:                                          ; preds = %if.then
  store i32 2, ptr %ptr, align 4
  br label %if.end8

if.else3:                                         ; preds = %entry
  %tobool4 = icmp eq i32 %c, 0
  br i1 %tobool4, label %if.else6, label %if.then5

if.then5:                                         ; preds = %if.else3
  store i32 3, ptr %ptr, align 4
  br label %if.end8

if.else6:                                         ; preds = %if.else3
  tail call void @rec-branch-2(i32 1, i32 1, i32 1, ptr %ptr)
  br label %if.end8

if.end8:                                          ; preds = %if.then5, %if.else6, %if.then2, %if.else
  ret void
}

declare void @unknown()
define void @nonnull_assume_pos(ptr %arg1, ptr %arg2, ptr %arg3, ptr %arg4) {
; ATTRIBUTOR-LABEL: define {{[^@]+}}@nonnull_assume_pos
; ATTRIBUTOR-SAME: (ptr nocapture nofree nonnull readnone dereferenceable(101) [[ARG1:%.*]], ptr nocapture nofree readnone dereferenceable_or_null(31) [[ARG2:%.*]], ptr nocapture nofree nonnull readnone [[ARG3:%.*]], ptr nocapture nofree readnone dereferenceable_or_null(42) [[ARG4:%.*]])
; ATTRIBUTOR-NEXT:    call void @llvm.assume(i1 true) #6 [ "nonnull"(ptr undef), "dereferenceable"(ptr undef, i64 1), "dereferenceable"(ptr undef, i64 2), "dereferenceable"(ptr undef, i64 101), "dereferenceable_or_null"(ptr undef, i64 31), "dereferenceable_or_null"(ptr undef, i64 42) ]
; ATTRIBUTOR-NEXT:    call void @unknown()
; ATTRIBUTOR-NEXT:    ret void
;
; CHECK-LABEL: define {{[^@]+}}@nonnull_assume_pos
; CHECK-SAME: (ptr nofree nonnull readnone captures(none) dereferenceable(101) [[ARG1:%.*]], ptr nofree readnone captures(none) dereferenceable_or_null(31) [[ARG2:%.*]], ptr nofree nonnull readnone captures(none) [[ARG3:%.*]], ptr nofree readnone captures(none) dereferenceable_or_null(42) [[ARG4:%.*]]) {
; CHECK-NEXT:    call void @llvm.assume(i1 noundef true) #[[ATTR9:[0-9]+]] [ "nonnull"(ptr [[ARG3]]), "dereferenceable"(ptr [[ARG1]], i64 1), "dereferenceable"(ptr [[ARG1]], i64 2), "dereferenceable"(ptr [[ARG1]], i64 101), "dereferenceable_or_null"(ptr [[ARG2]], i64 31), "dereferenceable_or_null"(ptr [[ARG4]], i64 42) ]
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    ret void
;
  call void @llvm.assume(i1 true) [ "nonnull"(ptr %arg3), "dereferenceable"(ptr %arg1, i64 1), "dereferenceable"(ptr %arg1, i64 2), "dereferenceable"(ptr %arg1, i64 101), "dereferenceable_or_null"(ptr %arg2, i64 31), "dereferenceable_or_null"(ptr %arg4, i64 42)]
  call void @unknown()
  ret void
}
define void @nonnull_assume_neg(ptr %arg1, ptr %arg2, ptr %arg3) {
; ATTRIBUTOR-LABEL: define {{[^@]+}}@nonnull_assume_neg
; ATTRIBUTOR-SAME: (ptr nocapture nofree readnone [[ARG1:%.*]], ptr nocapture nofree readnone [[ARG2:%.*]], ptr nocapture nofree readnone [[ARG3:%.*]])
; ATTRIBUTOR-NEXT:    call void @unknown()
; ATTRIBUTOR-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr undef, i64 101), "dereferenceable"(ptr undef, i64 -2), "dereferenceable_or_null"(ptr undef, i64 31) ]
; ATTRIBUTOR-NEXT:    ret void
;
; CHECK-LABEL: define {{[^@]+}}@nonnull_assume_neg
; CHECK-SAME: (ptr nofree readnone captures(none) [[ARG1:%.*]], ptr nofree readnone captures(none) [[ARG2:%.*]], ptr nofree readnone captures(none) [[ARG3:%.*]]) {
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    call void @llvm.assume(i1 noundef true) [ "dereferenceable"(ptr [[ARG1]], i64 101), "dereferenceable"(ptr [[ARG2]], i64 -2), "dereferenceable_or_null"(ptr [[ARG3]], i64 31) ]
; CHECK-NEXT:    ret void
;
  call void @unknown()
  call void @llvm.assume(i1 true) ["dereferenceable"(ptr %arg1, i64 101), "dereferenceable"(ptr %arg2, i64 -2), "dereferenceable_or_null"(ptr %arg3, i64 31)]
  ret void
}
define void @nonnull_assume_call(ptr %arg1, ptr %arg2, ptr %arg3, ptr %arg4) {
; ATTRIBUTOR-LABEL: define {{[^@]+}}@nonnull_assume_call
; ATTRIBUTOR-SAME: (ptr [[ARG1:%.*]], ptr [[ARG2:%.*]], ptr [[ARG3:%.*]], ptr [[ARG4:%.*]])
; ATTRIBUTOR-NEXT:    call void @unknown()
; ATTRIBUTOR-NEXT:    [[P:%.*]] = call nonnull dereferenceable(101) ptr @unkown_ptr()
; ATTRIBUTOR-NEXT:    call void @unknown_use32(ptr nonnull dereferenceable(101) [[P]])
; ATTRIBUTOR-NEXT:    call void @unknown_use8(ptr nonnull dereferenceable(42) [[ARG4]])
; ATTRIBUTOR-NEXT:    call void @unknown_use8(ptr nonnull [[ARG3]])
; ATTRIBUTOR-NEXT:    call void @unknown_use8(ptr nonnull dereferenceable(31) [[ARG2]])
; ATTRIBUTOR-NEXT:    call void @unknown_use8(ptr nonnull dereferenceable(2) [[ARG1]])
; ATTRIBUTOR-NEXT:    call void @llvm.assume(i1 true) [ "nonnull"(ptr [[ARG3]]), "dereferenceable"(ptr [[ARG1]], i64 1), "dereferenceable"(ptr [[ARG1]], i64 2), "dereferenceable"(ptr [[P]], i64 101), "dereferenceable_or_null"(ptr [[ARG2]], i64 31), "dereferenceable_or_null"(ptr [[ARG4]], i64 42) ]
; ATTRIBUTOR-NEXT:    call void @unknown_use8(ptr nonnull dereferenceable(2) [[ARG1]])
; ATTRIBUTOR-NEXT:    call void @unknown_use8(ptr nonnull dereferenceable(31) [[ARG2]])
; ATTRIBUTOR-NEXT:    call void @unknown_use8(ptr nonnull [[ARG3]])
; ATTRIBUTOR-NEXT:    call void @unknown_use8(ptr nonnull dereferenceable(42) [[ARG4]])
; ATTRIBUTOR-NEXT:    call void @unknown_use32(ptr nonnull dereferenceable(101) [[P]])
; ATTRIBUTOR-NEXT:    call void @unknown()
; ATTRIBUTOR-NEXT:    ret void
;
; CHECK-LABEL: define {{[^@]+}}@nonnull_assume_call
; CHECK-SAME: (ptr [[ARG1:%.*]], ptr [[ARG2:%.*]], ptr [[ARG3:%.*]], ptr [[ARG4:%.*]]) {
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    [[P:%.*]] = call nonnull dereferenceable(101) ptr @unkown_ptr() #[[ATTR10:[0-9]+]]
; CHECK-NEXT:    call void @unknown_use32(ptr nonnull dereferenceable(101) [[P]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown_use8(ptr dereferenceable_or_null(42) [[ARG4]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown_use8(ptr nonnull [[ARG3]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown_use8(ptr dereferenceable_or_null(31) [[ARG2]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown_use8(ptr nonnull dereferenceable(2) [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    call void @llvm.assume(i1 noundef true) [ "nonnull"(ptr [[ARG3]]), "dereferenceable"(ptr [[ARG1]], i64 1), "dereferenceable"(ptr [[ARG1]], i64 2), "dereferenceable"(ptr [[P]], i64 101), "dereferenceable_or_null"(ptr [[ARG2]], i64 31), "dereferenceable_or_null"(ptr [[ARG4]], i64 42) ]
; CHECK-NEXT:    call void @unknown_use8(ptr nonnull dereferenceable(2) [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown_use8(ptr dereferenceable_or_null(31) [[ARG2]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown_use8(ptr nonnull [[ARG3]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown_use8(ptr dereferenceable_or_null(42) [[ARG4]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown_use32(ptr nonnull dereferenceable(101) [[P]]) #[[ATTR10]]
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    ret void
;
  call void @unknown()
  %p = call ptr @unkown_ptr()
  call void @unknown_use32(ptr %p)
  call void @unknown_use8(ptr %arg4)
  call void @unknown_use8(ptr %arg3)
  call void @unknown_use8(ptr %arg2)
  call void @unknown_use8(ptr %arg1)
  call void @llvm.assume(i1 true) [ "nonnull"(ptr %arg3), "dereferenceable"(ptr %arg1, i64 1), "dereferenceable"(ptr %arg1, i64 2), "dereferenceable"(ptr %p, i64 101), "dereferenceable_or_null"(ptr %arg2, i64 31), "dereferenceable_or_null"(ptr %arg4, i64 42)]
  call void @unknown_use8(ptr %arg1)
  call void @unknown_use8(ptr %arg2)
  call void @unknown_use8(ptr %arg3)
  call void @unknown_use8(ptr %arg4)
  call void @unknown_use32(ptr %p)
  call void @unknown()
  ret void
}
declare void @unknown_use8(ptr) willreturn nounwind
declare void @unknown_use32(ptr) willreturn nounwind
declare void @llvm.assume(i1)

@g = global i64 0
define void @max_offset(i1 %c) {
; CHECK: Function Attrs: mustprogress nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@max_offset
; CHECK-SAME: (i1 noundef [[C:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr @g, i64 2
; CHECK-NEXT:    br label [[F]]
; CHECK:       f:
; CHECK-NEXT:    [[PHI:%.*]] = phi ptr [ [[GEP]], [[T]] ], [ @g, [[ENTRY:%.*]] ]
; CHECK-NEXT:    call void @unknown_use8(ptr noundef align 2 dereferenceable_or_null(6) [[PHI]]) #[[ATTR1]]
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %t, label %f
t:
  %gep = getelementptr i8, ptr @g, i64 2
  br label %f
f:
  %phi = phi ptr [%gep, %t], [@g, %entry]
  call void @unknown_use8(ptr %phi)
  ret void
}

!0 = !{i64 10, i64 100}

;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { nounwind willreturn }
; TUNIT: attributes #[[ATTR2]] = { mustprogress nounwind willreturn }
; TUNIT: attributes #[[ATTR3]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write) }
; TUNIT: attributes #[[ATTR4]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite) }
; TUNIT: attributes #[[ATTR5]] = { nofree nosync nounwind memory(argmem: write) }
; TUNIT: attributes #[[ATTR6:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(inaccessiblemem: write) }
; TUNIT: attributes #[[ATTR7]] = { nofree nosync nounwind willreturn memory(write) }
; TUNIT: attributes #[[ATTR8]] = { nofree nosync nounwind memory(write) }
; TUNIT: attributes #[[ATTR9]] = { nofree willreturn memory(write) }
; TUNIT: attributes #[[ATTR10]] = { nounwind }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { nounwind willreturn }
; CGSCC: attributes #[[ATTR2]] = { mustprogress nounwind willreturn }
; CGSCC: attributes #[[ATTR3]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write) }
; CGSCC: attributes #[[ATTR4]] = { mustprogress nofree nosync nounwind willreturn memory(argmem: readwrite) }
; CGSCC: attributes #[[ATTR5]] = { nofree nosync nounwind memory(argmem: write) }
; CGSCC: attributes #[[ATTR6:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(inaccessiblemem: write) }
; CGSCC: attributes #[[ATTR7]] = { nofree nounwind willreturn memory(write) }
; CGSCC: attributes #[[ATTR8]] = { nofree nosync nounwind memory(write) }
; CGSCC: attributes #[[ATTR9]] = { nofree willreturn memory(write) }
; CGSCC: attributes #[[ATTR10]] = { nounwind }
;.
; TUNIT: [[RNG0]] = !{i64 10, i64 100}
;.
; CGSCC: [[RNG0]] = !{i64 10, i64 100}
;.
