; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx | FileCheck %s --check-prefix=XOPAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx2 | FileCheck %s --check-prefix=XOPAVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=AVX512VL,AVX512DQVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512VL,AVX512BWVL
;
; 32-bit runs to make sure we do reasonable things for i64 shifts.
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx  | FileCheck %s --check-prefix=X86-AVX1
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=X86-AVX2

;
; Variable Shifts
;

define <4 x i64> @var_shift_v4i64(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: var_shift_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsllq %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpsllq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3],xmm0[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shift_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllvq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: var_shift_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpshlq %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshlq %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_shift_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllvq %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: var_shift_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllvq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shift_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllvq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: var_shift_v4i64:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X86-AVX1-NEXT:    vpsllq %xmm2, %xmm3, %xmm4
; X86-AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; X86-AVX1-NEXT:    vpsllq %xmm2, %xmm3, %xmm2
; X86-AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1,2,3],xmm2[4,5,6,7]
; X86-AVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm3
; X86-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; X86-AVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3],xmm0[4,5,6,7]
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: var_shift_v4i64:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllvq %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <4 x i64> %a, %b
  ret <4 x i64> %shift
}

define <8 x i32> @var_shift_v8i32(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: var_shift_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpslld $23, %xmm2, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1065353216,1065353216,1065353216,1065353216]
; AVX1-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vcvttps2dq %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpmulld %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpslld $23, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vcvttps2dq %xmm1, %xmm1
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shift_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: var_shift_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpshld %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshld %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_shift_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: var_shift_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shift_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: var_shift_v8i32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X86-AVX1-NEXT:    vpslld $23, %xmm2, %xmm2
; X86-AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1065353216,1065353216,1065353216,1065353216]
; X86-AVX1-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; X86-AVX1-NEXT:    vcvttps2dq %xmm2, %xmm2
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; X86-AVX1-NEXT:    vpmulld %xmm2, %xmm4, %xmm2
; X86-AVX1-NEXT:    vpslld $23, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; X86-AVX1-NEXT:    vcvttps2dq %xmm1, %xmm1
; X86-AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: var_shift_v8i32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <8 x i32> %a, %b
  ret <8 x i32> %shift
}

define <16 x i16> @var_shift_v16i16(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: var_shift_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $23, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [1065353216,1065353216,1065353216,1065353216]
; AVX1-NEXT:    vpaddd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vcvttps2dq %xmm3, %xmm3
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero
; AVX1-NEXT:    vpslld $23, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vcvttps2dq %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpmullw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm1[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $23, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vcvttps2dq %xmm3, %xmm3
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero
; AVX1-NEXT:    vpslld $23, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vcvttps2dq %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shift_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15]
; AVX2-NEXT:    vpsllvd %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpsrld $16, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11]
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: var_shift_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpshlw %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_shift_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; XOPAVX2-NEXT:    vpshlw %xmm2, %xmm3, %xmm2
; XOPAVX2-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: var_shift_v16i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpsllvd %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: var_shift_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: var_shift_v16i16:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512DQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQVL-NEXT:    vpsllvd %zmm1, %zmm0, %zmm0
; AVX512DQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: var_shift_v16i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpsllvw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X86-AVX1-LABEL: var_shift_v16i16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; X86-AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm3[4,4,5,5,6,6,7,7]
; X86-AVX1-NEXT:    vpslld $23, %xmm2, %xmm4
; X86-AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1065353216,1065353216,1065353216,1065353216]
; X86-AVX1-NEXT:    vpaddd %xmm2, %xmm4, %xmm4
; X86-AVX1-NEXT:    vcvttps2dq %xmm4, %xmm4
; X86-AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero
; X86-AVX1-NEXT:    vpslld $23, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpaddd %xmm2, %xmm3, %xmm3
; X86-AVX1-NEXT:    vcvttps2dq %xmm3, %xmm3
; X86-AVX1-NEXT:    vpackusdw %xmm4, %xmm3, %xmm3
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; X86-AVX1-NEXT:    vpmullw %xmm3, %xmm4, %xmm3
; X86-AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm1[4,4,5,5,6,6,7,7]
; X86-AVX1-NEXT:    vpslld $23, %xmm4, %xmm4
; X86-AVX1-NEXT:    vpaddd %xmm2, %xmm4, %xmm4
; X86-AVX1-NEXT:    vcvttps2dq %xmm4, %xmm4
; X86-AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero
; X86-AVX1-NEXT:    vpslld $23, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; X86-AVX1-NEXT:    vcvttps2dq %xmm1, %xmm1
; X86-AVX1-NEXT:    vpackusdw %xmm4, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: var_shift_v16i16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X86-AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15]
; X86-AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15]
; X86-AVX2-NEXT:    vpsllvd %ymm3, %ymm4, %ymm3
; X86-AVX2-NEXT:    vpsrld $16, %ymm3, %ymm3
; X86-AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11]
; X86-AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11]
; X86-AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <16 x i16> %a, %b
  ret <16 x i16> %shift
}

define <32 x i8> @var_shift_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: var_shift_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsllw $4, %xmm2, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpsllw $5, %xmm5, %xmm5
; AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $2, %xmm2, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm3
; AVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $4, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $2, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm3
; AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shift_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX2-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $2, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: var_shift_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_shift_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; XOPAVX2-NEXT:    vpshlb %xmm2, %xmm3, %xmm2
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: var_shift_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsllw $2, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: var_shift_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: var_shift_v32i8:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpsllw $2, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: var_shift_v32i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BWVL-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X86-AVX1-LABEL: var_shift_v32i8:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpsllw $4, %xmm2, %xmm3
; X86-AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; X86-AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; X86-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; X86-AVX1-NEXT:    vpsllw $5, %xmm5, %xmm5
; X86-AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpsllw $2, %xmm2, %xmm3
; X86-AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; X86-AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; X86-AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm3
; X86-AVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; X86-AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpsllw $4, %xmm0, %xmm3
; X86-AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpsllw $2, %xmm0, %xmm3
; X86-AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm3
; X86-AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: var_shift_v32i8:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; X86-AVX2-NEXT:    vpsllw $4, %ymm0, %ymm2
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm2, %ymm2
; X86-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpsllw $2, %ymm0, %ymm2
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm2, %ymm2
; X86-AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; X86-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; X86-AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; X86-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <32 x i8> %a, %b
  ret <32 x i8> %shift
}

;
; Uniform Variable Shifts
;

define <4 x i64> @splatvar_shift_v4i64(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: splatvar_shift_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsllq %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_shift_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_shift_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpsllq %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_shift_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_shift_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_shift_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatvar_shift_v4i64:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpsllq %xmm1, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatvar_shift_v4i64:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %splat = shufflevector <4 x i64> %b, <4 x i64> poison, <4 x i32> zeroinitializer
  %shift = shl <4 x i64> %a, %splat
  ret <4 x i64> %shift
}

define <8 x i32> @splatvar_shift_v8i32(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: splatvar_shift_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpslld %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_shift_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX2-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_shift_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; XOPAVX1-NEXT:    vpslld %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_shift_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; XOPAVX2-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_shift_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX512-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_shift_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX512VL-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatvar_shift_v8i32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; X86-AVX1-NEXT:    vpslld %xmm1, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatvar_shift_v8i32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; X86-AVX2-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %splat = shufflevector <8 x i32> %b, <8 x i32> poison, <8 x i32> zeroinitializer
  %shift = shl <8 x i32> %a, %splat
  ret <8 x i32> %shift
}

define <16 x i16> @splatvar_shift_v16i16(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: splatvar_shift_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_shift_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_shift_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; XOPAVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_shift_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; XOPAVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_shift_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX512-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_shift_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX512VL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatvar_shift_v16i16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatvar_shift_v16i16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; X86-AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %splat = shufflevector <16 x i16> %b, <16 x i16> poison, <16 x i32> zeroinitializer
  %shift = shl <16 x i16> %a, %splat
  ret <16 x i16> %shift
}

define <32 x i8> @splatvar_shift_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: splatvar_shift_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw %xmm1, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_shift_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_shift_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_shift_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; XOPAVX2-NEXT:    vpbroadcastb %xmm1, %xmm1
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: splatvar_shift_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512DQ-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; AVX512DQ-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_shift_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: splatvar_shift_v32i8:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512DQVL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512DQVL-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; AVX512DQVL-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512DQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: splatvar_shift_v32i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BWVL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BWVL-NEXT:    vpsllw %xmm1, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X86-AVX1-LABEL: splatvar_shift_v32i8:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; X86-AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatvar_shift_v32i8:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; X86-AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; X86-AVX2-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; X86-AVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; X86-AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %splat = shufflevector <32 x i8> %b, <32 x i8> poison, <32 x i32> zeroinitializer
  %shift = shl <32 x i8> %a, %splat
  ret <32 x i8> %shift
}

;
; Uniform Variable Modulo Shifts
;

define <4 x i64> @splatvar_modulo_shift_v4i64(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: splatvar_modulo_shift_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpsllq %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_modulo_shift_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_modulo_shift_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsllq %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_modulo_shift_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX2-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_modulo_shift_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_modulo_shift_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm1, %xmm1
; AVX512VL-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatvar_modulo_shift_v4i64:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpsllq %xmm1, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatvar_modulo_shift_v4i64:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %mod = and <4 x i64> %b, <i64 63, i64 63, i64 63, i64 63>
  %splat = shufflevector <4 x i64> %mod, <4 x i64> poison, <4 x i32> zeroinitializer
  %shift = shl <4 x i64> %a, %splat
  ret <4 x i64> %shift
}

define <8 x i32> @splatvar_modulo_shift_v8i32(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: splatvar_modulo_shift_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpslld %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_modulo_shift_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_modulo_shift_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vpslld %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_modulo_shift_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX2-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_modulo_shift_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_modulo_shift_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512VL-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatvar_modulo_shift_v8i32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpslld %xmm1, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatvar_modulo_shift_v8i32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %mod = and <8 x i32> %b, <i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31>
  %splat = shufflevector <8 x i32> %mod, <8 x i32> poison, <8 x i32> zeroinitializer
  %shift = shl <8 x i32> %a, %splat
  ret <8 x i32> %shift
}

define <16 x i16> @splatvar_modulo_shift_v16i16(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: splatvar_modulo_shift_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_modulo_shift_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_modulo_shift_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_modulo_shift_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_modulo_shift_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_modulo_shift_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512VL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatvar_modulo_shift_v16i16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatvar_modulo_shift_v16i16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %mod = and <16 x i16> %b, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %splat = shufflevector <16 x i16> %mod, <16 x i16> poison, <16 x i32> zeroinitializer
  %shift = shl <16 x i16> %a, %splat
  ret <16 x i16> %shift
}

define <32 x i8> @splatvar_modulo_shift_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: splatvar_modulo_shift_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw %xmm1, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_modulo_shift_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_modulo_shift_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_modulo_shift_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; XOPAVX2-NEXT:    vpbroadcastb %xmm1, %xmm1
; XOPAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: splatvar_modulo_shift_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512DQ-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512DQ-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; AVX512DQ-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_modulo_shift_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: splatvar_modulo_shift_v32i8:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512DQVL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512DQVL-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; AVX512DQVL-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512DQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: splatvar_modulo_shift_v32i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BWVL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BWVL-NEXT:    vpsllw %xmm1, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X86-AVX1-LABEL: splatvar_modulo_shift_v32i8:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X86-AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; X86-AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; X86-AVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatvar_modulo_shift_v32i8:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; X86-AVX2-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; X86-AVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; X86-AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %mod = and <32 x i8> %b, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %splat = shufflevector <32 x i8> %mod, <32 x i8> poison, <32 x i32> zeroinitializer
  %shift = shl <32 x i8> %a, %splat
  ret <32 x i8> %shift
}

;
; Constant Shifts
;

define <4 x i64> @constant_shift_v4i64(<4 x i64> %a) nounwind {
; AVX1-LABEL: constant_shift_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsllq $62, %xmm1, %xmm2
; AVX1-NEXT:    vpsllq $31, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsllq $7, %xmm0, %xmm2
; AVX1-NEXT:    vpaddq %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshlq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: constant_shift_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: constant_shift_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: constant_shift_v4i64:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-AVX1-NEXT:    vpsllq $62, %xmm1, %xmm2
; X86-AVX1-NEXT:    vpsllq $31, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; X86-AVX1-NEXT:    vpsllq $7, %xmm0, %xmm2
; X86-AVX1-NEXT:    vpaddq %xmm0, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: constant_shift_v4i64:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <4 x i64> %a, <i64 1, i64 7, i64 31, i64 62>
  ret <4 x i64> %shift
}

define <8 x i32> @constant_shift_v8i32(<8 x i32> %a) nounwind {
; AVX1-LABEL: constant_shift_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: constant_shift_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: constant_shift_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: constant_shift_v8i32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm1
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: constant_shift_v8i32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <8 x i32> %a, <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 8, i32 7>
  ret <8 x i32> %shift
}

define <16 x i16> @constant_shift_v16i16(<16 x i16> %a) nounwind {
; AVX1-LABEL: constant_shift_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1 # [1,2,4,8,16,32,64,128]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [256,512,1024,2048,4096,8192,16384,32768]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: constant_shift_v16i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: constant_shift_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: constant_shift_v16i16:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: constant_shift_v16i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X86-AVX1-LABEL: constant_shift_v16i16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm1 # [1,2,4,8,16,32,64,128]
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0 # [256,512,1024,2048,4096,8192,16384,32768]
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: constant_shift_v16i16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; X86-AVX2-NEXT:    retl
  %shift = shl <16 x i16> %a, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  ret <16 x i16> %shift
}

define <16 x i16> @constant_shift_v16i16_pairs(<16 x i16> %a) nounwind {
; AVX1-LABEL: constant_shift_v16i16_pairs:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1 # [4,4,8,8,1,1,2,2]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [64,64,128,128,16,16,32,32]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v16i16_pairs:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v16i16_pairs:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v16i16_pairs:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [4,4,8,8,1,1,2,2,64,64,128,128,16,16,32,32]
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: constant_shift_v16i16_pairs:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: constant_shift_v16i16_pairs:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [2,2,3,3,0,0,1,1,6,6,7,7,4,4,5,5]
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: constant_shift_v16i16_pairs:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: constant_shift_v16i16_pairs:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X86-AVX1-LABEL: constant_shift_v16i16_pairs:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm1 # [4,4,8,8,1,1,2,2]
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0 # [64,64,128,128,16,16,32,32]
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: constant_shift_v16i16_pairs:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <16 x i16> %a, <i16 2, i16 2, i16 3, i16 3, i16 0, i16 0, i16 1, i16 1, i16 6, i16 6, i16 7, i16 7, i16 4, i16 4, i16 5, i16 5>
  ret <16 x i16> %shift
}

define <32 x i8> @constant_shift_v32i8(<32 x i8> %a) nounwind {
; AVX1-LABEL: constant_shift_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; AVX1-NEXT:    vpmaddubsw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpmaddubsw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsllw $8, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = [1,4,16,64,128,32,8,2]
; AVX1-NEXT:    vpmaddubsw %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpmaddubsw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; AVX2-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,4,5,6,7,7,6,5,4,3,2,1,0]
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,4,5,6,7,7,6,5,4,3,2,1,0]
; XOPAVX2-NEXT:    vpshlb %xmm2, %xmm1, %xmm1
; XOPAVX2-NEXT:    vpshlb %xmm2, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: constant_shift_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; AVX512DQ-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512DQ-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: constant_shift_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: constant_shift_v32i8:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; AVX512DQVL-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; AVX512DQVL-NEXT:    vpsllw $8, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpternlogd {{.*#+}} ymm0 = ymm0 | (ymm1 & m32bcst)
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: constant_shift_v32i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BWVL-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X86-AVX1-LABEL: constant_shift_v32i8:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; X86-AVX1-NEXT:    vpmaddubsw %xmm1, %xmm0, %xmm2
; X86-AVX1-NEXT:    vpsllw $8, %xmm2, %xmm2
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X86-AVX1-NEXT:    vpmaddubsw %xmm1, %xmm3, %xmm1
; X86-AVX1-NEXT:    vpsllw $8, %xmm1, %xmm1
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; X86-AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = [1,4,16,64,128,32,8,2]
; X86-AVX1-NEXT:    vpmaddubsw %xmm2, %xmm3, %xmm3
; X86-AVX1-NEXT:    vpmaddubsw %xmm2, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: constant_shift_v32i8:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm1 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; X86-AVX2-NEXT:    vpsllw $8, %ymm1, %ymm1
; X86-AVX2-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <32 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <32 x i8> %shift
}

define <32 x i8> @constant_shift_v32i8_pairs(<32 x i8> %a) nounwind {
; AVX1-LABEL: constant_shift_v32i8_pairs:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1 # [8,128,64,4,128,1,128,2]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [32,1,16,128,64,2,16,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v32i8_pairs:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [8,128,64,4,128,1,128,2,32,1,16,128,64,2,16,1]
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v32i8_pairs:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v32i8_pairs:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; XOPAVX2-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: constant_shift_v32i8_pairs:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [8,128,64,4,128,1,128,2,32,1,16,128,64,2,16,1]
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: constant_shift_v32i8_pairs:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [3,7,6,2,7,0,7,1,5,0,4,7,6,1,4,0]
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: constant_shift_v32i8_pairs:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [8,128,64,4,128,1,128,2,32,1,16,128,64,2,16,1]
; AVX512DQVL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: constant_shift_v32i8_pairs:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X86-AVX1-LABEL: constant_shift_v32i8_pairs:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm1 # [8,128,64,4,128,1,128,2]
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0 # [32,1,16,128,64,2,16,1]
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: constant_shift_v32i8_pairs:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0 # [8,128,64,4,128,1,128,2,32,1,16,128,64,2,16,1]
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <32 x i8> %a, <i8 3, i8 3, i8 7, i8 7, i8 6, i8 6, i8 2, i8 2, i8 7, i8 7, i8 0, i8 0, i8 7, i8 7, i8 1, i8 1, i8 5, i8 5, i8 0, i8 0, i8 4, i8 4, i8 7, i8 7, i8 6, i8 6, i8 1, i8 1, i8 4, i8 4, i8 0, i8 0>
  ret <32 x i8> %shift
}

define <32 x i8> @constant_shift_v32i8_quads(<32 x i8> %a) nounwind {
; AVX1-LABEL: constant_shift_v32i8_quads:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1 # [4,4,8,8,1,1,2,2]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [64,64,128,128,16,16,32,32]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v32i8_quads:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v32i8_quads:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v32i8_quads:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; XOPAVX2-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: constant_shift_v32i8_quads:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: constant_shift_v32i8_quads:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: constant_shift_v32i8_quads:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm1 # [4,4,8,8,1,1,2,2]
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0 # [64,64,128,128,16,16,32,32]
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: constant_shift_v32i8_quads:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <32 x i8> %a, <i8 2, i8 2, i8 2, i8 2, i8 3, i8 3, i8 3, i8 3, i8 0, i8 0, i8 0, i8 0, i8 1, i8 1, i8 1, i8 1, i8 6, i8 6, i8 6, i8 6, i8 7, i8 7, i8 7, i8 7, i8 4, i8 4, i8 4, i8 4, i8 5, i8 5, i8 5, i8 5>
  ret <32 x i8> %shift
}

;
; Uniform Constant Shifts
;

define <4 x i64> @splatconstant_shift_v4i64(<4 x i64> %a) nounwind {
; AVX1-LABEL: splatconstant_shift_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllq $7, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsllq $7, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_shift_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllq $7, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_shift_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpsllq $7, %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsllq $7, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_shift_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllq $7, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatconstant_shift_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllq $7, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_shift_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllq $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatconstant_shift_v4i64:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpsllq $7, %xmm0, %xmm1
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpsllq $7, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatconstant_shift_v4i64:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllq $7, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <4 x i64> %a, <i64 7, i64 7, i64 7, i64 7>
  ret <4 x i64> %shift
}

define <8 x i32> @splatconstant_shift_v8i32(<8 x i32> %a) nounwind {
; AVX1-LABEL: splatconstant_shift_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpslld $5, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpslld $5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_shift_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $5, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_shift_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpslld $5, %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpslld $5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_shift_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpslld $5, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatconstant_shift_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpslld $5, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_shift_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $5, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatconstant_shift_v8i32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpslld $5, %xmm0, %xmm1
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpslld $5, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatconstant_shift_v8i32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpslld $5, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <8 x i32> %a, <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>
  ret <8 x i32> %shift
}

define <16 x i16> @splatconstant_shift_v16i16(<16 x i16> %a) nounwind {
; AVX1-LABEL: splatconstant_shift_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllw $3, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsllw $3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_shift_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_shift_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpsllw $3, %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsllw $3, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_shift_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllw $3, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatconstant_shift_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllw $3, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_shift_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $3, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatconstant_shift_v16i16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpsllw $3, %xmm0, %xmm1
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpsllw $3, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatconstant_shift_v16i16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllw $3, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <16 x i16> %a, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <16 x i16> %shift
}

define <32 x i8> @splatconstant_shift_v32i8(<32 x i8> %a) nounwind {
; AVX1-LABEL: splatconstant_shift_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllw $3, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsllw $3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_shift_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $3, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_shift_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_shift_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllw $3, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatconstant_shift_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllw $3, %ymm0, %ymm0
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_shift_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: splatconstant_shift_v32i8:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpsllw $3, %xmm0, %xmm1
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vpsllw $3, %xmm0, %xmm0
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: splatconstant_shift_v32i8:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllw $3, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <32 x i8> %a, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  ret <32 x i8> %shift
}

;
; Special Cases
;

define <4 x i64> @shift32_v4i64(<4 x i64> %a) nounwind {
; AVX1-LABEL: shift32_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm0[0,2],ymm1[4,6],ymm0[4,6]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shift32_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: shift32_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm0[0,2],ymm1[4,6],ymm0[4,6]
; XOPAVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: shift32_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsllq $32, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: shift32_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: shift32_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: shift32_v4i64:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm0[0,2],ymm1[4,6],ymm0[4,6]
; X86-AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: shift32_v4i64:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vpsllq $32, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %shift = shl <4 x i64> %a, <i64 32, i64 32, i64 32, i64 32>
  ret <4 x i64> %shift
}

define <4 x i64> @shift32_v4i64_concat(<2 x i64> %lo, <2 x i64> %hi) nounwind {
; AVX1-LABEL: shift32_v4i64_concat:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shift32_v4i64_concat:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: shift32_v4i64_concat:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpsllq $32, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: shift32_v4i64_concat:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpsllq $32, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: shift32_v4i64_concat:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: shift32_v4i64_concat:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X86-AVX1-LABEL: shift32_v4i64_concat:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vpsllq $32, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; X86-AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: shift32_v4i64_concat:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; X86-AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    vpsllq $32, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
  %a = shufflevector <2 x i64> %lo, <2 x i64> %hi, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shift = shl <4 x i64> %a, <i64 32, i64 32, i64 32, i64 32>
  ret <4 x i64> %shift
}
