; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=-avx,+sse2                 | FileCheck %s --check-prefixes=X64,SSE2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=-avx,+sse2 -fast-isel      | FileCheck %s --check-prefixes=X64,SSE2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=-avx,+sse2 -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=X64,SSE2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=-avx2,+avx                 | FileCheck %s --check-prefixes=X64,AVX
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=-avx2,+avx -fast-isel      | FileCheck %s --check-prefixes=X64,AVX
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=-avx2,+avx -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=X64,AVX
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel=0 -fast-isel=0            | FileCheck %s --check-prefixes=X86,SDAG-X86
; RUN: llc < %s -mtriple=i686-linux-gnu -fast-isel                             | FileCheck %s --check-prefixes=X86,FASTISEL-X86
; TODO: The last RUN line will fails GISEL selection and will fallback to DAG selection due to lack of support for loads/stores in i686 mode, support is expected soon enough, for this reason the llvm/test/CodeGen/X86/GlobalISel/sqrt.mir test is added for now because of the lack of support for i686 in GlobalISel.
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel -global-isel-abort=2      | FileCheck %s --check-prefixes=X86,GISEL-X86

define float @test_sqrt_f32(float %a) {
; SSE2-LABEL: test_sqrt_f32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    sqrtss %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_sqrt_f32:
; AVX:       ## %bb.0:
; AVX-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_sqrt_f32:
; X86:       # %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fsqrt
; X86-NEXT:    retl
  %res = call float @llvm.sqrt.f32(float %a)
  ret float %res
}
declare float @llvm.sqrt.f32(float) nounwind readnone

define double @test_sqrt_f64(double %a) {
; SSE2-LABEL: test_sqrt_f64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    sqrtsd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_sqrt_f64:
; AVX:       ## %bb.0:
; AVX-NEXT:    vsqrtsd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_sqrt_f64:
; X86:       # %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fsqrt
; X86-NEXT:    retl
  %res = call double @llvm.sqrt.f64(double %a)
  ret double %res
}
declare double @llvm.sqrt.f64(double) nounwind readnone

define x86_fp80 @test_sqrt_f80(x86_fp80 %a) {
; X64-LABEL: test_sqrt_f80:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fsqrt
; X64-NEXT:    retq
;
; X86-LABEL: test_sqrt_f80:
; X86:       # %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fsqrt
; X86-NEXT:    retl
  %res = call x86_fp80 @llvm.sqrt.f80(x86_fp80 %a)
  ret x86_fp80 %res
}
declare x86_fp80 @llvm.sqrt.f80(x86_fp80) nounwind readnone

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; FASTISEL-X86: {{.*}}
; GISEL-X86: {{.*}}
; SDAG-X86: {{.*}}
