; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zvfh,+zvfbfwma -verify-machineinstrs | FileCheck %s --check-prefix=ZVFBFWMA
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zvfh,+zvfbfwma -verify-machineinstrs | FileCheck %s --check-prefix=ZVFBFWMA
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zvfh,+zvfbfmin -verify-machineinstrs | FileCheck %s --check-prefix=ZVFBFMIN
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zvfh,+zvfbfmin -verify-machineinstrs | FileCheck %s --check-prefix=ZVFBFMIN

define <1 x float> @vfwmaccbf16_vv_v1f32(<1 x float> %a, <1 x bfloat> %b, <1 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_v1f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v9, v10
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_v1f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v11, v9
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v9, v10
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v9
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <1 x bfloat> %b to <1 x float>
  %c.ext = fpext <1 x bfloat> %c to <1 x float>
  %res = call <1 x float> @llvm.fma.v1f32(<1 x float> %b.ext, <1 x float> %c.ext, <1 x float> %a)
  ret <1 x float> %res
}

define <1 x float> @vfwmaccbf16_vf_v1f32(<1 x float> %a, bfloat %b, <1 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_v1f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    fmv.x.h a0, fa0
; ZVFBFWMA-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; ZVFBFWMA-NEXT:    vmv.s.x v10, a0
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v10, v9
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_v1f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; ZVFBFMIN-NEXT:    vmv.s.x v10, a0
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v11, v10
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v10, v9
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v10
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <1 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <1 x bfloat> %b.head, <1 x bfloat> poison, <1 x i32> zeroinitializer
  %b.ext = fpext <1 x bfloat> %b.splat to <1 x float>
  %c.ext = fpext <1 x bfloat> %c to <1 x float>
  %res = call <1 x float> @llvm.fma.v1f32(<1 x float> %b.ext, <1 x float> %c.ext, <1 x float> %a)
  ret <1 x float> %res
}

define <2 x float> @vfwmaccbf16_vv_v2f32(<2 x float> %a, <2 x bfloat> %b, <2 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_v2f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v9, v10
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_v2f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v11, v9
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v9, v10
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v9
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <2 x bfloat> %b to <2 x float>
  %c.ext = fpext <2 x bfloat> %c to <2 x float>
  %res = call <2 x float> @llvm.fma.v2f32(<2 x float> %b.ext, <2 x float> %c.ext, <2 x float> %a)
  ret <2 x float> %res
}

define <2 x float> @vfwmaccbf16_vf_v2f32(<2 x float> %a, bfloat %b, <2 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_v2f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    fmv.x.h a0, fa0
; ZVFBFWMA-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; ZVFBFWMA-NEXT:    vmv.v.x v10, a0
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v10, v9
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_v2f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v10, a0
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v11, v10
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v10, v9
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v10
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <2 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <2 x bfloat> %b.head, <2 x bfloat> poison, <2 x i32> zeroinitializer
  %b.ext = fpext <2 x bfloat> %b.splat to <2 x float>
  %c.ext = fpext <2 x bfloat> %c to <2 x float>
  %res = call <2 x float> @llvm.fma.v2f32(<2 x float> %b.ext, <2 x float> %c.ext, <2 x float> %a)
  ret <2 x float> %res
}

define <4 x float> @vfwmaccbf16_vv_v4f32(<4 x float> %a, <4 x bfloat> %b, <4 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_v4f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v9, v10
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_v4f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v11, v9
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v9, v10
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v9
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <4 x bfloat> %b to <4 x float>
  %c.ext = fpext <4 x bfloat> %c to <4 x float>
  %res = call <4 x float> @llvm.fma.v4f32(<4 x float> %b.ext, <4 x float> %c.ext, <4 x float> %a)
  ret <4 x float> %res
}

define <4 x float> @vfwmaccbf16_vf_v4f32(<4 x float> %a, bfloat %b, <4 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_v4f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    fmv.x.h a0, fa0
; ZVFBFWMA-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFBFWMA-NEXT:    vmv.v.x v10, a0
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v10, v9
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_v4f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v10, a0
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v11, v10
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v10, v9
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v10
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <4 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <4 x bfloat> %b.head, <4 x bfloat> poison, <4 x i32> zeroinitializer
  %b.ext = fpext <4 x bfloat> %b.splat to <4 x float>
  %c.ext = fpext <4 x bfloat> %c to <4 x float>
  %res = call <4 x float> @llvm.fma.v4f32(<4 x float> %b.ext, <4 x float> %c.ext, <4 x float> %a)
  ret <4 x float> %res
}

define <8 x float> @vfwmaccbf16_vv_v8f32(<8 x float> %a, <8 x bfloat> %b, <8 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_v8f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v10, v11
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_v8f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v12, v10
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v14, v11
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v12, v14
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <8 x bfloat> %b to <8 x float>
  %c.ext = fpext <8 x bfloat> %c to <8 x float>
  %res = call <8 x float> @llvm.fma.v8f32(<8 x float> %b.ext, <8 x float> %c.ext, <8 x float> %a)
  ret <8 x float> %res
}

define <8 x float> @vfwmaccbf16_vf_v8f32(<8 x float> %a, bfloat %b, <8 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_v8f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    fmv.x.h a0, fa0
; ZVFBFWMA-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFBFWMA-NEXT:    vmv.v.x v11, a0
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v11, v10
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_v8f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v11, a0
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v12, v11
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v14, v10
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v12, v14
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <8 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <8 x bfloat> %b.head, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %b.ext = fpext <8 x bfloat> %b.splat to <8 x float>
  %c.ext = fpext <8 x bfloat> %c to <8 x float>
  %res = call <8 x float> @llvm.fma.v8f32(<8 x float> %b.ext, <8 x float> %c.ext, <8 x float> %a)
  ret <8 x float> %res
}

define <16 x float> @vfwmaccbf16_vv_v16f32(<16 x float> %a, <16 x bfloat> %b, <16 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_v16f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v12, v14
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_v16f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v16, v12
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v20, v14
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v16, v20
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <16 x bfloat> %b to <16 x float>
  %c.ext = fpext <16 x bfloat> %c to <16 x float>
  %res = call <16 x float> @llvm.fma.v16f32(<16 x float> %b.ext, <16 x float> %c.ext, <16 x float> %a)
  ret <16 x float> %res
}

define <16 x float> @vfwmaccbf16_vf_v16f32(<16 x float> %a, bfloat %b, <16 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_v16f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    fmv.x.h a0, fa0
; ZVFBFWMA-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFBFWMA-NEXT:    vmv.v.x v14, a0
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v14, v12
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_v16f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v14, a0
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v16, v14
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v20, v12
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v16, v20
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <16 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <16 x bfloat> %b.head, <16 x bfloat> poison, <16 x i32> zeroinitializer
  %b.ext = fpext <16 x bfloat> %b.splat to <16 x float>
  %c.ext = fpext <16 x bfloat> %c to <16 x float>
  %res = call <16 x float> @llvm.fma.v16f32(<16 x float> %b.ext, <16 x float> %c.ext, <16 x float> %a)
  ret <16 x float> %res
}

define <32 x float> @vfwmaccbf32_vv_v32f32(<32 x float> %a, <32 x bfloat> %b, <32 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf32_vv_v32f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    li a0, 32
; ZVFBFWMA-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v16, v20
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf32_vv_v32f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    li a0, 32
; ZVFBFMIN-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v24, v16
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v0, v20
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v24, v0
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <32 x bfloat> %b to <32 x float>
  %c.ext = fpext <32 x bfloat> %c to <32 x float>
  %res = call <32 x float> @llvm.fma.v32f32(<32 x float> %b.ext, <32 x float> %c.ext, <32 x float> %a)
  ret <32 x float> %res
}

define <32 x float> @vfwmaccbf32_vf_v32f32(<32 x float> %a, bfloat %b, <32 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf32_vf_v32f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    fmv.x.h a0, fa0
; ZVFBFWMA-NEXT:    li a1, 32
; ZVFBFWMA-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; ZVFBFWMA-NEXT:    vmv.v.x v20, a0
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v20, v16
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf32_vf_v32f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    li a1, 32
; ZVFBFMIN-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v20, a0
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v24, v20
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v0, v16
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v24, v0
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <32 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <32 x bfloat> %b.head, <32 x bfloat> poison, <32 x i32> zeroinitializer
  %b.ext = fpext <32 x bfloat> %b.splat to <32 x float>
  %c.ext = fpext <32 x bfloat> %c to <32 x float>
  %res = call <32 x float> @llvm.fma.v32f32(<32 x float> %b.ext, <32 x float> %c.ext, <32 x float> %a)
  ret <32 x float> %res
}

define <4 x float> @vfwmaccbf16_vf_v4f32_scalar_extend(<4 x float> %rd, bfloat %a, <4 x bfloat> %b) local_unnamed_addr #0 {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_v4f32_scalar_extend:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vf v8, fa0, v9
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_v4f32_scalar_extend:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v10, v9
; ZVFBFMIN-NEXT:    slli a0, a0, 16
; ZVFBFMIN-NEXT:    fmv.w.x fa5, a0
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vf v8, fa5, v10
; ZVFBFMIN-NEXT:    ret
  %b_ext = fpext <4 x bfloat> %b to <4 x float>
  %a_extend = fpext bfloat %a to float
  %a_insert = insertelement <4 x float> poison, float %a_extend, i64 0
  %a_shuffle = shufflevector <4 x float> %a_insert, <4 x float> poison, <4 x i32> zeroinitializer
  %fma = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %a_shuffle, <4 x float> %b_ext, <4 x float> %rd)
  ret <4 x float> %fma
}

; Negative test with a mix of bfloat and half fpext.
define <4 x float> @mix(<4 x float> %rd, <4 x half> %a, <4 x bfloat> %b) {
; ZVFBFWMA-LABEL: mix:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFBFWMA-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFBFWMA-NEXT:    vfwcvtbf16.f.f.v v9, v10
; ZVFBFWMA-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFBFWMA-NEXT:    vfmacc.vv v8, v11, v9
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: mix:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v9, v10
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v9
; ZVFBFMIN-NEXT:    ret
  %a_ext = fpext <4 x half> %a to <4 x float>
  %b_ext = fpext <4 x bfloat> %b to <4 x float>
  %fma = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %a_ext, <4 x float> %b_ext, <4 x float> %rd)
  ret <4 x float> %fma
}
