; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s
; RUN: llc -mtriple=riscv32 -mattr=+zicbop -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32ZICBOP %s
; RUN: llc -mtriple=riscv64 -mattr=+zicbop -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64ZICBOP %s
; RUN: llc -mtriple=riscv64 -mattr=+zicbop,+zihintntl -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64ZICBOPZIHINTNTL %s

declare void @llvm.prefetch(ptr, i32, i32, i32)

define void @test_prefetch_read_locality_0(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_read_locality_0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_read_locality_0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_read_locality_0:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_read_locality_0:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_read_locality_0:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_write_locality_0(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_write_locality_0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_write_locality_0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_write_locality_0:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.w 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_write_locality_0:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.w 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_write_locality_0:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.w 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 1, i32 0, i32 1)
  ret void
}

define void @test_prefetch_instruction_locality_0(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_instruction_locality_0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_instruction_locality_0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_instruction_locality_0:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.i 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_instruction_locality_0:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.i 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_instruction_locality_0:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.i 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 0, i32 0, i32 0)
  ret void
}

define void @test_prefetch_read_locality_1(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_read_locality_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_read_locality_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_read_locality_1:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_read_locality_1:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_read_locality_1:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.pall
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 0, i32 1, i32 1)
  ret void
}

define void @test_prefetch_write_locality_1(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_write_locality_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_write_locality_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_write_locality_1:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.w 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_write_locality_1:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.w 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_write_locality_1:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.pall
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.w 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 1, i32 1, i32 1)
  ret void
}

define void @test_prefetch_instruction_locality_1(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_instruction_locality_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_instruction_locality_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_instruction_locality_1:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.i 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_instruction_locality_1:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.i 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_instruction_locality_1:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.pall
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.i 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 0, i32 1, i32 0)
  ret void
}

define void @test_prefetch_read_locality_2(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_read_locality_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_read_locality_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_read_locality_2:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_read_locality_2:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_read_locality_2:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.p1
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 0, i32 2, i32 1)
  ret void
}

define void @test_prefetch_write_locality_2(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_write_locality_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_write_locality_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_write_locality_2:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.w 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_write_locality_2:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.w 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_write_locality_2:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.p1
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.w 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 1, i32 2, i32 1)
  ret void
}

define void @test_prefetch_instruction_locality_2(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_instruction_locality_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_instruction_locality_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_instruction_locality_2:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.i 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_instruction_locality_2:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.i 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_instruction_locality_2:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.p1
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.i 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 0, i32 2, i32 0)
  ret void
}


define void @test_prefetch_read_locality_3(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_read_locality_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_read_locality_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_read_locality_3:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_read_locality_3:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_read_locality_3:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 0, i32 3, i32 1)
  ret void
}

define void @test_prefetch_write_locality_3(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_write_locality_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_write_locality_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_write_locality_3:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.w 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_write_locality_3:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.w 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_write_locality_3:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.w 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 1, i32 3, i32 1)
  ret void
}

define void @test_prefetch_instruction_locality_3(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_instruction_locality_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_instruction_locality_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_instruction_locality_3:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.i 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_instruction_locality_3:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.i 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_instruction_locality_3:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.i 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  call void @llvm.prefetch(ptr %a, i32 0, i32 3, i32 0)
  ret void
}

define void @test_prefetch_offsetable_0(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_0:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.r 2016(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_0:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.r 2016(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_0:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 2016(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 2016
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_1(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_1:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_1:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_1:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 -2048
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_2(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_2:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.r 32(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_2:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.r 32(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_2:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 32(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 32
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_3(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_3:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    prefetch.r -32(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_3:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    prefetch.r -32(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_3:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -32(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 -32
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_4(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_4:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_4:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_4:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi a0, a0, 32
; RV32ZICBOP-NEXT:    prefetch.r 2016(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_4:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi a0, a0, 32
; RV64ZICBOP-NEXT:    prefetch.r 2016(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_4:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, 32
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 2016(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 2048
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_5(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_5:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_5:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_5:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi a0, a0, -1
; RV32ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_5:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi a0, a0, -1
; RV64ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_5:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, -1
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 -2049
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_6(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_6:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_6:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_6:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi a0, a0, 16
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_6:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi a0, a0, 16
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_6:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, 16
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 16
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_7(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_7:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_7:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_7:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi a0, a0, -16
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_7:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi a0, a0, -16
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_7:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, -16
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 -16
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_9(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_9:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_9:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_9:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a1, 1
; RV32ZICBOP-NEXT:    add a0, a0, a1
; RV32ZICBOP-NEXT:    prefetch.r 64(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_9:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a1, 1
; RV64ZICBOP-NEXT:    add a0, a0, a1
; RV64ZICBOP-NEXT:    prefetch.r 64(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_9:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a1, 1
; RV64ZICBOPZIHINTNTL-NEXT:    add a0, a0, a1
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 64(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 4160
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_offsetable_8(ptr %a) nounwind {
; RV32I-LABEL: test_prefetch_offsetable_8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_offsetable_8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_offsetable_8:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a1, 1048575
; RV32ZICBOP-NEXT:    add a0, a0, a1
; RV32ZICBOP-NEXT:    prefetch.r -64(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_offsetable_8:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a1, 1048575
; RV64ZICBOP-NEXT:    add a0, a0, a1
; RV64ZICBOP-NEXT:    prefetch.r -64(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_offsetable_8:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a1, 1048575
; RV64ZICBOPZIHINTNTL-NEXT:    add a0, a0, a1
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -64(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %addr = getelementptr i8, ptr %a, i64 -4160
  call void @llvm.prefetch(ptr %addr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_0() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_0:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    prefetch.r 0(sp)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_0:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    prefetch.r 0(sp)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_0:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(sp)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 0
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_1() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, 16
; RV32I-NEXT:    sub sp, sp, a0
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, 16
; RV32I-NEXT:    add sp, sp, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addi a0, a0, 16
; RV64I-NEXT:    sub sp, sp, a0
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addi a0, a0, 16
; RV64I-NEXT:    add sp, sp, a0
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_1:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, 1
; RV32ZICBOP-NEXT:    addi a0, a0, 16
; RV32ZICBOP-NEXT:    sub sp, sp, a0
; RV32ZICBOP-NEXT:    addi a0, sp, 16
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    lui a0, 1
; RV32ZICBOP-NEXT:    addi a0, a0, 16
; RV32ZICBOP-NEXT:    add sp, sp, a0
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_1:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, 1
; RV64ZICBOP-NEXT:    addi a0, a0, 16
; RV64ZICBOP-NEXT:    sub sp, sp, a0
; RV64ZICBOP-NEXT:    addi a0, sp, 16
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    lui a0, 1
; RV64ZICBOP-NEXT:    addi a0, a0, 16
; RV64ZICBOP-NEXT:    add sp, sp, a0
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_1:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, 1
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, 16
; RV64ZICBOPZIHINTNTL-NEXT:    sub sp, sp, a0
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, sp, 16
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, 1
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, 16
; RV64ZICBOPZIHINTNTL-NEXT:    add sp, sp, a0
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [1024 x i32], align 4
  %ptr = bitcast ptr %data to ptr
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_2() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_2:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    addi a0, sp, 16
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_2:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    addi a0, sp, 16
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_2:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, sp, 16
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 4
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_3() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_3:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    addi a0, sp, -16
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_3:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    addi a0, sp, -16
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_3:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, sp, -16
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 -4
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_4() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_4:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_4:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_4:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    prefetch.r 32(sp)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_4:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    prefetch.r 32(sp)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_4:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 32(sp)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 8
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_5() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_5:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_5:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_5:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    prefetch.r -32(sp)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_5:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    prefetch.r -32(sp)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_5:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -32(sp)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 -8
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_6() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_6:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_6:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_6:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    prefetch.r 2016(sp)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_6:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    prefetch.r 2016(sp)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_6:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 2016(sp)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 504
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_7() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_7:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_7:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_7:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    prefetch.r -2048(sp)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_7:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    prefetch.r -2048(sp)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_7:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -2048(sp)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 -512
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_8() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_8:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    addi a0, sp, 2020
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_8:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    addi a0, sp, 2020
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_8:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, sp, 2020
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 505
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_frameindex_9() nounwind {
; RV32I-LABEL: test_prefetch_frameindex_9:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -512
; RV32I-NEXT:    addi sp, sp, 512
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_frameindex_9:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -512
; RV64I-NEXT:    addi sp, sp, 512
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_frameindex_9:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    addi sp, sp, -512
; RV32ZICBOP-NEXT:    mv a0, sp
; RV32ZICBOP-NEXT:    addi a0, a0, -4
; RV32ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV32ZICBOP-NEXT:    addi sp, sp, 512
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_frameindex_9:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    addi sp, sp, -512
; RV64ZICBOP-NEXT:    mv a0, sp
; RV64ZICBOP-NEXT:    addi a0, a0, -4
; RV64ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOP-NEXT:    addi sp, sp, 512
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_frameindex_9:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, -512
; RV64ZICBOPZIHINTNTL-NEXT:    mv a0, sp
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, -4
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    addi sp, sp, 512
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %data = alloca [128 x i32], align 4
  %base = bitcast ptr %data to ptr
  %ptr = getelementptr [128 x i32], ptr %base, i32 0, i32 -513
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_constant_address_0() nounwind {
; RV32I-LABEL: test_prefetch_constant_address_0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_constant_address_0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_constant_address_0:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, 1
; RV32ZICBOP-NEXT:    prefetch.r 32(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_constant_address_0:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, 1
; RV64ZICBOP-NEXT:    prefetch.r 32(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_constant_address_0:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, 1
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 32(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = inttoptr i64 4128 to ptr
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_constant_address_1() nounwind {
; RV32I-LABEL: test_prefetch_constant_address_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_constant_address_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_constant_address_1:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, 1
; RV32ZICBOP-NEXT:    addi a0, a0, 31
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_constant_address_1:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, 1
; RV64ZICBOP-NEXT:    addi a0, a0, 31
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_constant_address_1:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, 1
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, 31
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = inttoptr i64 4127 to ptr
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_constant_address_2() nounwind {
; RV32I-LABEL: test_prefetch_constant_address_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_constant_address_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_constant_address_2:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, 1048561
; RV32ZICBOP-NEXT:    prefetch.r 32(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_constant_address_2:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, 1048561
; RV64ZICBOP-NEXT:    prefetch.r 32(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_constant_address_2:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, 1048561
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 32(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = inttoptr i64 18446744073709490208 to ptr
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_constant_address_3() nounwind {
; RV32I-LABEL: test_prefetch_constant_address_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_constant_address_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_constant_address_3:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, 1048561
; RV32ZICBOP-NEXT:    addi a0, a0, 31
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_constant_address_3:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, 1048561
; RV64ZICBOP-NEXT:    addi a0, a0, 31
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_constant_address_3:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, 1048561
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, 31
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = inttoptr i64 18446744073709490207 to ptr
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

@g = external global [1024 x i32], align 4

define void @test_prefetch_global_0() nounwind {
; RV32I-LABEL: test_prefetch_global_0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_0:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_0:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_0:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 0
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_global_1() nounwind {
; RV32I-LABEL: test_prefetch_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_1:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g+16)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g+16)
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_1:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g+16)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g+16)
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_1:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g+16)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g+16)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 4
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_global_2() nounwind {
; RV32I-LABEL: test_prefetch_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_2:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g-16)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g-16)
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_2:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g-16)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g-16)
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_2:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g-16)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g-16)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 -4
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_global_3() nounwind {
; RV32I-LABEL: test_prefetch_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_3:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV32ZICBOP-NEXT:    prefetch.r 32(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_3:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOP-NEXT:    prefetch.r 32(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_3:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 32(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 8
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_global_4() nounwind {
; RV32I-LABEL: test_prefetch_global_4:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_4:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_4:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV32ZICBOP-NEXT:    prefetch.r -32(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_4:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOP-NEXT:    prefetch.r -32(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_4:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -32(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 -8
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_global_5() nounwind {
; RV32I-LABEL: test_prefetch_global_5:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_5:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_5:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV32ZICBOP-NEXT:    prefetch.r 2016(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_5:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOP-NEXT:    prefetch.r 2016(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_5:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 2016(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 504
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_global_6() nounwind {
; RV32I-LABEL: test_prefetch_global_6:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_6:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_6:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV32ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_6:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_6:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 -512
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_global_7() nounwind {
; RV32I-LABEL: test_prefetch_global_7:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_7:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_7:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g+2020)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g+2020)
; RV32ZICBOP-NEXT:    prefetch.r 0(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_7:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g+2020)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g+2020)
; RV64ZICBOP-NEXT:    prefetch.r 0(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_7:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g+2020)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g+2020)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r 0(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 505
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}

define void @test_prefetch_global_8() nounwind {
; RV32I-LABEL: test_prefetch_global_8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_prefetch_global_8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV32ZICBOP-LABEL: test_prefetch_global_8:
; RV32ZICBOP:       # %bb.0:
; RV32ZICBOP-NEXT:    lui a0, %hi(g-4)
; RV32ZICBOP-NEXT:    addi a0, a0, %lo(g-4)
; RV32ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV32ZICBOP-NEXT:    ret
;
; RV64ZICBOP-LABEL: test_prefetch_global_8:
; RV64ZICBOP:       # %bb.0:
; RV64ZICBOP-NEXT:    lui a0, %hi(g-4)
; RV64ZICBOP-NEXT:    addi a0, a0, %lo(g-4)
; RV64ZICBOP-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOP-NEXT:    ret
;
; RV64ZICBOPZIHINTNTL-LABEL: test_prefetch_global_8:
; RV64ZICBOPZIHINTNTL:       # %bb.0:
; RV64ZICBOPZIHINTNTL-NEXT:    lui a0, %hi(g-4)
; RV64ZICBOPZIHINTNTL-NEXT:    addi a0, a0, %lo(g-4)
; RV64ZICBOPZIHINTNTL-NEXT:    ntl.all
; RV64ZICBOPZIHINTNTL-NEXT:    prefetch.r -2048(a0)
; RV64ZICBOPZIHINTNTL-NEXT:    ret
  %ptr = getelementptr [1024 x i32], ptr @g, i32 0, i32 -513
  call void @llvm.prefetch(ptr %ptr, i32 0, i32 0, i32 1)
  ret void
}
