; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lsx --fp-contract=fast < %s \
; RUN:   | FileCheck %s --check-prefix=CONTRACT-FAST
; RUN: llc --mtriple=loongarch64 --mattr=+lsx --fp-contract=on < %s \
; RUN:   | FileCheck %s --check-prefix=CONTRACT-ON
; RUN: llc --mtriple=loongarch64 --mattr=+lsx --fp-contract=off < %s \
; RUN:   | FileCheck %s --check-prefix=CONTRACT-OFF

define void @vfmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-ON-NEXT:    vfadd.d $vr0, $vr0, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-OFF-NEXT:    vfadd.d $vr0, $vr0, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul<2 x double> %v0, %v1
  %add = fadd<2 x double> %mul, %v2
  store <2 x double> %add, ptr %res
  ret void
}

define void @vfmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-ON-NEXT:    vfsub.d $vr0, $vr0, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-OFF-NEXT:    vfsub.d $vr0, $vr0, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul<2 x double> %v0, %v1
  %sub = fsub<2 x double> %mul, %v2
  store <2 x double> %sub, ptr %res
  ret void
}

define void @vfnmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfnmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfnmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-ON-NEXT:    vfadd.d $vr0, $vr0, $vr2
; CONTRACT-ON-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfnmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-OFF-NEXT:    vfadd.d $vr0, $vr0, $vr2
; CONTRACT-OFF-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul<2 x double> %v0, %v1
  %add = fadd<2 x double> %mul, %v2
  %negadd = fneg<2 x double> %add
  store <2 x double> %negadd, ptr %res
  ret void
}

define void @vfnmadd_d_nsz(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfnmadd_d_nsz:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfnmadd_d_nsz:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-ON-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-ON-NEXT:    vfsub.d $vr0, $vr0, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfnmadd_d_nsz:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-OFF-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-OFF-NEXT:    vfsub.d $vr0, $vr0, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv0 = fneg nsz<2 x double> %v0
  %negv2 = fneg nsz<2 x double> %v2
  %mul = fmul nsz<2 x double> %negv0, %v1
  %add = fadd nsz<2 x double> %mul, %negv2
  store <2 x double> %add, ptr %res
  ret void
}

;; Check that vfnmadd.d is not emitted.
define void @not_vfnmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: not_vfnmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-FAST-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: not_vfnmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-ON-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-ON-NEXT:    vfsub.d $vr0, $vr0, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: not_vfnmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-OFF-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-OFF-NEXT:    vfsub.d $vr0, $vr0, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv0 = fneg<2 x double> %v0
  %negv2 = fneg<2 x double> %v2
  %mul = fmul<2 x double> %negv0, %v1
  %add = fadd<2 x double> %mul, %negv2
  store <2 x double> %add, ptr %res
  ret void
}

define void @vfnmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfnmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfnmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-ON-NEXT:    vfsub.d $vr0, $vr0, $vr2
; CONTRACT-ON-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfnmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-OFF-NEXT:    vfsub.d $vr0, $vr0, $vr2
; CONTRACT-OFF-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv2 = fneg<2 x double> %v2
  %mul = fmul<2 x double> %v0, %v1
  %add = fadd<2 x double> %mul, %negv2
  %neg = fneg<2 x double> %add
  store <2 x double> %neg, ptr %res
  ret void
}

define void @vfnmsub_d_nsz(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfnmsub_d_nsz:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfnmsub_d_nsz:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-ON-NEXT:    vfsub.d $vr0, $vr2, $vr0
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfnmsub_d_nsz:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-OFF-NEXT:    vfsub.d $vr0, $vr2, $vr0
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv0 = fneg nsz<2 x double> %v0
  %mul = fmul nsz<2 x double> %negv0, %v1
  %add = fadd nsz<2 x double> %mul, %v2
  store <2 x double> %add, ptr %res
  ret void
}

;; Check that vfnmsub.d is not emitted.
define void @not_vfnmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: not_vfnmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-FAST-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: not_vfnmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-ON-NEXT:    vfsub.d $vr0, $vr2, $vr0
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: not_vfnmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmul.d $vr0, $vr0, $vr1
; CONTRACT-OFF-NEXT:    vfsub.d $vr0, $vr2, $vr0
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv0 = fneg<2 x double> %v0
  %mul = fmul<2 x double> %negv0, %v1
  %add = fadd<2 x double> %mul, %v2
  store <2 x double> %add, ptr %res
  ret void
}

define void @contract_vfmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_vfmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_vfmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_vfmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul contract <2 x double> %v0, %v1
  %add = fadd contract <2 x double> %mul, %v2
  store <2 x double> %add, ptr %res
  ret void
}

define void @contract_vfmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_vfmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_vfmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_vfmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul contract <2 x double> %v0, %v1
  %sub = fsub contract <2 x double> %mul, %v2
  store <2 x double> %sub, ptr %res
  ret void
}

define void @contract_vfnmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_vfnmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_vfnmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_vfnmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul contract <2 x double> %v0, %v1
  %add = fadd contract <2 x double> %mul, %v2
  %negadd = fneg contract <2 x double> %add
  store <2 x double> %negadd, ptr %res
  ret void
}

define void @contract_vfnmadd_d_nsz(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_vfnmadd_d_nsz:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_vfnmadd_d_nsz:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_vfnmadd_d_nsz:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv0 = fneg contract nsz<2 x double> %v0
  %negv2 = fneg contract nsz<2 x double> %v2
  %mul = fmul contract nsz<2 x double> %negv0, %v1
  %add = fadd contract nsz<2 x double> %mul, %negv2
  store <2 x double> %add, ptr %res
  ret void
}

;; Check that vfnmadd.d is not emitted.
define void @not_contract_vfnmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: not_contract_vfnmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-FAST-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: not_contract_vfnmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-ON-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: not_contract_vfnmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-OFF-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv0 = fneg contract <2 x double> %v0
  %negv2 = fneg contract <2 x double> %v2
  %mul = fmul contract <2 x double> %negv0, %v1
  %add = fadd contract <2 x double> %mul, %negv2
  store <2 x double> %add, ptr %res
  ret void
}

define void @contract_vfnmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_vfnmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_vfnmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_vfnmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv2 = fneg contract <2 x double> %v2
  %mul = fmul contract <2 x double> %v0, %v1
  %add = fadd contract <2 x double> %mul, %negv2
  %neg = fneg contract <2 x double> %add
  store <2 x double> %neg, ptr %res
  ret void
}

define void @contract_vfnmsub_d_nsz(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_vfnmsub_d_nsz:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_vfnmsub_d_nsz:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_vfnmsub_d_nsz:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv0 = fneg contract nsz<2 x double> %v0
  %mul = fmul contract nsz<2 x double> %negv0, %v1
  %add = fadd contract nsz<2 x double> %mul, %v2
  store <2 x double> %add, ptr %res
  ret void
}

;; Check that vfnmsub.d is not emitted.
define void @not_contract_vfnmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: not_contract_vfnmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-FAST-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: not_contract_vfnmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-ON-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: not_contract_vfnmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vbitrevi.d $vr0, $vr0, 63
; CONTRACT-OFF-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %negv0 = fneg contract <2 x double> %v0
  %mul = fmul contract <2 x double> %negv0, %v1
  %add = fadd contract <2 x double> %mul, %v2
  store <2 x double> %add, ptr %res
  ret void
}

define void @vfmadd_d_contract(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfmadd_d_contract:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfmadd_d_contract:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfmadd_d_contract:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul contract <2 x double> %v0, %v1
  %add = fadd contract <2 x double> %mul, %v2
  store <2 x double> %add, ptr %res
  ret void
}

define void @vfmsub_d_contract(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfmsub_d_contract:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfmsub_d_contract:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfmsub_d_contract:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul contract <2 x double> %v0, %v1
  %sub = fsub contract <2 x double> %mul, %v2
  store <2 x double> %sub, ptr %res
  ret void
}

define void @vfnmadd_d_contract(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfnmadd_d_contract:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfnmadd_d_contract:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfnmadd_d_contract:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfnmadd.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul contract <2 x double> %v0, %v1
  %add = fadd contract <2 x double> %mul, %v2
  %negadd = fneg contract <2 x double> %add
  store <2 x double> %negadd, ptr %res
  ret void
}

define void @vfnmsub_d_contract(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: vfnmsub_d_contract:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    vld $vr0, $a1, 0
; CONTRACT-FAST-NEXT:    vld $vr1, $a2, 0
; CONTRACT-FAST-NEXT:    vld $vr2, $a3, 0
; CONTRACT-FAST-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-FAST-NEXT:    vst $vr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: vfnmsub_d_contract:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    vld $vr0, $a1, 0
; CONTRACT-ON-NEXT:    vld $vr1, $a2, 0
; CONTRACT-ON-NEXT:    vld $vr2, $a3, 0
; CONTRACT-ON-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-ON-NEXT:    vst $vr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: vfnmsub_d_contract:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    vld $vr0, $a1, 0
; CONTRACT-OFF-NEXT:    vld $vr1, $a2, 0
; CONTRACT-OFF-NEXT:    vld $vr2, $a3, 0
; CONTRACT-OFF-NEXT:    vfnmsub.d $vr0, $vr0, $vr1, $vr2
; CONTRACT-OFF-NEXT:    vst $vr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = load <2 x double>, ptr %a2
  %mul = fmul contract <2 x double> %v0, %v1
  %negv2 = fneg contract <2 x double> %v2
  %add = fadd contract <2 x double> %negv2, %mul
  %negadd = fneg contract <2 x double> %add
  store <2 x double> %negadd, ptr %res
  ret void
}
