; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; InstCombine should mark null-checked argument as nonnull at callsite
declare void @dummy(ptr, i32)

define void @test(ptr %a, i32 %b) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND1:%.*]] = icmp eq ptr [[A:%.*]], null
; CHECK-NEXT:    br i1 [[COND1]], label [[DEAD:%.*]], label [[NOT_NULL:%.*]]
; CHECK:       not_null:
; CHECK-NEXT:    [[COND2:%.*]] = icmp eq i32 [[B:%.*]], 0
; CHECK-NEXT:    br i1 [[COND2]], label [[DEAD]], label [[NOT_ZERO:%.*]]
; CHECK:       not_zero:
; CHECK-NEXT:    call void @dummy(ptr nonnull [[A]], i32 [[B]])
; CHECK-NEXT:    ret void
; CHECK:       dead:
; CHECK-NEXT:    unreachable
;
entry:
  %cond1 = icmp eq ptr %a, null
  br i1 %cond1, label %dead, label %not_null
not_null:
  %cond2 = icmp eq i32 %b, 0
  br i1 %cond2, label %dead, label %not_zero
not_zero:
  call void @dummy(ptr %a, i32 %b)
  ret void
dead:
  unreachable
}

; The nonnull attribute in the 'bar' declaration is
; propagated to the parameters of the 'baz' callsite.

declare void @bar(ptr, ptr nonnull noundef)
declare void @bar_without_noundef(ptr, ptr nonnull)
declare void @baz(ptr, ptr)

define void @deduce_nonnull_from_another_call(ptr %a, ptr %b) {
; CHECK-LABEL: @deduce_nonnull_from_another_call(
; CHECK-NEXT:    call void @bar(ptr [[A:%.*]], ptr [[B:%.*]])
; CHECK-NEXT:    call void @baz(ptr nonnull [[B]], ptr nonnull [[B]])
; CHECK-NEXT:    ret void
;
  call void @bar(ptr %a, ptr %b)
  call void @baz(ptr %b, ptr %b)
  ret void
}


define void @deduce_nonnull_from_another_call2(ptr %a, ptr %b) {
; CHECK-LABEL: @deduce_nonnull_from_another_call2(
; CHECK-NEXT:    call void @bar_without_noundef(ptr [[A:%.*]], ptr [[B:%.*]])
; CHECK-NEXT:    call void @baz(ptr [[B]], ptr [[B]])
; CHECK-NEXT:    ret void
;
  call void @bar_without_noundef(ptr %a, ptr %b)
  call void @baz(ptr %b, ptr %b)
  ret void
}

