; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='dse' -S %s | FileCheck %s

declare void @escape_and_clobber(ptr)
declare void @escape_writeonly(ptr) writeonly
declare void @clobber()

define i32 @test_not_captured_before_load_same_bb(ptr %in.ptr) {
; CHECK-LABEL: @test_not_captured_before_load_same_bb(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

define i32 @test_not_captured_before_load_same_bb_escape_unreachable_block(ptr %in.ptr) {
; CHECK-LABEL: @test_not_captured_before_load_same_bb_escape_unreachable_block(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
; CHECK:       unreach:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 0
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2

unreach:
  call void @escape_and_clobber(ptr %a)
  ret i32 0
}

define i32 @test_not_captured_before_load_same_bb_escape_unreachable_block2(ptr %in.ptr) {
; CHECK-LABEL: @test_not_captured_before_load_same_bb_escape_unreachable_block2(
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       unreach:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A:%.*]])
; CHECK-NEXT:    ret i32 0
; CHECK:       bb:
; CHECK-NEXT:    [[A]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  br label %bb

unreach:
  call void @escape_and_clobber(ptr %a)
  ret i32 0

bb:
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

define i32 @test_captured_and_clobbered_after_load_same_bb_2(ptr %in.ptr) {
; CHECK-LABEL: @test_captured_and_clobbered_after_load_same_bb_2(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  call void @escape_and_clobber(ptr %a)
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %in.lv.2
}

define i32 @test_captured_after_load_same_bb_2_clobbered_later(ptr %in.ptr) {
; CHECK-LABEL: @test_captured_after_load_same_bb_2_clobbered_later(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  call void @escape_writeonly(ptr %a)
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %in.lv.2
}

define i32 @test_captured_and_clobbered_before_load_same_bb_1(ptr %in.ptr) {
; CHECK-LABEL: @test_captured_and_clobbered_before_load_same_bb_1(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  call void @escape_and_clobber(ptr %a)
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %in.lv.2
}

define i32 @test_captured_before_load_same_bb_1_clobbered_later(ptr %in.ptr) {
; CHECK-LABEL: @test_captured_before_load_same_bb_1_clobbered_later(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  call void @escape_writeonly(ptr %a)
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %in.lv.2
}

define i32 @test_captured_before_load_same_bb_2(ptr %in.ptr) {
; CHECK-LABEL: @test_captured_before_load_same_bb_2(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  call void @escape_writeonly(ptr %a)
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %in.lv.2
}

define i32 @test_not_captured_before_load_same_bb_clobber(ptr %in.ptr) {
; CHECK-LABEL: @test_not_captured_before_load_same_bb_clobber(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  call void @clobber()
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

define i32 @test_captured_before_load_same_bb(ptr %in.ptr) {
; CHECK-LABEL: @test_captured_before_load_same_bb(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  call void @escape_and_clobber(ptr %a)
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

define i32 @test_captured_sibling_path_to_load_other_blocks_1(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_captured_sibling_path_to_load_other_blocks_1(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[THEN]] ], [ [[IN_LV_2]], [[ELSE]] ]
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %else

then:
  call void @escape_writeonly(ptr %a)
  br label %exit

else:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  br label %exit

exit:
  %p = phi i32 [ 0, %then ], [ %in.lv.2, %else ]
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %p
}

define i32 @test_only_captured_sibling_path_with_ret_to_load_other_blocks(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_only_captured_sibling_path_with_ret_to_load_other_blocks(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    ret i32 0
; CHECK:       else:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %else

then:
  call void @escape_writeonly(ptr %a)
  ret i32 0

else:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  br label %exit

exit:
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %in.lv.2
}

define i32 @test_captured_before_load_other_blocks_2(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_captured_before_load_other_blocks_2(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[THEN]] ], [ [[IN_LV_2]], [[ELSE]] ]
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %else

then:
  br label %exit

else:
  call void @escape_and_clobber(ptr %a)
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  br label %exit

exit:
  %p = phi i32 [ 0, %then ], [ %in.lv.2, %else ]
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %p
}

define i32 @test_captured_before_load_other_blocks_4(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_captured_before_load_other_blocks_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[THEN]] ], [ [[IN_LV_2]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
entry:
  %a = alloca i32, align 4
  store i32 55, ptr %a
  call void @escape_writeonly(ptr %a)
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  br i1 %c.1, label %then, label %exit

then:
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %p = phi i32 [ 0, %then ], [ %in.lv.2, %entry ]
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %p
}

define i32 @test_captured_before_load_other_blocks_5(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_captured_before_load_other_blocks_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
entry:
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %exit

then:
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %in.lv.2
}

define i32 @test_captured_before_load_other_blocks_6(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_captured_before_load_other_blocks_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
entry:
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %exit

then:
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_writeonly(ptr %a)
  call void @clobber()
  ret i32 %in.lv.2
}

define i32 @test_not_captured_before_load_other_blocks_1(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_before_load_other_blocks_1(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  br i1 %c.1, label %then, label %else

then:
  br label %exit

else:
  br label %exit

exit:
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

define i32 @test_not_captured_before_load_other_blocks_2(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_before_load_other_blocks_2(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  br i1 %c.1, label %then, label %else

then:
  call void @escape_and_clobber(ptr %a)
  br label %exit

else:
  call void @escape_and_clobber(ptr %a)
  br label %exit

exit:
  ret i32 %in.lv.2
}

define i32 @test_not_captured_before_load_other_blocks_3(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_before_load_other_blocks_3(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  br i1 %c.1, label %then, label %else

then:
  call void @escape_and_clobber(ptr %a)
  br label %exit

else:
  br label %exit

exit:
  ret i32 %in.lv.2
}

define i32 @test_not_captured_before_load_other_blocks_4(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_before_load_other_blocks_4(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[THEN]] ], [ [[IN_LV_2]], [[ELSE]] ]
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %else

then:
  br label %exit

else:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %p = phi i32 [ 0, %then ], [ %in.lv.2, %else ]
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %p
}

define i32 @test_not_captured_before_load_other_blocks_5(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_before_load_other_blocks_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ [[IN_LV_2]], [[THEN]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
entry:
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %exit

then:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %p = phi i32 [ %in.lv.2, %then ], [ 0, %entry ]
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %p
}

define i32 @test_not_captured_before_load_other_blocks_6(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_before_load_other_blocks_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ [[IN_LV_2]], [[THEN]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
entry:
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %exit

then:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %p = phi i32 [ %in.lv.2, %then ], [ 0, %entry ]
  store i32 99, ptr %a, align 4
  call void @escape_writeonly(ptr %a)
  call void @clobber()
  ret i32 %p
}

define i32 @test_not_captured_before_load_other_blocks_7(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_before_load_other_blocks_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[THEN]] ], [ [[IN_LV_2]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
entry:
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  call void @escape_writeonly(ptr %a)
  br i1 %c.1, label %then, label %exit

then:
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %p = phi i32 [ 0, %then ], [ %in.lv.2, %entry ]
  store i32 99, ptr %a, align 4
  call void @clobber()
  ret i32 %p
}

define i32 @test_not_captured_before_load_same_bb_but_read(ptr %in.ptr) {
; CHECK-LABEL: @test_not_captured_before_load_same_bb_but_read(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    [[LV:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[IN_LV_2]], [[LV]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  %lv = load i32, ptr %a
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  %res = add i32 %in.lv.2, %lv
  ret i32 %res
}

define i32 @test_not_captured_before_load_may_alias_same_bb_but_read(ptr %in.ptr, ptr %b, i1 %c) {
; CHECK-LABEL: @test_not_captured_before_load_may_alias_same_bb_but_read(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    [[PTR:%.*]] = select i1 [[C:%.*]], ptr [[A]], ptr [[B:%.*]]
; CHECK-NEXT:    [[LV:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[IN_LV_2]], [[LV]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  %ptr = select i1 %c, ptr %a, ptr %b
  %lv = load i32, ptr %ptr
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  %res = add i32 %in.lv.2, %lv
  ret i32 %res
}

define i32 @test_captured_after_loop(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_captured_after_loop(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br label %loop

loop:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  br i1 %c.1, label %loop, label %exit

exit:
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

define i32 @test_captured_in_loop(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_captured_in_loop(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br label %loop

loop:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  call void @escape_writeonly(ptr %a)
  store i32 99, ptr %a, align 4
  br i1 %c.1, label %loop, label %exit

exit:
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

declare void @llvm.memset.p0.i32(ptr nocapture writeonly, i8, i32, i1 immarg)

@global = external global ptr

define void @test_memset_not_captured_before_load() {
; CHECK-LABEL: @test_memset_not_captured_before_load(
; CHECK-NEXT:    [[A:%.*]] = alloca [2 x i32], align 4
; CHECK-NEXT:    [[LV_1:%.*]] = load ptr, ptr @global, align 8
; CHECK-NEXT:    store i32 1, ptr [[A]], align 4
; CHECK-NEXT:    [[GEP_LV:%.*]] = getelementptr inbounds [10 x i16], ptr [[LV_1]], i64 0, i32 1
; CHECK-NEXT:    [[LV_2:%.*]] = load i16, ptr [[GEP_LV]], align 2
; CHECK-NEXT:    [[EXT_LV_2:%.*]] = zext i16 [[LV_2]] to i32
; CHECK-NEXT:    [[GEP_A_1:%.*]] = getelementptr inbounds [2 x i32], ptr [[A]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[EXT_LV_2]], ptr [[GEP_A_1]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca [2 x i32], align 4
  call void @llvm.memset.p0.i32(ptr %a, i8 0, i32 8, i1 false)
  %lv.1 = load ptr, ptr @global, align 8
  store i32 1, ptr %a, align 4
  %gep.lv = getelementptr inbounds [10 x i16], ptr %lv.1, i64 0, i32 1
  %lv.2 = load i16, ptr %gep.lv, align 2
  %ext.lv.2 = zext i16 %lv.2 to i32
  %gep.a.1 = getelementptr inbounds [2 x i32], ptr %a, i32 0, i32 1
  store i32 %ext.lv.2, ptr %gep.a.1, align 4
  call void @escape_and_clobber(ptr %a)
  ret void
}

define void @test_test_not_captured_before_load(i1 %c.1) {
; CHECK-LABEL: @test_test_not_captured_before_load(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[A:%.*]] = alloca [2 x i32], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds i8, ptr [[A]], i32 4
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr align 1 [[TMP0]], i8 0, i32 4, i1 false)
; CHECK-NEXT:    [[LV_1:%.*]] = load ptr, ptr @global, align 8
; CHECK-NEXT:    [[GEP_LV:%.*]] = getelementptr inbounds [10 x i16], ptr [[LV_1]], i64 0, i32 1
; CHECK-NEXT:    [[LV_2:%.*]] = load i16, ptr [[GEP_LV]], align 2
; CHECK-NEXT:    store i32 1, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[EXT_LV_2:%.*]] = zext i16 [[LV_2]] to i32
; CHECK-NEXT:    [[GEP_A_1:%.*]] = getelementptr inbounds [2 x i32], ptr [[A]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[EXT_LV_2]], ptr [[GEP_A_1]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret void
;
bb:
  %a = alloca [2 x i32], align 4
  call void @llvm.memset.p0.i32(ptr %a, i8 0, i32 8, i1 false)
  %lv.1 = load ptr, ptr @global, align 8
  %gep.lv = getelementptr inbounds [10 x i16], ptr %lv.1, i64 0, i32 1
  %lv.2 = load i16, ptr %gep.lv, align 2
  store i32 1, ptr %a, align 4
  br i1 %c.1, label %then, label %else

then:
  call void @escape_and_clobber(ptr %a)
  br label %exit

else:
  br label %exit

exit:
  %ext.lv.2 = zext i16 %lv.2 to i32
  %gep.a.1 = getelementptr inbounds [2 x i32], ptr %a, i32 0, i32 1
  store i32 %ext.lv.2, ptr %gep.a.1, align 4
  call void @escape_and_clobber(ptr %a)
  ret void
}

declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture) #0
declare void @llvm.memset.p0.i64(ptr nocapture writeonly, i8, i64, i1 immarg) #1

declare void @use.i64(i64)

define i64 @test_a_not_captured_at_all(ptr %ptr, ptr %ptr.2, i1 %c) {
; CHECK-LABEL: @test_a_not_captured_at_all(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[B:%.*]] = alloca i64, align 8
; CHECK-NEXT:    store ptr [[B]], ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    [[LV_1:%.*]] = load ptr, ptr [[PTR_2:%.*]], align 8
; CHECK-NEXT:    br i1 [[C:%.*]], label [[EXIT:%.*]], label [[THEN:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LV_2:%.*]] = load i64, ptr [[LV_1]], align 4
; CHECK-NEXT:    call void @use.i64(i64 [[LV_2]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 8, ptr [[A]])
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr [[A]], i8 0, i64 8, i1 false)
; CHECK-NEXT:    [[L:%.*]] = load i64, ptr [[A]], align 4
; CHECK-NEXT:    ret i64 [[L]]
;
entry:
  %a = alloca i64, align 8
  %b = alloca i64, align 8
  store ptr %b, ptr %ptr, align 8
  %lv.1 = load ptr, ptr %ptr.2, align 8
  br i1 %c, label %exit, label %then

then:
  %lv.2 = load i64, ptr %lv.1
  call void @use.i64(i64 %lv.2)
  br label %exit

exit:
  call void @llvm.lifetime.start.p0(i64 8, ptr %a)
  store i64 99, ptr %a
  call void @clobber()
  call void @llvm.memset.p0.i64(ptr %a, i8 0, i64 8, i1 false)
  %l = load i64, ptr %a
  ret i64 %l
}

define i32 @test_not_captured_both_paths_1(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_both_paths_1(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[THEN]] ], [ [[IN_LV_2]], [[ELSE]] ]
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %else

then:
  store i32 99, ptr %a, align 4
  call void @escape_writeonly(ptr %a)
  br label %exit

else:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %p = phi i32 [ 0, %then ], [ %in.lv.2, %else ]
  call void @clobber()
  ret i32 %p
}

define i32 @test_not_captured_both_paths_2(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_not_captured_both_paths_2(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ [[IN_LV_2]], [[THEN]] ], [ 0, [[ELSE]] ]
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %else

then:
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_writeonly(ptr %a)
  br label %exit

else:
  store i32 99, ptr %a, align 4
  call void @escape_writeonly(ptr %a)
  br label %exit

exit:
  %p = phi i32 [ %in.lv.2, %then ], [ 0, %else ]
  call void @clobber()
  ret i32 %p
}

define i32 @test_captured_before_store_both_paths_2(ptr %in.ptr, i1 %c.1) {
; CHECK-LABEL: @test_captured_before_store_both_paths_2(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 55, ptr [[A]], align 4
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    call void @escape_writeonly(ptr [[A]])
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ [[IN_LV_2]], [[THEN]] ], [ 0, [[ELSE]] ]
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 [[P]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  br i1 %c.1, label %then, label %else

then:
  call void @escape_writeonly(ptr %a)
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  br label %exit

else:
  call void @escape_writeonly(ptr %a)
  store i32 99, ptr %a, align 4
  br label %exit

exit:
  %p = phi i32 [ %in.lv.2, %then ], [ 0, %else ]
  call void @clobber()
  ret i32 %p
}


declare noalias ptr @alloc() nounwind

define i32 @test_not_captured_before_load_same_bb_noalias_call(ptr %in.ptr) {
; CHECK-LABEL: @test_not_captured_before_load_same_bb_noalias_call(
; CHECK-NEXT:    [[A:%.*]] = call ptr @alloc()
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = call ptr @alloc()
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

define i32 @test_not_captured_before_load_same_bb_noalias_arg(ptr %in.ptr, ptr noalias %a) {
; CHECK-LABEL: @test_not_captured_before_load_same_bb_noalias_arg(
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[A:%.*]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  store i32 55, ptr %a
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %a, align 4
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.lv.2
}

define i32 @instruction_captures_multiple_objects(ptr %p.1, ptr %p.2, ptr %p.3, i1 %c) {
; CHECK-LABEL: @instruction_captures_multiple_objects(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_1:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[A_2:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 0, ptr [[P_1:%.*]], align 8
; CHECK-NEXT:    br i1 [[C:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LV_2:%.*]] = load ptr, ptr [[P_2:%.*]], align 8
; CHECK-NEXT:    [[LV_2_2:%.*]] = load i32, ptr [[LV_2]], align 4
; CHECK-NEXT:    ret i32 [[LV_2_2]]
; CHECK:       else:
; CHECK-NEXT:    [[LV_3:%.*]] = load ptr, ptr [[P_3:%.*]], align 8
; CHECK-NEXT:    [[LV_3_2:%.*]] = load i32, ptr [[LV_3]], align 4
; CHECK-NEXT:    call void @capture_and_clobber_multiple(ptr [[A_1]], ptr [[A_2]])
; CHECK-NEXT:    ret i32 [[LV_3_2]]
;
entry:
  %a.1 = alloca i32
  %a.2 = alloca i32
  store i32 0, ptr %p.1, align 8
  br i1 %c, label %then, label %else

then:
  store i32 99, ptr %a.2, align 4
  %lv.2 = load ptr, ptr %p.2
  %lv.2.2 = load i32, ptr %lv.2
  store i32 0, ptr %a.1, align 8
  ret i32 %lv.2.2

else:
  %lv.3 = load ptr, ptr %p.3
  %lv.3.2 = load i32, ptr %lv.3
  call void @capture_and_clobber_multiple(ptr %a.1, ptr %a.2)
  ret i32 %lv.3.2
}

declare void @capture_and_clobber_multiple(ptr, ptr)

declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)

define i64 @earliest_escape_ptrtoint(ptr %p.1) {
; CHECK-LABEL: @earliest_escape_ptrtoint(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_1:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[A_2:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[LV_1:%.*]] = load ptr, ptr [[P_1:%.*]], align 8
; CHECK-NEXT:    [[LV_2:%.*]] = load i64, ptr [[LV_1]], align 4
; CHECK-NEXT:    store ptr [[A_1]], ptr [[P_1]], align 8
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 8, ptr [[A_2]])
; CHECK-NEXT:    ret i64 [[LV_2]]
;
entry:
  %a.1 = alloca i64
  %a.2 = alloca i64
  store i64 99, ptr %a.1
  %lv.1 = load ptr, ptr %p.1
  %lv.2 = load i64, ptr %lv.1
  store ptr %a.1, ptr %p.1, align 8
  %int = ptrtoint ptr %a.2 to i64
  store i64 %int , ptr %a.2, align 8
  call void @llvm.lifetime.end.p0(i64 8, ptr %a.2)
  ret i64 %lv.2
}

define i32 @test_not_captured_before_load_of_ptrtoint(i64 %in) {
; CHECK-LABEL: @test_not_captured_before_load_of_ptrtoint(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_PTR:%.*]] = inttoptr i64 [[IN:%.*]] to ptr
; CHECK-NEXT:    [[IN_PTR_LOAD:%.*]] = load i32, ptr [[IN_PTR]], align 4
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_PTR_LOAD]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.ptr = inttoptr i64 %in to ptr
  %in.ptr.load = load i32, ptr %in.ptr
  store i32 99, ptr %a
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.ptr.load
}

declare ptr @getptr()

define i32 @test_not_captured_before_load_of_call() {
; CHECK-LABEL: @test_not_captured_before_load_of_call(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[IN_PTR:%.*]] = call ptr @getptr() #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    [[IN_PTR_LOAD:%.*]] = load i32, ptr [[IN_PTR]], align 4
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[A]])
; CHECK-NEXT:    ret i32 [[IN_PTR_LOAD]]
;
  %a = alloca i32, align 4
  store i32 55, ptr %a
  %in.ptr = call ptr @getptr() readnone
  %in.ptr.load = load i32, ptr %in.ptr
  store i32 99, ptr %a
  call void @escape_and_clobber(ptr %a)
  ret i32 %in.ptr.load
}

define i32 @test_not_captured_multiple_objects(i1 %c, ptr %in.ptr) {
; CHECK-LABEL: @test_not_captured_multiple_objects(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[O:%.*]] = select i1 [[C:%.*]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[IN_LV_1:%.*]] = load ptr, ptr [[IN_PTR:%.*]], align 2
; CHECK-NEXT:    [[IN_LV_2:%.*]] = load i32, ptr [[IN_LV_1]], align 2
; CHECK-NEXT:    store i32 99, ptr [[O]], align 4
; CHECK-NEXT:    call void @escape_and_clobber(ptr [[O]])
; CHECK-NEXT:    ret i32 [[IN_LV_2]]
;
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %o = select i1 %c, ptr %a, ptr %b
  store i32 55, ptr %o
  %in.lv.1 = load ptr , ptr %in.ptr, align 2
  %in.lv.2 = load i32 , ptr %in.lv.1, align 2
  store i32 99, ptr %o
  call void @escape_and_clobber(ptr %o)
  ret i32 %in.lv.2
}
