; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; RUN: opt < %s -passes=argpromotion -S | FileCheck %s
; PR36543

; Don't promote arguments of musttail callee

%T = type { i32, i32, i32, i32 }

define internal i32 @test(ptr %p) {
; CHECK-LABEL: define {{[^@]+}}@test
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:    [[A_GEP:%.*]] = getelementptr [[T:%.*]], ptr [[P]], i64 0, i32 3
; CHECK-NEXT:    [[B_GEP:%.*]] = getelementptr [[T]], ptr [[P]], i64 0, i32 2
; CHECK-NEXT:    [[A:%.*]] = load i32, ptr [[A_GEP]], align 4
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[B_GEP]], align 4
; CHECK-NEXT:    [[V:%.*]] = add i32 [[A]], [[B]]
; CHECK-NEXT:    ret i32 [[V]]
;
  %a.gep = getelementptr %T, ptr %p, i64 0, i32 3
  %b.gep = getelementptr %T, ptr %p, i64 0, i32 2
  %a = load i32, ptr %a.gep
  %b = load i32, ptr %b.gep
  %v = add i32 %a, %b
  ret i32 %v
}

define i32 @caller(ptr %p) {
; CHECK-LABEL: define {{[^@]+}}@caller
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:    [[V:%.*]] = musttail call i32 @test(ptr [[P]])
; CHECK-NEXT:    ret i32 [[V]]
;
  %v = musttail call i32 @test(ptr %p)
  ret i32 %v
}

; Don't promote arguments of musttail caller

define i32 @foo(ptr %p, i32 %v) {
; CHECK-LABEL: define {{[^@]+}}@foo
; CHECK-SAME: (ptr [[P:%.*]], i32 [[V:%.*]]) {
; CHECK-NEXT:    ret i32 0
;
  ret i32 0
}

define internal i32 @test2(ptr %p, i32 %p2) {
; CHECK-LABEL: define {{[^@]+}}@test2
; CHECK-SAME: (ptr [[P:%.*]], i32 [[P2:%.*]]) {
; CHECK-NEXT:    [[A_GEP:%.*]] = getelementptr [[T:%.*]], ptr [[P]], i64 0, i32 3
; CHECK-NEXT:    [[B_GEP:%.*]] = getelementptr [[T]], ptr [[P]], i64 0, i32 2
; CHECK-NEXT:    [[A:%.*]] = load i32, ptr [[A_GEP]], align 4
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[B_GEP]], align 4
; CHECK-NEXT:    [[V:%.*]] = add i32 [[A]], [[B]]
; CHECK-NEXT:    [[CA:%.*]] = musttail call i32 @foo(ptr undef, i32 [[V]])
; CHECK-NEXT:    ret i32 [[CA]]
;
  %a.gep = getelementptr %T, ptr %p, i64 0, i32 3
  %b.gep = getelementptr %T, ptr %p, i64 0, i32 2
  %a = load i32, ptr %a.gep
  %b = load i32, ptr %b.gep
  %v = add i32 %a, %b
  %ca = musttail call i32 @foo(ptr undef, i32 %v)
  ret i32 %ca
}

define i32 @caller2(ptr %g) {
; CHECK-LABEL: define {{[^@]+}}@caller2
; CHECK-SAME: (ptr [[G:%.*]]) {
; CHECK-NEXT:    [[V:%.*]] = call i32 @test2(ptr [[G]], i32 0)
; CHECK-NEXT:    ret i32 [[V]]
;
  %v = call i32 @test2(ptr %g, i32 0)
  ret i32 %v
}
