/* kkc.c generated by valac 0.38.8, the Vala compiler
 * generated from kkc.vala, do not modify */

/*
 * Copyright (C) 2012-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <locale.h>
#include <config.h>
#include <libkkc/libkkc.h>
#include <gio/gio.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_group_free0(var) ((var == NULL) ? NULL : (var = (g_option_group_free (var), NULL)))

#define TYPE_TOOL (tool_get_type ())
#define TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOOL, Tool))
#define IS_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOOL))
#define TOOL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_TOOL, ToolIface))

typedef struct _Tool Tool;
typedef struct _ToolIface ToolIface;

#define TYPE_DECODER_TOOL (decoder_tool_get_type ())
#define DECODER_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DECODER_TOOL, DecoderTool))
#define DECODER_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DECODER_TOOL, DecoderToolClass))
#define IS_DECODER_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DECODER_TOOL))
#define IS_DECODER_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DECODER_TOOL))
#define DECODER_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DECODER_TOOL, DecoderToolClass))

typedef struct _DecoderTool DecoderTool;
typedef struct _DecoderToolClass DecoderToolClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CONTEXT_TOOL (context_tool_get_type ())
#define CONTEXT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTEXT_TOOL, ContextTool))
#define CONTEXT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTEXT_TOOL, ContextToolClass))
#define IS_CONTEXT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTEXT_TOOL))
#define IS_CONTEXT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTEXT_TOOL))
#define CONTEXT_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTEXT_TOOL, ContextToolClass))

typedef struct _ContextTool ContextTool;
typedef struct _ContextToolClass ContextToolClass;

#define TYPE_SERVER_TOOL (server_tool_get_type ())
#define SERVER_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERVER_TOOL, ServerTool))
#define SERVER_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERVER_TOOL, ServerToolClass))
#define IS_SERVER_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERVER_TOOL))
#define IS_SERVER_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERVER_TOOL))
#define SERVER_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERVER_TOOL, ServerToolClass))

typedef struct _ServerTool ServerTool;
typedef struct _ServerToolClass ServerToolClass;
typedef struct _DecoderToolPrivate DecoderToolPrivate;
enum  {
	DECODER_TOOL_0_PROPERTY,
	DECODER_TOOL_NUM_PROPERTIES
};
static GParamSpec* decoder_tool_properties[DECODER_TOOL_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ContextToolPrivate ContextToolPrivate;
enum  {
	CONTEXT_TOOL_0_PROPERTY,
	CONTEXT_TOOL_NUM_PROPERTIES
};
static GParamSpec* context_tool_properties[CONTEXT_TOOL_NUM_PROPERTIES];
typedef struct _ServerToolPrivate ServerToolPrivate;
enum  {
	SERVER_TOOL_0_PROPERTY,
	SERVER_TOOL_NUM_PROPERTIES
};
static GParamSpec* server_tool_properties[SERVER_TOOL_NUM_PROPERTIES];
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _ToolIface {
	GTypeInterface parent_iface;
	gboolean (*parse_arguments) (Tool* self, gchar** args, int args_length1, GError** error);
	gboolean (*run) (Tool* self, GError** error);
};

struct _DecoderTool {
	GObject parent_instance;
	DecoderToolPrivate * priv;
};

struct _DecoderToolClass {
	GObjectClass parent_class;
};

struct _ContextTool {
	GObject parent_instance;
	ContextToolPrivate * priv;
};

struct _ContextToolClass {
	GObjectClass parent_class;
};

struct _ServerTool {
	GObject parent_instance;
	ServerToolPrivate * priv;
};

struct _ServerToolClass {
	GObjectClass parent_class;
};


extern gchar* opt_model;
gchar* opt_model = NULL;
extern gchar* opt_system_dictionary;
gchar* opt_system_dictionary = NULL;
extern gchar* opt_user_dictionary;
gchar* opt_user_dictionary = NULL;
extern gchar* opt_typing_rule;
gchar* opt_typing_rule = NULL;
extern GOptionGroup* model_group;
GOptionGroup* model_group = NULL;
static gpointer decoder_tool_parent_class = NULL;
static ToolIface * decoder_tool_tool_parent_iface = NULL;
static gpointer context_tool_parent_class = NULL;
static ToolIface * context_tool_tool_parent_iface = NULL;
static gpointer server_tool_parent_class = NULL;
static ToolIface * server_tool_tool_parent_iface = NULL;

void usage (gchar** args, int args_length1, FILE* output);
gint _vala_main (gchar** args, int args_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
GType tool_get_type (void) G_GNUC_CONST;
DecoderTool* decoder_tool_new (void);
DecoderTool* decoder_tool_construct (GType object_type);
GType decoder_tool_get_type (void) G_GNUC_CONST;
ContextTool* context_tool_new (void);
ContextTool* context_tool_construct (GType object_type);
GType context_tool_get_type (void) G_GNUC_CONST;
ServerTool* server_tool_new (void);
ServerTool* server_tool_construct (GType object_type);
GType server_tool_get_type (void) G_GNUC_CONST;
gboolean tool_parse_arguments (Tool* self, gchar** args, int args_length1, GError** error);
gboolean tool_run (Tool* self, GError** error);
static gboolean decoder_tool_real_parse_arguments (Tool* base, gchar** args, int args_length1, GError** error);
static gboolean decoder_tool_real_run (Tool* base, GError** error);
static gboolean context_tool_real_parse_arguments (Tool* base, gchar** args, int args_length1, GError** error);
static gboolean context_tool_real_run (Tool* base, GError** error);
static gboolean server_tool_real_parse_arguments (Tool* base, gchar** args, int args_length1, GError** error);
static gboolean server_tool_real_run (Tool* base, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry model_entries[2] = {{"model", 'm', 0, G_OPTION_ARG_STRING, &opt_model, N_ ("Language model"), NULL}, {NULL}};
const GOptionEntry decoder_entries[1] = {{NULL}};
const GOptionEntry context_entries[4] = {{"system-dictionary", 's', 0, G_OPTION_ARG_STRING, &opt_system_dictionary, N_ ("Path to a system dictionary"), NULL}, {"user-dictionary", 'u', 0, G_OPTION_ARG_STRING, &opt_user_dictionary, N_ ("Path to a user dictionary"), NULL}, {"rule", 'r', 0, G_OPTION_ARG_STRING, &opt_typing_rule, N_ ("Typing rule (use \"?\" to list available rules)"), NULL}, {NULL}};

void usage (gchar** args, int args_length1, FILE* output) {
	GOptionContext* o = NULL;
	GOptionContext* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* s = NULL;
	gchar* _tmp7_;
	FILE* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (output != NULL);
	_tmp0_ = g_option_context_new (_ ("COMMAND"));
	o = _tmp0_;
	g_option_context_set_help_enabled (o, FALSE);
	{
		g_option_context_parse (o, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (o);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (_ ("Commands:\n" \
"  help         Shows this information\n" \
"  decoder      Run decoder\n" \
"  context      Run context\n" \
"  server       Run server\n" \
"\n" \
"  Use \"%s COMMAND --help\" to get help on each command.\n"), _tmp4_);
	_tmp6_ = _tmp5_;
	g_option_context_set_description (o, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = g_option_context_get_help (o, FALSE, NULL);
	s = _tmp7_;
	_tmp8_ = output;
	fprintf (_tmp8_, "%s", s);
	_g_free0 (s);
	_g_option_context_free0 (o);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionGroup* _tmp0_;
	GOptionGroup* _tmp1_;
	gchar** new_args = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint new_args_length1;
	gint _new_args_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	Tool* tool = NULL;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_group_new ("model", N_ ("Model options:"), N_ ("Options specifying the language model"), NULL, NULL);
	_g_option_group_free0 (model_group);
	model_group = _tmp0_;
	_tmp1_ = model_group;
	g_option_group_add_entries (_tmp1_, model_entries);
	kkc_init ();
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_tmp4_ = ((_tmp2_ + 1) != NULL) ? _vala_array_dup1 (_tmp2_ + 1, _tmp3__length1 - 1) : ((gpointer) (_tmp2_ + 1));
	_tmp4__length1 = _tmp3__length1 - 1;
	new_args = _tmp4_;
	new_args_length1 = _tmp4__length1;
	_new_args_size_ = new_args_length1;
	_tmp5_ = new_args;
	_tmp5__length1 = new_args_length1;
	if (_tmp5__length1 < 1) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		_tmp6_ = new_args;
		_tmp6__length1 = new_args_length1;
		_tmp7_ = g_strdup ("decoder");
		_vala_array_add1 (&new_args, &new_args_length1, &_new_args_size_, _tmp7_);
	}
	_tmp8_ = args;
	_tmp8__length1 = args_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = new_args;
	_tmp10__length1 = new_args_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = g_strdup_printf ("%s %s", _tmp9_, _tmp11_);
	_tmp13_ = _tmp12_;
	g_set_prgname (_tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = new_args;
	_tmp14__length1 = new_args_length1;
	_tmp15_ = _tmp14_[0];
	if (g_strcmp0 (_tmp15_, "decoder") == 0) {
		DecoderTool* _tmp16_;
		_tmp16_ = decoder_tool_new ();
		_g_object_unref0 (tool);
		tool = (Tool*) _tmp16_;
	} else {
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		_tmp17_ = new_args;
		_tmp17__length1 = new_args_length1;
		_tmp18_ = _tmp17_[0];
		if (g_strcmp0 (_tmp18_, "context") == 0) {
			ContextTool* _tmp19_;
			_tmp19_ = context_tool_new ();
			_g_object_unref0 (tool);
			tool = (Tool*) _tmp19_;
		} else {
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			_tmp20_ = new_args;
			_tmp20__length1 = new_args_length1;
			_tmp21_ = _tmp20_[0];
			if (g_strcmp0 (_tmp21_, "server") == 0) {
				ServerTool* _tmp22_;
				_tmp22_ = server_tool_new ();
				_g_object_unref0 (tool);
				tool = (Tool*) _tmp22_;
			} else {
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				_tmp23_ = new_args;
				_tmp23__length1 = new_args_length1;
				_tmp24_ = _tmp23_[0];
				if (g_strcmp0 (_tmp24_, "help") == 0) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					FILE* _tmp26_;
					_tmp25_ = args;
					_tmp25__length1 = args_length1;
					_tmp26_ = stdout;
					usage (_tmp25_, _tmp25__length1, _tmp26_);
					result = 0;
					_g_object_unref0 (tool);
					new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
					return result;
				} else {
					FILE* _tmp27_;
					gchar** _tmp28_;
					gint _tmp28__length1;
					const gchar* _tmp29_;
					gchar** _tmp30_;
					gint _tmp30__length1;
					FILE* _tmp31_;
					_tmp27_ = stderr;
					_tmp28_ = new_args;
					_tmp28__length1 = new_args_length1;
					_tmp29_ = _tmp28_[0];
					fprintf (_tmp27_, "Unknown command: %s\n", _tmp29_);
					_tmp30_ = args;
					_tmp30__length1 = args_length1;
					_tmp31_ = stderr;
					usage (_tmp30_, _tmp30__length1, _tmp31_);
					result = 1;
					_g_object_unref0 (tool);
					new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	{
		Tool* _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		_tmp32_ = tool;
		_tmp33_ = new_args;
		_tmp33__length1 = new_args_length1;
		tool_parse_arguments (_tmp32_, _tmp33_, _tmp33__length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		gchar** _tmp34_;
		gint _tmp34__length1;
		FILE* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp34_ = args;
		_tmp34__length1 = args_length1;
		_tmp35_ = stderr;
		usage (_tmp34_, _tmp34__length1, _tmp35_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (tool);
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp36_ = 0;
		_g_object_unref0 (tool);
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp36_;
	}
	{
		Tool* _tmp37_;
		_tmp37_ = tool;
		tool_run (_tmp37_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (tool);
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp38_ = 0;
		_g_object_unref0 (tool);
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp38_;
	}
	result = 0;
	_g_object_unref0 (tool);
	new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


int main (int argc, char ** argv) {
	return _vala_main (argv, argc);
}


gboolean tool_parse_arguments (Tool* self, gchar** args, int args_length1, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return TOOL_GET_INTERFACE (self)->parse_arguments (self, args, args_length1, error);
}


gboolean tool_run (Tool* self, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return TOOL_GET_INTERFACE (self)->run (self, error);
}


static void tool_base_init (ToolIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType tool_get_type (void) {
	static volatile gsize tool_type_id__volatile = 0;
	if (g_once_init_enter (&tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ToolIface), (GBaseInitFunc) tool_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tool_type_id;
		tool_type_id = g_type_register_static (G_TYPE_INTERFACE, "Tool", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tool_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&tool_type_id__volatile, tool_type_id);
	}
	return tool_type_id__volatile;
}


static gboolean decoder_tool_real_parse_arguments (Tool* base, gchar** args, int args_length1, GError** error) {
	DecoderTool * self;
	gboolean result = FALSE;
	GOptionContext* o = NULL;
	GOptionContext* _tmp0_;
	GOptionGroup* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DecoderTool*) base;
	_tmp0_ = g_option_context_new (_ ("- run decoder on the command line"));
	o = _tmp0_;
	g_option_context_add_main_entries (o, decoder_entries, "libkkc");
	_tmp1_ = model_group;
	model_group = NULL;
	g_option_context_add_group (o, _tmp1_);
	_tmp3_ = g_option_context_parse (o, &args_length1, &args, &_inner_error_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_option_context_free0 (o);
		return _tmp4_;
	}
	result = _tmp2_;
	_g_option_context_free0 (o);
	return result;
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		GString* _tmp2_;
		gint _tmp4_;
		GString* _tmp5_;
		gint _tmp6_;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = ret;
		_tmp9_ = ((GString*) _tmp8_)->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean decoder_tool_real_run (Tool* base, GError** error) {
	DecoderTool * self;
	gboolean result = FALSE;
	KkcLanguageModel* model = NULL;
	KkcDecoder* decoder = NULL;
	KkcLanguageModel* _tmp12_;
	KkcDecoder* _tmp13_;
	FILE* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (DecoderTool*) base;
	{
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_;
		gchar* name = NULL;
		gchar* _tmp3_;
		KkcLanguageModel* _tmp4_ = NULL;
		const gchar* _tmp5_;
		KkcLanguageModel* _tmp6_;
		KkcLanguageModel* _tmp7_;
		_tmp1_ = opt_model;
		if (_tmp1_ == NULL) {
			_tmp0_ = "sorted3";
		} else {
			const gchar* _tmp2_;
			_tmp2_ = opt_model;
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = g_strdup (_tmp0_);
		name = _tmp3_;
		_tmp5_ = name;
		_tmp6_ = kkc_language_model_load (_tmp5_, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (name);
			if (_inner_error_->domain == KKC_LANGUAGE_MODEL_ERROR) {
				goto __catch3_kkc_language_model_error;
			}
			goto __finally3;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (model);
		model = _tmp7_;
		_g_object_unref0 (_tmp4_);
		_g_free0 (name);
	}
	goto __finally3;
	__catch3_kkc_language_model_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		fprintf (_tmp8_, "%s\n", _tmp10_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (model);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (model);
		return _tmp11_;
	}
	_tmp12_ = model;
	_tmp13_ = kkc_decoder_create (_tmp12_);
	decoder = _tmp13_;
	_tmp14_ = stdout;
	fprintf (_tmp14_, "%s", "Type kana sentence in the following form:\n" "SENTENCE [N-BEST [SEGMENT-BOUNDARY...]]\n");
	while (TRUE) {
		FILE* _tmp15_;
		FILE* _tmp16_;
		gchar* line = NULL;
		FILE* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gint nbest = 0;
		gchar** strv = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gchar** _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		gint strv_length1;
		gint _strv_size_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
		gint _tmp31_ = 0;
		gchar** _tmp32_;
		gint _tmp32__length1;
		gint* constraints = NULL;
		gint* _tmp34_;
		gint constraints_length1;
		gint _constraints_size_;
		KkcSegment** segments = NULL;
		KkcDecoder* _tmp46_;
		gchar** _tmp47_;
		gint _tmp47__length1;
		const gchar* _tmp48_;
		gint _tmp49_;
		gint* _tmp50_;
		gint _tmp50__length1;
		gint _tmp51_;
		KkcSegment** _tmp52_;
		gint segments_length1;
		gint _segments_size_;
		_tmp15_ = stdout;
		fprintf (_tmp15_, ">> ");
		_tmp16_ = stdout;
		fflush (_tmp16_);
		_tmp17_ = stdin;
		_tmp18_ = g_file_stream_read_line (_tmp17_);
		line = _tmp18_;
		_tmp19_ = line;
		if (_tmp19_ == NULL) {
			_g_free0 (line);
			break;
		}
		nbest = 1;
		_tmp20_ = line;
		_tmp21_ = string_strip (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, " ", 0);
		_tmp25_ = _tmp24_;
		_tmp25__length1 = _vala_array_length (_tmp23_);
		_g_free0 (_tmp22_);
		strv = _tmp25_;
		strv_length1 = _tmp25__length1;
		_strv_size_ = strv_length1;
		_tmp26_ = strv;
		_tmp26__length1 = strv_length1;
		if (_tmp26__length1 == 0) {
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (line);
			continue;
		}
		_tmp27_ = strv;
		_tmp27__length1 = strv_length1;
		if (_tmp27__length1 >= 2) {
			gchar** _tmp28_;
			gint _tmp28__length1;
			const gchar* _tmp29_;
			gint _tmp30_;
			_tmp28_ = strv;
			_tmp28__length1 = strv_length1;
			_tmp29_ = _tmp28_[1];
			_tmp30_ = atoi (_tmp29_);
			nbest = _tmp30_;
		}
		_tmp32_ = strv;
		_tmp32__length1 = strv_length1;
		if (_tmp32__length1 > 2) {
			gchar** _tmp33_;
			gint _tmp33__length1;
			_tmp33_ = strv;
			_tmp33__length1 = strv_length1;
			_tmp31_ = _tmp33__length1 - 2;
		} else {
			_tmp31_ = 0;
		}
		_tmp34_ = g_new0 (gint, _tmp31_);
		constraints = _tmp34_;
		constraints_length1 = _tmp31_;
		_constraints_size_ = constraints_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp35_ = FALSE;
				_tmp35_ = TRUE;
				while (TRUE) {
					gint _tmp37_;
					gint* _tmp38_;
					gint _tmp38__length1;
					gint* _tmp39_;
					gint _tmp39__length1;
					gint _tmp40_;
					gchar** _tmp41_;
					gint _tmp41__length1;
					gint _tmp42_;
					const gchar* _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					if (!_tmp35_) {
						gint _tmp36_;
						_tmp36_ = i;
						i = _tmp36_ + 1;
					}
					_tmp35_ = FALSE;
					_tmp37_ = i;
					_tmp38_ = constraints;
					_tmp38__length1 = constraints_length1;
					if (!(_tmp37_ < _tmp38__length1)) {
						break;
					}
					_tmp39_ = constraints;
					_tmp39__length1 = constraints_length1;
					_tmp40_ = i;
					_tmp41_ = strv;
					_tmp41__length1 = strv_length1;
					_tmp42_ = i;
					_tmp43_ = _tmp41_[2 + _tmp42_];
					_tmp44_ = atoi (_tmp43_);
					_tmp39_[_tmp40_] = _tmp44_;
					_tmp45_ = _tmp39_[_tmp40_];
				}
			}
		}
		_tmp46_ = decoder;
		_tmp47_ = strv;
		_tmp47__length1 = strv_length1;
		_tmp48_ = _tmp47_[0];
		_tmp49_ = nbest;
		_tmp50_ = constraints;
		_tmp50__length1 = constraints_length1;
		_tmp52_ = kkc_decoder_decode (_tmp46_, _tmp48_, _tmp49_, _tmp50_, _tmp50__length1, &_tmp51_);
		segments = _tmp52_;
		segments_length1 = _tmp51_;
		_segments_size_ = segments_length1;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp53_ = FALSE;
				_tmp53_ = TRUE;
				while (TRUE) {
					gint _tmp55_;
					KkcSegment** _tmp56_;
					gint _tmp56__length1;
					FILE* _tmp57_;
					gint _tmp58_;
					KkcSegment* segment = NULL;
					KkcSegment** _tmp59_;
					gint _tmp59__length1;
					gint _tmp60_;
					KkcSegment* _tmp61_;
					KkcSegment* _tmp62_;
					FILE* _tmp74_;
					if (!_tmp53_) {
						gint _tmp54_;
						_tmp54_ = index;
						index = _tmp54_ + 1;
					}
					_tmp53_ = FALSE;
					_tmp55_ = index;
					_tmp56_ = segments;
					_tmp56__length1 = segments_length1;
					if (!(_tmp55_ < _tmp56__length1)) {
						break;
					}
					_tmp57_ = stdout;
					_tmp58_ = index;
					fprintf (_tmp57_, "%d: ", _tmp58_);
					_tmp59_ = segments;
					_tmp59__length1 = segments_length1;
					_tmp60_ = index;
					_tmp61_ = _tmp59_[_tmp60_];
					_tmp62_ = _g_object_ref0 (_tmp61_);
					segment = _tmp62_;
					while (TRUE) {
						KkcSegment* _tmp63_;
						FILE* _tmp64_;
						KkcSegment* _tmp65_;
						const gchar* _tmp66_;
						const gchar* _tmp67_;
						KkcSegment* _tmp68_;
						const gchar* _tmp69_;
						const gchar* _tmp70_;
						KkcSegment* _tmp71_;
						KkcSegment* _tmp72_;
						KkcSegment* _tmp73_;
						_tmp63_ = segment;
						if (!(_tmp63_ != NULL)) {
							break;
						}
						_tmp64_ = stdout;
						_tmp65_ = segment;
						_tmp66_ = kkc_segment_get_output (_tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = segment;
						_tmp69_ = kkc_segment_get_input (_tmp68_);
						_tmp70_ = _tmp69_;
						fprintf (_tmp64_, "<%s/%s>", _tmp67_, _tmp70_);
						_tmp71_ = segment;
						_tmp72_ = _tmp71_->next;
						_tmp73_ = _g_object_ref0 (_tmp72_);
						_g_object_unref0 (segment);
						segment = _tmp73_;
					}
					_tmp74_ = stdout;
					fprintf (_tmp74_, "\n");
					_g_object_unref0 (segment);
				}
			}
		}
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_object_unref), NULL);
		constraints = (g_free (constraints), NULL);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
	result = TRUE;
	_g_object_unref0 (decoder);
	_g_object_unref0 (model);
	return result;
}


DecoderTool* decoder_tool_construct (GType object_type) {
	DecoderTool * self = NULL;
	self = (DecoderTool*) g_object_new (object_type, NULL);
	return self;
}


DecoderTool* decoder_tool_new (void) {
	return decoder_tool_construct (TYPE_DECODER_TOOL);
}


static void decoder_tool_class_init (DecoderToolClass * klass) {
	decoder_tool_parent_class = g_type_class_peek_parent (klass);
}


static void decoder_tool_tool_interface_init (ToolIface * iface) {
	decoder_tool_tool_parent_iface = g_type_interface_peek_parent (iface);
	iface->parse_arguments = (gboolean (*) (Tool *, gchar**, int, GError**)) decoder_tool_real_parse_arguments;
	iface->run = (gboolean (*) (Tool *, GError**)) decoder_tool_real_run;
}


static void decoder_tool_instance_init (DecoderTool * self) {
}


GType decoder_tool_get_type (void) {
	static volatile gsize decoder_tool_type_id__volatile = 0;
	if (g_once_init_enter (&decoder_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DecoderToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decoder_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecoderTool), 0, (GInstanceInitFunc) decoder_tool_instance_init, NULL };
		static const GInterfaceInfo tool_info = { (GInterfaceInitFunc) decoder_tool_tool_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType decoder_tool_type_id;
		decoder_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "DecoderTool", &g_define_type_info, 0);
		g_type_add_interface_static (decoder_tool_type_id, TYPE_TOOL, &tool_info);
		g_once_init_leave (&decoder_tool_type_id__volatile, decoder_tool_type_id);
	}
	return decoder_tool_type_id__volatile;
}


static gboolean context_tool_real_parse_arguments (Tool* base, gchar** args, int args_length1, GError** error) {
	ContextTool * self;
	gboolean result = FALSE;
	GOptionContext* o = NULL;
	GOptionContext* _tmp0_;
	GOptionGroup* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	self = (ContextTool*) base;
	_tmp0_ = g_option_context_new (_ ("- run context on the command line"));
	o = _tmp0_;
	g_option_context_add_main_entries (o, context_entries, "libkkc");
	_tmp1_ = model_group;
	model_group = NULL;
	g_option_context_add_group (o, _tmp1_);
	_tmp3_ = g_option_context_parse (o, &args_length1, &args, &_inner_error_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_option_context_free0 (o);
		return _tmp4_;
	}
	result = _tmp2_;
	_g_option_context_free0 (o);
	return result;
}


static gboolean context_tool_real_run (Tool* base, GError** error) {
	ContextTool * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	KkcLanguageModel* model = NULL;
	KkcContext* context = NULL;
	KkcLanguageModel* _tmp27_;
	KkcContext* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp41_;
	const gchar* _tmp54_;
	FILE* _tmp66_;
	GError * _inner_error_ = NULL;
	self = (ContextTool*) base;
	_tmp0_ = opt_typing_rule;
	if (g_strcmp0 (_tmp0_, "?") == 0) {
		KkcRuleMetadata** rules = NULL;
		gint _tmp1_;
		KkcRuleMetadata** _tmp2_;
		gint rules_length1;
		gint _rules_size_;
		KkcRuleMetadata** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = kkc_rule_list (&_tmp1_);
		rules = _tmp2_;
		rules_length1 = _tmp1_;
		_rules_size_ = rules_length1;
		_tmp3_ = rules;
		_tmp3__length1 = rules_length1;
		{
			KkcRuleMetadata** rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp3_;
			rule_collection_length1 = _tmp3__length1;
			for (rule_it = 0; rule_it < _tmp3__length1; rule_it = rule_it + 1) {
				KkcRuleMetadata* _tmp4_;
				KkcRuleMetadata* rule = NULL;
				_tmp4_ = _g_object_ref0 (rule_collection[rule_it]);
				rule = _tmp4_;
				{
					FILE* _tmp5_;
					KkcRuleMetadata* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					KkcRuleMetadata* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					KkcRuleMetadata* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp5_ = stdout;
					_tmp6_ = rule;
					_tmp7_ = kkc_metadata_file_get_name ((KkcMetadataFile*) _tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = rule;
					_tmp10_ = kkc_metadata_file_get_label ((KkcMetadataFile*) _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = rule;
					_tmp13_ = kkc_metadata_file_get_description ((KkcMetadataFile*) _tmp12_);
					_tmp14_ = _tmp13_;
					fprintf (_tmp5_, "%s - %s: %s\n", _tmp8_, _tmp11_, _tmp14_);
					_g_object_unref0 (rule);
				}
			}
		}
		result = TRUE;
		rules = (_vala_array_free (rules, rules_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	{
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		gchar* name = NULL;
		gchar* _tmp18_;
		KkcLanguageModel* _tmp19_ = NULL;
		const gchar* _tmp20_;
		KkcLanguageModel* _tmp21_;
		KkcLanguageModel* _tmp22_;
		_tmp16_ = opt_model;
		if (_tmp16_ == NULL) {
			_tmp15_ = "sorted3";
		} else {
			const gchar* _tmp17_;
			_tmp17_ = opt_model;
			_tmp15_ = _tmp17_;
		}
		_tmp18_ = g_strdup (_tmp15_);
		name = _tmp18_;
		_tmp20_ = name;
		_tmp21_ = kkc_language_model_load (_tmp20_, &_inner_error_);
		_tmp19_ = _tmp21_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (name);
			if (_inner_error_->domain == KKC_LANGUAGE_MODEL_ERROR) {
				goto __catch4_kkc_language_model_error;
			}
			goto __finally4;
		}
		_tmp22_ = _tmp19_;
		_tmp19_ = NULL;
		_g_object_unref0 (model);
		model = _tmp22_;
		_g_object_unref0 (_tmp19_);
		_g_free0 (name);
	}
	goto __finally4;
	__catch4_kkc_language_model_error:
	{
		GError* e = NULL;
		FILE* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		fprintf (_tmp23_, "%s\n", _tmp25_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (model);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp26_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (model);
		return _tmp26_;
	}
	_tmp27_ = model;
	_tmp28_ = kkc_context_new (_tmp27_);
	context = _tmp28_;
	_tmp29_ = opt_user_dictionary;
	if (_tmp29_ != NULL) {
		{
			KkcUserDictionary* _tmp30_ = NULL;
			const gchar* _tmp31_;
			KkcUserDictionary* _tmp32_;
			KkcContext* _tmp33_;
			KkcDictionaryList* _tmp34_;
			KkcDictionaryList* _tmp35_;
			_tmp31_ = opt_user_dictionary;
			_tmp32_ = kkc_user_dictionary_new (_tmp31_, &_inner_error_);
			_tmp30_ = _tmp32_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch5_g_error;
			}
			_tmp33_ = context;
			_tmp34_ = kkc_context_get_dictionaries (_tmp33_);
			_tmp35_ = _tmp34_;
			kkc_dictionary_list_add (_tmp35_, (KkcDictionary*) _tmp30_);
			_g_object_unref0 (_tmp30_);
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			FILE* _tmp36_;
			const gchar* _tmp37_;
			GError* _tmp38_;
			const gchar* _tmp39_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp36_ = stderr;
			_tmp37_ = opt_user_dictionary;
			_tmp38_ = e;
			_tmp39_ = _tmp38_->message;
			fprintf (_tmp36_, "can't open user dictionary %s: %s", _tmp37_, _tmp39_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return result;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp40_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return _tmp40_;
		}
	}
	_tmp41_ = opt_system_dictionary;
	if (_tmp41_ == NULL) {
		gchar* _tmp42_;
		_tmp42_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_g_free0 (opt_system_dictionary);
		opt_system_dictionary = _tmp42_;
	}
	{
		KkcSystemSegmentDictionary* _tmp43_ = NULL;
		const gchar* _tmp44_;
		KkcSystemSegmentDictionary* _tmp45_;
		KkcContext* _tmp46_;
		KkcDictionaryList* _tmp47_;
		KkcDictionaryList* _tmp48_;
		_tmp44_ = opt_system_dictionary;
		_tmp45_ = kkc_system_segment_dictionary_new (_tmp44_, "EUC-JP", &_inner_error_);
		_tmp43_ = _tmp45_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp46_ = context;
		_tmp47_ = kkc_context_get_dictionaries (_tmp46_);
		_tmp48_ = _tmp47_;
		kkc_dictionary_list_add (_tmp48_, (KkcDictionary*) _tmp43_);
		_g_object_unref0 (_tmp43_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp49_;
		const gchar* _tmp50_;
		GError* _tmp51_;
		const gchar* _tmp52_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp49_ = stderr;
		_tmp50_ = opt_system_dictionary;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		fprintf (_tmp49_, "can't open system dictionary %s: %s", _tmp50_, _tmp52_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (context);
		_g_object_unref0 (model);
		return result;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp53_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (context);
		_g_object_unref0 (model);
		return _tmp53_;
	}
	_tmp54_ = opt_typing_rule;
	if (_tmp54_ != NULL) {
		{
			KkcRuleMetadata* metadata = NULL;
			const gchar* _tmp55_;
			KkcRuleMetadata* _tmp56_;
			KkcRule* _tmp57_ = NULL;
			KkcRuleMetadata* _tmp58_;
			KkcRule* _tmp59_;
			KkcContext* _tmp60_;
			_tmp55_ = opt_typing_rule;
			_tmp56_ = kkc_rule_metadata_find (_tmp55_);
			metadata = _tmp56_;
			_tmp58_ = metadata;
			_tmp59_ = kkc_rule_new (_tmp58_, &_inner_error_);
			_tmp57_ = _tmp59_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (metadata);
				if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
					goto __catch7_kkc_rule_parse_error;
				}
				goto __finally7;
			}
			_tmp60_ = context;
			kkc_context_set_typing_rule (_tmp60_, _tmp57_);
			_g_object_unref0 (_tmp57_);
			_g_object_unref0 (metadata);
		}
		goto __finally7;
		__catch7_kkc_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp61_;
			const gchar* _tmp62_;
			GError* _tmp63_;
			const gchar* _tmp64_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp61_ = stderr;
			_tmp62_ = opt_typing_rule;
			_tmp63_ = e;
			_tmp64_ = _tmp63_->message;
			fprintf (_tmp61_, "can't load rule \"%s\": %s\n", _tmp62_, _tmp64_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return result;
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp65_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return _tmp65_;
		}
	}
	_tmp66_ = stdout;
	fprintf (_tmp66_, "Type key event sequence separated by space\n");
	while (TRUE) {
		FILE* _tmp67_;
		FILE* _tmp68_;
		gchar* line = NULL;
		FILE* _tmp69_;
		gchar* _tmp70_;
		const gchar* _tmp71_;
		KkcContext* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		KkcContext* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		_tmp67_ = stdout;
		fprintf (_tmp67_, ">> ");
		_tmp68_ = stdout;
		fflush (_tmp68_);
		_tmp69_ = stdin;
		_tmp70_ = g_file_stream_read_line (_tmp69_);
		line = _tmp70_;
		_tmp71_ = line;
		if (_tmp71_ == NULL) {
			_g_free0 (line);
			break;
		}
		{
			KkcContext* _tmp72_;
			const gchar* _tmp73_;
			_tmp72_ = context;
			_tmp73_ = line;
			kkc_context_process_key_events (_tmp72_, _tmp73_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp74_ = FALSE;
				if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
					goto __catch8_kkc_key_event_format_error;
				}
				_g_free0 (line);
				_g_object_unref0 (context);
				_g_object_unref0 (model);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp74_;
			}
		}
		goto __finally8;
		__catch8_kkc_key_event_format_error:
		{
			GError* e = NULL;
			FILE* _tmp75_;
			GError* _tmp76_;
			const gchar* _tmp77_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp75_ = stderr;
			_tmp76_ = e;
			_tmp77_ = _tmp76_->message;
			fprintf (_tmp75_, "%s\n", _tmp77_);
			_g_error_free0 (e);
			_g_free0 (line);
			continue;
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp78_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return _tmp78_;
		}
		_tmp79_ = context;
		_tmp80_ = kkc_context_get_input (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_;
		g_print ("input: %s\n", _tmp82_);
		_g_free0 (_tmp82_);
		g_print ("segments:\n");
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp83_ = FALSE;
				_tmp83_ = TRUE;
				while (TRUE) {
					gint _tmp85_;
					KkcContext* _tmp86_;
					KkcSegmentList* _tmp87_;
					KkcSegmentList* _tmp88_;
					gint _tmp89_;
					gint _tmp90_;
					gint _tmp91_;
					KkcContext* _tmp92_;
					KkcSegmentList* _tmp93_;
					KkcSegmentList* _tmp94_;
					gint _tmp95_;
					KkcSegment* _tmp96_;
					KkcSegment* _tmp97_;
					const gchar* _tmp98_;
					const gchar* _tmp99_;
					gint _tmp100_;
					KkcContext* _tmp101_;
					KkcSegmentList* _tmp102_;
					KkcSegmentList* _tmp103_;
					gint _tmp104_;
					KkcSegment* _tmp105_;
					KkcSegment* _tmp106_;
					const gchar* _tmp107_;
					const gchar* _tmp108_;
					if (!_tmp83_) {
						gint _tmp84_;
						_tmp84_ = i;
						i = _tmp84_ + 1;
					}
					_tmp83_ = FALSE;
					_tmp85_ = i;
					_tmp86_ = context;
					_tmp87_ = kkc_context_get_segments (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = kkc_segment_list_get_size (_tmp88_);
					_tmp90_ = _tmp89_;
					if (!(_tmp85_ < _tmp90_)) {
						break;
					}
					_tmp91_ = i;
					_tmp92_ = context;
					_tmp93_ = kkc_context_get_segments (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = i;
					_tmp96_ = kkc_segment_list_get (_tmp94_, _tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = kkc_segment_get_input (_tmp97_);
					_tmp99_ = _tmp98_;
					g_print ("  input[%d]: %s\n", _tmp91_, _tmp99_);
					_g_object_unref0 (_tmp97_);
					_tmp100_ = i;
					_tmp101_ = context;
					_tmp102_ = kkc_context_get_segments (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = i;
					_tmp105_ = kkc_segment_list_get (_tmp103_, _tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = kkc_segment_get_output (_tmp106_);
					_tmp108_ = _tmp107_;
					g_print ("  output[%d]: %s\n", _tmp100_, _tmp108_);
					_g_object_unref0 (_tmp106_);
				}
			}
		}
		_tmp109_ = context;
		_tmp110_ = kkc_context_poll_output (_tmp109_);
		_tmp111_ = _tmp110_;
		g_print ("output: %s\n", _tmp111_);
		_g_free0 (_tmp111_);
		_g_free0 (line);
	}
	result = TRUE;
	_g_object_unref0 (context);
	_g_object_unref0 (model);
	return result;
}


ContextTool* context_tool_construct (GType object_type) {
	ContextTool * self = NULL;
	self = (ContextTool*) g_object_new (object_type, NULL);
	return self;
}


ContextTool* context_tool_new (void) {
	return context_tool_construct (TYPE_CONTEXT_TOOL);
}


static void context_tool_class_init (ContextToolClass * klass) {
	context_tool_parent_class = g_type_class_peek_parent (klass);
}


static void context_tool_tool_interface_init (ToolIface * iface) {
	context_tool_tool_parent_iface = g_type_interface_peek_parent (iface);
	iface->parse_arguments = (gboolean (*) (Tool *, gchar**, int, GError**)) context_tool_real_parse_arguments;
	iface->run = (gboolean (*) (Tool *, GError**)) context_tool_real_run;
}


static void context_tool_instance_init (ContextTool * self) {
}


GType context_tool_get_type (void) {
	static volatile gsize context_tool_type_id__volatile = 0;
	if (g_once_init_enter (&context_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContextToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) context_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContextTool), 0, (GInstanceInitFunc) context_tool_instance_init, NULL };
		static const GInterfaceInfo tool_info = { (GInterfaceInitFunc) context_tool_tool_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType context_tool_type_id;
		context_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "ContextTool", &g_define_type_info, 0);
		g_type_add_interface_static (context_tool_type_id, TYPE_TOOL, &tool_info);
		g_once_init_leave (&context_tool_type_id__volatile, context_tool_type_id);
	}
	return context_tool_type_id__volatile;
}


static gboolean server_tool_real_parse_arguments (Tool* base, gchar** args, int args_length1, GError** error) {
	ServerTool * self;
	gboolean result = FALSE;
	GOptionContext* o = NULL;
	GOptionContext* _tmp0_;
	GOptionGroup* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	self = (ServerTool*) base;
	_tmp0_ = g_option_context_new (_ ("- run server on the command line"));
	o = _tmp0_;
	g_option_context_add_main_entries (o, context_entries, "libkkc");
	_tmp1_ = model_group;
	model_group = NULL;
	g_option_context_add_group (o, _tmp1_);
	_tmp3_ = g_option_context_parse (o, &args_length1, &args, &_inner_error_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_option_context_free0 (o);
		return _tmp4_;
	}
	result = _tmp2_;
	_g_option_context_free0 (o);
	return result;
}


static gboolean server_tool_real_run (Tool* base, GError** error) {
	ServerTool * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	KkcLanguageModel* model = NULL;
	KkcDictionaryList* dictionaries = NULL;
	KkcDictionaryList* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp38_;
	KkcRule* typing_rule = NULL;
	const gchar* _tmp49_;
	GDBusConnection* connection = NULL;
	GDBusConnection* _tmp61_;
	KkcDBusServer* server = NULL;
	GDBusConnection* _tmp63_;
	KkcLanguageModel* _tmp64_;
	KkcDictionaryList* _tmp65_;
	KkcRule* _tmp66_;
	KkcDBusServer* _tmp67_;
	GMainLoop* loop = NULL;
	GMainLoop* _tmp68_;
	GMainLoop* _tmp69_;
	GError * _inner_error_ = NULL;
	self = (ServerTool*) base;
	_tmp0_ = opt_typing_rule;
	if (g_strcmp0 (_tmp0_, "?") == 0) {
		KkcRuleMetadata** rules = NULL;
		gint _tmp1_;
		KkcRuleMetadata** _tmp2_;
		gint rules_length1;
		gint _rules_size_;
		KkcRuleMetadata** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = kkc_rule_list (&_tmp1_);
		rules = _tmp2_;
		rules_length1 = _tmp1_;
		_rules_size_ = rules_length1;
		_tmp3_ = rules;
		_tmp3__length1 = rules_length1;
		{
			KkcRuleMetadata** rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp3_;
			rule_collection_length1 = _tmp3__length1;
			for (rule_it = 0; rule_it < _tmp3__length1; rule_it = rule_it + 1) {
				KkcRuleMetadata* _tmp4_;
				KkcRuleMetadata* rule = NULL;
				_tmp4_ = _g_object_ref0 (rule_collection[rule_it]);
				rule = _tmp4_;
				{
					FILE* _tmp5_;
					KkcRuleMetadata* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					KkcRuleMetadata* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					KkcRuleMetadata* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp5_ = stdout;
					_tmp6_ = rule;
					_tmp7_ = kkc_metadata_file_get_name ((KkcMetadataFile*) _tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = rule;
					_tmp10_ = kkc_metadata_file_get_label ((KkcMetadataFile*) _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = rule;
					_tmp13_ = kkc_metadata_file_get_description ((KkcMetadataFile*) _tmp12_);
					_tmp14_ = _tmp13_;
					fprintf (_tmp5_, "%s - %s: %s\n", _tmp8_, _tmp11_, _tmp14_);
					_g_object_unref0 (rule);
				}
			}
		}
		result = TRUE;
		rules = (_vala_array_free (rules, rules_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	{
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		gchar* name = NULL;
		gchar* _tmp18_;
		KkcLanguageModel* _tmp19_ = NULL;
		const gchar* _tmp20_;
		KkcLanguageModel* _tmp21_;
		KkcLanguageModel* _tmp22_;
		_tmp16_ = opt_model;
		if (_tmp16_ == NULL) {
			_tmp15_ = "sorted3";
		} else {
			const gchar* _tmp17_;
			_tmp17_ = opt_model;
			_tmp15_ = _tmp17_;
		}
		_tmp18_ = g_strdup (_tmp15_);
		name = _tmp18_;
		_tmp20_ = name;
		_tmp21_ = kkc_language_model_load (_tmp20_, &_inner_error_);
		_tmp19_ = _tmp21_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (name);
			if (_inner_error_->domain == KKC_LANGUAGE_MODEL_ERROR) {
				goto __catch9_kkc_language_model_error;
			}
			goto __finally9;
		}
		_tmp22_ = _tmp19_;
		_tmp19_ = NULL;
		_g_object_unref0 (model);
		model = _tmp22_;
		_g_object_unref0 (_tmp19_);
		_g_free0 (name);
	}
	goto __finally9;
	__catch9_kkc_language_model_error:
	{
		GError* e = NULL;
		FILE* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		fprintf (_tmp23_, "%s\n", _tmp25_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (model);
		return result;
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp26_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (model);
		return _tmp26_;
	}
	_tmp27_ = kkc_dictionary_list_new ();
	dictionaries = _tmp27_;
	_tmp28_ = opt_user_dictionary;
	if (_tmp28_ != NULL) {
		{
			KkcUserDictionary* _tmp29_ = NULL;
			const gchar* _tmp30_;
			KkcUserDictionary* _tmp31_;
			KkcDictionaryList* _tmp32_;
			_tmp30_ = opt_user_dictionary;
			_tmp31_ = kkc_user_dictionary_new (_tmp30_, &_inner_error_);
			_tmp29_ = _tmp31_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch10_g_error;
			}
			_tmp32_ = dictionaries;
			kkc_dictionary_list_add (_tmp32_, (KkcDictionary*) _tmp29_);
			_g_object_unref0 (_tmp29_);
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			FILE* _tmp33_;
			const gchar* _tmp34_;
			GError* _tmp35_;
			const gchar* _tmp36_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp33_ = stderr;
			_tmp34_ = opt_user_dictionary;
			_tmp35_ = e;
			_tmp36_ = _tmp35_->message;
			fprintf (_tmp33_, "can't open user dictionary %s: %s", _tmp34_, _tmp36_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_object_unref0 (model);
			return result;
		}
		__finally10:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp37_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (dictionaries);
			_g_object_unref0 (model);
			return _tmp37_;
		}
	}
	_tmp38_ = opt_system_dictionary;
	if (_tmp38_ == NULL) {
		gchar* _tmp39_;
		_tmp39_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_g_free0 (opt_system_dictionary);
		opt_system_dictionary = _tmp39_;
	}
	{
		KkcSystemSegmentDictionary* _tmp40_ = NULL;
		const gchar* _tmp41_;
		KkcSystemSegmentDictionary* _tmp42_;
		KkcDictionaryList* _tmp43_;
		_tmp41_ = opt_system_dictionary;
		_tmp42_ = kkc_system_segment_dictionary_new (_tmp41_, "EUC-JP", &_inner_error_);
		_tmp40_ = _tmp42_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp43_ = dictionaries;
		kkc_dictionary_list_add (_tmp43_, (KkcDictionary*) _tmp40_);
		_g_object_unref0 (_tmp40_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp44_;
		const gchar* _tmp45_;
		GError* _tmp46_;
		const gchar* _tmp47_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp44_ = stderr;
		_tmp45_ = opt_system_dictionary;
		_tmp46_ = e;
		_tmp47_ = _tmp46_->message;
		fprintf (_tmp44_, "can't open system dictionary %s: %s", _tmp45_, _tmp47_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (dictionaries);
		_g_object_unref0 (model);
		return result;
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp48_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dictionaries);
		_g_object_unref0 (model);
		return _tmp48_;
	}
	typing_rule = NULL;
	_tmp49_ = opt_typing_rule;
	if (_tmp49_ != NULL) {
		{
			KkcRuleMetadata* metadata = NULL;
			const gchar* _tmp50_;
			KkcRuleMetadata* _tmp51_;
			KkcRule* _tmp52_ = NULL;
			KkcRuleMetadata* _tmp53_;
			KkcRule* _tmp54_;
			KkcRule* _tmp55_;
			_tmp50_ = opt_typing_rule;
			_tmp51_ = kkc_rule_metadata_find (_tmp50_);
			metadata = _tmp51_;
			_tmp53_ = metadata;
			_tmp54_ = kkc_rule_new (_tmp53_, &_inner_error_);
			_tmp52_ = _tmp54_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (metadata);
				if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
					goto __catch12_kkc_rule_parse_error;
				}
				goto __finally12;
			}
			_tmp55_ = _tmp52_;
			_tmp52_ = NULL;
			_g_object_unref0 (typing_rule);
			typing_rule = _tmp55_;
			_g_object_unref0 (_tmp52_);
			_g_object_unref0 (metadata);
		}
		goto __finally12;
		__catch12_kkc_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp56_;
			const gchar* _tmp57_;
			GError* _tmp58_;
			const gchar* _tmp59_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp56_ = stderr;
			_tmp57_ = opt_typing_rule;
			_tmp58_ = e;
			_tmp59_ = _tmp58_->message;
			fprintf (_tmp56_, "can't load rule \"%s\": %s\n", _tmp57_, _tmp59_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (typing_rule);
			_g_object_unref0 (dictionaries);
			_g_object_unref0 (model);
			return result;
		}
		__finally12:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp60_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (typing_rule);
			_g_object_unref0 (dictionaries);
			_g_object_unref0 (model);
			return _tmp60_;
		}
	}
	_tmp61_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	connection = _tmp61_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp62_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (typing_rule);
		_g_object_unref0 (dictionaries);
		_g_object_unref0 (model);
		return _tmp62_;
	}
	_tmp63_ = connection;
	_tmp64_ = model;
	_tmp65_ = dictionaries;
	_tmp66_ = typing_rule;
	_tmp67_ = kkc_dbus_server_new (_tmp63_, _tmp64_, _tmp65_, _tmp66_);
	server = _tmp67_;
	_tmp68_ = g_main_loop_new (NULL, TRUE);
	loop = _tmp68_;
	_tmp69_ = loop;
	g_main_loop_run (_tmp69_);
	result = TRUE;
	_g_main_loop_unref0 (loop);
	_g_object_unref0 (server);
	_g_object_unref0 (connection);
	_g_object_unref0 (typing_rule);
	_g_object_unref0 (dictionaries);
	_g_object_unref0 (model);
	return result;
}


ServerTool* server_tool_construct (GType object_type) {
	ServerTool * self = NULL;
	self = (ServerTool*) g_object_new (object_type, NULL);
	return self;
}


ServerTool* server_tool_new (void) {
	return server_tool_construct (TYPE_SERVER_TOOL);
}


static void server_tool_class_init (ServerToolClass * klass) {
	server_tool_parent_class = g_type_class_peek_parent (klass);
}


static void server_tool_tool_interface_init (ToolIface * iface) {
	server_tool_tool_parent_iface = g_type_interface_peek_parent (iface);
	iface->parse_arguments = (gboolean (*) (Tool *, gchar**, int, GError**)) server_tool_real_parse_arguments;
	iface->run = (gboolean (*) (Tool *, GError**)) server_tool_real_run;
}


static void server_tool_instance_init (ServerTool * self) {
}


GType server_tool_get_type (void) {
	static volatile gsize server_tool_type_id__volatile = 0;
	if (g_once_init_enter (&server_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ServerToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) server_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ServerTool), 0, (GInstanceInitFunc) server_tool_instance_init, NULL };
		static const GInterfaceInfo tool_info = { (GInterfaceInitFunc) server_tool_tool_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType server_tool_type_id;
		server_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "ServerTool", &g_define_type_info, 0);
		g_type_add_interface_static (server_tool_type_id, TYPE_TOOL, &tool_info);
		g_once_init_leave (&server_tool_type_id__volatile, server_tool_type_id);
	}
	return server_tool_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



