<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mpm_common - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Apache MPM : Directives Communes</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../de/mod/mpm_common.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/mpm_common.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mpm_common.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mpm_common.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../tr/mod/mpm_common.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Vrifiez la version
            anglaise pour les changements rcents.</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Une srie de directives implmentes par plusieurs
modules multi-processus (MPM)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>MPM</td></tr></table>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#coredumpdirectory">CoreDumpDirectory</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#enableexceptionhook">EnableExceptionHook</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#gracefulshutdowntimeout">GracefulShutdownTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#listen">Listen</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#listenbacklog">ListenBackLog</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#listencoresbucketsratio">ListenCoresBucketsRatio</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxconnectionsperchild">MaxConnectionsPerChild</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxmemfree">MaxMemFree</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxrequestworkers">MaxRequestWorkers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxsparethreads">MaxSpareThreads</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#minsparethreads">MinSpareThreads</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#pidfile">PidFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#receivebuffersize">ReceiveBufferSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#scoreboardfile">ScoreBoardFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sendbuffersize">SendBufferSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serverlimit">ServerLimit</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#startservers">StartServers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#startthreads">StartThreads</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#threadlimit">ThreadLimit</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#threadsperchild">ThreadsPerChild</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#threadstacksize">ThreadStackSize</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mpm_common">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mpm_common">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="#comments_section">Commentaires</a></li></ul></div>

<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="coredumpdirectory" id="coredumpdirectory">Directive</a> <a name="CoreDumpDirectory" id="CoreDumpDirectory">CoreDumpDirectory</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le rpertoire dans lequel le serveur HTTP Apache va tenter de se
positionner avant d'effectuer un vidage mmoire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CoreDumpDirectory <var>rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour le rpertoire par dfaut</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code></td></tr>
</table>
    <p>Cette directive permet de dfinir le rpertoire dans lequel
    Apache httpd va tenter de se positionner avant d'effectuer un vidage
    mmoire sur disque.
    Si votre systme d'exploitation est configur pour crer des
    fichiers de vidage mmoire dans le rpertoire de travail des
    processus qui se sont crashs,
    <code class="directive">CoreDumpDirectory</code> est ncessaire pour
    dfinir un rpertoire de travail autre que le rpertoire par dfaut
    <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code>, ce rpertoire de
    travail ne devant pas tre accessible en criture par l'utilisateur sous
    lequel le serveur s'excute.</p>

    <p>Si vous avez besoin d'un vidage mmoire pour le dbogage, vous
    pouvez utiliser cette directive pour le placer  un endroit
    diffrent. Cette directive n'a aucun effet si votre systme
    d'exploitation n'est pas configur pour crer des
    fichiers de vidage mmoire dans le rpertoire de travail des
    processus qui se sont crashs.</p>

    <div class="note"><h3>Vidages mmoire sous Linux</h3>
      <p>Si Apache httpd est dmarr sous l'utilisateur root puis bascule vers
      un autre utilisateur, le noyau Linux <em>dsactive</em> les
      vidages mmoire, mme si le rpertoire est accessible en criture au
      processus. Apache httpd (versions 2.0.46 et suprieures) ractive les
      vidages mmoire sous Linux 2.4 et au del, mais seulement si vous
      dfinissez une directive <code class="directive">CoreDumpDirectory</code>.</p>
    </div>

    <div class="note">
    <h3>Vidages mmoire sous BSD</h3>
    <p>Pour activer le vidage mmoire des excutables suid sur les
    systmes de style BSD (comme FreeBSD), dfinissez
    <code>kern.sugid_coredump</code>  1.
    </p>
    </div>

    <div class="note"><h3>Signaux spcifiques</h3>
      <p><code class="directive">CoreDumpDirectory</code> n'est trait qu' la
      reception d'un certain nombre de signaux , SIGFPE, SIGILL, SIGABORT,
      SIGSEGV, et SIGBUS.</p>
      <p>
      Sur certains systmes d'exploitation, SIGQUIT provoque aussi un
      vidage mmoire, mais n'est pas trait par les directives
      <code class="directive">CoreDumpDirectory</code> ou
      <code class="directive">EnableExceptionHook</code>, si bien que la
      dfinition du rpertoire d'enregistrement du vidage mmoire est
      entirement dvolue au systme d'exploitation.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="enableexceptionhook" id="enableexceptionhook">Directive</a> <a name="EnableExceptionHook" id="EnableExceptionHook">EnableExceptionHook</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active un hook ("point d'accrochage logiciel") qui excute des
gestionnaires d'exception aprs un crash</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>EnableExceptionHook On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>EnableExceptionHook Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code></td></tr>
</table>
    <p>Pour des raisons de scurit, cette directive n'est disponible
    que si la compilation du serveur a t configure avec l'option
    <code>--enable-exception-hook</code>. Elle permet d'activer un hook
    ("point d'accrochage logiciel")
    qui autorise certains modules externes  effectuer un branchement et
    accomplir telle ou telle action aprs le crash d'un processus
    enfant.</p>

    <p>Deux modules, <code>mod_whatkilledus</code> et
    <code>mod_backtrace</code> utilisent ce hook. Veuillez vous
    rfrer  la <a href="https://emptyhammock.com/projects/httpd/diag/">page EnableExceptionHook</a> de Jeff Trawick pour plus
    d'informations  leur sujet.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="gracefulshutdowntimeout" id="gracefulshutdowntimeout">Directive</a> <a name="GracefulShutdownTimeout" id="GracefulShutdownTimeout">GracefulShutdownTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie le dlai maximum aprs lequel le serveur va
s'arrter dans le cas d'un arrt "en douceur"</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>GracefulShutdownTimeout <var>seconds</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>GracefulShutdownTimeout 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code></td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible dans les versions 2.2 et suprieures</td></tr>
</table>
    <p>La directive <code class="directive">GracefulShutdownTimeout</code>
    permet de spcifier le temps, en secondes, pendant lequel le serveur
    va continuer  fonctionner aprs avoir reu un signal
    "graceful-stop" ("Arrt en douceur"), afin de terminer le traitement
    des connexions en cours.</p>

    <p>Dfinir cette valeur  zro signifie au serveur d'attendre
    jusqu' ce que toutes les requtes en cours aient t traites.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="listen" id="listen">Directive</a> <a name="Listen" id="Listen">Listen</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Les adresses IP et ports sur lesquels le serveur coute</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Listen [<var>adresse IP</var>:]<var>numro port</var>
[<var>protocole</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>L'argument <var>protocole</var> est support depuis la version
2.1.5</td></tr>
</table>
    <p>La directive <code class="directive">Listen</code> permet de signifier 
    Apache httpd de ne se mettre  l'coute que sur les adresses IP et ports spcifis ; par
    dfaut, le serveur rpond aux requtes en provenance de toutes les
    interfaces rseau. La directive <code class="directive">Listen</code> est
    dornavant requise, et si elle est absente du fichier de
    configuration, le serveur refusera de dmarrer. Ceci constitue un
    changement par rapport aux versions prcdentes d'Apache httpd.</p>

    <p>La directive <code class="directive">Listen</code> signifie au serveur de
    n'accepter les requtes entrantes que vers le port ou le couple
    adresse-port spcifi. Si seulement un port est spcifi, le serveur
    se met  l'coute sur ce port sur toutes les interfaces rseau. Si une adresse IP
    et un port sont spcifis, le serveur va se mettre  l'coute sur ce port sur
    l'interface rseau correspondant  l'adresse IP.</p>

    <p>On peut utiliser autant de directives
    <code class="directive">Listen</code> que ncessaire pour spcifier
    plusieurs adresses et/ou ports  couter. Le serveur rpondra aux
    requtes vers tous les adresses et ports spcifis.</p>

    <p>Par exemple, pour que le serveur accepte les connexions sur les
    ports 80 et 8000, utilisez :</p>

    <pre class="prettyprint lang-config">Listen 80
Listen 8000</pre>


    <p>Pour que le serveur accepte les connexions sur deux interfaces et
    ports particuliers, spcifiez :</p>

    <pre class="prettyprint lang-config">Listen 192.170.2.1:80
Listen 192.170.2.5:8000</pre>


    <p>Les adressee IPv6 doivent tre entoures de crochets, comme dans
    l'exemple suivant :</p>

    <pre class="prettyprint lang-config">Listen [2001:db8::a00:20ff:fea7:ccea]:80</pre>


    <p>L'argument optionnel <var>protocole</var> n'est pas ncessaire
    dans la plupart des configurations. S'il est absent,
    <code>https</code> est la valeur par dfaut pour le port 443 et
    <code>http</code> l'est pour tous les autres ports. L'argument
    protocole sert  dterminer quel module doit traiter une requte, et
     appliquer des optimisations spcifiques  certains protocoles 
    l'aide de la directive <code class="directive"><a href="../mod/core.html#acceptfilter">AcceptFilter</a></code>.</p>

    <p>La spcification d'un protocole n'est ncessaire que si vous
    utilisez des ports non standards. Par exemple, pour configurer un
    site en <code>https</code> sur le port 8443 :</p>

    <pre class="prettyprint lang-config">Listen 192.170.2.1:8443 https</pre>


    <div class="note"><h3>Condition d'erreur</h3>
      Plusieurs directives <code class="directive">Listen</code> pour les mmes
      adresse IP/port vont provoquer l'envoi d'un message d'erreur
      <code>Address already in use</code>.
    </div>


<h3>Voir aussi</h3>
<ul>
<li><a href="../dns-caveats.html">Problmes avec DNS</a></li>
<li><a href="../bind.html">Dfinition des adresses et ports
qu'utilise le serveur HTTP Apache</a></li>
<li><a href="http://wiki.apache.org/httpd/CouldNotBindToAddress">Autre
discussion  propos du message d'erreur <code>Address already in
use</code>, citant d'autres causes possibles.</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="listenbacklog" id="listenbacklog">Directive</a> <a name="ListenBackLog" id="ListenBackLog">ListenBackLog</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Longueur maximale de la liste d'attente des
connexions</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ListenBacklog <var>backlog</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ListenBacklog 511</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
</table>
    <p>La longueur maximale de la liste d'attente des connexions. En
    gnral, aucune modification n'est ncessaire, ni mme souhaitable ;
    cependant, sur certains systmes, il peut tre ncessaire
    d'en augmenter la valeur en cas d'attaque TCP SYN flood (envoi en
    masse de requtes SYN pour saturer le serveur). Voir le paramtre
    backlog de l'appel systme <code>listen(2)</code>.</p>

    <p>En fait, l'argument backlog sera souvent limit  une valeur
    infrieure en fonction du systme d'exploitation. Notez aussi que de
    nombreux systmes d'exploitation ne tiennent pas vraiment compte de
    la valeur spcifie pour l'argument backlog, mais s'en inspirent
    seulement (et choisissent en gnral une valeur suprieure).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="listencoresbucketsratio" id="listencoresbucketsratio">Directive</a> <a name="ListenCoresBucketsRatio" id="ListenCoresBucketsRatio">ListenCoresBucketsRatio</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rapport entre le nombre de coeurs de processeur activs et
le nombre de segments d'coute</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ListenCoresBucketsRatio <var>ratio</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ListenCoresBucketsRatio 0 (disabled)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code></td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.13 du serveur HTTP
Apache, avec un noyau supportant l'option de socket
<code>SO_REUSEPORT</code>, et distribuant uniformment les nouvelles
connexions aux sockets d'coute des processus (ou threads) qui
l'utilisent (par exemple Linux versions 3.9 et ultrieures, mais pas
l'implmentation courante de <code>SO_REUSEPORT</code> par les
plateformes de type BSD.</td></tr>
</table>
    <p>Vous pouvez utiliser la directive
    <code class="directive">ListenCoresBucketsRatio</code> pour spcifier un
    <var>ratio</var> entre le nombre de coeurs de CPU activs et le
    nombre de segments d'coute (listeners' buckets) souhaits ; le
    serveur HTTP Apache va alors crer<code>num_cpu_cores / ratio</code>
    segments d'coute, chacun contenant son propre socket d'coute
    <code class="directive">Listen</code> sur le ou les mmes ports ; chaque
    processus enfant sera associ  un seul segment d'coute (avec une
    distribution de type round-robin des segments  la cration des
    processus enfants).</p>

    <div class="note"><h3>Dfinition du terme coeur de CPU activ ("online")</h3>
    <p>Sous Linux et BSD, un coeur de CPU peut tre activ ou dsactiv si <a href="https://www.kernel.org/doc/Documentation/cpu-hotplug.txt">Hotplug</a>
    a t configur ; la directive
    <code class="directive">ListenCoresBucketsRatio</code> doit donc tenir compte de ce
    paramtre pour calculer le nombre de segments d'coute  crer.</p>
    </div>

    <p>La directive <code class="directive">ListenCoresBucketsRatio</code> peut
    amliorer le support de la monte en charge lorsque l'arrive de
    nouvelles connexions est/devient un goulot d'tranglement. Le test
    de cette fonctionnalit avec des machines possdant un nombre de
    coeurs de CPU important a permit de constater une amlioration des
    performances significative et des temps de rponse plus courts.</p>

    <p>Pour que cette fonctionnalit soit active, le nombre de coeurs
    de CPU doit tre gal au moins au double du <var>ratio</var>
    spcifi. Si vous spcifiez la valeur recommande pour
    <var>ratio</var>,  savoir <code>8</code>, le nombre minimum de
    coeurs de processeurs disponibles sera alors de <code>16</code>. La valeur
    optimale de <var>ratio</var> permettant d'obtenir des performances maximales
    doit tre calcule pour chaque systme cible, en testant plusieurs valeurs
    et en observant les rsultats.</p>

    <p>Cette directive influence le calcul des valeurs limites infrieures de
    <code class="directive"><a href="#minsparethreads">MinSpareThreads</a></code> et <code class="directive"><a href="#maxsparethreads">MaxSpareThreads</a></code>. En effet, pour accepter les
    connexions de manire optimale, le nombre de processus enfants doit tre un
    multiple du nombre de segments d'coute.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxconnectionsperchild" id="maxconnectionsperchild">Directive</a> <a name="MaxConnectionsPerChild" id="MaxConnectionsPerChild">MaxConnectionsPerChild</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le nombre de connexions qu'un processus enfant va
traiter au cours de son fonctionnement</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxConnectionsPerChild <var>number</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxConnectionsPerChild 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.9 du serveur HTTP
Apache. L'ancien nom <code>MaxRequestsPerChild</code> est encore
support.</td></tr>
</table>
    <p>La directive <code class="directive">MaxConnectionsPerChild</code> permet de
    dfinir le nombre maximum de connexions qu'un processus enfant va
    pouvoir traiter au cours de son fonctionnement. Lorsqu'il a trait
    <code class="directive">MaxConnectionsPerChild</code> connexions, le processus
    enfant est arrt. Si <code class="directive">MaxConnectionsPerChild</code> est
    dfinie  <code>0</code>, il n'y a plus aucune limite sur le nombre
    de connexions que le processus pourra traiter.</p>

    <p>Dfinir <code class="directive">MaxConnectionsPerChild</code>  une valeur
    non nulle limite la quantit de mmoire qu'un processus peut
    consommer  cause de fuites (accidentelles) de mmoire.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxmemfree" id="maxmemfree">Directive</a> <a name="MaxMemFree" id="MaxMemFree">MaxMemFree</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Quantit maximale de mmoire que l'allocateur principal est
autoris  conserver sans appeler <code>free()</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxMemFree <var>KOctets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxMemFree 2048</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code></td></tr>
</table>
    <p>La directive <code class="directive">MaxMemFree</code> permet de dfinir
    le nombre maximum de KOctets libres que tout allocateur est
    autoris  conserver sans appeler <code>free()</code>. Dans les MPMs
    threads, chaque thread possde son propre allocateur. Si elle est
    dfinie  0, la quantit de mmoire libre que peut conserver un
    allocateur est illimite.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxrequestworkers" id="maxrequestworkers">Directive</a> <a name="MaxRequestWorkers" id="MaxRequestWorkers">MaxRequestWorkers</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximum de connexions pouvant tre traites
simultanment</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxRequestWorkers <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour plus de dtails</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code></td></tr>
</table>
    <p>La directive <code class="directive">MaxRequestWorkers</code> permet de fixer le
    nombre maximum de requtes pouvant tre traites simultanment.
    Si la limite <code class="directive">MaxRequestWorkers</code> est atteinte, toute
    tentative de connexion sera normalement mise dans une file
    d'attente, et ceci jusqu' un certain nombre dpendant de la
    directive <code class="directive"><a href="#listenbacklog">ListenBacklog</a></code>.
    Lorsqu'un processus enfant se librera suite  la fin du traitement
    d'une requte, la connexion en attente pourra tre traite  son
    tour.</p>

    <p>Pour les serveurs non threads (<em>c'est  dire</em> utilisant
    <code class="module"><a href="../mod/prefork.html">prefork</a></code>), la directive
    <code class="directive">MaxRequestWorkers</code> dfinit alors le nombre maximum de
    processus enfants qui pourront tre lancs simultanment pour
    traiter les requtes. La valeur par dfaut est <code>256</code> ; si
    vous l'augmentez, vous devez aussi augmenter la valeur de la
    directive <code class="directive"><a href="#serverlimit">ServerLimit</a></code>.</p>

    <p>Pour les serveur threads et hybrides (utilisant <em>par
    exemple</em> <code class="module"><a href="../mod/event.html">event</a></code> ou <code class="module"><a href="../mod/worker.html">worker</a></code>),
    <code class="directive">MaxRequestWorkers</code> dfinit alors le nombre total de
    threads qui seront disponibles pour servir les clients. Dans le
    cas des MPMs hybrides, la valeur par dfaut est <code>16</code>
    (directive <code class="directive"><a href="#serverlimit">ServerLimit</a></code>) multipli par la valeur
    <code>25</code> (directive <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code>). Par consquent, pour affecter  la
    directive <code class="directive">MaxRequestWorkers</code> une valeur qui requiert
    plus de 16 processus, vous devez aussi augmenter la valeur de la
    directive <code class="directive"><a href="#serverlimit">ServerLimit</a></code>.</p>

    <p>Le nom de la directive <code class="directive">MaxRequestWorkers</code>
    tait <code class="directive">MaxClients</code> avant la version 2.3.13. Cet
    ancien nom est encore support.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxsparethreads" id="maxsparethreads">Directive</a> <a name="MaxSpareThreads" id="MaxSpareThreads">MaxSpareThreads</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximum de threads inactifs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxSpareThreads <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour plus de dtails</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
</table>
    <p>C'est le nombre maximum de threads inactifs. Les MPMs utilisent
    cette directive de diffrentes manires.</p>

    <p>Pour <code class="module"><a href="../mod/worker.html">worker</a></code> et <code class="module"><a href="../mod/event.html">event</a></code>, la dfinition par dfaut est
    <code>MaxSpareThreads 250</code>. Ce MPM gre les threads inactifs
    au niveau du serveur. Si le serveur possde trop de threads
    inactifs, des processus enfants seront arrts jusqu' ce que le
    nombre de threads inactifs repasse en dessous de cette limite. Des
    processus/threads supplmentaires sont susceptibles d'tre crs si
    <code class="directive"><a href="#listencoresbucketsratio">ListenCoresBucketsRatio</a></code> est
    active.</p>

    <p>Pour <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, la dfinition par dfaut est
    <code>MaxSpareThreads 100</code>. Comme ce MPM n'excute qu'un seul
    processus, le nombre de processus inactifs est surveill au
    niveau du serveur.</p>

    <p><code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code> fonctionne de manire similaire 
    <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>. Pour <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code>, la
    valeur par dfaut est <code>10</code>.</p>

    <div class="note"><h3>Contraintes</h3>
      <p>La gamme de valeurs pour <code class="directive">MaxSpareThreads</code>
      est limite. Apache httpd corrigera automatiquement cette valeur selon
      les rgles suivantes :</p>
      <ul>
        <li>Avec <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="directive">MaxSpareThreads</code> doit tre suprieure  <code class="directive"><a href="#minsparethreads">MinSpareThreads</a></code>.</li>

        <li>Avec
	<code class="module"><a href="../mod/worker.html">worker</a></code> et <code class="module"><a href="../mod/event.html">event</a></code>, <code class="directive">MaxSpareThreads</code>
	doit tre suprieure ou gale  la somme de <code class="directive"><a href="#minsparethreads">MinSpareThreads</a></code> et <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code>.</li>
      </ul>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#minsparethreads">MinSpareThreads</a></code></li>
<li><code class="directive"><a href="#startservers">StartServers</a></code></li>
<li><code class="directive"><a href="../mod/prefork.html#maxspareservers">MaxSpareServers</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="minsparethreads" id="minsparethreads">Directive</a> <a name="MinSpareThreads" id="MinSpareThreads">MinSpareThreads</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre minimum de threads inactifs qui seront disponibles
pour pouvoir traiter les pics de requtes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MinSpareThreads <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour plus de dtails</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
</table>
    <p>C'est le nombre minimum de threads inactifs pour tre en mesure
    de traiter les pics de requtes. Les MPMs utilisent cette directive
    de diffrentes manires.</p>

    <p>Avec <code class="module"><a href="../mod/worker.html">worker</a></code> et <code class="module"><a href="../mod/event.html">event</a></code>, la dfinition par dfaut est
    <code>MinSpareThreads 75</code>, et le nombre de threads inactifs
    est surveill au niveau du serveur. Si le serveur ne possde pas
    assez de threads inactifs, des processus enfants sont crs jusqu'
    ce que le nombre de threads inactifs repasse au dessus de
    <var>nombre</var>. Des processus/threads supplmentaires peuvent
    tre crs si <code class="directive"><a href="#listencoresbucketsratio">ListenCoresBucketsRatio</a></code> est active.</p>

    <p>Avec <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, la dfinition par dfaut est
    <code>MinSpareThreads 10</code> et, comme ce MPM n'excute qu'un
    seul processus, le nombre de threads est surveill au niveau du
    serveur.</p>

    <p><code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code> fonctionne de manire similaire 
    <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>. Pour <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code>, la
    valeur par dfaut est <code>5</code>.</p>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#maxsparethreads">MaxSpareThreads</a></code></li>
<li><code class="directive"><a href="#startservers">StartServers</a></code></li>
<li><code class="directive"><a href="../mod/prefork.html#minspareservers">MinSpareServers</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="pidfile" id="pidfile">Directive</a> <a name="PidFile" id="PidFile">PidFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ficher dans lequel le serveur enregistre l'identificateur
de processus du dmon</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>PidFile <var>nom fichier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>PidFile logs/httpd.pid</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
</table>
    <p>La directive <code class="directive">PidFile</code> permet de dfinir le
    ficher dans lequel le serveur
    enregistre l'identificateur de processus du dmon. Si le chemin du
    fichier n'est pas absolu, il est considr comme relatif au chemin
    dfini par la directive <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">PidFile /var/run/apache.pid</pre>
</div>

    <p>Il est souvent utile de pouvoir envoyer un signal au
    serveur afin qu'il ferme et ouvre  nouveau ses journaux
    d'<code class="directive"><a href="../mod/core.html#erreur">erreur</a></code> et de <code class="directive"><a href="../mod/mod_log_config.html#transfert">transfert</a></code>, et recharge son
    fichier de configuration. Pour ce faire, on envoie un signal SIGHUP
    (kill -1)  l'identificateur de processus enregistr dans le fichier
    dfini par la directive <code class="directive">PidFile</code>.</p>

    <p>La directive <code class="directive">PidFile</code> fait l'objet des
    mmes avertissements que ceux concernant le chemin d'enregistrement
    des fichiers journaux et la <a href="../misc/security_tips.html#serverroot">scurit</a>.</p>

    <div class="note"><h3>Note</h3>
      <p>Depuis la version 2 du serveur HTTP Apache, nous recommandons de n'utiliser
      que le script <code class="program"><a href="../programs/apachectl.html">apachectl</a></code>, ou le script de
      dmarrage fourni avec votre systme d'exploitation pour (re)dmarrer ou
      arrter le serveur.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="receivebuffersize" id="receivebuffersize">Directive</a> <a name="ReceiveBufferSize" id="ReceiveBufferSize">ReceiveBufferSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille du tampon TCP en entre</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ReceiveBufferSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ReceiveBufferSize 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
</table>
    <p>Le serveur va fixer la taille du tampon TCP en entre au
    nombre d'octets spcifi.</p>

    <p>Si la directive est dfinie  <code>0</code>, le serveur va
    utiliser la valeur par dfaut adopte par le systme
    d'exploitation.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="scoreboardfile" id="scoreboardfile">Directive</a> <a name="ScoreBoardFile" id="ScoreBoardFile">ScoreBoardFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Chemin du fichier o sont stockes les donnes concernant
la coordination des processus enfants</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ScoreBoardFile <var>chemin fichier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ScoreBoardFile logs/apache_runtime_status</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code></td></tr>
</table>
    <p>Le serveur HTTP Apache utilise un tableau de bord pour la
    communication entre le processus parent et les processus enfants.
    Pour faciliter cette communication, certaines architectures
    ncessitent un fichier. En l'absence de cette directive, donc si
    aucun nom de fichier n'est spcifi, Apache httpd tentera tout
    d'abord de crer un tableau uniquement en mmoire (en utilisant la
    mmoire partage anonyme) ; et si il n'y parvient pas, il tentera de
    crer un fichier sur disque (en utilisant la mmoire partage  base
    de fichier). Si cette directive est utilise, Apache httpd crera
    systmatiquement un fichier sur disque.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">ScoreBoardFile /var/run/apache_runtime_status</pre>
</div>

    <p>Une mmoire partage sous forme de fichier est utile pour les
    applications tierces qui ncessitent un accs direct au tableau de
    bord des processus.</p>

    <p>Si vous utilisez un <code class="directive">ScoreBoardFile</code>, vous
    pourrez constater une amlioration des performances en le plaant
    sur un disque virtuel en RAM. Assurez-vous cependant de tenir compte
    des mmes avertissements que ceux concernant le chemin du fichier
    journal et la <a href="../misc/security_tips.html">scurit</a>.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../stopping.html">Arrter et redmarrer
le serveur HTTP Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sendbuffersize" id="sendbuffersize">Directive</a> <a name="SendBufferSize" id="SendBufferSize">SendBufferSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille du tampon TCP en sortie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SendBufferSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SendBufferSize 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
</table>
    <p>Dfinit la taille du tampon TCP en sortie avec le nombre
    d'octets spcifi. Ceci s'avre souvent trs utile pour augmenter les
    valeurs par dfaut standards du pass des systmes d'exploitation
    pour les transmissions  grande vitesse et haute densit (<em>c'est
     dire</em> de l'ordre de 100ms comme sur les liaisons rapides
    transcontinentales).</p>

    <p>Si la directive est dfinie  <code>0</code>, le serveur va
    utiliser la valeur par dfaut adopte par le systme
    d'exploitation.</p>

    <p>L'amlioration des performances des connexions  grande vitesse
    et  temps de latence lev, peut ncessiter
    une intervention au niveau de la configuration de votre systme
    d'exploitation.</p>

    <div class="note"><p>Sous certains systmes d'exploitation, la modification du
    comportement TCP via une augmentation de la valeur de
    <code class="directive">SendBufferSize</code> risque de ne pas tre
    perceptible, si la directive <code class="directive"><a href="../mod/core.html#enablesendfile">EnableSendfile</a></code> n'est pas dfinie  OFF.
    Cette interaction ne s'applique qu'aux fichiers statiques.</p> </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serverlimit" id="serverlimit">Directive</a> <a name="ServerLimit" id="ServerLimit">ServerLimit</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite suprieure de la dfinition du nombre de
processus</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerLimit <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour plus de dtails</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code></td></tr>
</table>
    <p>Avec le MPM <code class="module"><a href="../mod/prefork.html">prefork</a></code>, cette directive dfinit le
    nombre maximum que l'on peut affecter  la directive <code class="directive"><a href="#maxrequestworkers">MaxRequestWorkers</a></code>, et ceci pour la
    dure de vie du processus Apache httpd. Avec les
    MPMs <code class="module"><a href="../mod/worker.html">worker</a></code> et <code class="module"><a href="../mod/event.html">event</a></code>, cette directive, en combinaison avec
    <code class="directive"><a href="#threadlimit">ThreadLimit</a></code>, dfinit le
    nombre maximum que l'on peut affecter  <code class="directive"><a href="#maxrequestworkers">MaxRequestWorkers</a></code>, et ceci pour la dure de
    vie du processus Apache httpd. Au cours d'un redmarrage, vous pouvez
    modifier la valeur de la directive <code class="directive"><a href="#maxrequestworkers">MaxRequestWorkers</a></code>, alors que toute
    tentative de modification de la valeur de la directive <code class="directive"><a href="#serverlimit">ServerLimit</a></code> sera ignore.</p>

    <p>Cette directive doit tre utilise avec prcaution. Si
    <code class="directive">ServerLimit</code> est dfinie  une valeur beaucoup
    plus grande que ncessaire, de la mmoire partage supplmentaire
    sera inutilement alloue. Si  la fois
    <code class="directive">ServerLimit</code> et <code class="directive"><a href="#maxrequestworkers">MaxRequestWorkers</a></code> possdent des valeurs
    suprieures  ce que le systme peut supporter, ce dernier peut
    devenir instable ou Apache httpd peut tout simplement refuser de dmarrer.</p>

    <p>Avec les MPMs <code class="module"><a href="../mod/prefork.html">prefork</a></code> et <code class="module"><a href="../mod/event.html">event</a></code>, n'utilisez cette directive
    que si vous devez dfinir <code class="directive"><a href="#maxrequestworkers">MaxRequestWorkers</a></code>  une valeur suprieure 
    256 (valeur par dfaut). N'affectez pas  la directive <code class="directive"><a href="#serverlimit">ServerLimit</a></code> une valeur suprieure 
    celle que vous avez prvu d'affecter  la directive <code class="directive"><a href="#maxrequestworkers">MaxRequestWorkers</a></code>.</p>

    <p>Avec <code class="module"><a href="../mod/worker.html">worker</a></code>, n'utilisez cette directive que si
    la dfinition de vos directives <code class="directive"><a href="#maxrequestworkers">MaxRequestWorkers</a></code> et <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code> ncessitent plus de
    16 processus serveurs (valeur par dfaut). N'affectez pas  la
    directive <code class="directive"><a href="#serverlimit">ServerLimit</a></code> une
    valeur suprieure au nombre de processus requis pour la dfinition
    des directives <code class="directive"><a href="#maxrequestworkers">MaxRequestWorkers
    </a></code> et <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code>.</p>

    <div class="note"><h3>Note</h3>
      <p>Il existe une limite de <code>ServerLimit 20000</code> code en
      dur dans le serveur (200000 pour le MPM <code class="module"><a href="../mod/prefork.html">prefork</a></code>).
      Ceci est cens viter les effets dsastreux que pourrait provoquer
      une faute de frappe. Pour dpasser cette limite, vous devez
      modifier la valeur de MAX_SERVER_LIMIT dans le fichier source du
      mpm et recompiler le serveur.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../stopping.html">Arrter et redmarrer
le serveur HTTP Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="startservers" id="startservers">Directive</a> <a name="StartServers" id="StartServers">StartServers</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de processus enfants du serveur crs au
dmarrage</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>StartServers <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour plus de dtails</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/prefork.html">prefork</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
</table>
    <p>La directive <code class="directive">StartServers</code> permet de
    dfinir le nombre de processus enfants du serveur crs au
    dmarrage. Comme le nombre de processus est contrl dynamiquement
    en fonction de la charge (voir <code class="directive"><a href="#minsparethreads">MinSpareThreads</a></code>, <code class="directive"><a href="#maxsparethreads">MaxSpareThreads</a></code>, <code class="directive"><a href="../mod/prefork.html#minspareservers">MinSpareServers</a></code>, <code class="directive"><a href="../mod/prefork.html#maxspareservers">MaxSpareServers</a></code>), il n'est en gnral
    pas ncessaire d'ajuster ce paramtre.</p>

    <p>La valeur par dfaut diffre d'un MPM  l'autre. Pour
    <code class="module"><a href="../mod/worker.html">worker</a></code> et <code class="module"><a href="../mod/event.html">event</a></code>, la dfinition par dfaut est
    <code>StartServers 3</code> ; la valeur par dfaut est
    <code>5</code> pour <code class="module"><a href="../mod/prefork.html">prefork</a></code> et <code>2</code>
    pour <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="startthreads" id="startthreads">Directive</a> <a name="StartThreads" id="StartThreads">StartThreads</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de threads crs au dmarrage</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>StartThreads <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour plus de dtails</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code></td></tr>
</table>
    <p>C'est le nombre de threads crs au dmarrage du serveur. Comme
    le nombre de threads est contrl dynamiquement
    en fonction de la charge (voir <code class="directive"><a href="#minsparethreads">MinSpareThreads</a></code>, <code class="directive"><a href="#maxsparethreads">MaxSpareThreads</a></code>, <code class="directive"><a href="../mod/prefork.html#minspareservers">MinSpareServers</a></code>, <code class="directive"><a href="../mod/prefork.html#maxspareservers">MaxSpareServers</a></code>), il n'est en gnral
    pas ncessaire d'ajuster ce paramtre.</p>

    <p>Pour <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, la dfinition par dfaut est
    <code>StartThreads 50</code> et, comme il n'y a qu'un processus, il
    s'agit du nombre total de threads crs au dmarrage pour servir les
    requtes.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="threadlimit" id="threadlimit">Directive</a> <a name="ThreadLimit" id="ThreadLimit">ThreadLimit</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nombre de threads maximum que l'on peut dfinir par
processus enfant</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ThreadLimit <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour plus de dtails</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code></td></tr>
</table>
    <p>Cette directive permet de dfinir le nombre maximum que l'on peut
    affecter  la directive <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code> pour la dure de vie
    du processus Apache httpd. La directive  <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code> peut tre modifie
    au cours d'un redmarrage jusqu' la valeur de la directive <code class="directive"><a href="#threadlimit">ThreadLimit</a></code>, mais toute tentative
    de modification de la directive <code class="directive"><a href="#threadlimit">ThreadLimit</a></code> au cours d'un
    redmarrage sera ignore.</p>

    <p>L'utilisation de cette directive doit faire l'objet de
    prcautions particulires. Si <code class="directive">ThreadLimit</code> est
    dfinie  une valeur trs suprieure  la directive <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code>, de la mmoire
    partage supplmentaire sera inutilement alloue. Si les directives
    <code class="directive">ThreadLimit</code> et <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code> sont dfinies  des
    valeurs suprieures  ce que le systme peut supporter, ce dernier
    peut devenir instable, ou Apache httpd peut tout simplement refuser de
    dmarrer. Ne dfinissez pas cette directive  une valeur suprieure
     la valeur maximale que vous pensez affecter  la directive <code class="directive"><a href="#threadsperchild">ThreadsPerChild</a></code> pour le processus
    Apache httpd en cours d'excution.</p>

    <p>La valeur par dfaut de la directive
    <code class="directive">ThreadLimit</code> est <code>1920</code> avec
    <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, et <code>64</code> avec les autres
    MPMs.</p>

    <div class="note"><h3>Note</h3>
      <p>Il existe une limite de <code>ThreadLimit 20000</code> (ou
      <code>ThreadLimit 100000</code> avec <code class="module"><a href="../mod/event.html">event</a></code>,
      <code>ThreadLimit 15000</code> avec <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>)
      code en dur dans le serveur. Ceci est cens viter les effets
      dsastreux que pourrait provoquer une faute de frappe. Pour
      dpasser cette limite, vous devez modifier la valeur de
      MAX_THREAD_LIMIT dans le fichier source du mpm et recompiler le
      serveur.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="threadsperchild" id="threadsperchild">Directive</a> <a name="ThreadsPerChild" id="ThreadsPerChild">ThreadsPerChild</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de threads crs par chaque processus
enfant</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ThreadsPerChild <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir ci-dessous pour plus de dtails</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code></td></tr>
</table>
    <p>Cette directive permet de dfinir le nombre de threads que va
    crer chaque processus enfant. Un processus enfant cre ces threads
    au dmarrage et n'en cre plus d'autres par la suite. Si l'on
    utilise un MPM comme <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code> qui ne lance qu'un
    processus enfant, ce nombre doit tre suffisamment grand pour
    supporter la charge du serveur. Avec un MPM comme
    <code class="module"><a href="../mod/worker.html">worker</a></code> qui lance plusieurs processus enfants, c'est
    le nombre <em>total</em> de threads qui doit tre suffisamment grand
    pour supporter la charge du serveur.</p>

    <p>La valeur par dfaut de la directive
    <code class="directive">ThreadsPerChild</code> est <code>64</code> avec
    <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, et <code>25</code> avec les autres
    MPMs.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="threadstacksize" id="threadstacksize">Directive</a> <a name="ThreadStackSize" id="ThreadStackSize">ThreadStackSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La taille en octets de la pile qu'utilisent les threads qui
traitent les connexions clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ThreadStackSize <var>taille</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>65536 sous NetWare; varie en fonction des autres systmes
d'exploitation</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td><code class="module"><a href="../mod/event.html">event</a></code>, <code class="module"><a href="../mod/worker.html">worker</a></code>, <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>, <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code></td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible dans les versions 2.1 et suprieures
du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive">ThreadStackSize</code> permet de
    dfinir la taille de la pile (pour les donnes propres) qu'utilisent
    les threads qui traitent les connexions clients en faisant appel 
    des modules. Dans la plupart des cas, la valeur par dfaut de la
    taille de la pile du systme d'exploitation convient, mais il existe
    certaines situations o il peut s'avrer ncessaire de l'ajuster
    :</p>

    <ul>
      <li>Sur les plates-formes qui possdent une valeur par dfaut de
      taille de la pile relativement petite (par exemple HP-UX), Apache
      httpd peut se crasher si l'on utilise certains modules tiers qui
      possdent un quantit de donnes propres stockes relativement
      importante. Il se peut que ces mmes modules fonctionnent
      correctement sur d'autres plate-formes o la valeur par dfaut de
      la taille de la pile est suprieure. Ce type de crash peut tre
      evit en dfinissant <code class="directive">ThreadStackSize</code>  une
      valeur suprieure  la valeur par dfaut du systme
      d'exploitation. Ce type d'ajustement n'est ncessaire que si le
      fournisseur du module tiers en fait mention, ou si le diagnostic
      d'un crash d'Apache httpd indique que la taille de la pile tait trop
      petite.</li>

      <li>Sur les plates-formes o la taille par dfaut de la pile des
      threads est sensiblement suprieure  la taille ncessaire pour la
      configuration du serveur web, il est possible de disposer d'un
      plus grand nombre de threads par processus enfant si la directive
      <code class="directive">ThreadStackSize</code> est dfinie  une valeur
      infrieure  la valeur par dfaut du systme d'exploitation.
      Cependant, ce
      type d'ajustement ne doit tre effectu que dans un environnement
      de test permettant de qualifier le serveur web au maximum de ses
      possibilits, car il peut arriver, dans de rares cas, que des
      requtes ncessitent une taille de pile suprieure pour pouvoir
      tre traites. La taille minimale requise pour la pile dpend
      fortement des modules utiliss, mais toute modification dans la
      configuration du serveur web peut invalider la dfinition courante
      de la directive <code class="directive">ThreadStackSize</code>.</li>

      <li>Sous Linux, cette directive ne peut tre utilise que pour
      augmenter la valeur par defaut de la taille de la pile, car
      l'appel systme sous-jacent utilise cette valeur comme taille de pile
      <em>minimale</em>. C'est la limite logicielle (souvent leve)
      pour <code>ulimit -s</code> (8Mo si aucune limite) qui est
      utilise comme taille de pile par dfaut.</li>
    </ul>

    <div class="note">Il est recommand de ne pas rduire
    <code class="directive">ThreadStackSize</code>,  moins qu'un grand nombre
    de threads par processus enfant ne soit ncessaire. Sur certaines
    plates-formes (y compris Linux), une valeur de 128000 est dj trop
    basse et provoque des crashes avec certains modules courants.</div>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../de/mod/mpm_common.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/mpm_common.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mpm_common.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mpm_common.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../tr/mod/mpm_common.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mpm_common.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>