<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_include - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_include</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_include.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_include.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_include.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Documents html interprts par le serveur (Server Side
Includes ou SSI)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>include_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_include.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module fournit un filtre qui va traiter les fichiers avant
    de les envoyer au client. Le traitement est contrl via des
    commentaires SGML spcialement formats, aussi nomms
    <dfn>lments</dfn>. Ces lments permettent l'insertion
    conditionnelle de texte, l'inclusion d'autres fichiers ou
    programmes, ainsi que la dfinition et l'affichage de variables
    d'environnement.</p>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#enabling">Activation des SSI</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#pathinfo">PATH_INFO et SSI</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#elements">Elments disponibles</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#includevars">Variables include</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#substitution">Substitution de variable</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flowctrl">Elments de contrle d'inclusion conditionnelle</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#legacyexpr">Syntaxe des expressions hrite</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#ssiendtag">SSIEndTag</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssierrormsg">SSIErrorMsg</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssietag">SSIETag</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssilastmodified">SSILastModified</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssilegacyexprparser">SSILegacyExprParser</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssistarttag">SSIStartTag</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssitimeformat">SSITimeFormat</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssiundefinedecho">SSIUndefinedEcho</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#xbithack">XBitHack</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_include">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_include">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/core.html#options">Options</a></code></li>
<li><code class="directive"><a href="../mod/core.html#acceptpathinfo">AcceptPathInfo</a></code></li>
<li><a href="../filter.html">Les filtres</a></li>
<li><a href="../howto/ssi.html">Tutoriel SSI</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="enabling" id="enabling">Activation des SSI</a></h2>
    

    <p>Les SSI sont implments par le <a href="../filter.html">filtre</a> <code>INCLUDES</code>. Si des
    documents contenant des directives SSI possdent une extension
    .shtml, les directives suivantes indiqueront  Apache de les
    interprter et d'assigner le type MIME
    <code>text/html</code> au document obtenu :</p>

    <pre class="prettyprint lang-config">AddType text/html .shtml
AddOutputFilter INCLUDES .shtml</pre>


    <p>L'option suivante doit tre dfinie pour les rpertoires qui
    contiennent les fichiers shtml (en gnral dans une section
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>, mais
    cette option peut galement tre dfinie dans un fichier
    <code>.htaccess</code> si <code><code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code> Options</code> a t dfini pour le
    rpertoire considr) :</p>

    <pre class="prettyprint lang-config">Options +Includes</pre>


    <p>Pour des raisons de compatibilit ascendante, le <a href="../handler.html">gestionnaire</a>  <code>server-parsed</code>
    peut aussi activer le filtre INCLUDES. Ainsi, Apache va activer le
    filtre INCLUDES pour tout document de type MIME
    <code>text/x-server-parsed-html</code> ou
    <code>text/x-server-parsed-html3</code> (et le document obtenu aura
    pour type MIME <code>text/html</code>).</p>

    <p>Pour plus d'informations, voyez notre <a href="../howto/ssi.html">Tutoriel SSI</a>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="pathinfo" id="pathinfo">PATH_INFO et SSI</a></h2>
    

    <p>Les fichiers traits dans le cadre des SSI n'acceptent plus par
    dfaut les requtes avec <code>PATH_INFO</code> (les informations
    relatives au chemin en fin de requte). La directive <code class="directive"><a href="../mod/core.html#acceptpathinfo">AcceptPathInfo</a></code> permet de configurer le
    serveur de faon  ce qu'il accepte ce genre de requte.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="elements" id="elements">Elments disponibles</a></h2>
    <p>Le document est interprt comme un document HTML, avec des
    commandes spciales incluses sous forme de commentaires SGML. La
    syntaxe d'une commande est la suivante : </p>

    <div class="example"><p><code>
      &lt;!--#<var>lment</var> <var>attribut</var>=<var>valeur</var>
      <var>attribut</var>=<var>valeur</var> ... --&gt;
    </code></p></div>

    <p>Les valeurs sont souvent entoures de guillemets, mais on peut
    aussi utiliser des apostrophes (<code>'</code>) ou des apostrophes
    inverses (<code>`</code>). De nombreuses commandes n'acceptent
    qu'une seule paire attribut-valeur. Notez que le terminateur de
    commentaire (<code>--&gt;</code>) doit tre prcd d'un espace afin
    d'tre sr qu'il ne soit pas considr comme un lment de commande
    SSI. Notez aussi que le dlimiteur de dbut <code>&lt;!--#</code>
    est <em>un</em> lment de commande et ne doit donc pas contenir
    d'espace.</p>

    <p>La table suivante contient la liste des lments autoriss :</p>

    <table class="bordered">
    <tr><th>Elment</th><th>Description</th></tr>
    <tr><td><code><a href="#element.comment">comment</a></code></td>
        <td>commentaire SSI</td></tr>
    <tr><td><code><a href="#element.config">config</a></code></td>
        <td>configure les formats de sortie</td></tr>
    <tr><td><code><a href="#element.echo">echo</a></code></td>
        <td>affiche le contenu de variables</td></tr>
    <tr><td><code><a href="#element.exec">exec</a></code></td>
        <td>excute des programmes externes</td></tr>
    <tr><td><code><a href="#element.fsize">fsize</a></code></td>
        <td>affiche la taille d'un fichier</td></tr>
    <tr><td><code><a href="#element.flastmod">flastmod</a></code></td>
        <td>affiche la date de dernire modification d'un fichier</td></tr>
    <tr><td><code><a href="#element.include">include</a></code></td>
        <td>inclut un fichier</td></tr>
    <tr><td><code><a href="#element.printenv">printenv</a></code></td>
        <td>affiche toutes les variables disponibles</td></tr>
    <tr><td><code><a href="#element.set">set</a></code></td>
        <td>dfinit la valeur d'une variable</td></tr>
    </table>

    <p>Les lments SSI peuvent tre dfinis par d'autres modules que
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>.  ce titre, l'lment <code><a href="#element.exec">exec</a></code> est fourni par
    <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code>, et ne sera disponible que si ce module est
    charg.</p>

    <h3><a name="element.comment" id="element.comment">L'lment comment</a></h3>
      <p>Cette commande n'affiche aucune information. Elle n'a pour but que
      l'ajout de commentaires dans un fichier et ces commentaires ne sont pas
      affichs.</p>

      <p>Cette syntaxe est disponible  partir de la version 2.4.21 du serveur
      HTTP Apache.</p>

      <div class="example"><p><code>
      &lt;!--#comment Blah Blah Blah --&gt;
      </code></p></div>
     
    
    <h3><a name="element.config" id="element.config">L'lment config</a></h3>
      <p>Cette commande contrle divers aspects de l'interprtation. Les
      attributs valides sont :</p>

      <dl>
      <dt><code>echomsg</code> (<em>Versions 2.1 et suprieures
      d'Apache</em>)</dt>
      <dd><p>La valeur est un message qui sera envoy au client si
      l'lment <code><a href="#element.echo">echo</a></code> tente
      d'afficher le contenu d'une variable non dfinie. Cet attribut
      l'emporte sur toute directive <code class="directive"><a href="#ssiundefinedecho">SSIUndefinedEcho</a></code>.</p>

      <div class="example"><p><code>
        &lt;!--#config echomsg="[Valeur non dfinie]" --&gt;
      </code></p></div>

      </dd>

      <dt><code>errmsg</code></dt>
      <dd><p>La valeur est un message qui sera envoy au client si une
      erreur survient lors de l'interprtation du document. Cet attribut
      l'emporte sur toute directive <code class="directive"><a href="#ssierrormsg">SSIErrorMsg</a></code>.</p>

      <div class="example"><p><code>
       &lt;!--#config errmsg="[Zut, quelque chose s'est mal pass.]" --&gt;
      </code></p></div>

      </dd>

      <dt><code>sizefmt</code></dt>
      <dd><p>La valeur dfinit l'unit employe lors de l'affichage de la
      taille d'un fichier. Les valeurs possibles sont <code>bytes</code>
      pour une taille en octets, ou <code>abbrev</code> pour une taille
      en Ko ou Mo selon son importance ; par exemple, une taille de 1024
      octets sera affiche sous la forme "1K".</p>

      <div class="example"><p><code>
      &lt;!--#config sizefmt="abbrev" --&gt;
      </code></p></div>

      </dd>

      <dt><code>timefmt</code></dt>
      <dd><p>La valeur est une chane que pourra utiliser la fonction de la
      bibliothque standard <code>strftime(3)</code> lors de l'affichage
      des dates.</p>

      <div class="example"><p><code>
      &lt;!--#config timefmt=""%R, %B %d, %Y"" --&gt;
      </code></p></div>

      </dd>
      
      </dl>
     

    <h3><a name="element.echo" id="element.echo">L'lment echo</a></h3>
      <p>Cette commande affiche le contenu d'une des <a href="#includevars">variables include</a> dfinies ci-dessous. Si
      la variable n'est pas dfinie, le rsultat est dtermin par la
      valeur de la directive <code class="directive"><a href="#ssiundefinedecho">SSIUndefinedEcho</a></code>. Le format d'affichage des dates est
      dfini par l'attribut <code>timefmt</code> de la commande
      config.</p>

      <p>Attributs:</p>

      <dl>
      <dt><code>var</code></dt>
      <dd>La valeur est le nom de la variable  afficher.</dd>

      <dt><code>decoding</code></dt>
      <dd><p>Spcifie si Apache doit effectuer un dcodage dans la
      variable avant son traitement ultrieur. La valeur par dfaut est
      <code>none</code>, et dans ce cas, aucun dcodage n'est effectu.
      Si la valeur est <code>url</code>, un dcodage de type URL sera
      effectu (il s'agit du codage de type %-encoding utilis dans les
      URLs des liens, etc...). Si la valeur est <code>urlencoded</code>,
      c'est un dcodage des lments de type
      application/x-www-form-urlencode (que l'on trouve dans les chanes
      de paramtres) qui sera effectu. Si la valeur est
      <code>base64</code>, un
      decodage de type base64 sera effectu, et si elle est
      <code>entity</code>, c'est un dcodage des entits HTML qui sera
      effectu. Ce dcodage est effectu avant tout codage ultrieur de
      la variable. Il est possible d'effectuer plusieurs dcodages en
      spcifiant plusieurs valeurs spares par des virgules. Les
      spcifications de dcodages restent valables jusqu'au prochain
      attribut de dcodage, ou la fin de l'lment.</p>

      <p>Pour tre pris en compte, l'attribut de <code>dcodage</code>
      doit <em>prcder</em> l'attribut <code>var</code> correspondant.</p>
      </dd>

      <dt><code>encoding</code></dt>
      <dd><p>Spcifie la manire dont Apache va coder les caractres
      spciaux que la variable contient avant leur affichage. S'il est
      dfini  <code>none</code>, aucun codage ne sera effectu. S'il
      est dfini  <code>url</code>, un codage de type URL sera effectu
      (aussi connu sous le nom de codage avec caractres % , il convient
      pour les URLS des liens, etc...). S'il est dfini 
      <code>urlencoded</code>, c'est un codage compatible
      application/x-www-form-urlencoded qui sera effectu ( utiliser
      dans les chanes de paramtres). S'il est dfini 
      <code>base64</code>, c'est un encodage de type base64 qui sera
      effectu. Au dbut d'un lment
      <code>echo</code>, la valeur par dfaut est dfinie 
      <code>entity</code>, ce qui correspond  un codage de type entit
      (codage qui convient pour un lment HTML de type bloc, comme le
      paragraphe d'un texte). Cette valeur par dfaut peut tre modifie
      en ajoutant un attribut <code>encoding</code>, qui fera effet
      jusqu' la dfinition d'un nouvel attribut <code>encoding</code>
      ou la fin de l'lment echo.</p>

      <p>Pour produire son effet, l'attribut <code>encoding</code> doit
      prcder l'attribut <code>var</code> concern.</p>

      <div class="warning">
        Afin de prvenir les attaques de type cross-site scripting, il
	est recommand de <em>toujours</em> encoder les donnes fournies
	par les utilisateurs.
      </div>

      <div class="example"><h3>Example</h3><p><code>
        &lt;!--#echo encoding="entity" var="QUERY_STRING" --&gt;
      </code></p></div>
      </dd>
      </dl>
     

    <h3><a name="element.exec" id="element.exec">L'lment exec</a></h3>
      <p>La commande <code>exec</code> excute la commande shell ou le
      script spcifi. Elle ncessite le chargement du module
      <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code>. Si <code class="directive"><a href="../mod/core.html#options">Options</a></code> <code>IncludesNOEXEC</code> est
      dfinie, cette commande est dsactive. Les attributs disponibles
      sont :</p>

      <dl>
      <dt><code>cgi</code></dt>
      <dd><p>La valeur spcifie un chemin URL vers le script CGI (encod
      avec caractres %). Si le chemin ne commence pas par un slash (/),
      il est considr comme relatif au document courant. Le document
      rfrenc par ce chemin est invoqu en tant que script CGI, mme
      s'il n'est pas cens tre reconnu comme tel par le serveur. Les
      scripts CGI doivent cependant tre activs dans le rpertoire qui
      contient les scripts (via la directive <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code> ou l'<code class="directive"><a href="../mod/core.html#options">Options</a></code> <code>ExecCGI</code>).</p>

      <p>Le <code>PATH_INFO</code> et la chane d'arguments
      (<code>QUERY_STRING</code>) de la requte originale du client sont
      fournis au script CGI ; ils <em>ne peuvent pas</em> tre spcifis
      dans le chemin de l'URL. Le script disposera des variables include
      en plus de l'environnement standard <a href="mod_cgi.html">CGI</a>.</p>

      <div class="example"><h3>Exemple</h3><p><code>
        &lt;!--#exec cgi="/cgi-bin/exemple.cgi" --&gt;
      </code></p></div>

      <p>Si,  la place d'un flux de sortie, le script renvoie un
      en-tte <code>Location:</code>, ce dernier sera traduit en ancrage
      HTML.</p>

      <p>L'lment <code><a href="#includevirtual">include
      virtual</a></code> doit tre prfr  <code>exec cgi</code>. En
      particulier, si vous devez transmettre des arguments
      supplmentaires  un programme CGI en utilisant la chane
      d'arguments de la requte, c'est impossible avec <code>exec
      cgi</code>, mais vous pouvez y parvenir avec <code>include
      virtual</code> comme suit :</p>

      <div class="example"><p><code>
        &lt;!--#include virtual="/cgi-bin/exemple.cgi?argument=valeur" --&gt;
      </code></p></div>
      </dd>

      <dt><code>cmd</code></dt>
      <dd><p>Le serveur va excuter la commande fournie en utilisant
      <code>/bin/sh</code>. La commande dispose des <a href="#includevars">variables include</a>, en plus du jeu habituel
      de variables CGI.</p>

      <p>Il est toujours prfrable d'utiliser <code><a href="#includevirtual">#include virtual</a></code>  la place de
      <code>#exec cgi</code> ou <code>#exec cmd</code>. <code>#include
      virtual</code> utilise le mcanisme standard des sous-requtes
      d'Apache pour inclure des fichiers ou des scripts. Il a fait
      l'objet de tests plus approfondis et sa maintenance est mieux
      suivie.</p>

      <p>De plus, sur certaines plate-formes, comme Win32, et sous unix,
      si l'on utilise <a href="../suexec.html">suexec</a>, il est
      impossible de transmettre des arguments  une commande dans une
      directive <code>exec</code>,  moins d'insrer des espaces dans la
      commande. Ainsi, alors que ce qui suit fonctionnera sous unix avec
      une configuration sans suexec, l'effet produit ne sera pas celui
      dsir sous Win32, ou dans le cas de l'utilisation de suexec
      :</p>

      <div class="example"><p><code>
        &lt;!--#exec cmd="perl /chemin/vers/script_perl arg1 arg2" --&gt;
      </code></p></div>
      </dd>
      </dl>
     

    <h3><a name="element.fsize" id="element.fsize">L'lment fsize</a></h3>
      <p>Cette commande permet d'afficher la taille du fichier spcifi
      en fonction des spcifications de format de <code>sizefmt</code>.
      Attributs :</p>

      <dl>
      <dt><code>file</code></dt>
      <dd>La valeur est le chemin du fichier, relatif au rpertoire
      contenant le document en cours d'interprtation.

      <div class="example"><p><code>
        Ce fichier a une taille de &lt;!--#fsize file="mod_include.html"
	--&gt; octets.
    </code></p></div>

    La valeur de <code>file</code> ne peut pas faire rfrence  un
    fichier situ  un niveau suprieur de l'arborescence du rpertoire
    courant ou en dehors de la racine des documents ; il ne peut donc
    ni commencer par un slash, ni contenir la squence de caractres
    <code>../</code>. Si c'est le cas, le message d'erreur <code>The
    given path was above the root path</code> sera renvoy.
      </dd>

      <dt><code>virtual</code></dt>
      <dd>La valeur est un chemin URL (cod avec caractres %). S'il ne
      commence pas par un slash (/), il est considr comme relatif au
      document courant. Notez que cette commande n'affiche <em>pas</em>
      la taille de la sortie d'un programme CGI, mais la taille du
      programme CGI lui-mme.</dd>
      </dl>

      <div class="example"><p><code>
        Ce fichier a une taille de &lt;!--#fsize
	virtual="/docs/mod/mod_include.html" --&gt; octets.
    </code></p></div>

      <p>Notez que dans la plupart des cas, ces deux attributs sont
      identiques. Cependant, l'attribut <code>file</code> ne respecte
      pas les aliases URL-space.</p>
     

    <h3><a name="element.flastmod" id="element.flastmod">L'lment flastmod</a></h3>
      <p>Cette commande permet d'afficher la date de dernire
      modification du fichier spcifi, en fonction des spcifications
      de format de <code>timefmt</code>. Les attributs sont les mmes
      que ceux de la commande <code><a href="#element.fsize">fsize</a></code>.</p>
     

    <h3><a name="element.include" id="element.include">L'lment include</a></h3>
      <p>Cette commande permet d'insrer le texte d'un autre document ou
      fichier dans le fichier en cours d'interprtation. Tout fichier
      inclus est soumis au contrle d'accs habituel. Si <a href="core.html#options">Options</a> <code>IncludesNOEXEC</code>
      est dfini pour le rpertoire contenant le fichier
      interprt, seuls les documents possdant un
      <a class="glossarylink" href="../glossary.html#type mime" title="voir glossaire">type MIME</a> de type texte
      (<code>text/plain</code>, <code>text/html</code>, etc...) seront
      inclus. Les scripts CGI, quant  eux, sont invoqus de manire
      habituelle en utilisant l'URL complte fournie avec la commande, y
      compris toute chane d'arguments ventuelle.</p>

      <p>Un attribut dfinit le chemin du document  inclure, et peut
      apparatre plusieurs fois dans l'lment  inclure ; en retour, pour
      chaque attribut fourni  la commande include, une inclusion est
      effectue. Les attributs disponibles sont :</p>

      <dl>
      <dt><code>file</code></dt>
      <dd>La valeur est un chemin relatif au rpertoire contenant le
      fichier en cours d'interprtation. Elle ne peut ni contenir
      <code>../</code>, ni tre un chemin absolu. Ainsi, vous ne pouvez
      pas inclure de fichiers situs en dehors de l'arborescence du
      site web ou dans un niveau suprieur  celui du fichier courant
      dans cette arborescence. Il est toujours prfrable d'utiliser
      l'attribut <code>virtual</code>.</dd>

      <dt><code><a id="includevirtual" name="includevirtual">virtual</a></code></dt>
      <dd><p>La valeur est un chemin URL (cod avec caractres %). L'URL
      ne peut contenir qu'un chemin et une chane d'arguments
      ventuelle,  l'exclusion de tout protocole ou nom d'hte. S'il ne
      commence pas par un slash (/), il est considr comme relatif au
      document courant.</p>

      <p>Une URL est construite  partir de l'attribut, et la sortie que
      renverrait le serveur si l'URL tait accde par le client est
      incluse dans la sortie interprte. Les inclusions de fichiers
      peuvent ainsi tre imbriques.</p>

      <p>Si l'URL spcifie correspond  un programme CGI, le programme
      sera excut, et son flux de sortie insr  la place de la
      directive dans le fichier interprt. Vous pouvez insrer une
      chane d'arguments dans une URL correspond  un programme CGI
      :</p>

      <div class="example"><p><code>
        &lt;!--#include virtual="/cgi-bin/exemple.cgi?argument=valeur" --&gt;
      </code></p></div>

      <p><code>include virtual</code> doit tre prfr  <code>exec
      cgi</code> pour inclure le flux de sortie d'un programme CGI dans
      un document HTML.</p>

      <p>Si la directive <code class="directive"><a href="../mod/mod_request.html#keptbodysize">KeptBodySize</a></code> est correctement
      dfinie et valide pour le fichier inclus, les tentatives de
      requtes POST vers le document HTML qui inclut des fichiers seront
      transmises aux sous-requtes en tant que requtes POST
      elles-mmes. Sans cette directive, toutes les sous-requtes sont
      traites en tant que requtes GET.</p>

      </dd>

      <dt><code>onerror</code></dt>
      <dd><p>La valeur est un chemin-URL (cod-%) qui est affich si une
      tentative prcdente d'inclure un fichier ou un attribut virtuel a
      chou. Pour produire son effet, cet attribut doit tre spcifi
      aprs le fichier ou les attributs virtuels concerns. Si la
      tentative d'inclure le chemin onerror choue, ou si onerror n'est
      pas spcifi, c'est le message d'erreur par dfaut qui sera
      inclus.</p>

      <div class="example"><p><code>
        # Exemple simple<br />
        &lt;!--#include virtual="/not-exist.html" onerror="/error.html" --&gt;
      </code></p></div>

      <div class="example"><p><code>
        # Chemins onerror ddis<br />
        &lt;!--#include virtual="/path-a.html" onerror="/error-a.html" virtual="/path-b.html" onerror="/error-b.html" --&gt;
      </code></p></div>

      </dd>
      </dl>
     

    <h3><a name="element.printenv" id="element.printenv">L'lment printenv</a></h3>
      <p>Cette commande affiche la liste en mode texte de toutes les variables et de
      leurs valeurs. Les caractres spciaux sont encods <code>entity</code> avant
      d'tre affichs (se reporter  l'lment <code><a href="#element.echo">echo</a></code> pour plus de dtails). Cette
      commande ne comporte pas d'attributs.</p>

      <div class="example"><h3>Exemple</h3><p><code>
        &lt;pre&gt;
          &lt;!--#printenv --&gt;
        &lt;/pre&gt;
      </code></p></div>
     

    <h3><a name="element.set" id="element.set">L'lment set</a></h3>
      <p>Cette commande permet de dfinir la valeur d'une variable. Les
      attributs sont :</p>

      <dl>
      <dt><code>var</code></dt>
      <dd>Le nom de la variable  dfinir.</dd>

      <dt><code>value</code></dt>
      <dd>La valeur  affecter  la variable.</dd>
      <dt><code>decoding</code></dt>
      <dd><p>Spcifie si Apache doit effectuer un dcodage dans la
      variable avant son traitement ultrieur. La valeur par dfaut est
      <code>none</code>, et dans ce cas, aucun dcodage n'est effectu.
      Si la valeur est <code>url</code>, <code>urlencoded</code>,
      <code>base64</code> ou
      <code>entity</code>, c'est un dcodage de type URL,
      application/x-www-form-urlencoded, base64 ou
      entit HTML qui sera respectivement effectu. Il est possible
      d'effectuer plusieurs dcodages en
      spcifiant plusieurs valeurs spares par des virgules. Les
      spcifications de dcodages restent valables jusqu'au prochain
      attribut de dcodage, ou la fin de l'lment. Pour tre pris en
      compte, l'attribut de <code>dcodage</code>
      doit <em>prcder</em> l'attribut <code>var</code> correspondant.</p>
      </dd>

      <dt><code>encoding</code></dt>
      <dd><p>Spcifie la manire dont Apache va encoder les caractres
      spciaux que la variable contient avant leur affichage. S'il est
      dfini  <code>none</code>, aucun encodage ne sera effectu. Si la
      valeur est <code>url</code>, <code>urlencoding</code>,
      <code>base64</code> ou
      <code>entity</code>, c'est un encodage de type URL,
      application/x-www-form-urlencoded, base64 ou
      entit HTML qui sera respectivement effectu. Il est possible de
      spcifier plusieurs types d'encodage en les sparant par des
      virgules. La spcification du type d'encodage fera effet
      jusqu' la dfinition d'un nouvel attribut encoding
      ou la fin de l'lment. Pour produire son effet, l'attribut <code>encoding</code> doit
      prcder l'attribut <code>var</code> concern. Les encodages sont
      effectus aprs les oprations de dcodage.</p>
      </dd>

      </dl>

      <div class="example"><h3>Exemple</h3><p><code>
        &lt;!--#set var="category" value="help" --&gt;
      </code></p></div>
     
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="includevars" id="includevars">Variables include</a></h2>
    

    <p> l'instar des variables de l'environnement CGI standard, ces
    variables sont mises  la disposition de la commande
    <code>echo</code>, des oprateurs conditionnels <code>if</code> et
    <code>elif</code>, et de tout programme invoqu par le document.</p>

    <dl>
      <dt><code>DATE_GMT</code></dt>
      <dd>La date GMT (Greenwich Mean Time) courante.</dd>

      <dt><code>DATE_LOCAL</code></dt>
      <dd>La date locale courante.</dd>

      <dt><code>DOCUMENT_ARGS</code></dt>
      <dd>Cette variable contient la chane de paramtres de la requte du
      document SSI actif, ou la chane vide si aucune chane de paramtres de
      requte n'est incluse. Pour les sous-requtes invoques par la directive
      SSI <code>include</code>, <code>QUERY_STRING</code> contiendra la chane
      de paramtres de la sous-requte et <code>DOCUMENT_ARGS</code> la chane
      de paramtres du document SSI (disponible  partir de la version 2.4.19 du
      serveur HTTP Apache).</dd>

      <dt><code>DOCUMENT_NAME</code></dt>
      <dd>Le nom de base du fichier demand par l'utilisateur (sans son
      chemin).</dd>

      <dt><code>DOCUMENT_URI</code></dt>
      <dd>Le chemin URL (caractres % dcods) du document demand par
      l'utilisateur. Notez que dans le cas d'inclusions de fichiers
      imbriques, il ne s'agit <em>pas</em> de l'URL du document
      courant. Notez galement que si l'URL est modifie en interne (par
      exemple via une directive <code class="directive"><a href="../mod/mod_alias.html#alias">alias</a></code> ou <code class="directive"><a href="../mod/mod_dir.html#directoryindex">directoryindex</a></code>), c'est l'URL modifie
      que contiendra la variable.</dd>

      <dt><code>LAST_MODIFIED</code></dt>
      <dd>La date de dernire modification du document demand par
      l'utilisateur.</dd>

      <dt><code>QUERY_STRING_UNESCAPED</code></dt>
      <dd>Si une chane d'arguments est prsente dans la requte pour le
      document SSI actif, elle sera affecte 
      cette variable, les caractres %-dcods, et ventuellement
      <em>chapps</em> pour qu'ils ne soient pas interprts par le
      shell (les caractres spciaux comme <code>&amp;</code>,etc...
      sont prcds d'anti-slashes). Cette variable n'est pas dfinie si aucune
      chane d'arguments n'est prsente. Utilisez <code>DOCUMENT_ARGS</code> si
      l'chappement des caractres du shell n'est pas souhait.</dd>
    </dl>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="substitution" id="substitution">Substitution de variable</a></h2>

    <p>Une substitution de variable  l'intrieur d'une chane entre
    guillemets s'effectue dans la plupart des situations o cette
    dernire peut raisonablement constituer un argument d'une directive
    SSI. Sont concernes les directives <code>config</code>,
    <code>exec</code>, <code>flastmod</code>, <code>fsize</code>,
    <code>include</code>, <code>echo</code>, et <code>set</code>. Si la
    directive <code class="directive"><a href="#ssilegacyexprparser">SSILegacyExprParser</a></code> est dfinie 
    <code>on</code>, la substitution s'effectue aussi dans les arguments
    des oprateurs conditionnels. Vous pouvez insrer
    un signe dollar en tant que caractre littral dans une chane en
    utilisant un anti-slash :</p>

    <div class="example"><p><code>
      &lt;!--#set var="cur" value="\$test" --&gt;
    </code></p></div>

    <p>Si une rfrence de variable doit tre substitue au beau milieu
    d'une squence de caractres qui pourrait tre elle-mme considre
    comme un identifiant valide, l'ambigut peut tre leve en
    entourant la rfrence d'accolades,  la manire du shell :</p>

    <div class="example"><p><code>
      &lt;!--#set var="Zed" value="${REMOTE_HOST}_${REQUEST_METHOD}" --&gt;
    </code></p></div>

    <p>Dans cet exemple, la variable <code>Zed</code> se verra affecter
    la valeur "<code>X_Y</code>" si <code>REMOTE_HOST</code> et
    <code>REQUEST_METHOD</code> contiennent respectivement
    "<code>X</code>" et "<code>Y</code>".</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flowctrl" id="flowctrl">Elments de contrle d'inclusion conditionnelle</a></h2>
    

    <p>Les lments de base du contrle d'inclusion conditionnelle sont
    :</p>

    <div class="example"><p><code>
      &lt;!--#if expr="<var>test_condition</var>" --&gt;<br />
      &lt;!--#elif expr="<var>test_condition</var>" --&gt;<br />
      &lt;!--#else --&gt;<br />
      &lt;!--#endif --&gt;
    </code></p></div>

    <p>L'lment <code>if</code> fonctionne de la mme manire que
    la directive if d'un langage de programmation. La condition est
    value et si le rsultat est vrai, le texte qui suit jusqu'au
    prochain lment <code>elif</code>, <code>else</code> ou
    <code>endif</code> sera inclus dans le flux de sortie.</p>

    <p>Les lments <code>elif</code> ou <code>else</code> permettent
    d'insrer du texte dans le flux de sortie si
    <var>test_condition</var> s'est rvl faux. Ces lments sont
    optionnels.</p>

    <p>L'lment <code>endif</code> termine le bloc de traitement
    conditionnel <code>if</code> et est obligatoire.</p>

    <p><var>test_condition</var> est une expression boolenne qui
    emprunte la syntaxe <a href="../expr.html">ap_expr</a>. La directive
    <code class="directive"><a href="#ssilegacyexprparser">SSILegacyExprParser</a></code>
    permet de modifier cette syntaxe pour la rendre compatible avec
    Apache HTTPD 2.2.x.</p>

    <p>Le jeu de variables SSI avec l'lment <code>var</code> sont
    exportes vers l'environnement de la requte et sont accessibles via
    la fonction <code>reqenv</code>. Pour faire simple, le nom de
    fonction <code>v</code> est aussi disponible dans le module
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>.</p>

    <p>Dans l'exemple suivant, "depuis le rseau local"  sera affich si
    l'adresse IP du client appartient au sous-rseau 10.0.0.0/8.</p>

    <div class="example"><p><code>
      &lt;!--#if expr='-R "10.0.0.0/8"' --&gt;<br />
      <span class="indent">
        depuis le rseau local<br />
      </span>
      &lt;!--#else --&gt;<br />
      <span class="indent">
        depuis ailleurs<br />
      </span>
      &lt;!--#endif --&gt;
    </code></p></div>

    <p>Dans l'exemple suivant, "foo vaut bar" sera affich si la variable
    <code>foo</code> contient la valeur "bar".</p>

    <div class="example"><p><code>
      &lt;!--#if expr='v("foo") = "bar"' --&gt;<br />
      <span class="indent">
        foo vaut bar<br />
      </span>
      &lt;!--#endif --&gt;
    </code></p></div>

    <div class="note"><h3>Documentation de rfrence</h3>
    <p>Voir aussi <a href="../expr.html">Les expressions dans le serveur
    HTTP Apache</a> pour une rfrence complte et des exemples. Les
    fonctions <em>restricted</em> ne sont pas disponibles dans
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>.</p>
    </div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="legacyexpr" id="legacyexpr">Syntaxe des expressions hrite</a></h2>
    

    <p>Cette section dcrit la syntaxe de l'lment <code>#if
    expr</code> dans le cas o la directive <code class="directive"><a href="#ssilegacyexprparser">SSILegacyExprParser</a></code> est dfinie 
    <code>on</code>.</p>

    <dl>
      <dt><code><var>chane</var></code></dt>
      <dd>vrai si <var>chane</var> n'est pas vide</dd>

      <dt><code><var>-A string</var></code></dt>
      <dd><p>vrai si l'URL que contient la chane est accessible du
      point de vue de la configuration, faux sinon. Il
      s'avre utile lorsqu'un lien vers une URL doit tre cach aux
      utilisateurs qui ne sont pas autoriss  voir cette URL. Notez que
      le test porte sur l'autorisation d'accs  l'URL, et non sur son
      existence.</p>

      <div class="example"><h3>Exemple</h3><p><code>
        &lt;!--#if expr="-A /prive" --&gt;<br />
        <span class="indent">
          Cliquez &lt;a href="/prive"&gt;ici&lt;/a&gt; pour accder aux
	  informations prives.<br />
        </span>
        &lt;!--#endif --&gt;
      </code></p></div>
      </dd>

      <dt><code><var>chane1</var> = <var>chane2</var><br />
      <var>chane1</var> == <var>chane2</var><br />
      <var>chane1</var> != <var>chane2</var></code></dt>

      <dd><p>Compare <var>chane1</var>  <var>chane2</var>. Si
      <var>chane2</var> est de la forme
      <code>/<var>chane2</var>/</code>, elle est traite comme une
      expression rationnelle. Les expressions rationnelles sont
      implmentes par le moteur <a href="http://www.pcre.org">PCRE</a>
      et possdent la mme syntaxe que celles de <a href="http://www.perl.com">perl 5</a>. Notez que <code>==</code>
      n'est qu'un alias pour <code>=</code> et se comporte exactement de
      la mme manire que ce dernier.</p>

      <p>Si vous faites une comparaison directe (<code>=</code> ou
      <code>==</code>), vous pouvez extraire des parties de l'expression
      rationnelle. Les parties extraites sont stockes dans les
      variables spciales <code>$1</code> .. <code>$9</code>. L'ensemble
      de la chane correspondant  l'expression rationnelle est stock
      dans la variable spciale <code>$0</code>.</p>

      <div class="example"><h3>Exemple</h3><p><code>
        &lt;!--#if expr="$QUERY_STRING = /^sid=([a-zA-Z0-9]+)/" --&gt;<br />
        <span class="indent">
          &lt;!--#set var="session" value="$1" --&gt;<br />
        </span>
        &lt;!--#endif --&gt;
      </code></p></div>
      </dd>

      <dt><code><var>chane1</var> &lt; <var>chane2</var><br />
       <var>chane1</var> &lt;= <var>chane2</var><br />
       <var>chane1</var> &gt; <var>chane2</var><br />
       <var>chane1</var> &gt;= <var>chane2</var></code></dt>

      <dd>Compare <var>chane1</var>  <var>chane2</var>. Notez que les
      chanes sont compares de manire <em>littrale</em> (en utilisant
      <code>strcmp(3)</code>). Ainsi, la chane "100" est infrieure 
      "20".</dd>

      <dt><code>( <var>test_condition</var> )</code></dt>
      <dd>vrai si <var>test_condition</var> est vrai</dd>

      <dt><code>! <var>test_condition</var></code></dt>
      <dd>vrai si <var>test_condition</var> est faux</dd>

      <dt><code><var>test_condition1</var> &amp;&amp;
        <var>test_condition2</var></code></dt>
      <dd>vrai si <var>test_condition1</var> et
      <var>test_condition2</var> sont tous les deux vrais</dd>

      <dt><code><var>test_condition1</var> ||
        <var>test_condition2</var></code></dt>
      <dd>vrai si au moins un des tests <var>test_condition1</var> ou
      <var>test_condition2</var> est vrai</dd>
    </dl>

    <p>"<code>=</code>" et "<code>!=</code>" ont une priorit suprieure
     "<code>&amp;&amp;</code>" et "<code>||</code>". "<code>!</code>" a
    la priorit la plus haute. Ainsi, les deux directives suivantes sont
    quivalentes :</p>

    <div class="example"><p><code>
      &lt;!--#if expr="$a = test1 &amp;&amp; $b = test2" --&gt;<br />
      &lt;!--#if expr="($a = test1) &amp;&amp; ($b = test2)" --&gt;
    </code></p></div>

    <p>Les oprateurs boolens <code>&amp;&amp;</code> et
    <code>||</code> ont la mme priorit. Ainsi, si vous voulez
    augmenter la priorit d'un de ces oprateurs, vous devez utiliser
    des parenthses.</p>

    <p>Tout ce qui n'est pas reconnu comme variable ou oprateur est
    trait comme une chane. Les chanes peuvent aussi tre entoures
    d'apostrophes : <code>'chane'</code>. Les chanes sans apostrophe
    ne peuvent pas contenir d'espaces (espaces ou tabulations) car
    ceux-ci servent  sparer certains lments comme les variables. Si
    plusieurs chanes se trouvent dans une ligne, elles sont concatnes
    en utilisant des espaces. Ainsi,</p>

    <div class="example"><p><code><var>chane1</var>&nbsp;&nbsp;&nbsp;&nbsp;<var>chane2</var></code> devient <code><var>chane1</var>&nbsp;<var>chane2</var></code><br />
      <br />
      et<br />
      <br />
      <code>'<var>chane1</var>&nbsp;&nbsp;&nbsp;&nbsp;<var>chane2</var>'</code> devient <code><var>chane1</var>&nbsp;&nbsp;&nbsp;&nbsp;<var>chane2</var></code>.</p></div>

    <div class="note"><h3>Optimisation des expressions boolennes</h3>
      <p>Si les expressions atteignent une complexit suffisante pour
      ralentir les traitements de manire significative, vous pouvez
      essayer de les optimiser en fonction des rgles d'valuation :</p>
      <ul>
      <li>Les expressions sont values de la gauche vers la droite</li>
      <li>Les oprateurs boolens binaires (<code>&amp;&amp;</code> et
      <code>||</code>) font l'objet d'une valuation abrge chaque fois
      que cela est possible. En d'autres termes, et selon la rgle
      ci-dessus, <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> value tout d'abord la
      partie gauche de l'expression. Si le rsultat de l'valuation de
      cette partie gauche suffit  dterminer le rsultat final,
      l'valuation s'arrte ici. Dans le cas contraire, la partie droite
      est value, et le rsultat final tient compte des rsultats des
      valuations des parties gauche et droite.</li>
      <li>L'valuation abrge est dsactive tant qu'il reste des
      expressions rgulires  traiter. Ces dernires doivent tre
      values afin de dfinir les variables correspondant aux
      rfrences arrires (<code>$1</code> .. <code>$9</code>).</li>
      </ul>
      <p>Si vous voulez dterminer la manire dont une expression est
      traite, vous pouvez recompiler <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> en
      utilisant l'option de compilation <code>-DDEBUG_INCLUDE</code>.
      Ceci a pour effet d'insrer, pour chaque expression interprte,
      des informations tiquetes, l'arbre d'interprtation et la
      manire dont elle est value au sein du flux de sortie envoy au
      client.</p>
    </div>

    <div class="note"><h3>Slashes d'chappement dans les expressions
    rationnelles</h3>
     <p>Tous les caractres slashes qui ne sont pas des sparateurs dans
     votre expression rationnelle doivent tre chapps, et ceci sans
     tenir compte de leur signification du point de vue du moteur
     d'expressions rationnelles.</p>
    </div>

    <div class="note"><h3>Documentation de rfrence</h3>
    <p>Voir le document <a href="../expr.html">Les expressions dans le
    serveur HTTP Apache</a>, pour une rfrence complte et des exemples.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssiendtag" id="ssiendtag">Directive</a> <a name="SSIEndTag" id="SSIEndTag">SSIEndTag</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Chane qui termine l'lment include</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSIEndTag <var>tag</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSIEndTag "--&gt;"</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
</table>
    <p>Cette directive permet de modifier la chane que
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> interprte comme la fin d'un lment
    include.</p>

    <pre class="prettyprint lang-config">SSIEndTag "%&gt;"</pre>



<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#ssistarttag">SSIStartTag</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssierrormsg" id="ssierrormsg">Directive</a> <a name="SSIErrorMsg" id="SSIErrorMsg">SSIErrorMsg</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Message d'erreur affich lorsqu'une erreur SSI
survient</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSIErrorMsg <var>message</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSIErrorMsg "[an error occurred while processing this
directive]"</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
</table>
    <p>La directive <code class="directive">SSIErrorMsg</code> permet de
    modifier le message d'erreur affich lorsqu'une erreur SSI survient.
    Pour les serveurs en production, il est recommand de modifier le
    message d'erreur par dfaut en <code>"&lt;!-- Error
    --&gt;"</code>, de faon  ce que le message ne soit pas
    prsent  l'utilisateur.</p>

    <p>Cette directive a le mme effet que l'lment
    <code>&lt;!--#config errmsg=<var>message</var> --&gt;</code>.</p>

    <pre class="prettyprint lang-config">SSIErrorMsg "&lt;!-- Error --&gt;"</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssietag" id="ssietag">Directive</a> <a name="SSIETag" id="SSIETag">SSIETag</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit si des en-ttes ETags sont gnrs par le serveur.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSIETag on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSIETag off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.2.15 du serveur HTTP
Apache.</td></tr>
</table>
      <p>Dans le cas gnral, un fichier filtr par
      <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> peut contenir des lments soit
      gnrs dynamiquement, soit ventuellement modifis indpendemment
      du fichier original. En consquence, il est demand par dfaut au
      serveur de ne pas gnrer d'en-tte <code>ETag</code>  la rponse
      en ajoutant <code>no-etag</code> aux informations de requte.</p>

      <p>Ce comportement peut tre modifi via la directive
      <code class="directive">SSIETag</code> qui permet au serveur de gnrer un
      en-tte <code>ETag</code>. On peut aussi l'utiliser pour la mise
      en cache de la sortie. Notez qu'un serveur d'arrire-plan ou un
      gnrateur de contenu dynamique peut lui-mme gnrer un en-tte
      <code>ETag</code>, en ignorant l'information <code>no-etag</code>,
      cet en-tte <code>ETag</code> tant transmis par
      <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> sans tenir compte de la dfinition de
      la prsente directive. La directive <code class="directive">SSIETag</code>
      peut prendre une des valeurs suivantes :</p>

      <dl>

        <dt><code>off</code></dt>
        <dd><code>no-etag</code> sera ajout aux informations de
	requte, et il sera demand au serveur de ne pas gnrer
	d'en-tte <code>ETag</code>. Lorsqu'un serveur ignore la valeur
	de <code>no-etag</code> et gnre tout de mme un en-tte
	<code>ETag</code>, ce dernier sera respect.</dd>

        <dt><code>on</code></dt>
        <dd>Les en-ttes <code>ETag</code> existants seront respects,
	et ceux gnrs par le serveur seront ajouts  la rponse.</dd>

      </dl>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssilastmodified" id="ssilastmodified">Directive</a> <a name="SSILastModified" id="SSILastModified">SSILastModified</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit si des en-ttes <code>Last-Modified</code> sont
gnrs par le serveur.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSILastModified on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSILastModified off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.2.15 du serveur HTTP
Apache.</td></tr>
</table>
      <p>Dans le cas gnral, un fichier filtr par
      <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> peut contenir des lments soit
      gnrs dynamiquement, soit ventuellement modifis indpendemment
      du fichier original. En consquence, l'en-tte
      <code>Last-Modified</code> est supprim par dfaut de la rponse.</p>

      <p>La directive <code class="directive">SSILastModified</code> permet de
      modifier ce comportement en faisant en sorte que l'en-tte
      <code>Last-Modified</code> soit respect s'il est dj prsent, ou
      dfini dans le cas contraire. On peut aussi l'utiliser pour la mise
      en cache de la sortie. La directive
      <code class="directive">SSILastModified</code> peut prendre une des
      valeurs suivantes :</p>

      <dl>

        <dt><code>off</code></dt>
        <dd>L'en-tte <code>Last-Modified</code> sera supprim des
	rponses,  moins que la directive <code class="directive"><a href="#xbithack">XBitHack</a></code> ne soit dfinie 
	<code>full</code> comme dcrit plus loin.</dd>

        <dt><code>on</code></dt>
        <dd>L'en-tte <code>Last-Modified</code> sera respect s'il est
	dj prsent, et ajout  la rponse si cette dernire est un
	fichier et si l'en-tte est manquant. La directive <code class="directive"><a href="#ssilastmodified">SSILastModified</a></code> l'emporte sur
	la directive <code class="directive"><a href="#xbithack">XBitHack</a></code>.</dd>

      </dl>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssilegacyexprparser" id="ssilegacyexprparser">Directive</a> <a name="SSILegacyExprParser" id="SSILegacyExprParser">SSILegacyExprParser</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active le mode de compatibilit pour les expressions
conditionnelles.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSILegacyExprParser on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSILegacyExprParser off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.3.13.</td></tr>
</table>
    <p>Depuis la version 2.3.13, <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> a adopt
    la nouvelle syntaxe <a href="../expr.html">ap_expr</a> pour ses
    expressions conditionnelles dans les lments de contrle de flux
    <code>#if</code>. Cette directive permet de ractiver l'<a href="#legacyexpr">ancienne syntaxe</a> qui est compatible avec les
    versions 2.2.x et antrieures d'Apache HTTPD.
    </p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssistarttag" id="ssistarttag">Directive</a> <a name="SSIStartTag" id="SSIStartTag">SSIStartTag</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Chane qui marque le dbut d'un lment
include</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSIStartTag <var>tag</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSIStartTag "&lt;!--#"</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
</table>
    <p>Cette directive permet de modifier la chane que
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> interprte comme le dbut d'un lment
    include.</p>

    <p>Cette option peut vous tre utile si vous avez deux serveurs qui
    interprtent un fichier avec des commandes diffrentes (et
    ventuellement  des moments diffrents).</p>

    <pre class="prettyprint lang-config">SSIStartTag "&lt;%"
SSIEndTag   "%&gt;"</pre>


    <p>Avec l'exemple ci-dessus, qui dfinit aussi une directive
    <code class="directive"><a href="#ssiendtag">SSIEndTag</a></code>, vous pourrez
    inscrire des directives SSI comme dans l'exemple suivant :</p>

    <div class="example"><h3>Directives SSI avec marques de dbut et de fin
    personnalises</h3><p><code>
      &lt;%printenv %&gt;
    </code></p></div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#ssiendtag">SSIEndTag</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssitimeformat" id="ssitimeformat">Directive</a> <a name="SSITimeFormat" id="SSITimeFormat">SSITimeFormat</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configuration du format d'affichage des dates</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSITimeFormat <var>chane de formatage</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSITimeFormat "%A, %d-%b-%Y %H:%M:%S %Z"</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
</table>
<p>Cette directive permet de modifier le format d'affichage des
variables d'environnement <code>DATE</code>. La <var>chane de
formatage</var> est identique  celle de la fonction
<code>strftime(3)</code> de la bibliothque C standard.</p>

    <p>Cette directive a le mme effet que l'lment
    <code>&lt;!--#config timefmt=<var>chane de formatage</var>
    --&gt;</code>.</p>

    <pre class="prettyprint lang-config">SSITimeFormat "%R, %B %d, %Y"</pre>


    <p>Avec l'exemple ci-dessus, les dates seront affiches dans le
    style "22:26, June 14, 2002".</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssiundefinedecho" id="ssiundefinedecho">Directive</a> <a name="SSIUndefinedEcho" id="SSIUndefinedEcho">SSIUndefinedEcho</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Chane  afficher lorsqu'on tente d'extraire le contenu
d'une variable non dfinie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSIUndefinedEcho <var>chane</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSIUndefinedEcho "(none)"</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
</table>
    <p>Cette directive permet de modifier la chane affiche par
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> lorsqu'on tente d'extraire le contenu
    d'une variable non dfinie.</p>

    <pre class="prettyprint lang-config">SSIUndefinedEcho "&lt;!-- nondef --&gt;"</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="xbithack" id="xbithack">Directive</a> <a name="XBitHack" id="XBitHack">XBitHack</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Interprte les directives SSI dans les fichiers dont le bit
d'excution est positionn</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>XBitHack on|off|full</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>XBitHack off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Options</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_include</td></tr>
</table>
    <p>La directive <code class="directive">XBitHack</code> permet de contrler
    l'interprtation des documents html standards. Elle n'affecte que
    les fichiers dont le <a class="glossarylink" href="../glossary.html#type mime" title="voir glossaire">type MIME</a> est
    <code>text/html</code>. <code class="directive">XBitHack</code> peut prendre
    les valeurs suivantes :</p>

    <dl>
      <dt><code>off</code></dt>
      <dd>Aucun traitement particulier pour les fichiers
      excutables.</dd>

      <dt><code>on</code></dt>
      <dd>Tout fichier <code>text/html</code> dont le bit d'excution
      est positionn pour le propritaire sera trait en tant que
      document html interprt par le serveur.</dd>

      <dt><code>full</code></dt>
      <dd>Identique  <code>on</code>, avec test du bit d'excution pour
      le groupe. Si ce dernier est positionn, la date de <code>dernire
      modification</code> du fichier renvoy est dfinie  la date de
      dernire modification du fichier. Dans le cas contraire, aucune
      date de dernire modification n'est renvoye. Le positionnement de
      ce bit permet aux clients et aux mandataires de grer la mise en
      cache du rsultat de la requte.

      <div class="note"><h3>Note</h3>
      <p>Il est recommand de n'utiliser l'option full que dans le cas
      o vous tes certain que le bit d'excution du groupe est non
      positionn pour les scripts SSI qui pourraient effectuer l'<code>#include</code> d'un programme CGI ou bien produire des sorties
      diffrentes  chaque accs (ou seraient susceptibles d'tre
      modifies au cours des requtes ultrieures).</p>

      <p>Lorsqu'elle est dfinie  <code>on</code>, la directive
      <code class="directive"><a href="#ssilastmodified">SSILastModified</a></code>
      l'emporte sur la directive <code class="directive"><a href="#xbithack">XBitHack</a></code>.</p>
      </div>

      </dd>
    </dl>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_include.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_include.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_include.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_include.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>