<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_actions - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_actions</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../de/mod/mod_actions.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/mod_actions.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_actions.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_actions.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_actions.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Excution des scripts CGI en fonction du
type de mdia ou de la mthode de requte.</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>actions_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_actions.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module possde deux directives. La directive <code class="directive"><a href="#action">Action</a></code> vous permet de lancer
    l'excution de scripts CGI chaque fois qu'un fichier possdant un
    certain <a class="glossarylink" href="../glossary.html#mime-type" title="voir glossaire">type de contenu MIME</a>
    fait l'objet d'une requte. La directive <code class="directive"><a href="#script">Script</a></code> vous permet de lancer
    l'excution de scripts CGI chaque fois que la requte utilise une
    mthode particulire. Ceci facilite grandement l'excution de
    scripts qui traitent des fichiers.</p> </div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#action">Action</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#script">Script</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_actions">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_actions">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code></li>
<li><a href="../howto/cgi.html">Contenu dynamique avec CGI</a></li>
<li><a href="../handler.html">Utilisation des gestionnaires
d'Apache httpd</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>

<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="action" id="action">Directive</a> <a name="Action" id="Action">Action</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active un script CGI pour un gestionnaire ou un type de
contenu particulier</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Action <var>type d'action</var> <var>script cgi</var>
[virtual]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_actions</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Le modificateur <code>virtual</code> et le passage de
gestionnaire ont t introduits dans Apache 2.1</td></tr>
</table>
    <p>Cette directive ajoute une action qui va activer <var>script
    cgi</var> lorsque <var>type d'action</var> est dclench par la
    requte. <var>script cgi</var> est un chemin URL vers une ressource
    qui a t dsigne comme script CGI  l'aide des directives
    <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code> ou <code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code>. <var>type d'action</var>
    peut tre soit un <a href="../handler.html">gestionnaire</a>, soit
    un <a class="glossarylink" href="../glossary.html#mime-type" title="voir glossaire">type de contenu MIME</a>. L'URL
    et le chemin du document correspondant sont envoys en utilisant
    les variables d'environnement CGI standards <code>PATH_INFO</code>
    et <code>PATH_TRANSLATED</code>. Le gestionnaire utilis pour cette
    requte particulire est transmis  l'aide de la variable
    <code>REDIRECT_HANDLER</code>.</p>

    <div class="example"><h3>Exemple : type MIME</h3><pre class="prettyprint lang-config"># Requests for files of a particular MIME content type:
Action image/gif /cgi-bin/images.cgi</pre>
</div>

    <p>Dans cet exemple, les requtes pour des fichiers possdant
    le type de contenu MIME <code>image/gif</code> seront traites par
    le script CGI <code>/cgi-bin/images.cgi</code>.</p>

    <div class="example"><h3>Example: File extension</h3><pre class="prettyprint lang-config"># Files of a particular file extension
AddHandler my-file-type .xyz
Action my-file-type "/cgi-bin/program.cgi"</pre>
</div>
    <p>Dans cet exemple, les requtes pour des fichiers possdant
    l'extension <code>.xyz</code> seront traites par
    le script CGI <code>/cgi-bin/programme.cgi</code>.</p>

    <p>Le modificateur optionnel <code>virtual</code> permet de
    dsactiver la vrification de l'existence du fichier demand. Ceci
    peut s'avrer utile, par exemple, si vous voulez utiliser la
    directive <code class="directive">Action</code> pour des localisations
    virtuelles.</p>

    <pre class="prettyprint lang-config">&lt;Location "/news"&gt;
    SetHandler news-handler
    Action news-handler "/cgi-bin/news.cgi" virtual
&lt;/Location&gt;</pre>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="script" id="script">Directive</a> <a name="Script" id="Script">Script</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active un script CGI dans le cas d'une mthode de requte
particulire.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Script <var>mthode</var> <var>script cgi</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_actions</td></tr>
</table>
    <p>Cette directive ajoute une action qui va activer <var>script
    cgi</var> lorsqu'un fichier est demand en utilisant la mthode
    <var>mthode</var>. <var>script cgi</var> est le chemin URL d'une
    ressource qui a t dsigne comme script CGI en utilisant les
    directives <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code> ou <code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code>. L'URL et le chemin du
    document demand sont envoys en utilisant les variables
    d'environnement CGI standards <code>PATH_INFO</code> et
    <code>PATH_TRANSLATED</code>.</p>

    <div class="note">
      Tous les noms de mthode peuvent tre utiliss. <strong>Les noms
      de mthode sont sensibles  la casse</strong>, si bien que
      <code>Script PUT</code> et <code>Script put</code> ont des effets
      totalement diffrents.
    </div>

    <p>Notez que la commande <code class="directive">Script</code> ne dfinit
    que des actions par dfaut. Si un script CGI est appel, ou toute
    autre ressource capable de grer la mthode de la requte en
    interne, il agira en consquence. Notez aussi que
    <code class="directive">Script</code> avec une mthode <code>GET</code> ne
    sera appel que si la requte possde des arguments (par exemple
    foo.html?hi). Dans le cas contraire, la requte sera traite
    normalement.</p>

    <pre class="prettyprint lang-config"># All GET requests go here
Script GET "/cgi-bin/search"

# A CGI PUT handler
Script PUT "/~bob/put.cgi"</pre>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../de/mod/mod_actions.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/mod_actions.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_actions.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_actions.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_actions.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_actions.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>