; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -S -passes='require<profile-summary>,function(codegenprepare)' -mtriple=amdgcn--amdhsa < %s | FileCheck %s

define i64 @no_sink_local_to_flat(i1 %pred, ptr addrspace(3) %ptr) {
; CHECK-LABEL: define i64 @no_sink_local_to_flat(
; CHECK-SAME: i1 [[PRED:%.*]], ptr addrspace(3) [[PTR:%.*]]) {
; CHECK-NEXT:    [[PTR_CAST:%.*]] = addrspacecast ptr addrspace(3) [[PTR]] to ptr
; CHECK-NEXT:    br i1 [[PRED]], label [[L1:%.*]], label [[L2:%.*]]
; CHECK:       l1:
; CHECK-NEXT:    [[V1:%.*]] = load i64, ptr addrspace(3) [[PTR]], align 8
; CHECK-NEXT:    ret i64 [[V1]]
; CHECK:       l2:
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr [[PTR_CAST]], align 8
; CHECK-NEXT:    ret i64 [[V2]]
;
  %ptr_cast = addrspacecast ptr addrspace(3) %ptr to ptr
  br i1 %pred, label %l1, label %l2

l1:
  %v1 = load i64, ptr addrspace(3) %ptr
  ret i64 %v1

l2:
  %v2 = load i64, ptr %ptr_cast
  ret i64 %v2
}

define i64 @no_sink_private_to_flat(i1 %pred, ptr addrspace(5) %ptr) {
; CHECK-LABEL: define i64 @no_sink_private_to_flat(
; CHECK-SAME: i1 [[PRED:%.*]], ptr addrspace(5) [[PTR:%.*]]) {
; CHECK-NEXT:    [[PTR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[PTR]] to ptr
; CHECK-NEXT:    br i1 [[PRED]], label [[L1:%.*]], label [[L2:%.*]]
; CHECK:       l1:
; CHECK-NEXT:    [[V1:%.*]] = load i64, ptr addrspace(5) [[PTR]], align 8
; CHECK-NEXT:    ret i64 [[V1]]
; CHECK:       l2:
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr [[PTR_CAST]], align 8
; CHECK-NEXT:    ret i64 [[V2]]
;
  %ptr_cast = addrspacecast ptr addrspace(5) %ptr to ptr
  br i1 %pred, label %l1, label %l2

l1:
  %v1 = load i64, ptr addrspace(5) %ptr
  ret i64 %v1

l2:
  %v2 = load i64, ptr %ptr_cast
  ret i64 %v2
}


define i64 @sink_global_to_flat(i1 %pred, ptr addrspace(1) %ptr) {
; CHECK-LABEL: define i64 @sink_global_to_flat(
; CHECK-SAME: i1 [[PRED:%.*]], ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    br i1 [[PRED]], label [[L1:%.*]], label [[L2:%.*]]
; CHECK:       l1:
; CHECK-NEXT:    [[V1:%.*]] = load i64, ptr addrspace(1) [[PTR]], align 8
; CHECK-NEXT:    ret i64 [[V1]]
; CHECK:       l2:
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(1) [[PTR]] to ptr
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr [[TMP1]], align 8
; CHECK-NEXT:    ret i64 [[V2]]
;
  %ptr_cast = addrspacecast ptr addrspace(1) %ptr to ptr
  br i1 %pred, label %l1, label %l2

l1:
  %v1 = load i64, ptr addrspace(1) %ptr
  ret i64 %v1

l2:
  %v2 = load i64, ptr %ptr_cast
  ret i64 %v2
}

define i64 @sink_flat_to_global(i1 %pred, ptr %ptr) {
; CHECK-LABEL: define i64 @sink_flat_to_global(
; CHECK-SAME: i1 [[PRED:%.*]], ptr [[PTR:%.*]]) {
; CHECK-NEXT:    br i1 [[PRED]], label [[L1:%.*]], label [[L2:%.*]]
; CHECK:       l1:
; CHECK-NEXT:    [[V1:%.*]] = load i64, ptr [[PTR]], align 8
; CHECK-NEXT:    ret i64 [[V1]]
; CHECK:       l2:
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(1)
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr addrspace(1) [[TMP1]], align 8
; CHECK-NEXT:    ret i64 [[V2]]
;
  %ptr_cast = addrspacecast ptr %ptr to ptr addrspace(1)
  br i1 %pred, label %l1, label %l2

l1:
  %v1 = load i64, ptr %ptr
  ret i64 %v1

l2:
  %v2 = load i64, ptr addrspace(1) %ptr_cast
  ret i64 %v2
}

define i64 @sink_flat_to_constant(i1 %pred, ptr %ptr) {
; CHECK-LABEL: define i64 @sink_flat_to_constant(
; CHECK-SAME: i1 [[PRED:%.*]], ptr [[PTR:%.*]]) {
; CHECK-NEXT:    br i1 [[PRED]], label [[L1:%.*]], label [[L2:%.*]]
; CHECK:       l1:
; CHECK-NEXT:    [[V1:%.*]] = load i64, ptr [[PTR]], align 8
; CHECK-NEXT:    ret i64 [[V1]]
; CHECK:       l2:
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(4)
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr addrspace(4) [[TMP1]], align 8
; CHECK-NEXT:    ret i64 [[V2]]
;
  %ptr_cast = addrspacecast ptr %ptr to ptr addrspace(4)
  br i1 %pred, label %l1, label %l2

l1:
  %v1 = load i64, ptr %ptr
  ret i64 %v1

l2:
  %v2 = load i64, ptr addrspace(4) %ptr_cast
  ret i64 %v2
}

define i64 @sink_flat_to_local(i1 %pred, ptr %ptr) {
; CHECK-LABEL: define i64 @sink_flat_to_local(
; CHECK-SAME: i1 [[PRED:%.*]], ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[PTR_CAST:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(3)
; CHECK-NEXT:    br i1 [[PRED]], label [[L1:%.*]], label [[L2:%.*]]
; CHECK:       l1:
; CHECK-NEXT:    [[V1:%.*]] = load i64, ptr [[PTR]], align 8
; CHECK-NEXT:    ret i64 [[V1]]
; CHECK:       l2:
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr addrspace(3) [[PTR_CAST]], align 8
; CHECK-NEXT:    ret i64 [[V2]]
;
  %ptr_cast = addrspacecast ptr %ptr to ptr addrspace(3)
  br i1 %pred, label %l1, label %l2

l1:
  %v1 = load i64, ptr %ptr
  ret i64 %v1

l2:
  %v2 = load i64, ptr addrspace(3) %ptr_cast
  ret i64 %v2
}

define i64 @sink_flat_to_private(i1 %pred, ptr %ptr) {
; CHECK-LABEL: define i64 @sink_flat_to_private(
; CHECK-SAME: i1 [[PRED:%.*]], ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[PTR_CAST:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(5)
; CHECK-NEXT:    br i1 [[PRED]], label [[L1:%.*]], label [[L2:%.*]]
; CHECK:       l1:
; CHECK-NEXT:    [[V1:%.*]] = load i64, ptr [[PTR]], align 8
; CHECK-NEXT:    ret i64 [[V1]]
; CHECK:       l2:
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr addrspace(5) [[PTR_CAST]], align 8
; CHECK-NEXT:    ret i64 [[V2]]
;
  %ptr_cast = addrspacecast ptr %ptr to ptr addrspace(5)
  br i1 %pred, label %l1, label %l2

l1:
  %v1 = load i64, ptr %ptr
  ret i64 %v1

l2:
  %v2 = load i64, ptr addrspace(5) %ptr_cast
  ret i64 %v2
}
