; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=alignment-from-assumptions -S < %s | FileCheck %s

; The alignment assumption is a global, which has users in a different
; function. Test that in this case the dominator tree is only queried with
; blocks from the same function.

@global = external constant [192 x i8]

define void @fn1() {
; CHECK-LABEL: define void @fn1() {
; CHECK-NEXT:    call void @llvm.assume(i1 false) [ "align"(ptr @global, i64 1) ]
; CHECK-NEXT:    ret void
;
  call void @llvm.assume(i1 false) [ "align"(ptr @global, i64 1) ]
  ret void
}

define void @fn2() {
; CHECK-LABEL: define void @fn2() {
; CHECK-NEXT:    ret void
; CHECK:       [[LOOP:.*]]:
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr @global, i64 0
; CHECK-NEXT:    [[LOAD:%.*]] = load i64, ptr [[GEP]], align 1
; CHECK-NEXT:    br label %[[LOOP]]
;
  ret void

loop:
  %gep = getelementptr inbounds i8, ptr @global, i64 0
  %load = load i64, ptr %gep, align 1
  br label %loop
}
