; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=sparc -relocation-model=pic < %s | FileCheck --check-prefix=SPARC %s
; RUN: llc -mtriple=sparc64 -relocation-model=pic < %s | FileCheck --check-prefix=SPARC64 %s

@x = external thread_local global i8

;; Test that we don't over-allocate stack space when calling __tls_get_addr
;; with the call frame pseudos able to be eliminated.
define ptr @no_alloca() nounwind {
; SPARC-LABEL: no_alloca:
; SPARC:       ! %bb.0: ! %entry
; SPARC-NEXT:    save %sp, -96, %sp
; SPARC-NEXT:  .Ltmp0:
; SPARC-NEXT:    call .Ltmp1
; SPARC-NEXT:  .Ltmp2:
; SPARC-NEXT:    sethi %hi(_GLOBAL_OFFSET_TABLE_+(.Ltmp2-.Ltmp0)), %i0
; SPARC-NEXT:  .Ltmp1:
; SPARC-NEXT:    or %i0, %lo(_GLOBAL_OFFSET_TABLE_+(.Ltmp1-.Ltmp0)), %i0
; SPARC-NEXT:    add %i0, %o7, %i0
; SPARC-NEXT:    sethi %tgd_hi22(x), %i1
; SPARC-NEXT:    add %i1, %tgd_lo10(x), %i1
; SPARC-NEXT:    add %i0, %i1, %o0, %tgd_add(x)
; SPARC-NEXT:    call __tls_get_addr, %tgd_call(x)
; SPARC-NEXT:    nop
; SPARC-NEXT:    ret
; SPARC-NEXT:    restore %g0, %o0, %o0
;
; SPARC64-LABEL: no_alloca:
; SPARC64:       ! %bb.0: ! %entry
; SPARC64-NEXT:    save %sp, -128, %sp
; SPARC64-NEXT:  .Ltmp0:
; SPARC64-NEXT:    rd %pc, %o7
; SPARC64-NEXT:  .Ltmp2:
; SPARC64-NEXT:    sethi %hi(_GLOBAL_OFFSET_TABLE_+(.Ltmp2-.Ltmp0)), %i0
; SPARC64-NEXT:  .Ltmp1:
; SPARC64-NEXT:    or %i0, %lo(_GLOBAL_OFFSET_TABLE_+(.Ltmp1-.Ltmp0)), %i0
; SPARC64-NEXT:    add %i0, %o7, %i0
; SPARC64-NEXT:    sethi %tgd_hi22(x), %i1
; SPARC64-NEXT:    add %i1, %tgd_lo10(x), %i1
; SPARC64-NEXT:    add %i0, %i1, %o0, %tgd_add(x)
; SPARC64-NEXT:    call __tls_get_addr, %tgd_call(x)
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore %g0, %o0, %o0
entry:
  %0 = call ptr @llvm.threadlocal.address.p0(ptr @x)
  ret ptr %0
}

;; Test that %sp is valid for the call to __tls_get_addr. We store to a dynamic
;; alloca in order to prevent eliminating any call frame pseudos from the call.
define ptr @dynamic_alloca(i64 %n) nounwind {
; SPARC-LABEL: dynamic_alloca:
; SPARC:       ! %bb.0: ! %entry
; SPARC-NEXT:    save %sp, -96, %sp
; SPARC-NEXT:  .Ltmp3:
; SPARC-NEXT:    call .Ltmp4
; SPARC-NEXT:  .Ltmp5:
; SPARC-NEXT:    sethi %hi(_GLOBAL_OFFSET_TABLE_+(.Ltmp5-.Ltmp3)), %i0
; SPARC-NEXT:  .Ltmp4:
; SPARC-NEXT:    or %i0, %lo(_GLOBAL_OFFSET_TABLE_+(.Ltmp4-.Ltmp3)), %i0
; SPARC-NEXT:    add %i0, %o7, %i0
; SPARC-NEXT:    sethi %tgd_hi22(x), %i2
; SPARC-NEXT:    add %i2, %tgd_lo10(x), %i2
; SPARC-NEXT:    add %i0, %i2, %o0, %tgd_add(x)
; SPARC-NEXT:    call __tls_get_addr, %tgd_call(x)
; SPARC-NEXT:    nop
; SPARC-NEXT:    add %i1, 7, %i0
; SPARC-NEXT:    and %i0, -8, %i0
; SPARC-NEXT:    sub %sp, %i0, %i0
; SPARC-NEXT:    add %i0, -8, %sp
; SPARC-NEXT:    mov 1, %i1
; SPARC-NEXT:    stb %i1, [%i0+88]
; SPARC-NEXT:    ret
; SPARC-NEXT:    restore %g0, %o0, %o0
;
; SPARC64-LABEL: dynamic_alloca:
; SPARC64:       ! %bb.0: ! %entry
; SPARC64-NEXT:    save %sp, -128, %sp
; SPARC64-NEXT:  .Ltmp3:
; SPARC64-NEXT:    rd %pc, %o7
; SPARC64-NEXT:  .Ltmp5:
; SPARC64-NEXT:    sethi %hi(_GLOBAL_OFFSET_TABLE_+(.Ltmp5-.Ltmp3)), %i1
; SPARC64-NEXT:  .Ltmp4:
; SPARC64-NEXT:    or %i1, %lo(_GLOBAL_OFFSET_TABLE_+(.Ltmp4-.Ltmp3)), %i1
; SPARC64-NEXT:    add %i1, %o7, %i1
; SPARC64-NEXT:    sethi %tgd_hi22(x), %i2
; SPARC64-NEXT:    add %i2, %tgd_lo10(x), %i2
; SPARC64-NEXT:    add %i1, %i2, %o0, %tgd_add(x)
; SPARC64-NEXT:    call __tls_get_addr, %tgd_call(x)
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    add %i0, 15, %i0
; SPARC64-NEXT:    and %i0, -16, %i0
; SPARC64-NEXT:    sub %sp, %i0, %i0
; SPARC64-NEXT:    mov %i0, %sp
; SPARC64-NEXT:    mov 1, %i1
; SPARC64-NEXT:    stb %i1, [%i0+2175]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore %g0, %o0, %o0
entry:
  %0 = call ptr @llvm.threadlocal.address.p0(ptr @x)
  %1 = alloca i8, i64 %n
  store i8 1, ptr %1
  ret ptr %0
}
