; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK,RV32I %s
; RUN: llc -relocation-model=pic -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK,RV32I-PIC %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s
; RUN: llc -code-model=small -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I-SMALL %s
; RUN: llc -code-model=medium -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I-MEDIUM %s
; RUN: llc -code-model=large -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I-LARGE %s
; RUN: llc -code-model=large -mtriple=riscv64 -mattr=experimental-zicfilp -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I-LARGE-ZICFILP %s

declare i32 @external_function(i32)

define i32 @test_call_external(i32 %a) nounwind {
; CHECK-LABEL: test_call_external:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    call external_function
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_external:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call external_function
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: test_call_external:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -16
; RV64I-SMALL-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    call external_function
; RV64I-SMALL-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    addi sp, sp, 16
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: test_call_external:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -16
; RV64I-MEDIUM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    call external_function
; RV64I-MEDIUM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    addi sp, sp, 16
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: test_call_external:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -16
; RV64I-LARGE-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:  .Lpcrel_hi0:
; RV64I-LARGE-NEXT:    auipc a1, %pcrel_hi(.LCPI0_0)
; RV64I-LARGE-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi0)(a1)
; RV64I-LARGE-NEXT:    jalr a1
; RV64I-LARGE-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    addi sp, sp, 16
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: test_call_external:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -16
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:  .Lpcrel_hi0:
; RV64I-LARGE-ZICFILP-NEXT:    auipc a1, %pcrel_hi(.LCPI0_0)
; RV64I-LARGE-ZICFILP-NEXT:    ld t2, %pcrel_lo(.Lpcrel_hi0)(a1)
; RV64I-LARGE-ZICFILP-NEXT:    jalr t2
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 16
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = call i32 @external_function(i32 %a)
  ret i32 %1
}

declare dso_local i32 @dso_local_function(i32)

define i32 @test_call_dso_local(i32 %a) nounwind {
; CHECK-LABEL: test_call_dso_local:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    call dso_local_function
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_dso_local:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call dso_local_function
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: test_call_dso_local:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -16
; RV64I-SMALL-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    call dso_local_function
; RV64I-SMALL-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    addi sp, sp, 16
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: test_call_dso_local:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -16
; RV64I-MEDIUM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    call dso_local_function
; RV64I-MEDIUM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    addi sp, sp, 16
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: test_call_dso_local:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -16
; RV64I-LARGE-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:  .Lpcrel_hi1:
; RV64I-LARGE-NEXT:    auipc a1, %pcrel_hi(.LCPI1_0)
; RV64I-LARGE-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi1)(a1)
; RV64I-LARGE-NEXT:    jalr a1
; RV64I-LARGE-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    addi sp, sp, 16
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: test_call_dso_local:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -16
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:  .Lpcrel_hi1:
; RV64I-LARGE-ZICFILP-NEXT:    auipc a1, %pcrel_hi(.LCPI1_0)
; RV64I-LARGE-ZICFILP-NEXT:    ld t2, %pcrel_lo(.Lpcrel_hi1)(a1)
; RV64I-LARGE-ZICFILP-NEXT:    jalr t2
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 16
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = call i32 @dso_local_function(i32 %a)
  ret i32 %1
}

define i32 @defined_function(i32 %a) nounwind {
; CHECK-LABEL: defined_function:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, a0, 1
; CHECK-NEXT:    ret
;
; RV64I-LABEL: defined_function:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: defined_function:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addiw a0, a0, 1
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: defined_function:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addiw a0, a0, 1
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: defined_function:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addiw a0, a0, 1
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: defined_function:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addiw a0, a0, 1
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = add i32 %a, 1
  ret i32 %1
}

define i32 @test_call_defined(i32 %a) nounwind {
; CHECK-LABEL: test_call_defined:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    call defined_function
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_defined:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call defined_function
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: test_call_defined:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -16
; RV64I-SMALL-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    call defined_function
; RV64I-SMALL-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    addi sp, sp, 16
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: test_call_defined:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -16
; RV64I-MEDIUM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    call defined_function
; RV64I-MEDIUM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    addi sp, sp, 16
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: test_call_defined:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -16
; RV64I-LARGE-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:  .Lpcrel_hi2:
; RV64I-LARGE-NEXT:    auipc a1, %pcrel_hi(.LCPI3_0)
; RV64I-LARGE-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi2)(a1)
; RV64I-LARGE-NEXT:    jalr a1
; RV64I-LARGE-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    addi sp, sp, 16
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: test_call_defined:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -16
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:  .Lpcrel_hi2:
; RV64I-LARGE-ZICFILP-NEXT:    auipc a1, %pcrel_hi(.LCPI3_0)
; RV64I-LARGE-ZICFILP-NEXT:    ld t2, %pcrel_lo(.Lpcrel_hi2)(a1)
; RV64I-LARGE-ZICFILP-NEXT:    jalr t2
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 16
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = call i32 @defined_function(i32 %a)
  ret i32 %1
}

define i32 @test_call_indirect(ptr %a, i32 %b) nounwind {
; CHECK-LABEL: test_call_indirect:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    jalr a2
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_indirect:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, a0
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    jalr a2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: test_call_indirect:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -16
; RV64I-SMALL-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    mv a2, a0
; RV64I-SMALL-NEXT:    mv a0, a1
; RV64I-SMALL-NEXT:    jalr a2
; RV64I-SMALL-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    addi sp, sp, 16
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: test_call_indirect:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -16
; RV64I-MEDIUM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    mv a2, a0
; RV64I-MEDIUM-NEXT:    mv a0, a1
; RV64I-MEDIUM-NEXT:    jalr a2
; RV64I-MEDIUM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    addi sp, sp, 16
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: test_call_indirect:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -16
; RV64I-LARGE-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:    mv a2, a0
; RV64I-LARGE-NEXT:    mv a0, a1
; RV64I-LARGE-NEXT:    jalr a2
; RV64I-LARGE-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    addi sp, sp, 16
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: test_call_indirect:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -16
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:    mv a2, a0
; RV64I-LARGE-ZICFILP-NEXT:    mv a0, a1
; RV64I-LARGE-ZICFILP-NEXT:    jalr a2
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 16
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = call i32 %a(i32 %b)
  ret i32 %1
}

; Make sure we don't use t0 as the source for jalr as that is a hint to pop the
; return address stack on some microarchitectures.
define i32 @test_call_indirect_no_t0(ptr %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h) nounwind {
; CHECK-LABEL: test_call_indirect_no_t0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv t1, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    mv a3, a4
; CHECK-NEXT:    mv a4, a5
; CHECK-NEXT:    mv a5, a6
; CHECK-NEXT:    mv a6, a7
; CHECK-NEXT:    jalr t1
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_indirect_no_t0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv t1, a0
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    mv a1, a2
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    mv a3, a4
; RV64I-NEXT:    mv a4, a5
; RV64I-NEXT:    mv a5, a6
; RV64I-NEXT:    mv a6, a7
; RV64I-NEXT:    jalr t1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: test_call_indirect_no_t0:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -16
; RV64I-SMALL-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    mv t1, a0
; RV64I-SMALL-NEXT:    mv a0, a1
; RV64I-SMALL-NEXT:    mv a1, a2
; RV64I-SMALL-NEXT:    mv a2, a3
; RV64I-SMALL-NEXT:    mv a3, a4
; RV64I-SMALL-NEXT:    mv a4, a5
; RV64I-SMALL-NEXT:    mv a5, a6
; RV64I-SMALL-NEXT:    mv a6, a7
; RV64I-SMALL-NEXT:    jalr t1
; RV64I-SMALL-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    addi sp, sp, 16
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: test_call_indirect_no_t0:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -16
; RV64I-MEDIUM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    mv t1, a0
; RV64I-MEDIUM-NEXT:    mv a0, a1
; RV64I-MEDIUM-NEXT:    mv a1, a2
; RV64I-MEDIUM-NEXT:    mv a2, a3
; RV64I-MEDIUM-NEXT:    mv a3, a4
; RV64I-MEDIUM-NEXT:    mv a4, a5
; RV64I-MEDIUM-NEXT:    mv a5, a6
; RV64I-MEDIUM-NEXT:    mv a6, a7
; RV64I-MEDIUM-NEXT:    jalr t1
; RV64I-MEDIUM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    addi sp, sp, 16
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: test_call_indirect_no_t0:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -16
; RV64I-LARGE-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:    mv t1, a0
; RV64I-LARGE-NEXT:    mv a0, a1
; RV64I-LARGE-NEXT:    mv a1, a2
; RV64I-LARGE-NEXT:    mv a2, a3
; RV64I-LARGE-NEXT:    mv a3, a4
; RV64I-LARGE-NEXT:    mv a4, a5
; RV64I-LARGE-NEXT:    mv a5, a6
; RV64I-LARGE-NEXT:    mv a6, a7
; RV64I-LARGE-NEXT:    jalr t1
; RV64I-LARGE-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    addi sp, sp, 16
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: test_call_indirect_no_t0:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -16
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:    mv t1, a0
; RV64I-LARGE-ZICFILP-NEXT:    mv a0, a1
; RV64I-LARGE-ZICFILP-NEXT:    mv a1, a2
; RV64I-LARGE-ZICFILP-NEXT:    mv a2, a3
; RV64I-LARGE-ZICFILP-NEXT:    mv a3, a4
; RV64I-LARGE-ZICFILP-NEXT:    mv a4, a5
; RV64I-LARGE-ZICFILP-NEXT:    mv a5, a6
; RV64I-LARGE-ZICFILP-NEXT:    mv a6, a7
; RV64I-LARGE-ZICFILP-NEXT:    jalr t1
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 16
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = call i32 %a(i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h)
  ret i32 %1
}

; Ensure that calls to fastcc functions aren't rejected. Such calls may be
; introduced when compiling with optimisation.

define fastcc i32 @fastcc_function(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: fastcc_function:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add a0, a0, a1
; CHECK-NEXT:    ret
;
; RV64I-LABEL: fastcc_function:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: fastcc_function:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addw a0, a0, a1
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: fastcc_function:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addw a0, a0, a1
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: fastcc_function:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addw a0, a0, a1
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: fastcc_function:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addw a0, a0, a1
; RV64I-LARGE-ZICFILP-NEXT:    ret
 %1 = add i32 %a, %b
 ret i32 %1
}

define i32 @test_call_fastcc(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: test_call_fastcc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    call fastcc_function
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_fastcc:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    call fastcc_function
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: test_call_fastcc:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -16
; RV64I-SMALL-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    mv s0, a0
; RV64I-SMALL-NEXT:    call fastcc_function
; RV64I-SMALL-NEXT:    mv a0, s0
; RV64I-SMALL-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    addi sp, sp, 16
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: test_call_fastcc:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -16
; RV64I-MEDIUM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    mv s0, a0
; RV64I-MEDIUM-NEXT:    call fastcc_function
; RV64I-MEDIUM-NEXT:    mv a0, s0
; RV64I-MEDIUM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    addi sp, sp, 16
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: test_call_fastcc:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -16
; RV64I-LARGE-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:    mv s0, a0
; RV64I-LARGE-NEXT:  .Lpcrel_hi3:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI7_0)
; RV64I-LARGE-NEXT:    ld a2, %pcrel_lo(.Lpcrel_hi3)(a0)
; RV64I-LARGE-NEXT:    mv a0, s0
; RV64I-LARGE-NEXT:    jalr a2
; RV64I-LARGE-NEXT:    mv a0, s0
; RV64I-LARGE-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    addi sp, sp, 16
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: test_call_fastcc:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -16
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:    mv s0, a0
; RV64I-LARGE-ZICFILP-NEXT:  .Lpcrel_hi3:
; RV64I-LARGE-ZICFILP-NEXT:    auipc a0, %pcrel_hi(.LCPI7_0)
; RV64I-LARGE-ZICFILP-NEXT:    ld t2, %pcrel_lo(.Lpcrel_hi3)(a0)
; RV64I-LARGE-ZICFILP-NEXT:    mv a0, s0
; RV64I-LARGE-ZICFILP-NEXT:    jalr t2
; RV64I-LARGE-ZICFILP-NEXT:    mv a0, s0
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 16
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = call fastcc i32 @fastcc_function(i32 %a, i32 %b)
  ret i32 %a
}

declare i32 @external_many_args(i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) nounwind

define i32 @test_call_external_many_args(i32 %a) nounwind {
; CHECK-LABEL: test_call_external_many_args:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    sw a0, 0(sp)
; CHECK-NEXT:    sw a0, 4(sp)
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a4, a0
; CHECK-NEXT:    mv a5, a0
; CHECK-NEXT:    mv a6, a0
; CHECK-NEXT:    mv a7, a0
; CHECK-NEXT:    call external_many_args
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_external_many_args:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    sd a0, 0(sp)
; RV64I-NEXT:    sd a0, 8(sp)
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a2, a0
; RV64I-NEXT:    mv a3, a0
; RV64I-NEXT:    mv a4, a0
; RV64I-NEXT:    mv a5, a0
; RV64I-NEXT:    mv a6, a0
; RV64I-NEXT:    mv a7, a0
; RV64I-NEXT:    call external_many_args
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: test_call_external_many_args:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -32
; RV64I-SMALL-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    mv s0, a0
; RV64I-SMALL-NEXT:    sd a0, 0(sp)
; RV64I-SMALL-NEXT:    sd a0, 8(sp)
; RV64I-SMALL-NEXT:    mv a1, a0
; RV64I-SMALL-NEXT:    mv a2, a0
; RV64I-SMALL-NEXT:    mv a3, a0
; RV64I-SMALL-NEXT:    mv a4, a0
; RV64I-SMALL-NEXT:    mv a5, a0
; RV64I-SMALL-NEXT:    mv a6, a0
; RV64I-SMALL-NEXT:    mv a7, a0
; RV64I-SMALL-NEXT:    call external_many_args
; RV64I-SMALL-NEXT:    mv a0, s0
; RV64I-SMALL-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    addi sp, sp, 32
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: test_call_external_many_args:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -32
; RV64I-MEDIUM-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    mv s0, a0
; RV64I-MEDIUM-NEXT:    sd a0, 0(sp)
; RV64I-MEDIUM-NEXT:    sd a0, 8(sp)
; RV64I-MEDIUM-NEXT:    mv a1, a0
; RV64I-MEDIUM-NEXT:    mv a2, a0
; RV64I-MEDIUM-NEXT:    mv a3, a0
; RV64I-MEDIUM-NEXT:    mv a4, a0
; RV64I-MEDIUM-NEXT:    mv a5, a0
; RV64I-MEDIUM-NEXT:    mv a6, a0
; RV64I-MEDIUM-NEXT:    mv a7, a0
; RV64I-MEDIUM-NEXT:    call external_many_args
; RV64I-MEDIUM-NEXT:    mv a0, s0
; RV64I-MEDIUM-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    addi sp, sp, 32
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: test_call_external_many_args:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -32
; RV64I-LARGE-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:    mv s0, a0
; RV64I-LARGE-NEXT:  .Lpcrel_hi4:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI8_0)
; RV64I-LARGE-NEXT:    ld t1, %pcrel_lo(.Lpcrel_hi4)(a0)
; RV64I-LARGE-NEXT:    sd s0, 0(sp)
; RV64I-LARGE-NEXT:    sd s0, 8(sp)
; RV64I-LARGE-NEXT:    mv a0, s0
; RV64I-LARGE-NEXT:    mv a1, s0
; RV64I-LARGE-NEXT:    mv a2, s0
; RV64I-LARGE-NEXT:    mv a3, s0
; RV64I-LARGE-NEXT:    mv a4, s0
; RV64I-LARGE-NEXT:    mv a5, s0
; RV64I-LARGE-NEXT:    mv a6, s0
; RV64I-LARGE-NEXT:    mv a7, s0
; RV64I-LARGE-NEXT:    jalr t1
; RV64I-LARGE-NEXT:    mv a0, s0
; RV64I-LARGE-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    addi sp, sp, 32
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: test_call_external_many_args:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -32
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:    mv s0, a0
; RV64I-LARGE-ZICFILP-NEXT:  .Lpcrel_hi4:
; RV64I-LARGE-ZICFILP-NEXT:    auipc a0, %pcrel_hi(.LCPI8_0)
; RV64I-LARGE-ZICFILP-NEXT:    ld t2, %pcrel_lo(.Lpcrel_hi4)(a0)
; RV64I-LARGE-ZICFILP-NEXT:    sd s0, 0(sp)
; RV64I-LARGE-ZICFILP-NEXT:    sd s0, 8(sp)
; RV64I-LARGE-ZICFILP-NEXT:    mv a0, s0
; RV64I-LARGE-ZICFILP-NEXT:    mv a1, s0
; RV64I-LARGE-ZICFILP-NEXT:    mv a2, s0
; RV64I-LARGE-ZICFILP-NEXT:    mv a3, s0
; RV64I-LARGE-ZICFILP-NEXT:    mv a4, s0
; RV64I-LARGE-ZICFILP-NEXT:    mv a5, s0
; RV64I-LARGE-ZICFILP-NEXT:    mv a6, s0
; RV64I-LARGE-ZICFILP-NEXT:    mv a7, s0
; RV64I-LARGE-ZICFILP-NEXT:    jalr t2
; RV64I-LARGE-ZICFILP-NEXT:    mv a0, s0
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 32
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = call i32 @external_many_args(i32 %a, i32 %a, i32 %a, i32 %a, i32 %a,
                                    i32 %a, i32 %a, i32 %a, i32 %a, i32 %a)
  ret i32 %a
}

define i32 @defined_many_args(i32, i32, i32, i32, i32, i32, i32, i32, i32, i32 %j) nounwind {
; CHECK-LABEL: defined_many_args:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw a0, 4(sp)
; CHECK-NEXT:    addi a0, a0, 1
; CHECK-NEXT:    ret
;
; RV64I-LABEL: defined_many_args:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lw a0, 8(sp)
; RV64I-NEXT:    addiw a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: defined_many_args:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    lw a0, 8(sp)
; RV64I-SMALL-NEXT:    addiw a0, a0, 1
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: defined_many_args:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    lw a0, 8(sp)
; RV64I-MEDIUM-NEXT:    addiw a0, a0, 1
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: defined_many_args:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    lw a0, 8(sp)
; RV64I-LARGE-NEXT:    addiw a0, a0, 1
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: defined_many_args:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    lw a0, 8(sp)
; RV64I-LARGE-ZICFILP-NEXT:    addiw a0, a0, 1
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %added = add i32 %j, 1
  ret i32 %added
}

define i32 @test_call_defined_many_args(i32 %a) nounwind {
; CHECK-LABEL: test_call_defined_many_args:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw a0, 0(sp)
; CHECK-NEXT:    sw a0, 4(sp)
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a4, a0
; CHECK-NEXT:    mv a5, a0
; CHECK-NEXT:    mv a6, a0
; CHECK-NEXT:    mv a7, a0
; CHECK-NEXT:    call defined_many_args
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_defined_many_args:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a0, 0(sp)
; RV64I-NEXT:    sd a0, 8(sp)
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a2, a0
; RV64I-NEXT:    mv a3, a0
; RV64I-NEXT:    mv a4, a0
; RV64I-NEXT:    mv a5, a0
; RV64I-NEXT:    mv a6, a0
; RV64I-NEXT:    mv a7, a0
; RV64I-NEXT:    call defined_many_args
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: test_call_defined_many_args:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -32
; RV64I-SMALL-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    sd a0, 0(sp)
; RV64I-SMALL-NEXT:    sd a0, 8(sp)
; RV64I-SMALL-NEXT:    mv a1, a0
; RV64I-SMALL-NEXT:    mv a2, a0
; RV64I-SMALL-NEXT:    mv a3, a0
; RV64I-SMALL-NEXT:    mv a4, a0
; RV64I-SMALL-NEXT:    mv a5, a0
; RV64I-SMALL-NEXT:    mv a6, a0
; RV64I-SMALL-NEXT:    mv a7, a0
; RV64I-SMALL-NEXT:    call defined_many_args
; RV64I-SMALL-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    addi sp, sp, 32
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: test_call_defined_many_args:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -32
; RV64I-MEDIUM-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    sd a0, 0(sp)
; RV64I-MEDIUM-NEXT:    sd a0, 8(sp)
; RV64I-MEDIUM-NEXT:    mv a1, a0
; RV64I-MEDIUM-NEXT:    mv a2, a0
; RV64I-MEDIUM-NEXT:    mv a3, a0
; RV64I-MEDIUM-NEXT:    mv a4, a0
; RV64I-MEDIUM-NEXT:    mv a5, a0
; RV64I-MEDIUM-NEXT:    mv a6, a0
; RV64I-MEDIUM-NEXT:    mv a7, a0
; RV64I-MEDIUM-NEXT:    call defined_many_args
; RV64I-MEDIUM-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    addi sp, sp, 32
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: test_call_defined_many_args:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -32
; RV64I-LARGE-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:  .Lpcrel_hi5:
; RV64I-LARGE-NEXT:    auipc a1, %pcrel_hi(.LCPI10_0)
; RV64I-LARGE-NEXT:    ld t1, %pcrel_lo(.Lpcrel_hi5)(a1)
; RV64I-LARGE-NEXT:    sd a0, 0(sp)
; RV64I-LARGE-NEXT:    sd a0, 8(sp)
; RV64I-LARGE-NEXT:    mv a1, a0
; RV64I-LARGE-NEXT:    mv a2, a0
; RV64I-LARGE-NEXT:    mv a3, a0
; RV64I-LARGE-NEXT:    mv a4, a0
; RV64I-LARGE-NEXT:    mv a5, a0
; RV64I-LARGE-NEXT:    mv a6, a0
; RV64I-LARGE-NEXT:    mv a7, a0
; RV64I-LARGE-NEXT:    jalr t1
; RV64I-LARGE-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    addi sp, sp, 32
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: test_call_defined_many_args:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -32
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:  .Lpcrel_hi5:
; RV64I-LARGE-ZICFILP-NEXT:    auipc a1, %pcrel_hi(.LCPI10_0)
; RV64I-LARGE-ZICFILP-NEXT:    ld t2, %pcrel_lo(.Lpcrel_hi5)(a1)
; RV64I-LARGE-ZICFILP-NEXT:    sd a0, 0(sp)
; RV64I-LARGE-ZICFILP-NEXT:    sd a0, 8(sp)
; RV64I-LARGE-ZICFILP-NEXT:    mv a1, a0
; RV64I-LARGE-ZICFILP-NEXT:    mv a2, a0
; RV64I-LARGE-ZICFILP-NEXT:    mv a3, a0
; RV64I-LARGE-ZICFILP-NEXT:    mv a4, a0
; RV64I-LARGE-ZICFILP-NEXT:    mv a5, a0
; RV64I-LARGE-ZICFILP-NEXT:    mv a6, a0
; RV64I-LARGE-ZICFILP-NEXT:    mv a7, a0
; RV64I-LARGE-ZICFILP-NEXT:    jalr t2
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 32
; RV64I-LARGE-ZICFILP-NEXT:    ret
  %1 = call i32 @defined_many_args(i32 %a, i32 %a, i32 %a, i32 %a, i32 %a,
                                   i32 %a, i32 %a, i32 %a, i32 %a, i32 %a)
  ret i32 %1
}

define fastcc void @fastcc_call_nonfastcc(){
; CHECK-LABEL: fastcc_call_nonfastcc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -4
; CHECK-NEXT:    li t0, 10
; CHECK-NEXT:    li t1, 9
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    li a1, 2
; CHECK-NEXT:    li a2, 3
; CHECK-NEXT:    li a3, 4
; CHECK-NEXT:    li a4, 5
; CHECK-NEXT:    li a5, 6
; CHECK-NEXT:    li a6, 7
; CHECK-NEXT:    li a7, 8
; CHECK-NEXT:    sw t1, 0(sp)
; CHECK-NEXT:    sw t0, 4(sp)
; CHECK-NEXT:    call external_many_args
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    .cfi_restore ra
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
;
; RV64I-LABEL: fastcc_call_nonfastcc:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    .cfi_def_cfa_offset 32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    li t0, 10
; RV64I-NEXT:    li t1, 9
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    li a1, 2
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    li a5, 6
; RV64I-NEXT:    li a6, 7
; RV64I-NEXT:    li a7, 8
; RV64I-NEXT:    sd t1, 0(sp)
; RV64I-NEXT:    sd t0, 8(sp)
; RV64I-NEXT:    call external_many_args
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-SMALL-LABEL: fastcc_call_nonfastcc:
; RV64I-SMALL:       # %bb.0:
; RV64I-SMALL-NEXT:    addi sp, sp, -32
; RV64I-SMALL-NEXT:    .cfi_def_cfa_offset 32
; RV64I-SMALL-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-SMALL-NEXT:    .cfi_offset ra, -8
; RV64I-SMALL-NEXT:    li t0, 10
; RV64I-SMALL-NEXT:    li t1, 9
; RV64I-SMALL-NEXT:    li a0, 1
; RV64I-SMALL-NEXT:    li a1, 2
; RV64I-SMALL-NEXT:    li a2, 3
; RV64I-SMALL-NEXT:    li a3, 4
; RV64I-SMALL-NEXT:    li a4, 5
; RV64I-SMALL-NEXT:    li a5, 6
; RV64I-SMALL-NEXT:    li a6, 7
; RV64I-SMALL-NEXT:    li a7, 8
; RV64I-SMALL-NEXT:    sd t1, 0(sp)
; RV64I-SMALL-NEXT:    sd t0, 8(sp)
; RV64I-SMALL-NEXT:    call external_many_args
; RV64I-SMALL-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-SMALL-NEXT:    .cfi_restore ra
; RV64I-SMALL-NEXT:    addi sp, sp, 32
; RV64I-SMALL-NEXT:    .cfi_def_cfa_offset 0
; RV64I-SMALL-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: fastcc_call_nonfastcc:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi sp, sp, -32
; RV64I-MEDIUM-NEXT:    .cfi_def_cfa_offset 32
; RV64I-MEDIUM-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-MEDIUM-NEXT:    .cfi_offset ra, -8
; RV64I-MEDIUM-NEXT:    li t0, 10
; RV64I-MEDIUM-NEXT:    li t1, 9
; RV64I-MEDIUM-NEXT:    li a0, 1
; RV64I-MEDIUM-NEXT:    li a1, 2
; RV64I-MEDIUM-NEXT:    li a2, 3
; RV64I-MEDIUM-NEXT:    li a3, 4
; RV64I-MEDIUM-NEXT:    li a4, 5
; RV64I-MEDIUM-NEXT:    li a5, 6
; RV64I-MEDIUM-NEXT:    li a6, 7
; RV64I-MEDIUM-NEXT:    li a7, 8
; RV64I-MEDIUM-NEXT:    sd t1, 0(sp)
; RV64I-MEDIUM-NEXT:    sd t0, 8(sp)
; RV64I-MEDIUM-NEXT:    call external_many_args
; RV64I-MEDIUM-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-MEDIUM-NEXT:    .cfi_restore ra
; RV64I-MEDIUM-NEXT:    addi sp, sp, 32
; RV64I-MEDIUM-NEXT:    .cfi_def_cfa_offset 0
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: fastcc_call_nonfastcc:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi sp, sp, -32
; RV64I-LARGE-NEXT:    .cfi_def_cfa_offset 32
; RV64I-LARGE-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-LARGE-NEXT:    .cfi_offset ra, -8
; RV64I-LARGE-NEXT:    li t0, 10
; RV64I-LARGE-NEXT:    li t1, 9
; RV64I-LARGE-NEXT:  .Lpcrel_hi6:
; RV64I-LARGE-NEXT:    auipc a5, %pcrel_hi(.LCPI11_0)
; RV64I-LARGE-NEXT:    li a0, 1
; RV64I-LARGE-NEXT:    li a1, 2
; RV64I-LARGE-NEXT:    li a2, 3
; RV64I-LARGE-NEXT:    li a3, 4
; RV64I-LARGE-NEXT:    li a4, 5
; RV64I-LARGE-NEXT:    ld t2, %pcrel_lo(.Lpcrel_hi6)(a5)
; RV64I-LARGE-NEXT:    li a5, 6
; RV64I-LARGE-NEXT:    li a6, 7
; RV64I-LARGE-NEXT:    li a7, 8
; RV64I-LARGE-NEXT:    sd t1, 0(sp)
; RV64I-LARGE-NEXT:    sd t0, 8(sp)
; RV64I-LARGE-NEXT:    jalr t2
; RV64I-LARGE-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-LARGE-NEXT:    .cfi_restore ra
; RV64I-LARGE-NEXT:    addi sp, sp, 32
; RV64I-LARGE-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LARGE-NEXT:    ret
;
; RV64I-LARGE-ZICFILP-LABEL: fastcc_call_nonfastcc:
; RV64I-LARGE-ZICFILP:       # %bb.0:
; RV64I-LARGE-ZICFILP-NEXT:    lpad 0
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, -32
; RV64I-LARGE-ZICFILP-NEXT:    .cfi_def_cfa_offset 32
; RV64I-LARGE-ZICFILP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-LARGE-ZICFILP-NEXT:    .cfi_offset ra, -8
; RV64I-LARGE-ZICFILP-NEXT:    li t0, 10
; RV64I-LARGE-ZICFILP-NEXT:    li t1, 9
; RV64I-LARGE-ZICFILP-NEXT:  .Lpcrel_hi6:
; RV64I-LARGE-ZICFILP-NEXT:    auipc a5, %pcrel_hi(.LCPI11_0)
; RV64I-LARGE-ZICFILP-NEXT:    li a0, 1
; RV64I-LARGE-ZICFILP-NEXT:    li a1, 2
; RV64I-LARGE-ZICFILP-NEXT:    li a2, 3
; RV64I-LARGE-ZICFILP-NEXT:    li a3, 4
; RV64I-LARGE-ZICFILP-NEXT:    li a4, 5
; RV64I-LARGE-ZICFILP-NEXT:    ld t2, %pcrel_lo(.Lpcrel_hi6)(a5)
; RV64I-LARGE-ZICFILP-NEXT:    li a5, 6
; RV64I-LARGE-ZICFILP-NEXT:    li a6, 7
; RV64I-LARGE-ZICFILP-NEXT:    li a7, 8
; RV64I-LARGE-ZICFILP-NEXT:    sd t1, 0(sp)
; RV64I-LARGE-ZICFILP-NEXT:    sd t0, 8(sp)
; RV64I-LARGE-ZICFILP-NEXT:    jalr t2
; RV64I-LARGE-ZICFILP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-LARGE-ZICFILP-NEXT:    .cfi_restore ra
; RV64I-LARGE-ZICFILP-NEXT:    addi sp, sp, 32
; RV64I-LARGE-ZICFILP-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LARGE-ZICFILP-NEXT:    ret
  call void @external_many_args(i32 1, i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10)
  ret void
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32I: {{.*}}
; RV32I-PIC: {{.*}}
