; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-unknown-linux-gnu %s -o - | FileCheck %s

; Purpose: With BTI enabled, the landing pad (%lpad) begins with an EH_LABEL and the
; first *executed* instruction is `bti j`. (BTI is inserted *after* the EH label and meta.)

declare i32 @__gxx_personality_v0(...)
declare void @may_throw()

define void @test() #0 personality ptr @__gxx_personality_v0 {
; CHECK-LABEL: test:
; CHECK:       .Lfunc_begin0:
; CHECK-NEXT:    .cfi_startproc
; CHECK-NEXT:    .cfi_personality 156, DW.ref.__gxx_personality_v0
; CHECK-NEXT:    .cfi_lsda 28, .Lexception0
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    bti c
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:  .Ltmp0:
; CHECK-NEXT:    bl may_throw
; CHECK-NEXT:  .Ltmp1:
; CHECK-NEXT:  // %bb.1: // %common.ret
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB0_2: // %lpad
; CHECK-NEXT:  .Ltmp2:
; CHECK-NEXT:    bti j
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  invoke void @may_throw()
          to label %ret unwind label %lpad

lpad:
  landingpad { ptr, i32 } cleanup
  ret void

ret:
  ret void
}

attributes #0 = { noinline "branch-target-enforcement"="true" "target-features"="+bti" }
