; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=aarch64-linux-gnu -passes=atomic-expand %s | FileCheck %s

define float @test_atomicrmw_fadd_f32(ptr %ptr, float %value) {
; CHECK-LABEL: @test_atomicrmw_fadd_f32(
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CHECK-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret float [[TMP5]]
;
  %res = atomicrmw fadd ptr %ptr, float %value seq_cst
  ret float %res
}

define float @test_atomicrmw_fsub_f32(ptr %ptr, float %value) {
; CHECK-LABEL: @test_atomicrmw_fsub_f32(
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[NEW:%.*]] = fsub float [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CHECK-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret float [[TMP5]]
;
  %res = atomicrmw fsub ptr %ptr, float %value seq_cst
  ret float %res
}

define float @atomicrmw_fmin_float(ptr %ptr, float %value) {
; CHECK-LABEL: @atomicrmw_fmin_float(
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call float @llvm.minnum.f32(float [[LOADED]], float [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret float [[TMP6]]
;
  %res = atomicrmw fmin ptr %ptr, float %value seq_cst
  ret float %res
}

define float @atomicrmw_fmax_float(ptr %ptr, float %value) {
; CHECK-LABEL: @atomicrmw_fmax_float(
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call float @llvm.maxnum.f32(float [[LOADED]], float [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret float [[TMP6]]
;
  %res = atomicrmw fmax ptr %ptr, float %value seq_cst
  ret float %res
}

define double @atomicrmw_fmin_double(ptr %ptr, double %value) {
; CHECK-LABEL: @atomicrmw_fmin_double(
; CHECK-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call double @llvm.minnum.f64(double [[LOADED]], double [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast double [[TMP2]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast double [[LOADED]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP4]], i64 [[TMP3]] seq_cst seq_cst, align 8
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i64 [[NEWLOADED]] to double
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret double [[TMP6]]
;
  %res = atomicrmw fmin ptr %ptr, double %value seq_cst
  ret double %res
}

define double @atomicrmw_fmax_double(ptr %ptr, double %value) {
; CHECK-LABEL: @atomicrmw_fmax_double(
; CHECK-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call double @llvm.maxnum.f64(double [[LOADED]], double [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast double [[TMP2]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast double [[LOADED]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP4]], i64 [[TMP3]] seq_cst seq_cst, align 8
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i64 [[NEWLOADED]] to double
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret double [[TMP6]]
;
  %res = atomicrmw fmax ptr %ptr, double %value seq_cst
  ret double %res
}

define float @atomicrmw_fminimum_float(ptr %ptr, float %value) {
; CHECK-LABEL: @atomicrmw_fminimum_float(
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call float @llvm.minimum.f32(float [[LOADED]], float [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret float [[TMP6]]
;
  %res = atomicrmw fminimum ptr %ptr, float %value seq_cst
  ret float %res
}

define float @atomicrmw_fmaximum_float(ptr %ptr, float %value) {
; CHECK-LABEL: @atomicrmw_fmaximum_float(
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call float @llvm.maximum.f32(float [[LOADED]], float [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret float [[TMP6]]
;
  %res = atomicrmw fmaximum ptr %ptr, float %value seq_cst
  ret float %res
}

define double @atomicrmw_fminimum_double(ptr %ptr, double %value) {
; CHECK-LABEL: @atomicrmw_fminimum_double(
; CHECK-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call double @llvm.minimum.f64(double [[LOADED]], double [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast double [[TMP2]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast double [[LOADED]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP4]], i64 [[TMP3]] seq_cst seq_cst, align 8
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i64 [[NEWLOADED]] to double
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret double [[TMP6]]
;
  %res = atomicrmw fminimum ptr %ptr, double %value seq_cst
  ret double %res
}

define double @atomicrmw_fmaximum_double(ptr %ptr, double %value) {
; CHECK-LABEL: @atomicrmw_fmaximum_double(
; CHECK-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call double @llvm.maximum.f64(double [[LOADED]], double [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast double [[TMP2]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast double [[LOADED]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP4]], i64 [[TMP3]] seq_cst seq_cst, align 8
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i64 [[NEWLOADED]] to double
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret double [[TMP6]]
;
  %res = atomicrmw fmaximum ptr %ptr, double %value seq_cst
  ret double %res
}

define bfloat @atomicrmw_fmaximum_bfloat(ptr %ptr, bfloat %val) {
; CHECK-LABEL: @atomicrmw_fmaximum_bfloat(
; CHECK-NEXT:    [[TMP1:%.*]] = load bfloat, ptr [[PTR:%.*]], align 2
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi bfloat [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call bfloat @llvm.maximum.bf16(bfloat [[LOADED]], bfloat [[VAL:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast bfloat [[TMP2]] to i16
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast bfloat [[LOADED]] to i16
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i16 [[TMP4]], i16 [[TMP3]] seq_cst seq_cst, align 2
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i16, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i16 [[NEWLOADED]] to bfloat
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret bfloat [[TMP6]]
;
  %res = atomicrmw fmaximum ptr %ptr, bfloat %val seq_cst
  ret bfloat %res
}

define half @atomicrmw_fmaximum_half(ptr %ptr, half %val) {
; CHECK-LABEL: @atomicrmw_fmaximum_half(
; CHECK-NEXT:    [[TMP1:%.*]] = load half, ptr [[PTR:%.*]], align 2
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi half [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call half @llvm.maximum.f16(half [[LOADED]], half [[VAL:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast half [[TMP2]] to i16
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast half [[LOADED]] to i16
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i16 [[TMP4]], i16 [[TMP3]] seq_cst seq_cst, align 2
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i16, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i16 [[NEWLOADED]] to half
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret half [[TMP6]]
;
  %res = atomicrmw fmaximum ptr %ptr, half %val seq_cst
  ret half %res
}

define <2 x half> @atomicrmw_fmaximum_2_x_half(ptr %ptr, <2 x half> %val) {
; CHECK-LABEL: @atomicrmw_fmaximum_2_x_half(
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x half>, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi <2 x half> [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x half> @llvm.maximum.v2f16(<2 x half> [[LOADED]], <2 x half> [[VAL:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <2 x half> [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <2 x half> [[LOADED]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to <2 x half>
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret <2 x half> [[TMP6]]
;
  %res = atomicrmw fmaximum ptr %ptr, <2 x half> %val seq_cst
  ret <2 x half> %res
}

define bfloat @atomicrmw_fminimum_bfloat(ptr %ptr, bfloat %val) {
; CHECK-LABEL: @atomicrmw_fminimum_bfloat(
; CHECK-NEXT:    [[TMP1:%.*]] = load bfloat, ptr [[PTR:%.*]], align 2
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi bfloat [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call bfloat @llvm.minimum.bf16(bfloat [[LOADED]], bfloat [[VAL:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast bfloat [[TMP2]] to i16
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast bfloat [[LOADED]] to i16
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i16 [[TMP4]], i16 [[TMP3]] seq_cst seq_cst, align 2
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i16, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i16 [[NEWLOADED]] to bfloat
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret bfloat [[TMP6]]
;
  %res = atomicrmw fminimum ptr %ptr, bfloat %val seq_cst
  ret bfloat %res
}

define half @atomicrmw_fminimum_half(ptr %ptr, half %val) {
; CHECK-LABEL: @atomicrmw_fminimum_half(
; CHECK-NEXT:    [[TMP1:%.*]] = load half, ptr [[PTR:%.*]], align 2
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi half [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call half @llvm.minimum.f16(half [[LOADED]], half [[VAL:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast half [[TMP2]] to i16
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast half [[LOADED]] to i16
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i16 [[TMP4]], i16 [[TMP3]] seq_cst seq_cst, align 2
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i16, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i16 [[NEWLOADED]] to half
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret half [[TMP6]]
;
  %res = atomicrmw fminimum ptr %ptr, half %val seq_cst
  ret half %res
}

define <2 x half> @atomicrmw_fminimum_2_x_half(ptr %ptr, <2 x half> %val) {
; CHECK-LABEL: @atomicrmw_fminimum_2_x_half(
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x half>, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi <2 x half> [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x half> @llvm.minimum.v2f16(<2 x half> [[LOADED]], <2 x half> [[VAL:%.*]])
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <2 x half> [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <2 x half> [[LOADED]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; CHECK-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; CHECK-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to <2 x half>
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret <2 x half> [[TMP6]]
;
  %res = atomicrmw fminimum ptr %ptr, <2 x half> %val seq_cst
  ret <2 x half> %res
}
