; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=CHECK,X64

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/avx512vl-builtins.c

define <4 x float> @test_mm_mask_cvtepi32_ps(<4 x float> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_cvtepi32_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtdq2ps %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtepi32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtdq2ps %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i.i = sitofp <4 x i32> %0 to <4 x float>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %conv.i.i, <4 x float> %__W
  ret <4 x float> %2
}

define <4 x float> @test_mm_maskz_cvtepi32_ps(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_cvtepi32_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtdq2ps %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtepi32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtdq2ps %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i.i = sitofp <4 x i32> %0 to <4 x float>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %conv.i.i, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <8 x float> @test_mm256_mask_cvtepi32_ps(<8 x float> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_cvtepi32_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtdq2ps %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepi32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtdq2ps %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %conv.i.i = sitofp <8 x i32> %0 to <8 x float>
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %conv.i.i, <8 x float> %__W
  ret <8 x float> %2
}

define <8 x float> @test_mm256_maskz_cvtepi32_ps(i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_cvtepi32_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtdq2ps %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepi32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtdq2ps %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %conv.i.i = sitofp <8 x i32> %0 to <8 x float>
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %conv.i.i, <8 x float> zeroinitializer
  ret <8 x float> %2
}

define <2 x i64> @test_mm_mask_cvtpd_epi32(<2 x i64> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_mask_cvtpd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2dq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2dq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2dq.128(<2 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvtpd_epi32(i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_maskz_cvtpd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2dq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2dq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2dq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvtpd_epi32(<2 x i64> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_mask_cvtpd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2dq %ymm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2dq %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double> %__A) #8
  %1 = bitcast <2 x i64> %__W to <4 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm256_maskz_cvtpd_epi32(i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_maskz_cvtpd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2dq %ymm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2dq %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x float> @test_mm_mask_cvtpd_ps(<4 x float> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_mask_cvtpd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2ps %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtpd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2ps %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.avx512.mask.cvtpd2ps(<2 x double> %__A, <4 x float> %__W, i8 %__U) #8
  ret <4 x float> %0
}

define <4 x float> @test_mm_maskz_cvtpd_ps(i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_maskz_cvtpd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2ps %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtpd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2ps %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.avx512.mask.cvtpd2ps(<2 x double> %__A, <4 x float> zeroinitializer, i8 %__U) #8
  ret <4 x float> %0
}

define <4 x float> @test_mm256_mask_cvtpd_ps(<4 x float> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_mask_cvtpd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2ps %ymm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtpd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2ps %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.avx.cvt.pd2.ps.256(<4 x double> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__W
  ret <4 x float> %2
}

define <4 x float> @test_mm256_maskz_cvtpd_ps(i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_maskz_cvtpd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2ps %ymm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtpd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2ps %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.avx.cvt.pd2.ps.256(<4 x double> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <2 x i64> @test_mm_cvtpd_epu32(<2 x double> %__A) {
; CHECK-LABEL: test_mm_cvtpd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtpd2udq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvtpd_epu32(<2 x i64> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_mask_cvtpd_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2udq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2udq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.128(<2 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvtpd_epu32(i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_maskz_cvtpd_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2udq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2udq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_cvtpd_epu32(<4 x double> %__A) {
; CHECK-LABEL: test_mm256_cvtpd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtpd2udq %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.256(<4 x double> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvtpd_epu32(<2 x i64> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_mask_cvtpd_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2udq %ymm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2udq %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.256(<4 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm256_maskz_cvtpd_epu32(i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_maskz_cvtpd_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtpd2udq %ymm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2udq %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.256(<4 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <4 x float> @test_mm_mask_cvtph_ps(<4 x float> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_cvtph_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtph2ps %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtph_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtph2ps %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <8 x i16>
  %1 = shufflevector <8 x i16> %0, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = bitcast <4 x i16> %1 to <4 x half>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = fpext <4 x half> %2 to <4 x float>
  %6 = select <4 x i1> %4, <4 x float> %5, <4 x float> %__W
  ret <4 x float> %6
}

define <4 x float> @test_mm_maskz_cvtph_ps(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_cvtph_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtph2ps %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtph_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtph2ps %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <8 x i16>
  %1 = shufflevector <8 x i16> %0, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = bitcast <4 x i16> %1 to <4 x half>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = fpext <4 x half> %2 to <4 x float>
  %6 = select <4 x i1> %4, <4 x float> %5, <4 x float> zeroinitializer
  ret <4 x float> %6
}

define <8 x float> @test_mm256_mask_cvtph_ps(<8 x float> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm256_mask_cvtph_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtph2ps %xmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtph_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtph2ps %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <8 x i16>
  %1 = bitcast <8 x i16> %0 to <8 x half>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = fpext <8 x half> %1 to <8 x float>
  %4 = select <8 x i1> %2, <8 x float> %3, <8 x float> %__W
  ret <8 x float> %4
}

define <8 x float> @test_mm256_maskz_cvtph_ps(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_cvtph_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtph2ps %xmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtph_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtph2ps %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <8 x i16>
  %1 = bitcast <8 x i16> %0 to <8 x half>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = fpext <8 x half> %1 to <8 x float>
  %4 = select <8 x i1> %2, <8 x float> %3, <8 x float> zeroinitializer
  ret <8 x float> %4
}

define <2 x i64> @test_mm_mask_cvtps_epi32(<2 x i64> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_cvtps_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2dq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2dq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float> %__A) #8
  %1 = bitcast <2 x i64> %__W to <4 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_maskz_cvtps_epi32(i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_maskz_cvtps_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2dq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2dq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @test_mm256_mask_cvtps_epi32(<4 x i64> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_mask_cvtps_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2dq %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2dq %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float> %__A) #8
  %1 = bitcast <4 x i64> %__W to <8 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_cvtps_epi32(i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_maskz_cvtps_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2dq %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2dq %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> %0, <8 x i32> zeroinitializer
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <2 x double> @test_mm_mask_cvtps_pd(<2 x double> %__W, i8 zeroext %__U, <4 x float> %__A) local_unnamed_addr #0 {
; X86-LABEL: test_mm_mask_cvtps_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2pd %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <2 x i32> <i32 0, i32 1>
  %conv.i.i = fpext <2 x float> %shuffle.i.i to <2 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> %__W
  ret <2 x double> %1
}

define <2 x double> @test_mm_maskz_cvtps_pd(i8 zeroext %__U, <4 x float> %__A) local_unnamed_addr #0 {
; X86-LABEL: test_mm_maskz_cvtps_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2pd %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <2 x i32> <i32 0, i32 1>
  %conv.i.i = fpext <2 x float> %shuffle.i.i to <2 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> zeroinitializer
  ret <2 x double> %1
}

define <4 x double> @test_mm256_mask_cvtps_pd(<4 x double> %__W, i8 zeroext %__U, <4 x float> %__A) local_unnamed_addr #0 {
; X86-LABEL: test_mm256_mask_cvtps_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2pd %xmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i.i = fpext <4 x float> %__A to <4 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_cvtps_pd(i8 zeroext %__U, <4 x float> %__A) local_unnamed_addr #0 {
; X86-LABEL: test_mm256_maskz_cvtps_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2pd %xmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i.i = fpext <4 x float> %__A to <4 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <2 x i64> @test_mm_cvtps_epu32(<4 x float> %__A) {
; CHECK-LABEL: test_mm_cvtps_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtps2udq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtps2udq.128(<4 x float> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvtps_epu32(<2 x i64> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_cvtps_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2udq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2udq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtps2udq.128(<4 x float> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvtps_epu32(i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_maskz_cvtps_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2udq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2udq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtps2udq.128(<4 x float> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <4 x i64> @test_mm256_cvtps_epu32(<8 x float> %__A) {
; CHECK-LABEL: test_mm256_cvtps_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtps2udq %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx512.mask.cvtps2udq.256(<8 x float> %__A, <8 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_mask_cvtps_epu32(<4 x i64> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_mask_cvtps_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2udq %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2udq %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__W to <8 x i32>
  %1 = tail call <8 x i32> @llvm.x86.avx512.mask.cvtps2udq.256(<8 x float> %__A, <8 x i32> %0, i8 %__U) #8
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_cvtps_epu32(i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_maskz_cvtps_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2udq %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2udq %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx512.mask.cvtps2udq.256(<8 x float> %__A, <8 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <2 x i64> @test_mm_mask_cvttpd_epi32(<2 x i64> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_mask_cvttpd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttpd2dq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvttpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2dq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2dq.128(<2 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvttpd_epi32(i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_maskz_cvttpd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttpd2dq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvttpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2dq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2dq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvttpd_epi32(<2 x i64> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_mask_cvttpd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttpd2dq %ymm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvttpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2dq %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx.cvtt.pd2dq.256(<4 x double> %__A) #8
  %1 = bitcast <2 x i64> %__W to <4 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm256_maskz_cvttpd_epi32(i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_maskz_cvttpd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttpd2dq %ymm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvttpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2dq %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx.cvtt.pd2dq.256(<4 x double> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm_cvttpd_epu32(<2 x double> %__A) {
; CHECK-LABEL: test_mm_cvttpd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttpd2udq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvttpd_epu32(<2 x i64> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_mask_cvttpd_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttpd2udq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2udq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.128(<2 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvttpd_epu32(i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_maskz_cvttpd_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttpd2udq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2udq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_cvttpd_epu32(<4 x double> %__A) {
; CHECK-LABEL: test_mm256_cvttpd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttpd2udq %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.256(<4 x double> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvttpd_epu32(<2 x i64> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_mask_cvttpd_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttpd2udq %ymm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2udq %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.256(<4 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm256_maskz_cvttpd_epu32(i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_maskz_cvttpd_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttpd2udq %ymm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2udq %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.256(<4 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvttps_epi32(<2 x i64> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_cvttps_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttps2dq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvttps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2dq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float> %__A) #8
  %1 = bitcast <2 x i64> %__W to <4 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_maskz_cvttps_epi32(i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_maskz_cvttps_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttps2dq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvttps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2dq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @test_mm256_mask_cvttps_epi32(<4 x i64> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_mask_cvttps_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttps2dq %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvttps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2dq %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx.cvtt.ps2dq.256(<8 x float> %__A) #8
  %1 = bitcast <4 x i64> %__W to <8 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_cvttps_epi32(i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_maskz_cvttps_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttps2dq %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvttps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2dq %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx.cvtt.ps2dq.256(<8 x float> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> %0, <8 x i32> zeroinitializer
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <2 x i64> @test_mm_cvttps_epu32(<4 x float> %__A) {
; CHECK-LABEL: test_mm_cvttps_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttps2udq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttps2udq.128(<4 x float> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvttps_epu32(<2 x i64> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_cvttps_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttps2udq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2udq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttps2udq.128(<4 x float> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvttps_epu32(i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_maskz_cvttps_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttps2udq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2udq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttps2udq.128(<4 x float> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <4 x i64> @test_mm256_cvttps_epu32(<8 x float> %__A) {
; CHECK-LABEL: test_mm256_cvttps_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttps2udq %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx512.mask.cvttps2udq.256(<8 x float> %__A, <8 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_mask_cvttps_epu32(<4 x i64> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_mask_cvttps_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttps2udq %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2udq %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__W to <8 x i32>
  %1 = tail call <8 x i32> @llvm.x86.avx512.mask.cvttps2udq.256(<8 x float> %__A, <8 x i32> %0, i8 %__U) #8
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_cvttps_epu32(i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_maskz_cvttps_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvttps2udq %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2udq %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx512.mask.cvttps2udq.256(<8 x float> %__A, <8 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <2 x double> @test_mm_cvtepu32_pd(<2 x i64> %__A) local_unnamed_addr #0 {
; CHECK-LABEL: test_mm_cvtepu32_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtudq2pd %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %shuffle.i = shufflevector <4 x i32> %0, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %conv.i = uitofp <2 x i32> %shuffle.i to <2 x double>
  ret <2 x double> %conv.i
}

define <2 x double> @test_mm_mask_cvtepu32_pd(<2 x double> %__W, i8 zeroext %__U, <2 x i64> %__A) local_unnamed_addr #0 {
; X86-LABEL: test_mm_mask_cvtepu32_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtudq2pd %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2pd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %shuffle.i.i = shufflevector <4 x i32> %0, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %conv.i.i = uitofp <2 x i32> %shuffle.i.i to <2 x double>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> %__W
  ret <2 x double> %2
}

define <2 x double> @test_mm_maskz_cvtepu32_pd(i8 zeroext %__U, <2 x i64> %__A) local_unnamed_addr #0 {
; X86-LABEL: test_mm_maskz_cvtepu32_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtudq2pd %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2pd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %shuffle.i.i = shufflevector <4 x i32> %0, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %conv.i.i = uitofp <2 x i32> %shuffle.i.i to <2 x double>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> zeroinitializer
  ret <2 x double> %2
}

define <4 x double> @test_mm256_cvtepu32_pd(<2 x i64> %__A) local_unnamed_addr #0 {
; CHECK-LABEL: test_mm256_cvtepu32_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtudq2pd %xmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i = uitofp <4 x i32> %0 to <4 x double>
  ret <4 x double> %conv.i
}

define <4 x double> @test_mm256_mask_cvtepu32_pd(<4 x double> %__W, i8 zeroext %__U, <2 x i64> %__A) local_unnamed_addr #0 {
; X86-LABEL: test_mm256_mask_cvtepu32_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtudq2pd %xmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2pd %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i.i = uitofp <4 x i32> %0 to <4 x double>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> %__W
  ret <4 x double> %2
}

define <4 x double> @test_mm256_maskz_cvtepu32_pd(i8 zeroext %__U, <2 x i64> %__A) local_unnamed_addr #0 {
; X86-LABEL: test_mm256_maskz_cvtepu32_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtudq2pd %xmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2pd %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i.i = uitofp <4 x i32> %0 to <4 x double>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> zeroinitializer
  ret <4 x double> %2
}

define <4 x float> @test_mm_cvtepu32_ps(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_cvtepu32_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtudq2ps %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i = uitofp <4 x i32> %0 to <4 x float>
  ret <4 x float> %conv.i
}

define <4 x float> @test_mm_mask_cvtepu32_ps(<4 x float> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_cvtepu32_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtudq2ps %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2ps %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i.i = uitofp <4 x i32> %0 to <4 x float>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %conv.i.i, <4 x float> %__W
  ret <4 x float> %2
}

define <4 x float> @test_mm_maskz_cvtepu32_ps(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_cvtepu32_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtudq2ps %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2ps %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i.i = uitofp <4 x i32> %0 to <4 x float>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %conv.i.i, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <8 x float> @test_mm256_cvtepu32_ps(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_cvtepu32_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtudq2ps %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %conv.i = uitofp <8 x i32> %0 to <8 x float>
  ret <8 x float> %conv.i
}

define <8 x float> @test_mm256_mask_cvtepu32_ps(<8 x float> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_cvtepu32_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtudq2ps %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2ps %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %conv.i.i = uitofp <8 x i32> %0 to <8 x float>
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %conv.i.i, <8 x float> %__W
  ret <8 x float> %2
}

define <8 x float> @test_mm256_maskz_cvtepu32_ps(i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_cvtepu32_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtudq2ps %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2ps %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %conv.i.i = uitofp <8 x i32> %0 to <8 x float>
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %conv.i.i, <8 x float> zeroinitializer
  ret <8 x float> %2
}

define <8 x float> @test_mm256_shuffle_f32x4(<8 x float> %__A, <8 x float> %__B) {
; CHECK-LABEL: test_mm256_shuffle_f32x4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle = shufflevector <8 x float> %__A, <8 x float> %__B, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15>
  ret <8 x float> %shuffle
}

define <8 x float> @test_mm256_mask_shuffle_f32x4(<8 x float> %__W, i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; X86-LABEL: test_mm256_mask_shuffle_f32x4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshuff32x4 {{.*#+}} ymm0 {%k1} = ymm1[4,5,6,7],ymm2[4,5,6,7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_f32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff32x4 {{.*#+}} ymm0 {%k1} = ymm1[4,5,6,7],ymm2[4,5,6,7]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x float> %__A, <8 x float> %__B, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x float> %shuffle, <8 x float> %__W
  ret <8 x float> %1
}

define <8 x float> @test_mm256_maskz_shuffle_f32x4(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; X86-LABEL: test_mm256_maskz_shuffle_f32x4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshuff32x4 {{.*#+}} ymm0 {%k1} {z} = ymm0[4,5,6,7],ymm1[4,5,6,7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_f32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff32x4 {{.*#+}} ymm0 {%k1} {z} = ymm0[4,5,6,7],ymm1[4,5,6,7]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x float> %__A, <8 x float> %__B, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x float> %shuffle, <8 x float> zeroinitializer
  ret <8 x float> %1
}

define <4 x double> @test_mm256_shuffle_f64x2(<4 x double> %__A, <4 x double> %__B) {
; CHECK-LABEL: test_mm256_shuffle_f64x2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle = shufflevector <4 x double> %__A, <4 x double> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  ret <4 x double> %shuffle
}

define <4 x double> @test_mm256_mask_shuffle_f64x2(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; X86-LABEL: test_mm256_mask_shuffle_f64x2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshuff64x2 {{.*#+}} ymm0 {%k1} = ymm1[2,3],ymm2[2,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_f64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff64x2 {{.*#+}} ymm0 {%k1} = ymm1[2,3],ymm2[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x double> %__A, <4 x double> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x double> %shuffle, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_shuffle_f64x2(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; X86-LABEL: test_mm256_maskz_shuffle_f64x2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshuff64x2 {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3],ymm1[2,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_f64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff64x2 {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3],ymm1[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x double> %__A, <4 x double> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x double> %shuffle, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <4 x i64> @test_mm256_shuffle_i32x4(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_shuffle_i32x4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  ret <4 x i64> %shuffle
}

define <4 x i64> @test_mm256_mask_shuffle_i32x4(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_shuffle_i32x4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufi32x4 {{.*#+}} ymm0 {%k1} = ymm1[4,5,6,7],ymm2[4,5,6,7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_i32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi32x4 {{.*#+}} ymm0 {%k1} = ymm1[4,5,6,7],ymm2[4,5,6,7]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast <4 x i64> %shuffle to <8 x i32>
  %1 = bitcast <4 x i64> %__W to <8 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_shuffle_i32x4(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_maskz_shuffle_i32x4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufi32x4 {{.*#+}} ymm0 {%k1} {z} = ymm0[4,5,6,7],ymm1[4,5,6,7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_i32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi32x4 {{.*#+}} ymm0 {%k1} {z} = ymm0[4,5,6,7],ymm1[4,5,6,7]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast <4 x i64> %shuffle to <8 x i32>
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> %0, <8 x i32> zeroinitializer
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_mm256_shuffle_i64x2(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_shuffle_i64x2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  ret <4 x i64> %shuffle
}

define <4 x i64> @test_mm256_mask_shuffle_i64x2(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_shuffle_i64x2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufi64x2 {{.*#+}} ymm0 {%k1} = ymm1[2,3],ymm2[2,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_i64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi64x2 {{.*#+}} ymm0 {%k1} = ymm1[2,3],ymm2[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x i64> %shuffle, <4 x i64> %__W
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_maskz_shuffle_i64x2(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_maskz_shuffle_i64x2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufi64x2 {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3],ymm1[2,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_i64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi64x2 {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3],ymm1[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x i64> %shuffle, <4 x i64> zeroinitializer
  ret <4 x i64> %1
}

define zeroext i8 @test_mm_test_epi32_mask(<2 x i64> %__A, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_test_epi32_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestmd %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = bitcast <2 x i64> %and.i.i to <4 x i32>
  %1 = icmp ne <4 x i32> %0, zeroinitializer
  %2 = shufflevector <4 x i1> %1, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = bitcast <8 x i1> %2 to i8
  ret i8 %3
}

define zeroext i8 @test_mm_mask_test_epi32_mask(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_test_epi32_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestmd %xmm0, %xmm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_test_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmd %xmm0, %xmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = bitcast <2 x i64> %and.i.i to <4 x i32>
  %1 = icmp ne <4 x i32> %0, zeroinitializer
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = and <4 x i1> %1, %extract.i
  %4 = shufflevector <4 x i1> %3, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = bitcast <8 x i1> %4 to i8
  ret i8 %5
}

define zeroext i8 @test_mm256_test_epi32_mask(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_test_epi32_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestmd %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = bitcast <4 x i64> %and.i.i to <8 x i32>
  %1 = icmp ne <8 x i32> %0, zeroinitializer
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm256_mask_test_epi32_mask(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_test_epi32_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestmd %ymm0, %ymm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_test_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmd %ymm0, %ymm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = bitcast <4 x i64> %and.i.i to <8 x i32>
  %1 = icmp ne <8 x i32> %0, zeroinitializer
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = and <8 x i1> %1, %2
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm_test_epi64_mask(<2 x i64> %__A, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_test_epi64_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestmq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = icmp ne <2 x i64> %and.i.i, zeroinitializer
  %1 = shufflevector <2 x i1> %0, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm_mask_test_epi64_mask(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_test_epi64_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestmq %xmm0, %xmm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_test_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmq %xmm0, %xmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = icmp ne <2 x i64> %and.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = and <2 x i1> %0, %extract.i
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm256_test_epi64_mask(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_test_epi64_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestmq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = icmp ne <4 x i64> %and.i.i, zeroinitializer
  %1 = shufflevector <4 x i1> %0, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm256_mask_test_epi64_mask(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_test_epi64_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestmq %ymm0, %ymm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_test_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmq %ymm0, %ymm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = icmp ne <4 x i64> %and.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = and <4 x i1> %0, %extract.i
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm_testn_epi32_mask(<2 x i64> %__A, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_testn_epi32_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestnmd %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = bitcast <2 x i64> %and.i.i to <4 x i32>
  %1 = icmp eq <4 x i32> %0, zeroinitializer
  %2 = shufflevector <4 x i1> %1, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = bitcast <8 x i1> %2 to i8
  ret i8 %3
}

define zeroext i8 @test_mm_mask_testn_epi32_mask(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_testn_epi32_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestnmd %xmm0, %xmm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_testn_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmd %xmm0, %xmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = bitcast <2 x i64> %and.i.i to <4 x i32>
  %1 = icmp eq <4 x i32> %0, zeroinitializer
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = and <4 x i1> %1, %extract.i
  %4 = shufflevector <4 x i1> %3, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = bitcast <8 x i1> %4 to i8
  ret i8 %5
}

define zeroext i8 @test_mm256_testn_epi32_mask(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_testn_epi32_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestnmd %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = bitcast <4 x i64> %and.i.i to <8 x i32>
  %1 = icmp eq <8 x i32> %0, zeroinitializer
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm256_mask_testn_epi32_mask(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_testn_epi32_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestnmd %ymm0, %ymm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_testn_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmd %ymm0, %ymm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = bitcast <4 x i64> %and.i.i to <8 x i32>
  %1 = icmp eq <8 x i32> %0, zeroinitializer
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = and <8 x i1> %1, %2
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm_testn_epi64_mask(<2 x i64> %__A, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_testn_epi64_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestnmq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = icmp eq <2 x i64> %and.i.i, zeroinitializer
  %1 = shufflevector <2 x i1> %0, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm_mask_testn_epi64_mask(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_testn_epi64_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestnmq %xmm0, %xmm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_testn_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmq %xmm0, %xmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = icmp eq <2 x i64> %and.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = and <2 x i1> %0, %extract.i
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm256_testn_epi64_mask(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_testn_epi64_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestnmq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = icmp eq <4 x i64> %and.i.i, zeroinitializer
  %1 = shufflevector <4 x i1> %0, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm256_mask_testn_epi64_mask(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_testn_epi64_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestnmq %ymm0, %ymm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_testn_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmq %ymm0, %ymm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = icmp eq <4 x i64> %and.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = and <4 x i1> %0, %extract.i
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define <2 x i64> @test_mm_mask_set1_epi32(<2 x i64> %__O, i8 zeroext %__M)  {
; X86-LABEL: test_mm_mask_set1_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd {{.*#+}} xmm0 {%k1} = [5,5,5,5]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*#+}} xmm0 {%k1} = [5,5,5,5]
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__O to <4 x i32>
  %1 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> <i32 5, i32 5, i32 5, i32 5>, <4 x i32> %0
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm_maskz_set1_epi32(i8 zeroext %__M) {
; X86-LABEL: test_mm_maskz_set1_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd {{.*#+}} xmm0 {%k1} {z} = [5,5,5,5]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*#+}} xmm0 {%k1} {z} = [5,5,5,5]
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i32> <i32 5, i32 5, i32 5, i32 5>, <4 x i32> zeroinitializer
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_mask_set1_epi32(<4 x i64> %__O, i8 zeroext %__M)  {
; X86-LABEL: test_mm256_mask_set1_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd {{.*#+}} ymm0 {%k1} = [5,5,5,5,5,5,5,5]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*#+}} ymm0 {%k1} = [5,5,5,5,5,5,5,5]
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__O to <8 x i32>
  %1 = bitcast i8 %__M to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>, <8 x i32> %0
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_mm256_maskz_set1_epi32(i8 zeroext %__M)  {
; X86-LABEL: test_mm256_maskz_set1_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd {{.*#+}} ymm0 {%k1} {z} = [5,5,5,5,5,5,5,5]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*#+}} ymm0 {%k1} {z} = [5,5,5,5,5,5,5,5]
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>, <8 x i32> zeroinitializer
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <2 x i64> @test_mm_mask_set1_epi64(<2 x i64> %__O, i8 zeroext %__M, i64 %__A)  {
; X86-LABEL: test_mm_mask_set1_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %rsi, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecinit.i.i.i = insertelement <2 x i64> undef, i64 %__A, i32 0
  %vecinit1.i.i.i = shufflevector <2 x i64> %vecinit.i.i.i, <2 x i64> undef, <2 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x i64> %vecinit1.i.i.i, <2 x i64> %__O
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_maskz_set1_epi64(i8 zeroext %__M, i64 %__A)  {
; X86-LABEL: test_mm_maskz_set1_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %rsi, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecinit.i.i.i = insertelement <2 x i64> undef, i64 %__A, i32 0
  %vecinit1.i.i.i = shufflevector <2 x i64> %vecinit.i.i.i, <2 x i64> undef, <2 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x i64> %vecinit1.i.i.i, <2 x i64> zeroinitializer
  ret <2 x i64> %1
}


define <4 x i64> @test_mm256_mask_set1_epi64(<4 x i64> %__O, i8 zeroext %__M, i64 %__A) {
; X86-LABEL: test_mm256_mask_set1_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %rsi, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecinit.i.i = insertelement <4 x i64> undef, i64 %__A, i32 0
  %vecinit3.i.i = shufflevector <4 x i64> %vecinit.i.i, <4 x i64> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i64> %vecinit3.i.i, <4 x i64> %__O
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_maskz_set1_epi64(i8 zeroext %__M, i64 %__A)  {
; X86-LABEL: test_mm256_maskz_set1_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %rsi, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecinit.i.i = insertelement <4 x i64> undef, i64 %__A, i32 0
  %vecinit3.i.i = shufflevector <4 x i64> %vecinit.i.i, <4 x i64> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i64> %vecinit3.i.i, <4 x i64> zeroinitializer
  ret <4 x i64> %1
}

define <2 x i64> @test_mm_broadcastd_epi32(<2 x i64> %a0) {
; CHECK-LABEL: test_mm_broadcastd_epi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastss %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg0, <4 x i32> undef, <4 x i32> zeroinitializer
  %res1 = bitcast <4 x i32> %res0 to <2 x i64>
  ret <2 x i64> %res1
}

define <2 x i64> @test_mm_mask_broadcastd_epi32(<2 x i64> %__O, i8 zeroext %__M, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_broadcastd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %shuffle.i.i = shufflevector <4 x i32> %0, <4 x i32> undef, <4 x i32> zeroinitializer
  %1 = bitcast <2 x i64> %__O to <4 x i32>
  %2 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %shuffle.i.i, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_maskz_broadcastd_epi32(i8 zeroext %__M, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_broadcastd_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %shuffle.i.i = shufflevector <4 x i32> %0, <4 x i32> undef, <4 x i32> zeroinitializer
  %1 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %shuffle.i.i, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @test_mm256_broadcastd_epi32(<2 x i64> %a0) {
; CHECK-LABEL: test_mm256_broadcastd_epi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastss %xmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg0, <4 x i32> undef, <8 x i32> zeroinitializer
  %res1 = bitcast <8 x i32> %res0 to <4 x i64>
  ret <4 x i64> %res1
}

define <4 x i64> @test_mm256_mask_broadcastd_epi32(<4 x i64> %a0, i8 %a1, <2 x i64> %a2) {
; X86-LABEL: test_mm256_mask_broadcastd_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd %xmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
  %arg0 = bitcast <4 x i64> %a0 to <8 x i32>
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %arg2 = bitcast <2 x i64> %a2 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg2, <4 x i32> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg1, <8 x i32> %res0, <8 x i32> %arg0
  %res2 = bitcast <8 x i32> %res1 to <4 x i64>
  ret <4 x i64> %res2
}

define <4 x i64> @test_mm256_maskz_broadcastd_epi32(i8 %a0, <2 x i64> %a1) {
; X86-LABEL: test_mm256_maskz_broadcastd_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd %xmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg1, <4 x i32> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg0, <8 x i32> %res0, <8 x i32> zeroinitializer
  %res2 = bitcast <8 x i32> %res1 to <4 x i64>
  ret <4 x i64> %res2
}

define <2 x i64> @test_mm_broadcastq_epi64(<2 x i64> %a0) {
; CHECK-LABEL: test_mm_broadcastq_epi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x i64> %a0, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_mask_broadcastq_epi64(<2 x i64> %__O, i8 zeroext %__M, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_broadcastq_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastq_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <2 x i64> %__A, <2 x i64> undef, <2 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x i64> %shuffle.i.i, <2 x i64> %__O
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_maskz_broadcastq_epi64(i8 zeroext %__M, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_broadcastq_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastq_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <2 x i64> %__A, <2 x i64> undef, <2 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x i64> %shuffle.i.i, <2 x i64> zeroinitializer
  ret <2 x i64> %1
}

define <4 x i64> @test_mm256_broadcastq_epi64(<2 x i64> %a0) {
; CHECK-LABEL: test_mm256_broadcastq_epi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd %xmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x i64> %a0, <2 x i64> undef, <4 x i32> zeroinitializer
  ret <4 x i64> %res
}

define <4 x i64> @test_mm256_mask_broadcastq_epi64(<4 x i64> %__O, i8 zeroext %__M, <2 x i64> %__A) {
; X86-LABEL: test_mm256_mask_broadcastq_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastq_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <2 x i64> %__A, <2 x i64> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i64> %shuffle.i.i, <4 x i64> %__O
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_maskz_broadcastq_epi64(i8 zeroext %__M, <2 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_broadcastq_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastq_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <2 x i64> %__A, <2 x i64> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i64> %shuffle.i.i, <4 x i64> zeroinitializer
  ret <4 x i64> %1
}

define <4 x double> @test_mm256_broadcastsd_pd(<2 x double> %a0) {
; CHECK-LABEL: test_mm256_broadcastsd_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd %xmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> undef, <4 x i32> zeroinitializer
  ret <4 x double> %res
}

define <4 x double> @test_mm256_mask_broadcastsd_pd(<4 x double> %__O, i8 zeroext %__M, <2 x double> %__A) {
; X86-LABEL: test_mm256_mask_broadcastsd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastsd %xmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastsd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <2 x double> %__A, <2 x double> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %shuffle.i.i, <4 x double> %__O
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_broadcastsd_pd(i8 zeroext %__M, <2 x double> %__A) {
; X86-LABEL: test_mm256_maskz_broadcastsd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastsd %xmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastsd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <2 x double> %__A, <2 x double> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %shuffle.i.i, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <4 x float> @test_mm_broadcastss_ps(<4 x float> %a0) {
; CHECK-LABEL: test_mm_broadcastss_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastss %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> zeroinitializer
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_broadcastss_ps(<4 x float> %__O, i8 zeroext %__M, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_broadcastss_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastss_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x float> %shuffle.i.i, <4 x float> %__O
  ret <4 x float> %1
}

define <4 x float> @test_mm_maskz_broadcastss_ps(i8 zeroext %__M, <4 x float> %__A) {
; X86-LABEL: test_mm_maskz_broadcastss_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastss_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x float> %shuffle.i.i, <4 x float> zeroinitializer
  ret <4 x float> %1
}

define <8 x float> @test_mm256_broadcastss_ps(<4 x float> %a0) {
; CHECK-LABEL: test_mm256_broadcastss_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastss %xmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <8 x i32> zeroinitializer
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_broadcastss_ps(<8 x float> %a0, i8 %a1, <4 x float> %a2) {
; X86-LABEL: test_mm256_mask_broadcastss_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss %xmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <4 x float> %a2, <4 x float> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg1, <8 x float> %res0, <8 x float> %a0
  ret <8 x float> %res1
}

define <8 x float> @test_mm256_maskz_broadcastss_ps(i8 %a0, <4 x float> %a1) {
; X86-LABEL: test_mm256_maskz_broadcastss_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss %xmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <4 x float> %a1, <4 x float> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg0, <8 x float> %res0, <8 x float> zeroinitializer
  ret <8 x float> %res1
}

define <2 x double> @test_mm_movddup_pd(<2 x double> %a0) {
; CHECK-LABEL: test_mm_movddup_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> undef, <2 x i32> zeroinitializer
  ret <2 x double> %res
}

define <2 x double> @test_mm_mask_movedup_pd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_mask_movedup_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = xmm1[0,0]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_movedup_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = xmm1[0,0]
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <2 x double> %__A, <2 x double> undef, <2 x i32> zeroinitializer
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %shuffle.i.i, <2 x double> %__W
  ret <2 x double> %1
}

define <2 x double> @test_mm_maskz_movedup_pd(i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_maskz_movedup_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_movedup_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0]
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <2 x double> %__A, <2 x double> undef, <2 x i32> zeroinitializer
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %shuffle.i.i, <2 x double> zeroinitializer
  ret <2 x double> %1
}

define <4 x double> @test_mm256_movddup_pd(<4 x double> %a0) {
; CHECK-LABEL: test_mm256_movddup_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x double> %a0, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x double> %res
}

define <4 x double> @test_mm256_mask_movedup_pd(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_mask_movedup_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovddup {{.*#+}} ymm0 {%k1} = ymm1[0,0,2,2]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_movedup_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} ymm0 {%k1} = ymm1[0,0,2,2]
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x double> %__A, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %shuffle.i.i, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_movedup_pd(i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_maskz_movedup_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovddup {{.*#+}} ymm0 {%k1} {z} = ymm0[0,0,2,2]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_movedup_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} ymm0 {%k1} {z} = ymm0[0,0,2,2]
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x double> %__A, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %shuffle.i.i, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <4 x float> @test_mm_movehdup_ps(<4 x float> %a0) {
; CHECK-LABEL: test_mm_movehdup_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_movehdup_ps(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_movehdup_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovshdup {{.*#+}} xmm0 {%k1} = xmm1[1,1,3,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_movehdup_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} xmm0 {%k1} = xmm1[1,1,3,3]
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x float> %shuffle.i.i, <4 x float> %__W
  ret <4 x float> %1
}

define <4 x float> @test_mm_maskz_movehdup_ps(i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_maskz_movehdup_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovshdup {{.*#+}} xmm0 {%k1} {z} = xmm0[1,1,3,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_movehdup_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} xmm0 {%k1} {z} = xmm0[1,1,3,3]
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x float> %shuffle.i.i, <4 x float> zeroinitializer
  ret <4 x float> %1
}

define <8 x float> @test_mm256_movehdup_ps(<8 x float> %a0) {
; CHECK-LABEL: test_mm256_movehdup_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x float> %a0, <8 x float> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_movehdup_ps(<8 x float> %a0, i8 %a1, <8 x float> %a2) {
; X86-LABEL: test_mm256_mask_movehdup_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovshdup {{.*#+}} ymm0 {%k1} = ymm1[1,1,3,3,5,5,7,7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} ymm0 {%k1} = ymm1[1,1,3,3,5,5,7,7]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x float> %a2, <8 x float> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  %res1 = select <8 x i1> %arg1, <8 x float> %res0, <8 x float> %a0
  ret <8 x float> %res1
}

define <8 x float> @test_mm256_maskz_movehdup_ps(i8 %a0, <8 x float> %a1) {
; X86-LABEL: test_mm256_maskz_movehdup_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovshdup {{.*#+}} ymm0 {%k1} {z} = ymm0[1,1,3,3,5,5,7,7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} ymm0 {%k1} {z} = ymm0[1,1,3,3,5,5,7,7]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x float> %a1, <8 x float> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  %res1 = select <8 x i1> %arg0, <8 x float> %res0, <8 x float> zeroinitializer
  ret <8 x float> %res1
}

define <4 x float> @test_mm_moveldup_ps(<4 x float> %a0) {
; CHECK-LABEL: test_mm_moveldup_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovsldup {{.*#+}} xmm0 = xmm0[0,0,2,2]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_moveldup_ps(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_moveldup_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovsldup {{.*#+}} xmm0 {%k1} = xmm1[0,0,2,2]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_moveldup_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} xmm0 {%k1} = xmm1[0,0,2,2]
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x float> %shuffle.i.i, <4 x float> %__W
  ret <4 x float> %1
}

define <4 x float> @test_mm_maskz_moveldup_ps(i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_maskz_moveldup_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovsldup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0,2,2]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_moveldup_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0,2,2]
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x float> %shuffle.i.i, <4 x float> zeroinitializer
  ret <4 x float> %1
}

define <8 x float> @test_mm256_moveldup_ps(<8 x float> %a0) {
; CHECK-LABEL: test_mm256_moveldup_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x float> %a0, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_moveldup_ps(<8 x float> %a0, i8 %a1, <8 x float> %a2) {
; X86-LABEL: test_mm256_mask_moveldup_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovsldup {{.*#+}} ymm0 {%k1} = ymm1[0,0,2,2,4,4,6,6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} ymm0 {%k1} = ymm1[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x float> %a2, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %res1 = select <8 x i1> %arg1, <8 x float> %res0, <8 x float> %a0
  ret <8 x float> %res1
}

define <8 x float> @test_mm256_maskz_moveldup_ps(i8 %a0, <8 x float> %a1) {
; X86-LABEL: test_mm256_maskz_moveldup_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovsldup {{.*#+}} ymm0 {%k1} {z} = ymm0[0,0,2,2,4,4,6,6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} ymm0 {%k1} {z} = ymm0[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x float> %a1, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %res1 = select <8 x i1> %arg0, <8 x float> %res0, <8 x float> zeroinitializer
  ret <8 x float> %res1
}

define <4 x i64> @test_mm256_permutex_epi64(<4 x i64> %a0) {
; CHECK-LABEL: test_mm256_permutex_epi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,0,0,0]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x i64> %a0, <4 x i64> undef, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  ret <4 x i64> %res
}

define <4 x i64> @test_mm256_mask_permutex_epi64(<4 x i64> %__W, i8 zeroext %__M, <4 x i64> %__X) {
; X86-LABEL: test_mm256_mask_permutex_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermq {{.*#+}} ymm0 {%k1} = ymm1[3,0,0,0]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_permutex_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermq {{.*#+}} ymm0 {%k1} = ymm1[3,0,0,0]
; X64-NEXT:    retq
entry:
  %perm = shufflevector <4 x i64> %__X, <4 x i64> undef, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  %0 = bitcast i8 %__M to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x i64> %perm, <4 x i64> %__W
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_maskz_permutex_epi64(i8 zeroext %__M, <4 x i64> %__X) {
; X86-LABEL: test_mm256_maskz_permutex_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermq {{.*#+}} ymm0 {%k1} {z} = ymm0[3,0,0,0]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_permutex_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermq {{.*#+}} ymm0 {%k1} {z} = ymm0[3,0,0,0]
; X64-NEXT:    retq
entry:
  %perm = shufflevector <4 x i64> %__X, <4 x i64> undef, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  %0 = bitcast i8 %__M to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x i64> %perm, <4 x i64> zeroinitializer
  ret <4 x i64> %1
}

define <4 x double> @test_mm256_permutex_pd(<4 x double> %a0) {
; CHECK-LABEL: test_mm256_permutex_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,0,0,0]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x double> %a0, <4 x double> undef, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  ret <4 x double> %res
}

define <4 x double> @test_mm256_mask_permutex_pd(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__X) {
; X86-LABEL: test_mm256_mask_permutex_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermpd {{.*#+}} ymm0 {%k1} = ymm1[1,0,0,0]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_permutex_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermpd {{.*#+}} ymm0 {%k1} = ymm1[1,0,0,0]
; X64-NEXT:    retq
entry:
  %perm = shufflevector <4 x double> %__X, <4 x double> undef, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x double> %perm, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_permutex_pd(i8 zeroext %__U, <4 x double> %__X) {
; X86-LABEL: test_mm256_maskz_permutex_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1,0,0,0]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_permutex_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1,0,0,0]
; X64-NEXT:    retq
entry:
  %perm = shufflevector <4 x double> %__X, <4 x double> undef, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x double> %perm, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <2 x double> @test_mm_shuffle_pd(<2 x double> %a0, <2 x double> %a1) {
; CHECK-LABEL: test_mm_shuffle_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> %a1, <2 x i32> <i32 1, i32 3>
  ret <2 x double> %res
}

define <2 x double> @test_mm_mask_shuffle_pd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_shuffle_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} = xmm1[1],xmm2[1]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_shuffle_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} = xmm1[1],xmm2[1]
; X64-NEXT:    retq
entry:
  %shufp = shufflevector <2 x double> %__A, <2 x double> %__B, <2 x i32> <i32 1, i32 3>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract, <2 x double> %shufp, <2 x double> %__W
  ret <2 x double> %1
}

define <2 x double> @test_mm_maskz_shuffle_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_maskz_shuffle_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_shuffle_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; X64-NEXT:    retq
entry:
  %shufp = shufflevector <2 x double> %__A, <2 x double> %__B, <2 x i32> <i32 1, i32 3>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract, <2 x double> %shufp, <2 x double> zeroinitializer
  ret <2 x double> %1
}

define <4 x double> @test_mm256_shuffle_pd(<4 x double> %a0, <4 x double> %a1) {
; CHECK-LABEL: test_mm256_shuffle_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[2],ymm1[2]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x double> %a0, <4 x double> %a1, <4 x i32> <i32 1, i32 5, i32 2, i32 6>
  ret <4 x double> %res
}

define <4 x double> @test_mm256_mask_shuffle_pd(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; X86-LABEL: test_mm256_mask_shuffle_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} = ymm1[1],ymm2[1],ymm1[2],ymm2[2]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} = ymm1[1],ymm2[1],ymm1[2],ymm2[2]
; X64-NEXT:    retq
entry:
  %shufp = shufflevector <4 x double> %__A, <4 x double> %__B, <4 x i32> <i32 1, i32 5, i32 2, i32 6>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x double> %shufp, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_shuffle_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; X86-LABEL: test_mm256_maskz_shuffle_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[2],ymm1[2]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[2],ymm1[2]
; X64-NEXT:    retq
entry:
  %shufp = shufflevector <4 x double> %__A, <4 x double> %__B, <4 x i32> <i32 1, i32 5, i32 2, i32 6>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x double> %shufp, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <4 x float> @test_mm_shuffle_ps(<4 x float> %a0, <4 x float> %a1) {
; CHECK-LABEL: test_mm_shuffle_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,0]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 1, i32 4, i32 4>
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_shuffle_ps(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_shuffle_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufps {{.*#+}} xmm0 {%k1} = xmm1[0,1],xmm2[0,0]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_shuffle_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufps {{.*#+}} xmm0 {%k1} = xmm1[0,1],xmm2[0,0]
; X64-NEXT:    retq
entry:
  %shufp = shufflevector <4 x float> %__A, <4 x float> %__B, <4 x i32> <i32 0, i32 1, i32 4, i32 4>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x float> %shufp, <4 x float> %__W
  ret <4 x float> %1
}

define <4 x float> @test_mm_maskz_shuffle_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_maskz_shuffle_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufps {{.*#+}} xmm0 {%k1} {z} = xmm0[0,1],xmm1[0,0]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_shuffle_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufps {{.*#+}} xmm0 {%k1} {z} = xmm0[0,1],xmm1[0,0]
; X64-NEXT:    retq
entry:
  %shufp = shufflevector <4 x float> %__A, <4 x float> %__B, <4 x i32> <i32 0, i32 1, i32 4, i32 4>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x float> %shufp, <4 x float> zeroinitializer
  ret <4 x float> %1
}

define <8 x float> @test_mm256_shuffle_ps(<8 x float> %a0, <8 x float> %a1) {
; CHECK-LABEL: test_mm256_shuffle_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1],ymm1[0,0],ymm0[4,5],ymm1[4,4]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x float> %a0, <8 x float> %a1, <8 x i32> <i32 0, i32 1, i32 8, i32 8, i32 4, i32 5, i32 12, i32 12>
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_shuffle_ps(<8 x float> %a0, i8 %a1, <8 x float> %a2, <8 x float> %a3) {
; X86-LABEL: test_mm256_mask_shuffle_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufps {{.*#+}} ymm0 {%k1} = ymm1[0,1],ymm2[0,0],ymm1[4,5],ymm2[4,4]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufps {{.*#+}} ymm0 {%k1} = ymm1[0,1],ymm2[0,0],ymm1[4,5],ymm2[4,4]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x float> %a2, <8 x float> %a3, <8 x i32> <i32 0, i32 1, i32 8, i32 8, i32 4, i32 5, i32 12, i32 12>
  %res1 = select <8 x i1> %arg1, <8 x float> %res0, <8 x float> %a0
  ret <8 x float> %res1
}

define <8 x float> @test_mm256_maskz_shuffle_ps(i8 %a0, <8 x float> %a1, <8 x float> %a2) {
; X86-LABEL: test_mm256_maskz_shuffle_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufps {{.*#+}} ymm0 {%k1} {z} = ymm0[0,1],ymm1[0,0],ymm0[4,5],ymm1[4,4]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufps {{.*#+}} ymm0 {%k1} {z} = ymm0[0,1],ymm1[0,0],ymm0[4,5],ymm1[4,4]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x float> %a1, <8 x float> %a2, <8 x i32> <i32 0, i32 1, i32 8, i32 8, i32 4, i32 5, i32 12, i32 12>
  %res1 = select <8 x i1> %arg0, <8 x float> %res0, <8 x float> zeroinitializer
  ret <8 x float> %res1
}

define <4 x i64> @test_mm256_mask_mul_epi32(<4 x i64> %__W, i8 zeroext %__M, <4 x i64> %__X, <4 x i64> %__Y) nounwind {
; X86-LABEL: test_mm256_mask_mul_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuldq %ymm1, %ymm2, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_mul_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %ymm1, %ymm2, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %tmp = shl <4 x i64> %__X, <i64 32, i64 32, i64 32, i64 32>
  %tmp1 = ashr exact <4 x i64> %tmp, <i64 32, i64 32, i64 32, i64 32>
  %tmp2 = shl <4 x i64> %__Y, <i64 32, i64 32, i64 32, i64 32>
  %tmp3 = ashr exact <4 x i64> %tmp2, <i64 32, i64 32, i64 32, i64 32>
  %tmp4 = mul nsw <4 x i64> %tmp3, %tmp1
  %tmp5 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp5, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp6 = select <4 x i1> %extract.i, <4 x i64> %tmp4, <4 x i64> %__W
  ret <4 x i64> %tmp6
}

define <4 x i64> @test_mm256_maskz_mul_epi32(i8 zeroext %__M, <4 x i64> %__X, <4 x i64> %__Y) nounwind {
; X86-LABEL: test_mm256_maskz_mul_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuldq %ymm0, %ymm1, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_mul_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %ymm0, %ymm1, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %tmp = shl <4 x i64> %__X, <i64 32, i64 32, i64 32, i64 32>
  %tmp1 = ashr exact <4 x i64> %tmp, <i64 32, i64 32, i64 32, i64 32>
  %tmp2 = shl <4 x i64> %__Y, <i64 32, i64 32, i64 32, i64 32>
  %tmp3 = ashr exact <4 x i64> %tmp2, <i64 32, i64 32, i64 32, i64 32>
  %tmp4 = mul nsw <4 x i64> %tmp3, %tmp1
  %tmp5 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp5, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp6 = select <4 x i1> %extract.i, <4 x i64> %tmp4, <4 x i64> zeroinitializer
  ret <4 x i64> %tmp6
}

define <2 x i64> @test_mm_mask_mul_epi32(<2 x i64> %__W, i8 zeroext %__M, <2 x i64> %__X, <2 x i64> %__Y) nounwind {
; X86-LABEL: test_mm_mask_mul_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuldq %xmm1, %xmm2, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_mul_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %xmm1, %xmm2, %xmm0 {%k1}
; X64-NEXT:    retq
  %tmp = shl <2 x i64> %__X, <i64 32, i64 32>
  %tmp1 = ashr exact <2 x i64> %tmp, <i64 32, i64 32>
  %tmp2 = shl <2 x i64> %__Y, <i64 32, i64 32>
  %tmp3 = ashr exact <2 x i64> %tmp2, <i64 32, i64 32>
  %tmp4 = mul nsw <2 x i64> %tmp3, %tmp1
  %tmp5 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp5, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %tmp6 = select <2 x i1> %extract.i, <2 x i64> %tmp4, <2 x i64> %__W
  ret <2 x i64> %tmp6
}

define <2 x i64> @test_mm_maskz_mul_epi32(i8 zeroext %__M, <2 x i64> %__X, <2 x i64> %__Y) nounwind {
; X86-LABEL: test_mm_maskz_mul_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuldq %xmm0, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_mul_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %xmm0, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
  %tmp = shl <2 x i64> %__X, <i64 32, i64 32>
  %tmp1 = ashr exact <2 x i64> %tmp, <i64 32, i64 32>
  %tmp2 = shl <2 x i64> %__Y, <i64 32, i64 32>
  %tmp3 = ashr exact <2 x i64> %tmp2, <i64 32, i64 32>
  %tmp4 = mul nsw <2 x i64> %tmp3, %tmp1
  %tmp5 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp5, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %tmp6 = select <2 x i1> %extract.i, <2 x i64> %tmp4, <2 x i64> zeroinitializer
  ret <2 x i64> %tmp6
}

define <4 x i64> @test_mm256_mask_mul_epu32(<4 x i64> %__W, i8 zeroext %__M, <4 x i64> %__X, <4 x i64> %__Y) nounwind {
; X86-LABEL: test_mm256_mask_mul_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuludq %ymm1, %ymm2, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %ymm1, %ymm2, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %tmp = and <4 x i64> %__X, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp1 = and <4 x i64> %__Y, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <4 x i64> %tmp1, %tmp
  %tmp3 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp4 = select <4 x i1> %extract.i, <4 x i64> %tmp2, <4 x i64> %__W
  ret <4 x i64> %tmp4
}

define <4 x i64> @test_mm256_maskz_mul_epu32(i8 zeroext %__M, <4 x i64> %__X, <4 x i64> %__Y) nounwind {
; X86-LABEL: test_mm256_maskz_mul_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuludq %ymm0, %ymm1, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %ymm0, %ymm1, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %tmp = and <4 x i64> %__X, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp1 = and <4 x i64> %__Y, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <4 x i64> %tmp1, %tmp
  %tmp3 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp4 = select <4 x i1> %extract.i, <4 x i64> %tmp2, <4 x i64> zeroinitializer
  ret <4 x i64> %tmp4
}

define <2 x i64> @test_mm_mask_mul_epu32(<2 x i64> %__W, i8 zeroext %__M, <2 x i64> %__X, <2 x i64> %__Y) nounwind {
; X86-LABEL: test_mm_mask_mul_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuludq %xmm1, %xmm2, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %xmm1, %xmm2, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %tmp = and <2 x i64> %__X, <i64 4294967295, i64 4294967295>
  %tmp1 = and <2 x i64> %__Y, <i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <2 x i64> %tmp1, %tmp
  %tmp3 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %tmp4 = select <2 x i1> %extract.i, <2 x i64> %tmp2, <2 x i64> %__W
  ret <2 x i64> %tmp4
}

define <2 x i64> @test_mm_maskz_mul_epu32(i8 zeroext %__M, <2 x i64> %__X, <2 x i64> %__Y) nounwind {
; X86-LABEL: test_mm_maskz_mul_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuludq %xmm0, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %xmm0, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %tmp = and <2 x i64> %__X, <i64 4294967295, i64 4294967295>
  %tmp1 = and <2 x i64> %__Y, <i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <2 x i64> %tmp1, %tmp
  %tmp3 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %tmp4 = select <2 x i1> %extract.i, <2 x i64> %tmp2, <2 x i64> zeroinitializer
  ret <2 x i64> %tmp4
}

define <2 x i64> @test_mm_cvtepi32_epi8(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_cvtepi32_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovdb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i = trunc <4 x i32> %0 to <4 x i8>
  %shuf.i = shufflevector <4 x i8> %conv.i, <4 x i8> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %1 = bitcast <16 x i8> %shuf.i to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_cvtepi32_epi16(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_cvtepi32_epi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovdw %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i = trunc <4 x i32> %0 to <4 x i16>
  %shuf.i = shufflevector <4 x i16> %conv.i, <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1 = bitcast <8 x i16> %shuf.i to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_cvtepi64_epi8(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_cvtepi64_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovqb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = trunc <2 x i64> %__A to <2 x i8>
  %shuf.i = shufflevector <2 x i8> %conv.i, <2 x i8> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %0 = bitcast <16 x i8> %shuf.i to <2 x i64>
  ret <2 x i64> %0
}

define <2 x i64> @test_mm_cvtepi64_epi16(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_cvtepi64_epi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovqw %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = trunc <2 x i64> %__A to <2 x i16>
  %shuf.i = shufflevector <2 x i16> %conv.i, <2 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %0 = bitcast <8 x i16> %shuf.i to <2 x i64>
  ret <2 x i64> %0
}

define <2 x i64> @test_mm_cvtepi64_epi32(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_cvtepi64_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovqd %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = trunc <2 x i64> %__A to <2 x i32>
  %shuf.i = shufflevector <2 x i32> %conv.i, <2 x i32> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %0 = bitcast <4 x i32> %shuf.i to <2 x i64>
  ret <2 x i64> %0
}

define <2 x i64> @test_mm256_cvtepi32_epi16(<4 x i64> %__A) local_unnamed_addr #0 {
; CHECK-LABEL: test_mm256_cvtepi32_epi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovdw %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %conv.i = trunc <8 x i32> %0 to <8 x i16>
  %1 = bitcast <8 x i16> %conv.i to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvtepi32_epi16(<2 x i64> %__O, i8 zeroext %__M, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_cvtepi32_epi16:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovdw %ymm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepi32_epi16:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovdw %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <2 x i64> %__O to <8 x i16>
  %2 = tail call <8 x i16> @llvm.x86.avx512.mask.pmov.dw.256(<8 x i32> %0, <8 x i16> %1, i8 %__M)
  %3 = bitcast <8 x i16> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm256_maskz_cvtepi32_epi16(i8 zeroext %__M, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_cvtepi32_epi16:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovdw %ymm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepi32_epi16:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovdw %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x i16> @llvm.x86.avx512.mask.pmov.dw.256(<8 x i32> %0, <8 x i16> zeroinitializer, i8 %__M)
  %2 = bitcast <8 x i16> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm256_cvtepi64_epi32(<4 x i64> %__A) local_unnamed_addr #0 {
; CHECK-LABEL: test_mm256_cvtepi64_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovqd %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = trunc <4 x i64> %__A to <4 x i32>
  %0 = bitcast <4 x i32> %conv.i to <2 x i64>
  ret <2 x i64> %0
}

define <2 x i64> @test_mm256_mask_cvtepi64_epi32(<2 x i64> %__O, i8 zeroext %__M, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_cvtepi64_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovqd %ymm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepi64_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovqd %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %conv.i.i = trunc <4 x i64> %__A to <4 x i32>
  %0 = bitcast <2 x i64> %__O to <4 x i32>
  %1 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %conv.i.i, <4 x i32> %0
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm256_maskz_cvtepi64_epi32(i8 zeroext %__M, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_cvtepi64_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovqd %ymm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepi64_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovqd %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %conv.i.i = trunc <4 x i64> %__A to <4 x i32>
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i32> %conv.i.i, <4 x i32> zeroinitializer
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm256_cvtepi64_epi8(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_cvtepi64_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovqb %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = trunc <4 x i64> %__A to <4 x i8>
  %shuf.i = shufflevector <4 x i8> %conv.i, <4 x i8> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %0 = bitcast <16 x i8> %shuf.i to <2 x i64>
  ret <2 x i64> %0
}

define <2 x i64> @test_mm256_cvtepi64_epi16(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_cvtepi64_epi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovqw %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = trunc <4 x i64> %__A to <4 x i16>
  %shuf.i = shufflevector <4 x i16> %conv.i, <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %0 = bitcast <8 x i16> %shuf.i to <2 x i64>
  ret <2 x i64> %0
}

define <2 x i64> @test_mm256_cvtepi32_epi8(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_cvtepi32_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovdb %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %conv.i = trunc <8 x i32> %0 to <8 x i8>
  %shuf.i = shufflevector <8 x i8> %conv.i, <8 x i8> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1 = bitcast <16 x i8> %shuf.i to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_ternarylogic_epi32(<2 x i64> %__A, <2 x i64> %__B, <2 x i64> %__C) {
; CHECK-LABEL: test_mm_ternarylogic_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm1 & ~(xmm0 | xmm2)
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = bitcast <2 x i64> %__C to <4 x i32>
  %3 = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %0, <4 x i32> %1, <4 x i32> %2, i32 4)
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

declare <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32>, <4 x i32>, <4 x i32>, i32) #2

define <2 x i64> @test_mm_mask_ternarylogic_epi32(<2 x i64> %__A, i8 zeroext %__U, <2 x i64> %__B, <2 x i64> %__C) {
; X86-LABEL: test_mm_mask_ternarylogic_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd {{.*#+}} xmm0 {%k1} = xmm1 & ~(xmm0 | xmm2)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_ternarylogic_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd {{.*#+}} xmm0 {%k1} = xmm1 & ~(xmm0 | xmm2)
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = bitcast <2 x i64> %__C to <4 x i32>
  %3 = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %0, <4 x i32> %1, <4 x i32> %2, i32 4)
  %4 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract, <4 x i32> %3, <4 x i32> %0
  %6 = bitcast <4 x i32> %5 to <2 x i64>
  ret <2 x i64> %6
}

define <2 x i64> @test_mm_maskz_ternarylogic_epi32(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B, <2 x i64> %__C) {
; X86-LABEL: test_mm_maskz_ternarylogic_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd {{.*#+}} xmm0 {%k1} {z} = xmm1 & ~(xmm0 | xmm2)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_ternarylogic_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd {{.*#+}} xmm0 {%k1} {z} = xmm1 & ~(xmm0 | xmm2)
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = bitcast <2 x i64> %__C to <4 x i32>
  %3 = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %0, <4 x i32> %1, <4 x i32> %2, i32 4)
  %4 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract, <4 x i32> %3, <4 x i32> zeroinitializer
  %6 = bitcast <4 x i32> %5 to <2 x i64>
  ret <2 x i64> %6
}

define <4 x i64> @test_mm256_ternarylogic_epi32(<4 x i64> %__A, <4 x i64> %__B, <4 x i64> %__C) {
; CHECK-LABEL: test_mm256_ternarylogic_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpternlogd {{.*#+}} ymm0 = ymm1 & ~(ymm0 | ymm2)
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = bitcast <4 x i64> %__C to <8 x i32>
  %3 = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %0, <8 x i32> %1, <8 x i32> %2, i32 4)
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

declare <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32>, <8 x i32>, <8 x i32>, i32) #2

define <4 x i64> @test_mm256_mask_ternarylogic_epi32(<4 x i64> %__A, i8 zeroext %__U, <4 x i64> %__B, <4 x i64> %__C) {
; X86-LABEL: test_mm256_mask_ternarylogic_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd {{.*#+}} ymm0 {%k1} = ymm1 & ~(ymm0 | ymm2)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_ternarylogic_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd {{.*#+}} ymm0 {%k1} = ymm1 & ~(ymm0 | ymm2)
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = bitcast <4 x i64> %__C to <8 x i32>
  %3 = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %0, <8 x i32> %1, <8 x i32> %2, i32 4)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x i32> %3, <8 x i32> %0
  %6 = bitcast <8 x i32> %5 to <4 x i64>
  ret <4 x i64> %6
}

define <4 x i64> @test_mm256_maskz_ternarylogic_epi32(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B, <4 x i64> %__C) {
; X86-LABEL: test_mm256_maskz_ternarylogic_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd {{.*#+}} ymm0 {%k1} {z} = ymm1 & ~(ymm0 | ymm2)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_ternarylogic_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd {{.*#+}} ymm0 {%k1} {z} = ymm1 & ~(ymm0 | ymm2)
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = bitcast <4 x i64> %__C to <8 x i32>
  %3 = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %0, <8 x i32> %1, <8 x i32> %2, i32 4)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x i32> %3, <8 x i32> zeroinitializer
  %6 = bitcast <8 x i32> %5 to <4 x i64>
  ret <4 x i64> %6
}

define <2 x i64> @test_mm_ternarylogic_epi64(<2 x i64> %__A, <2 x i64> %__B, <2 x i64> %__C) {
; CHECK-LABEL: test_mm_ternarylogic_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpternlogq {{.*#+}} xmm0 = xmm1 & ~(xmm0 | xmm2)
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %__A, <2 x i64> %__B, <2 x i64> %__C, i32 4)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64>, <2 x i64>, <2 x i64>, i32) #2

define <2 x i64> @test_mm_mask_ternarylogic_epi64(<2 x i64> %__A, i8 zeroext %__U, <2 x i64> %__B, <2 x i64> %__C) {
; X86-LABEL: test_mm_mask_ternarylogic_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogq {{.*#+}} xmm0 {%k1} = xmm1 & ~(xmm0 | xmm2)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_ternarylogic_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogq {{.*#+}} xmm0 {%k1} = xmm1 & ~(xmm0 | xmm2)
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %__A, <2 x i64> %__B, <2 x i64> %__C, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract, <2 x i64> %0, <2 x i64> %__A
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_ternarylogic_epi64(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B, <2 x i64> %__C) {
; X86-LABEL: test_mm_maskz_ternarylogic_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogq {{.*#+}} xmm0 {%k1} {z} = xmm1 & ~(xmm0 | xmm2)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_ternarylogic_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogq {{.*#+}} xmm0 {%k1} {z} = xmm1 & ~(xmm0 | xmm2)
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %__A, <2 x i64> %__B, <2 x i64> %__C, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract, <2 x i64> %0, <2 x i64> zeroinitializer
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_ternarylogic_epi64(<4 x i64> %__A, <4 x i64> %__B, <4 x i64> %__C) {
; CHECK-LABEL: test_mm256_ternarylogic_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpternlogq {{.*#+}} ymm0 = ymm1 & ~(ymm0 | ymm2)
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %__A, <4 x i64> %__B, <4 x i64> %__C, i32 4)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64>, <4 x i64>, <4 x i64>, i32) #2

define <4 x i64> @test_mm256_mask_ternarylogic_epi64(<4 x i64> %__A, i8 zeroext %__U, <4 x i64> %__B, <4 x i64> %__C) {
; X86-LABEL: test_mm256_mask_ternarylogic_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogq {{.*#+}} ymm0 {%k1} = ymm1 & ~(ymm0 | ymm2)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_ternarylogic_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogq {{.*#+}} ymm0 {%k1} = ymm1 & ~(ymm0 | ymm2)
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %__A, <4 x i64> %__B, <4 x i64> %__C, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract, <4 x i64> %0, <4 x i64> %__A
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_ternarylogic_epi64(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B, <4 x i64> %__C) {
; X86-LABEL: test_mm256_maskz_ternarylogic_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogq {{.*#+}} ymm0 {%k1} {z} = ymm1 & ~(ymm0 | ymm2)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_ternarylogic_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogq {{.*#+}} ymm0 {%k1} {z} = ymm1 & ~(ymm0 | ymm2)
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %__A, <4 x i64> %__B, <4 x i64> %__C, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract, <4 x i64> %0, <4 x i64> zeroinitializer
  ret <4 x i64> %2
}

define <2 x i64> @test_mm_mask2_permutex2var_epi32(<2 x i64> %__A, <2 x i64> %__I, i8 zeroext %__U, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask2_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2d %xmm2, %xmm0, %xmm1 {%k1}
; X86-NEXT:    vmovdqa %xmm1, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask2_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2d %xmm2, %xmm0, %xmm1 {%k1}
; X64-NEXT:    vmovdqa %xmm1, %xmm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__I to <4 x i32>
  %2 = bitcast <2 x i64> %__B to <4 x i32>
  %3 = tail call <4 x i32> @llvm.x86.avx512.vpermi2var.d.128(<4 x i32> %0, <4 x i32> %1, <4 x i32> %2)
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x i32> %3, <4 x i32> %1
  %6 = bitcast <4 x i32> %5 to <2 x i64>
  ret <2 x i64> %6
}

define <4 x i64> @test_mm256_mask2_permutex2var_epi32(<4 x i64> %__A, <4 x i64> %__I, i8 zeroext %__U, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask2_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2d %ymm2, %ymm0, %ymm1 {%k1}
; X86-NEXT:    vmovdqa %ymm1, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask2_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2d %ymm2, %ymm0, %ymm1 {%k1}
; X64-NEXT:    vmovdqa %ymm1, %ymm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__I to <8 x i32>
  %2 = bitcast <4 x i64> %__B to <8 x i32>
  %3 = tail call <8 x i32> @llvm.x86.avx512.vpermi2var.d.256(<8 x i32> %0, <8 x i32> %1, <8 x i32> %2)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x i32> %3, <8 x i32> %1
  %6 = bitcast <8 x i32> %5 to <4 x i64>
  ret <4 x i64> %6
}

define <2 x double> @test_mm_mask2_permutex2var_pd(<2 x double> %__A, <2 x i64> %__I, i8 zeroext %__U, <2 x double> %__B) {
; X86-LABEL: test_mm_mask2_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2pd %xmm2, %xmm0, %xmm1 {%k1}
; X86-NEXT:    vmovapd %xmm1, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask2_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2pd %xmm2, %xmm0, %xmm1 {%k1}
; X64-NEXT:    vmovapd %xmm1, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.x86.avx512.vpermi2var.pd.128(<2 x double> %__A, <2 x i64> %__I, <2 x double> %__B)
  %1 = bitcast <2 x i64> %__I to <2 x double>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %3 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %1
  ret <2 x double> %3
}

define <4 x double> @test_mm256_mask2_permutex2var_pd(<4 x double> %__A, <4 x i64> %__I, i8 zeroext %__U, <4 x double> %__B) {
; X86-LABEL: test_mm256_mask2_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2pd %ymm2, %ymm0, %ymm1 {%k1}
; X86-NEXT:    vmovapd %ymm1, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask2_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2pd %ymm2, %ymm0, %ymm1 {%k1}
; X64-NEXT:    vmovapd %ymm1, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double> %__A, <4 x i64> %__I, <4 x double> %__B)
  %1 = bitcast <4 x i64> %__I to <4 x double>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %1
  ret <4 x double> %3
}

define <4 x float> @test_mm_mask2_permutex2var_ps(<4 x float> %__A, <2 x i64> %__I, i8 zeroext %__U, <4 x float> %__B) {
; X86-LABEL: test_mm_mask2_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2ps %xmm2, %xmm0, %xmm1 {%k1}
; X86-NEXT:    vmovaps %xmm1, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask2_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2ps %xmm2, %xmm0, %xmm1 {%k1}
; X64-NEXT:    vmovaps %xmm1, %xmm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__I to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.avx512.vpermi2var.ps.128(<4 x float> %__A, <4 x i32> %0, <4 x float> %__B)
  %2 = bitcast <2 x i64> %__I to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %1, <4 x float> %2
  ret <4 x float> %4
}

define <8 x float> @test_mm256_mask2_permutex2var_ps(<8 x float> %__A, <4 x i64> %__I, i8 zeroext %__U, <8 x float> %__B) {
; X86-LABEL: test_mm256_mask2_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2ps %ymm2, %ymm0, %ymm1 {%k1}
; X86-NEXT:    vmovaps %ymm1, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask2_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2ps %ymm2, %ymm0, %ymm1 {%k1}
; X64-NEXT:    vmovaps %ymm1, %ymm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__I to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx512.vpermi2var.ps.256(<8 x float> %__A, <8 x i32> %0, <8 x float> %__B)
  %2 = bitcast <4 x i64> %__I to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %1, <8 x float> %2
  ret <8 x float> %4
}

define <2 x i64> @test_mm_mask2_permutex2var_epi64(<2 x i64> %__A, <2 x i64> %__I, i8 zeroext %__U, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask2_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2q %xmm2, %xmm0, %xmm1 {%k1}
; X86-NEXT:    vmovdqa %xmm1, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask2_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2q %xmm2, %xmm0, %xmm1 {%k1}
; X64-NEXT:    vmovdqa %xmm1, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx512.vpermi2var.q.128(<2 x i64> %__A, <2 x i64> %__I, <2 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> %__I
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_mask2_permutex2var_epi64(<4 x i64> %__A, <4 x i64> %__I, i8 zeroext %__U, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask2_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2q %ymm2, %ymm0, %ymm1 {%k1}
; X86-NEXT:    vmovdqa %ymm1, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask2_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2q %ymm2, %ymm0, %ymm1 {%k1}
; X64-NEXT:    vmovdqa %ymm1, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx512.vpermi2var.q.256(<4 x i64> %__A, <4 x i64> %__I, <4 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> %__I
  ret <4 x i64> %2
}

define <2 x i64> @test_mm_permutex2var_epi32(<2 x i64> %__A, <2 x i64> %__I, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_permutex2var_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2d %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__I to <4 x i32>
  %2 = bitcast <2 x i64> %__B to <4 x i32>
  %3 = tail call <4 x i32> @llvm.x86.avx512.vpermi2var.d.128(<4 x i32> %0, <4 x i32> %1, <4 x i32> %2)
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_mask_permutex2var_epi32(<2 x i64> %__A, i8 zeroext %__U, <2 x i64> %__I, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2d %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2d %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__I to <4 x i32>
  %2 = bitcast <2 x i64> %__B to <4 x i32>
  %3 = tail call <4 x i32> @llvm.x86.avx512.vpermi2var.d.128(<4 x i32> %0, <4 x i32> %1, <4 x i32> %2)
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x i32> %3, <4 x i32> %0
  %6 = bitcast <4 x i32> %5 to <2 x i64>
  ret <2 x i64> %6
}

define <2 x i64> @test_mm_maskz_permutex2var_epi32(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__I, <2 x i64> %__B) {
; X86-LABEL: test_mm_maskz_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2d %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2d %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__I to <4 x i32>
  %2 = bitcast <2 x i64> %__B to <4 x i32>
  %3 = tail call <4 x i32> @llvm.x86.avx512.vpermi2var.d.128(<4 x i32> %0, <4 x i32> %1, <4 x i32> %2)
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x i32> %3, <4 x i32> zeroinitializer
  %6 = bitcast <4 x i32> %5 to <2 x i64>
  ret <2 x i64> %6
}

define <4 x i64> @test_mm256_permutex2var_epi32(<4 x i64> %__A, <4 x i64> %__I, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_permutex2var_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2d %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__I to <8 x i32>
  %2 = bitcast <4 x i64> %__B to <8 x i32>
  %3 = tail call <8 x i32> @llvm.x86.avx512.vpermi2var.d.256(<8 x i32> %0, <8 x i32> %1, <8 x i32> %2)
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_mask_permutex2var_epi32(<4 x i64> %__A, i8 zeroext %__U, <4 x i64> %__I, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2d %ymm2, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2d %ymm2, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__I to <8 x i32>
  %2 = bitcast <4 x i64> %__B to <8 x i32>
  %3 = tail call <8 x i32> @llvm.x86.avx512.vpermi2var.d.256(<8 x i32> %0, <8 x i32> %1, <8 x i32> %2)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x i32> %3, <8 x i32> %0
  %6 = bitcast <8 x i32> %5 to <4 x i64>
  ret <4 x i64> %6
}

define <4 x i64> @test_mm256_maskz_permutex2var_epi32(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__I, <4 x i64> %__B) {
; X86-LABEL: test_mm256_maskz_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2d %ymm2, %ymm1, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2d %ymm2, %ymm1, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__I to <8 x i32>
  %2 = bitcast <4 x i64> %__B to <8 x i32>
  %3 = tail call <8 x i32> @llvm.x86.avx512.vpermi2var.d.256(<8 x i32> %0, <8 x i32> %1, <8 x i32> %2)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x i32> %3, <8 x i32> zeroinitializer
  %6 = bitcast <8 x i32> %5 to <4 x i64>
  ret <4 x i64> %6
}

define <2 x double> @test_mm_permutex2var_pd(<2 x double> %__A, <2 x i64> %__I, <2 x double> %__B) {
; CHECK-LABEL: test_mm_permutex2var_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2pd %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <2 x double> @llvm.x86.avx512.vpermi2var.pd.128(<2 x double> %__A, <2 x i64> %__I, <2 x double> %__B)
  ret <2 x double> %0
}

define <2 x double> @test_mm_mask_permutex2var_pd(<2 x double> %__A, i8 zeroext %__U, <2 x i64> %__I, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2pd %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2pd %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.x86.avx512.vpermi2var.pd.128(<2 x double> %__A, <2 x i64> %__I, <2 x double> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__A
  ret <2 x double> %2
}

define <2 x double> @test_mm_maskz_permutex2var_pd(i8 zeroext %__U, <2 x double> %__A, <2 x i64> %__I, <2 x double> %__B) {
; X86-LABEL: test_mm_maskz_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2pd %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2pd %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.x86.avx512.vpermi2var.pd.128(<2 x double> %__A, <2 x i64> %__I, <2 x double> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> zeroinitializer
  ret <2 x double> %2
}

define <4 x double> @test_mm256_permutex2var_pd(<4 x double> %__A, <4 x i64> %__I, <4 x double> %__B) {
; CHECK-LABEL: test_mm256_permutex2var_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2pd %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double> %__A, <4 x i64> %__I, <4 x double> %__B)
  ret <4 x double> %0
}

define <4 x double> @test_mm256_mask_permutex2var_pd(<4 x double> %__A, i8 zeroext %__U, <4 x i64> %__I, <4 x double> %__B) {
; X86-LABEL: test_mm256_mask_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2pd %ymm2, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2pd %ymm2, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double> %__A, <4 x i64> %__I, <4 x double> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__A
  ret <4 x double> %2
}

define <4 x double> @test_mm256_maskz_permutex2var_pd(i8 zeroext %__U, <4 x double> %__A, <4 x i64> %__I, <4 x double> %__B) {
; X86-LABEL: test_mm256_maskz_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2pd %ymm2, %ymm1, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2pd %ymm2, %ymm1, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double> %__A, <4 x i64> %__I, <4 x double> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> zeroinitializer
  ret <4 x double> %2
}

define <4 x float> @test_mm_permutex2var_ps(<4 x float> %__A, <2 x i64> %__I, <4 x float> %__B) {
; CHECK-LABEL: test_mm_permutex2var_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2ps %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__I to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.avx512.vpermi2var.ps.128(<4 x float> %__A, <4 x i32> %0, <4 x float> %__B)
  ret <4 x float> %1
}

define <4 x float> @test_mm_mask_permutex2var_ps(<4 x float> %__A, i8 zeroext %__U, <2 x i64> %__I, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2ps %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2ps %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__I to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.avx512.vpermi2var.ps.128(<4 x float> %__A, <4 x i32> %0, <4 x float> %__B)
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x float> %1, <4 x float> %__A
  ret <4 x float> %3
}

define <4 x float> @test_mm_maskz_permutex2var_ps(i8 zeroext %__U, <4 x float> %__A, <2 x i64> %__I, <4 x float> %__B) {
; X86-LABEL: test_mm_maskz_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2ps %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2ps %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__I to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.avx512.vpermi2var.ps.128(<4 x float> %__A, <4 x i32> %0, <4 x float> %__B)
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x float> %1, <4 x float> zeroinitializer
  ret <4 x float> %3
}

define <8 x float> @test_mm256_permutex2var_ps(<8 x float> %__A, <4 x i64> %__I, <8 x float> %__B) {
; CHECK-LABEL: test_mm256_permutex2var_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2ps %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__I to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx512.vpermi2var.ps.256(<8 x float> %__A, <8 x i32> %0, <8 x float> %__B)
  ret <8 x float> %1
}

define <8 x float> @test_mm256_mask_permutex2var_ps(<8 x float> %__A, i8 zeroext %__U, <4 x i64> %__I, <8 x float> %__B) {
; X86-LABEL: test_mm256_mask_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2ps %ymm2, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2ps %ymm2, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__I to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx512.vpermi2var.ps.256(<8 x float> %__A, <8 x i32> %0, <8 x float> %__B)
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x float> %1, <8 x float> %__A
  ret <8 x float> %3
}

define <8 x float> @test_mm256_maskz_permutex2var_ps(i8 zeroext %__U, <8 x float> %__A, <4 x i64> %__I, <8 x float> %__B) {
; X86-LABEL: test_mm256_maskz_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2ps %ymm2, %ymm1, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2ps %ymm2, %ymm1, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__I to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx512.vpermi2var.ps.256(<8 x float> %__A, <8 x i32> %0, <8 x float> %__B)
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x float> %1, <8 x float> zeroinitializer
  ret <8 x float> %3
}

define <2 x i64> @test_mm_permutex2var_epi64(<2 x i64> %__A, <2 x i64> %__I, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_permutex2var_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2q %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx512.vpermi2var.q.128(<2 x i64> %__A, <2 x i64> %__I, <2 x i64> %__B)
  ret <2 x i64> %0
}

define <2 x i64> @test_mm_mask_permutex2var_epi64(<2 x i64> %__A, i8 zeroext %__U, <2 x i64> %__I, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2q %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2q %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx512.vpermi2var.q.128(<2 x i64> %__A, <2 x i64> %__I, <2 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> %__A
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_permutex2var_epi64(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__I, <2 x i64> %__B) {
; X86-LABEL: test_mm_maskz_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2q %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2q %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx512.vpermi2var.q.128(<2 x i64> %__A, <2 x i64> %__I, <2 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> zeroinitializer
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_permutex2var_epi64(<4 x i64> %__A, <4 x i64> %__I, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_permutex2var_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2q %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx512.vpermi2var.q.256(<4 x i64> %__A, <4 x i64> %__I, <4 x i64> %__B)
  ret <4 x i64> %0
}

define <4 x i64> @test_mm256_mask_permutex2var_epi64(<4 x i64> %__A, i8 zeroext %__U, <4 x i64> %__I, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2q %ymm2, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2q %ymm2, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx512.vpermi2var.q.256(<4 x i64> %__A, <4 x i64> %__I, <4 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> %__A
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_permutex2var_epi64(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__I, <4 x i64> %__B) {
; X86-LABEL: test_mm256_maskz_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2q %ymm2, %ymm1, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2q %ymm2, %ymm1, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx512.vpermi2var.q.256(<4 x i64> %__A, <4 x i64> %__I, <4 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> zeroinitializer
  ret <4 x i64> %2
}


define <2 x double> @test_mm_mask_fmadd_pd(<2 x double> %__A, i8 zeroext %__U, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_mask_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd132pd {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd132pd {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) + xmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__A
  ret <2 x double> %2
}

define <2 x double> @test_mm_mask_fmsub_pd(<2 x double> %__A, i8 zeroext %__U, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_mask_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub132pd {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub132pd {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) - xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__A
  ret <2 x double> %2
}

define <2 x double> @test_mm_mask3_fmadd_pd(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231pd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) + xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231pd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) + xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__C
  ret <2 x double> %2
}

define <2 x double> @test_mm_mask3_fnmadd_pd(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231pd {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) + xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231pd {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) + xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %sub.i, <2 x double> %__B, <2 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__C
  ret <2 x double> %2
}

define <2 x double> @test_mm_maskz_fmadd_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213pd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213pd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> zeroinitializer
  ret <2 x double> %2
}

define <2 x double> @test_mm_maskz_fmsub_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213pd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213pd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> zeroinitializer
  ret <2 x double> %2
}

define <2 x double> @test_mm_maskz_fnmadd_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213pd {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213pd {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %sub.i, <2 x double> %__B, <2 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> zeroinitializer
  ret <2 x double> %2
}

define <2 x double> @test_mm_maskz_fnmsub_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213pd {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213pd {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__A
  %sub1.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %sub.i, <2 x double> %__B, <2 x double> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> zeroinitializer
  ret <2 x double> %2
}

define <4 x double> @test_mm256_mask_fmadd_pd(<4 x double> %__A, i8 zeroext %__U, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_mask_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd132pd {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) + ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd132pd {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) + ymm2
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__A
  ret <4 x double> %2
}

define <4 x double> @test_mm256_mask_fmsub_pd(<4 x double> %__A, i8 zeroext %__U, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_mask_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub132pd {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) - ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub132pd {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) - ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__A
  ret <4 x double> %2
}

define <4 x double> @test_mm256_mask3_fmadd_pd(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231pd {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) + ymm2
; X86-NEXT:    vmovapd %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231pd {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) + ymm2
; X64-NEXT:    vmovapd %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__C
  ret <4 x double> %2
}

define <4 x double> @test_mm256_mask3_fnmadd_pd(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231pd {{.*#+}} ymm2 {%k1} = -(ymm0 * ymm1) + ymm2
; X86-NEXT:    vmovapd %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231pd {{.*#+}} ymm2 {%k1} = -(ymm0 * ymm1) + ymm2
; X64-NEXT:    vmovapd %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %sub.i, <4 x double> %__B, <4 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__C
  ret <4 x double> %2
}

define <4 x double> @test_mm256_maskz_fmadd_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_maskz_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213pd {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) + ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213pd {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) + ymm2
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> zeroinitializer
  ret <4 x double> %2
}

define <4 x double> @test_mm256_maskz_fmsub_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_maskz_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213pd {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) - ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213pd {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) - ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> zeroinitializer
  ret <4 x double> %2
}

define <4 x double> @test_mm256_maskz_fnmadd_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_maskz_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213pd {{.*#+}} ymm0 {%k1} {z} = -(ymm1 * ymm0) + ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213pd {{.*#+}} ymm0 {%k1} {z} = -(ymm1 * ymm0) + ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %sub.i, <4 x double> %__B, <4 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> zeroinitializer
  ret <4 x double> %2
}

define <4 x double> @test_mm256_maskz_fnmsub_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_maskz_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213pd {{.*#+}} ymm0 {%k1} {z} = -(ymm1 * ymm0) - ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213pd {{.*#+}} ymm0 {%k1} {z} = -(ymm1 * ymm0) - ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %sub1.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %sub.i, <4 x double> %__B, <4 x double> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> zeroinitializer
  ret <4 x double> %2
}

define <4 x float> @test_mm_mask_fmadd_ps(<4 x float> %__A, i8 zeroext %__U, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_mask_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd132ps {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd132ps {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) + xmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__A
  ret <4 x float> %2
}

define <4 x float> @test_mm_mask_fmsub_ps(<4 x float> %__A, i8 zeroext %__U, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_mask_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub132ps {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub132ps {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) - xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__A
  ret <4 x float> %2
}

define <4 x float> @test_mm_mask3_fmadd_ps(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231ps {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) + xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231ps {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) + xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__C
  ret <4 x float> %2
}

define <4 x float> @test_mm_mask3_fnmadd_ps(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231ps {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) + xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231ps {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) + xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %sub.i, <4 x float> %__B, <4 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__C
  ret <4 x float> %2
}

define <4 x float> @test_mm_maskz_fmadd_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213ps {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213ps {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <4 x float> @test_mm_maskz_fmsub_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213ps {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213ps {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <4 x float> @test_mm_maskz_fnmadd_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213ps {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213ps {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %sub.i, <4 x float> %__B, <4 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <4 x float> @test_mm_maskz_fnmsub_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213ps {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213ps {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %sub1.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %sub.i, <4 x float> %__B, <4 x float> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <8 x float> @test_mm256_mask_fmadd_ps(<8 x float> %__A, i8 zeroext %__U, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_mask_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd132ps {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) + ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd132ps {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) + ymm2
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__A
  ret <8 x float> %2
}

define <8 x float> @test_mm256_mask_fmsub_ps(<8 x float> %__A, i8 zeroext %__U, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_mask_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub132ps {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) - ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub132ps {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) - ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__A
  ret <8 x float> %2
}

define <8 x float> @test_mm256_mask3_fmadd_ps(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231ps {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) + ymm2
; X86-NEXT:    vmovaps %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231ps {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) + ymm2
; X64-NEXT:    vmovaps %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__C
  ret <8 x float> %2
}

define <8 x float> @test_mm256_mask3_fnmadd_ps(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231ps {{.*#+}} ymm2 {%k1} = -(ymm0 * ymm1) + ymm2
; X86-NEXT:    vmovaps %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231ps {{.*#+}} ymm2 {%k1} = -(ymm0 * ymm1) + ymm2
; X64-NEXT:    vmovaps %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %sub.i, <8 x float> %__B, <8 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__C
  ret <8 x float> %2
}

define <8 x float> @test_mm256_maskz_fmadd_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_maskz_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213ps {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) + ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213ps {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) + ymm2
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> zeroinitializer
  ret <8 x float> %2
}

define <8 x float> @test_mm256_maskz_fmsub_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_maskz_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213ps {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) - ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213ps {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) - ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> zeroinitializer
  ret <8 x float> %2
}

define <8 x float> @test_mm256_maskz_fnmadd_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_maskz_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213ps {{.*#+}} ymm0 {%k1} {z} = -(ymm1 * ymm0) + ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213ps {{.*#+}} ymm0 {%k1} {z} = -(ymm1 * ymm0) + ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %sub.i, <8 x float> %__B, <8 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> zeroinitializer
  ret <8 x float> %2
}

define <8 x float> @test_mm256_maskz_fnmsub_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_maskz_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213ps {{.*#+}} ymm0 {%k1} {z} = -(ymm1 * ymm0) - ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213ps {{.*#+}} ymm0 {%k1} {z} = -(ymm1 * ymm0) - ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %sub1.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %sub.i, <8 x float> %__B, <8 x float> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> zeroinitializer
  ret <8 x float> %2
}

define <2 x double> @test_mm_mask_fmaddsub_pd(<2 x double> %__A, i8 zeroext %__U, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_mask_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub132pd {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) +/- xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub132pd {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) +/- xmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %1 = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %1) #9
  %3 = shufflevector <2 x double> %2, <2 x double> %0, <2 x i32> <i32 0, i32 3>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %5 = select <2 x i1> %extract.i, <2 x double> %3, <2 x double> %__A
  ret <2 x double> %5
}

define <2 x double> @test_mm_mask_fmsubadd_pd(<2 x double> %__A, i8 zeroext %__U, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_mask_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd132pd {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) -/+ xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd132pd {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) -/+ xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %sub.i) #9
  %1 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %2 = shufflevector <2 x double> %1, <2 x double> %0, <2 x i32> <i32 0, i32 3>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> %__A
  ret <2 x double> %4
}

define <2 x double> @test_mm_mask3_fmaddsub_pd(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub231pd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) +/- xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub231pd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) +/- xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %1 = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %1) #9
  %3 = shufflevector <2 x double> %2, <2 x double> %0, <2 x i32> <i32 0, i32 3>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %5 = select <2 x i1> %extract.i, <2 x double> %3, <2 x double> %__C
  ret <2 x double> %5
}

define <2 x double> @test_mm_maskz_fmaddsub_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub213pd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) +/- xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub213pd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) +/- xmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %1 = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %1) #9
  %3 = shufflevector <2 x double> %2, <2 x double> %0, <2 x i32> <i32 0, i32 3>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %5 = select <2 x i1> %extract.i, <2 x double> %3, <2 x double> zeroinitializer
  ret <2 x double> %5
}

define <2 x double> @test_mm_maskz_fmsubadd_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd213pd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) -/+ xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd213pd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) -/+ xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %sub.i) #9
  %1 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %2 = shufflevector <2 x double> %1, <2 x double> %0, <2 x i32> <i32 0, i32 3>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> zeroinitializer
  ret <2 x double> %4
}

define <4 x double> @test_mm256_mask_fmaddsub_pd(<4 x double> %__A, i8 zeroext %__U, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_mask_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub132pd {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) +/- ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub132pd {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) +/- ymm2
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %1 = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %1) #9
  %3 = shufflevector <4 x double> %2, <4 x double> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x double> %3, <4 x double> %__A
  ret <4 x double> %5
}

define <4 x double> @test_mm256_mask_fmsubadd_pd(<4 x double> %__A, i8 zeroext %__U, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_mask_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd132pd {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) -/+ ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd132pd {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) -/+ ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %sub.i) #9
  %1 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %2 = shufflevector <4 x double> %1, <4 x double> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> %__A
  ret <4 x double> %4
}

define <4 x double> @test_mm256_mask3_fmaddsub_pd(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub231pd {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) +/- ymm2
; X86-NEXT:    vmovapd %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub231pd {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) +/- ymm2
; X64-NEXT:    vmovapd %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %1 = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %1) #9
  %3 = shufflevector <4 x double> %2, <4 x double> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x double> %3, <4 x double> %__C
  ret <4 x double> %5
}

define <4 x double> @test_mm256_maskz_fmaddsub_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_maskz_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub213pd {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) +/- ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub213pd {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) +/- ymm2
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %1 = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %1) #9
  %3 = shufflevector <4 x double> %2, <4 x double> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x double> %3, <4 x double> zeroinitializer
  ret <4 x double> %5
}

define <4 x double> @test_mm256_maskz_fmsubadd_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_maskz_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd213pd {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) -/+ ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd213pd {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) -/+ ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %sub.i) #9
  %1 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %2 = shufflevector <4 x double> %1, <4 x double> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> zeroinitializer
  ret <4 x double> %4
}

define <4 x float> @test_mm_mask_fmaddsub_ps(<4 x float> %__A, i8 zeroext %__U, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_mask_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub132ps {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) +/- xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub132ps {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) +/- xmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %1 = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %1) #9
  %3 = shufflevector <4 x float> %2, <4 x float> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x float> %3, <4 x float> %__A
  ret <4 x float> %5
}

define <4 x float> @test_mm_mask_fmsubadd_ps(<4 x float> %__A, i8 zeroext %__U, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_mask_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd132ps {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) -/+ xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd132ps {{.*#+}} xmm0 {%k1} = (xmm0 * xmm1) -/+ xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %sub.i) #9
  %1 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %2 = shufflevector <4 x float> %1, <4 x float> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> %__A
  ret <4 x float> %4
}

define <4 x float> @test_mm_mask3_fmaddsub_ps(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub231ps {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) +/- xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub231ps {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) +/- xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %1 = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %1) #9
  %3 = shufflevector <4 x float> %2, <4 x float> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x float> %3, <4 x float> %__C
  ret <4 x float> %5
}

define <4 x float> @test_mm_maskz_fmaddsub_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub213ps {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) +/- xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub213ps {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) +/- xmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %1 = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %1) #9
  %3 = shufflevector <4 x float> %2, <4 x float> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x float> %3, <4 x float> zeroinitializer
  ret <4 x float> %5
}

define <4 x float> @test_mm_maskz_fmsubadd_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd213ps {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) -/+ xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd213ps {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) -/+ xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %sub.i) #9
  %1 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %2 = shufflevector <4 x float> %1, <4 x float> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> zeroinitializer
  ret <4 x float> %4
}

define <8 x float> @test_mm256_mask_fmaddsub_ps(<8 x float> %__A, i8 zeroext %__U, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_mask_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub132ps {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) +/- ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub132ps {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) +/- ymm2
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %1 = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %1) #9
  %3 = shufflevector <8 x float> %2, <8 x float> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x float> %3, <8 x float> %__A
  ret <8 x float> %5
}

define <8 x float> @test_mm256_mask_fmsubadd_ps(<8 x float> %__A, i8 zeroext %__U, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_mask_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd132ps {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) -/+ ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd132ps {{.*#+}} ymm0 {%k1} = (ymm0 * ymm1) -/+ ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %sub.i) #9
  %1 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %2 = shufflevector <8 x float> %1, <8 x float> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> %__A
  ret <8 x float> %4
}

define <8 x float> @test_mm256_mask3_fmaddsub_ps(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub231ps {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) +/- ymm2
; X86-NEXT:    vmovaps %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub231ps {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) +/- ymm2
; X64-NEXT:    vmovaps %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %1 = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %1) #9
  %3 = shufflevector <8 x float> %2, <8 x float> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x float> %3, <8 x float> %__C
  ret <8 x float> %5
}

define <8 x float> @test_mm256_maskz_fmaddsub_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_maskz_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub213ps {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) +/- ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub213ps {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) +/- ymm2
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %1 = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %1) #9
  %3 = shufflevector <8 x float> %2, <8 x float> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x float> %3, <8 x float> zeroinitializer
  ret <8 x float> %5
}

define <8 x float> @test_mm256_maskz_fmsubadd_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_maskz_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd213ps {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) -/+ ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd213ps {{.*#+}} ymm0 {%k1} {z} = (ymm1 * ymm0) -/+ ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %sub.i) #9
  %1 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %2 = shufflevector <8 x float> %1, <8 x float> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> zeroinitializer
  ret <8 x float> %4
}

define <2 x double> @test_mm_mask3_fmsub_pd(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231pd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) - xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231pd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) - xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__C
  ret <2 x double> %2
}

define <4 x double> @test_mm256_mask3_fmsub_pd(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231pd {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) - ymm2
; X86-NEXT:    vmovapd %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231pd {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) - ymm2
; X64-NEXT:    vmovapd %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__C
  ret <4 x double> %2
}

define <4 x float> @test_mm_mask3_fmsub_ps(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231ps {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) - xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231ps {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) - xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__C
  ret <4 x float> %2
}

define <8 x float> @test_mm256_mask3_fmsub_ps(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231ps {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) - ymm2
; X86-NEXT:    vmovaps %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231ps {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) - ymm2
; X64-NEXT:    vmovaps %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %sub.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__C
  ret <8 x float> %2
}

define <2 x double> @test_mm_mask3_fmsubadd_pd(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd231pd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) -/+ xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd231pd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) -/+ xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %sub.i) #9
  %1 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C) #9
  %2 = shufflevector <2 x double> %1, <2 x double> %0, <2 x i32> <i32 0, i32 3>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> %__C
  ret <2 x double> %4
}

define <4 x double> @test_mm256_mask3_fmsubadd_pd(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd231pd {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) -/+ ymm2
; X86-NEXT:    vmovapd %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd231pd {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) -/+ ymm2
; X64-NEXT:    vmovapd %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %sub.i) #9
  %1 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C) #9
  %2 = shufflevector <4 x double> %1, <4 x double> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> %__C
  ret <4 x double> %4
}

define <4 x float> @test_mm_mask3_fmsubadd_ps(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd231ps {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) -/+ xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd231ps {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) -/+ xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %sub.i) #9
  %1 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C) #9
  %2 = shufflevector <4 x float> %1, <4 x float> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> %__C
  ret <4 x float> %4
}

define <8 x float> @test_mm256_mask3_fmsubadd_ps(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd231ps {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) -/+ ymm2
; X86-NEXT:    vmovaps %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd231ps {{.*#+}} ymm2 {%k1} = (ymm0 * ymm1) -/+ ymm2
; X64-NEXT:    vmovaps %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %sub.i) #9
  %1 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C) #9
  %2 = shufflevector <8 x float> %1, <8 x float> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> %__C
  ret <8 x float> %4
}

define <2 x double> @test_mm_mask_fnmadd_pd(<2 x double> %__A, i8 zeroext %__U, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_mask_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd132pd {{.*#+}} xmm0 {%k1} = -(xmm0 * xmm1) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd132pd {{.*#+}} xmm0 {%k1} = -(xmm0 * xmm1) + xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__B
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %sub.i, <2 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__A
  ret <2 x double> %2
}

define <4 x double> @test_mm256_mask_fnmadd_pd(<4 x double> %__A, i8 zeroext %__U, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_mask_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd132pd {{.*#+}} ymm0 {%k1} = -(ymm0 * ymm1) + ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd132pd {{.*#+}} ymm0 {%k1} = -(ymm0 * ymm1) + ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__B
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %sub.i, <4 x double> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__A
  ret <4 x double> %2
}

define <4 x float> @test_mm_mask_fnmadd_ps(<4 x float> %__A, i8 zeroext %__U, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_mask_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd132ps {{.*#+}} xmm0 {%k1} = -(xmm0 * xmm1) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd132ps {{.*#+}} xmm0 {%k1} = -(xmm0 * xmm1) + xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %sub.i, <4 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__A
  ret <4 x float> %2
}

define <8 x float> @test_mm256_mask_fnmadd_ps(<8 x float> %__A, i8 zeroext %__U, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_mask_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd132ps {{.*#+}} ymm0 {%k1} = -(ymm0 * ymm1) + ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd132ps {{.*#+}} ymm0 {%k1} = -(ymm0 * ymm1) + ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %sub.i, <8 x float> %__C) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__A
  ret <8 x float> %2
}

define <2 x double> @test_mm_mask_fnmsub_pd(<2 x double> %__A, i8 zeroext %__U, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_mask_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub132pd {{.*#+}} xmm0 {%k1} = -(xmm0 * xmm1) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub132pd {{.*#+}} xmm0 {%k1} = -(xmm0 * xmm1) - xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__B
  %sub1.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %sub.i, <2 x double> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__A
  ret <2 x double> %2
}

define <2 x double> @test_mm_mask3_fnmsub_pd(<2 x double> %__A, <2 x double> %__B, <2 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231pd {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) - xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231pd {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) - xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__B
  %sub1.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %__A, <2 x double> %sub.i, <2 x double> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__C
  ret <2 x double> %2
}

define <4 x double> @test_mm256_mask_fnmsub_pd(<4 x double> %__A, i8 zeroext %__U, <4 x double> %__B, <4 x double> %__C) {
; X86-LABEL: test_mm256_mask_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub132pd {{.*#+}} ymm0 {%k1} = -(ymm0 * ymm1) - ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub132pd {{.*#+}} ymm0 {%k1} = -(ymm0 * ymm1) - ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__B
  %sub1.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %sub.i, <4 x double> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__A
  ret <4 x double> %2
}

define <4 x double> @test_mm256_mask3_fnmsub_pd(<4 x double> %__A, <4 x double> %__B, <4 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231pd {{.*#+}} ymm2 {%k1} = -(ymm0 * ymm1) - ymm2
; X86-NEXT:    vmovapd %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231pd {{.*#+}} ymm2 {%k1} = -(ymm0 * ymm1) - ymm2
; X64-NEXT:    vmovapd %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__B
  %sub1.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %__A, <4 x double> %sub.i, <4 x double> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__C
  ret <4 x double> %2
}

define <4 x float> @test_mm_mask_fnmsub_ps(<4 x float> %__A, i8 zeroext %__U, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_mask_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub132ps {{.*#+}} xmm0 {%k1} = -(xmm0 * xmm1) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub132ps {{.*#+}} xmm0 {%k1} = -(xmm0 * xmm1) - xmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %sub1.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %sub.i, <4 x float> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__A
  ret <4 x float> %2
}

define <4 x float> @test_mm_mask3_fnmsub_ps(<4 x float> %__A, <4 x float> %__B, <4 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231ps {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) - xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231ps {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) - xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %sub1.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %__A, <4 x float> %sub.i, <4 x float> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__C
  ret <4 x float> %2
}

define <8 x float> @test_mm256_mask_fnmsub_ps(<8 x float> %__A, i8 zeroext %__U, <8 x float> %__B, <8 x float> %__C) {
; X86-LABEL: test_mm256_mask_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub132ps {{.*#+}} ymm0 {%k1} = -(ymm0 * ymm1) - ymm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub132ps {{.*#+}} ymm0 {%k1} = -(ymm0 * ymm1) - ymm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %sub1.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %sub.i, <8 x float> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__A
  ret <8 x float> %2
}

define <8 x float> @test_mm256_mask3_fnmsub_ps(<8 x float> %__A, <8 x float> %__B, <8 x float> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm256_mask3_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231ps {{.*#+}} ymm2 {%k1} = -(ymm0 * ymm1) - ymm2
; X86-NEXT:    vmovaps %ymm2, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask3_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231ps {{.*#+}} ymm2 {%k1} = -(ymm0 * ymm1) - ymm2
; X64-NEXT:    vmovaps %ymm2, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %sub1.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %__A, <8 x float> %sub.i, <8 x float> %sub1.i) #9
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__C
  ret <8 x float> %2
}

define <2 x double> @test_mm_mask_expandloadu_pd(<2 x double> %__W, i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm_mask_expandloadu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandpd (%eax), %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_expandloadu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandpd (%rsi), %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = tail call <2 x double> @llvm.masked.expandload.v2f64(ptr %__P, <2 x i1> %extract.i, <2 x double> %__W)
  ret <2 x double> %1
}

define <2 x double> @test_mm_maskz_expandloadu_pd(i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm_maskz_expandloadu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandpd (%eax), %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_expandloadu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandpd (%rsi), %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = tail call <2 x double> @llvm.masked.expandload.v2f64(ptr %__P, <2 x i1> %extract.i, <2 x double> zeroinitializer)
  ret <2 x double> %1
}

define <4 x double> @test_mm256_mask_expandloadu_pd(<4 x double> %__W, i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm256_mask_expandloadu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandpd (%eax), %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_expandloadu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandpd (%rsi), %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = tail call <4 x double> @llvm.masked.expandload.v4f64(ptr %__P, <4 x i1> %extract.i, <4 x double> %__W)
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_expandloadu_pd(i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm256_maskz_expandloadu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandpd (%eax), %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_expandloadu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandpd (%rsi), %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = tail call <4 x double> @llvm.masked.expandload.v4f64(ptr %__P, <4 x i1> %extract.i, <4 x double> zeroinitializer)
  ret <4 x double> %1
}

define <2 x i64> @test_mm_mask_expandloadu_epi64(<2 x i64> %__W, i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm_mask_expandloadu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandq (%eax), %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_expandloadu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandq (%rsi), %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = tail call <2 x i64> @llvm.masked.expandload.v2i64(ptr %__P, <2 x i1> %extract.i, <2 x i64> %__W) #10
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_maskz_expandloadu_epi64(i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm_maskz_expandloadu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandq (%eax), %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_expandloadu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandq (%rsi), %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = tail call <2 x i64> @llvm.masked.expandload.v2i64(ptr %__P, <2 x i1> %extract.i, <2 x i64> zeroinitializer)
  ret <2 x i64> %1
}

define <4 x i64> @test_mm256_mask_expandloadu_epi64(<4 x i64> %__W, i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm256_mask_expandloadu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandq (%eax), %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_expandloadu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandq (%rsi), %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = tail call <4 x i64> @llvm.masked.expandload.v4i64(ptr %__P, <4 x i1> %extract.i, <4 x i64> %__W) #10
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_maskz_expandloadu_epi64(i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm256_maskz_expandloadu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandq (%eax), %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_expandloadu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandq (%rsi), %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = tail call <4 x i64> @llvm.masked.expandload.v4i64(ptr %__P, <4 x i1> %extract.i, <4 x i64> zeroinitializer)
  ret <4 x i64> %1
}

define <4 x float> @test_mm_mask_expandloadu_ps(<4 x float> %__W, i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm_mask_expandloadu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandps (%eax), %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_expandloadu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandps (%rsi), %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = tail call <4 x float> @llvm.masked.expandload.v4f32(ptr %__P, <4 x i1> %extract.i, <4 x float> %__W)
  ret <4 x float> %1
}

define <4 x float> @test_mm_maskz_expandloadu_ps(i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm_maskz_expandloadu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandps (%eax), %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_expandloadu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandps (%rsi), %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = tail call <4 x float> @llvm.masked.expandload.v4f32(ptr %__P, <4 x i1> %extract.i, <4 x float> zeroinitializer)
  ret <4 x float> %1
}

define <8 x float> @test_mm256_mask_expandloadu_ps(<8 x float> %__W, i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm256_mask_expandloadu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandps (%eax), %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_expandloadu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandps (%rsi), %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = tail call <8 x float> @llvm.masked.expandload.v8f32(ptr %__P, <8 x i1> %0, <8 x float> %__W)
  ret <8 x float> %1
}

define <8 x float> @test_mm256_maskz_expandloadu_ps(i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm256_maskz_expandloadu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandps (%eax), %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_expandloadu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandps (%rsi), %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = tail call <8 x float> @llvm.masked.expandload.v8f32(ptr %__P, <8 x i1> %0, <8 x float> zeroinitializer)
  ret <8 x float> %1
}

define <2 x i64> @test_mm_mask_expandloadu_epi32(<2 x i64> %__W, i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm_mask_expandloadu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandd (%eax), %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_expandloadu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandd (%rsi), %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = tail call <4 x i32> @llvm.masked.expandload.v4i32(ptr %__P, <4 x i1> %extract.i, <4 x i32> %0)
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm_maskz_expandloadu_epi32(i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm_maskz_expandloadu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandd (%eax), %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_expandloadu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandd (%rsi), %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = tail call <4 x i32> @llvm.masked.expandload.v4i32(ptr %__P, <4 x i1> %extract.i, <4 x i32> zeroinitializer)
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_mask_expandloadu_epi32(<4 x i64> %__W, i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm256_mask_expandloadu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandd (%eax), %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_expandloadu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandd (%rsi), %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__W to <8 x i32>
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = tail call <8 x i32> @llvm.masked.expandload.v8i32(ptr %__P, <8 x i1> %1, <8 x i32> %0)
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_mm256_maskz_expandloadu_epi32(i8 zeroext %__U, ptr readonly %__P) {
; X86-LABEL: test_mm256_maskz_expandloadu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandd (%eax), %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_expandloadu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandd (%rsi), %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = tail call <8 x i32> @llvm.masked.expandload.v8i32(ptr %__P, <8 x i1> %0, <8 x i32> zeroinitializer)
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define void @test_mm_mask_compressstoreu_pd(ptr %__P, i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_mask_compressstoreu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcompresspd %xmm0, (%ecx) {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_compressstoreu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vcompresspd %xmm0, (%rdi) {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  tail call void @llvm.masked.compressstore.v2f64(<2 x double> %__A, ptr %__P, <2 x i1> %extract.i)
  ret void
}

define void @test_mm256_mask_compressstoreu_pd(ptr %__P, i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_mask_compressstoreu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcompresspd %ymm0, (%ecx) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_compressstoreu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vcompresspd %ymm0, (%rdi) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  tail call void @llvm.masked.compressstore.v4f64(<4 x double> %__A, ptr %__P, <4 x i1> %extract.i)
  ret void
}

define void @test_mm_mask_compressstoreu_epi64(ptr %__P, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_compressstoreu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpcompressq %xmm0, (%ecx) {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_compressstoreu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpcompressq %xmm0, (%rdi) {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  tail call void @llvm.masked.compressstore.v2i64(<2 x i64> %__A, ptr %__P, <2 x i1> %extract.i)
  ret void
}

define void @test_mm256_mask_compressstoreu_epi64(ptr %__P, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_compressstoreu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpcompressq %ymm0, (%ecx) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_compressstoreu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpcompressq %ymm0, (%rdi) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  tail call void @llvm.masked.compressstore.v4i64(<4 x i64> %__A, ptr %__P, <4 x i1> %extract.i)
  ret void
}

define void @test_mm_mask_compressstoreu_ps(ptr %__P, i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_compressstoreu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcompressps %xmm0, (%ecx) {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_compressstoreu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vcompressps %xmm0, (%rdi) {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  tail call void @llvm.masked.compressstore.v4f32(<4 x float> %__A, ptr %__P, <4 x i1> %extract.i)
  ret void
}

define void @test_mm256_mask_compressstoreu_ps(ptr %__P, i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_mask_compressstoreu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcompressps %ymm0, (%ecx) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_compressstoreu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vcompressps %ymm0, (%rdi) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__U to <8 x i1>
  tail call void @llvm.masked.compressstore.v8f32(<8 x float> %__A, ptr %__P, <8 x i1> %0)
  ret void
}

define void @test_mm_mask_compressstoreu_epi32(ptr %__P, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_compressstoreu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpcompressd %xmm0, (%ecx) {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_compressstoreu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpcompressd %xmm0, (%rdi) {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  tail call void @llvm.masked.compressstore.v4i32(<4 x i32> %0, ptr %__P, <4 x i1> %extract.i)
  ret void
}

define void @test_mm256_mask_compressstoreu_epi32(ptr %__P, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_compressstoreu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpcompressd %ymm0, (%ecx) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_compressstoreu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpcompressd %ymm0, (%rdi) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast i8 %__U to <8 x i1>
  tail call void @llvm.masked.compressstore.v8i32(<8 x i32> %0, ptr %__P, <8 x i1> %1) #10
  ret void
}


declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>) #8
declare <4 x double> @llvm.fma.v4f64(<4 x double>, <4 x double>, <4 x double>) #8
declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>) #8
declare <8 x float> @llvm.fma.v8f32(<8 x float>, <8 x float>, <8 x float>) #8

define <2 x double> @test_mm_mask_sqrt_pd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_mask_sqrt_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtpd %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_sqrt_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtpd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.sqrt.v2f64(<2 x double> %__A) #2
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> %__W
  ret <2 x double> %2
}

declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)

define <2 x double> @test_mm_maskz_sqrt_pd(i8 zeroext %__U, <2 x double> %__A) {
; X86-LABEL: test_mm_maskz_sqrt_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtpd %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_sqrt_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtpd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.sqrt.v2f64(<2 x double> %__A) #2
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %0, <2 x double> zeroinitializer
  ret <2 x double> %2
}

define <4 x double> @test_mm256_mask_sqrt_pd(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_mask_sqrt_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtpd %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_sqrt_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtpd %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.sqrt.v4f64(<4 x double> %__A) #2
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> %__W
  ret <4 x double> %2
}

declare <4 x double> @llvm.sqrt.v4f64(<4 x double>)

define <4 x double> @test_mm256_maskz_sqrt_pd(i8 zeroext %__U, <4 x double> %__A) {
; X86-LABEL: test_mm256_maskz_sqrt_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtpd %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_sqrt_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtpd %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.sqrt.v4f64(<4 x double> %__A) #2
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %0, <4 x double> zeroinitializer
  ret <4 x double> %2
}

define <4 x float> @test_mm_mask_sqrt_ps(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_mask_sqrt_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtps %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_sqrt_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtps %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.sqrt.v4f32(<4 x float> %__A) #2
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__W
  ret <4 x float> %2
}

declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)

define <4 x float> @test_mm_maskz_sqrt_ps(i8 zeroext %__U, <4 x float> %__A) {
; X86-LABEL: test_mm_maskz_sqrt_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtps %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_sqrt_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtps %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.sqrt.v4f32(<4 x float> %__A) #2
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <8 x float> @test_mm256_mask_sqrt_ps(<8 x float> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_mask_sqrt_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtps %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_sqrt_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtps %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.sqrt.v8f32(<8 x float> %__A) #2
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> %__W
  ret <8 x float> %2
}

define <8 x float> @test_mm256_maskz_sqrt_ps(i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm256_maskz_sqrt_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtps %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_sqrt_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtps %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.sqrt.v8f32(<8 x float> %__A) #2
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x float> %0, <8 x float> zeroinitializer
  ret <8 x float> %2
}

declare <8 x float> @llvm.sqrt.v8f32(<8 x float>)

define <2 x i64> @test_mm_rol_epi32(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_rol_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprold $5, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_mask_rol_epi32(<2 x i64> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_rol_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprold $5, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_rol_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprold $5, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <2 x i64> %__W to <4 x i32>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract, <4 x i32> %1, <4 x i32> %2
  %5 = bitcast <4 x i32> %4 to <2 x i64>
  ret <2 x i64> %5
}

define <2 x i64> @test_mm_maskz_rol_epi32(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_rol_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprold $5, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_rol_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprold $5, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract, <4 x i32> %1, <4 x i32> zeroinitializer
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <4 x i64> @test_mm256_rol_epi32(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_rol_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprold $5, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x i32> @llvm.fshl.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_mask_rol_epi32(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_rol_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprold $5, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_rol_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprold $5, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x i32> @llvm.fshl.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <4 x i64> %__W to <8 x i32>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x i32> %1, <8 x i32> %2
  %5 = bitcast <8 x i32> %4 to <4 x i64>
  ret <4 x i64> %5
}

define <4 x i64> @test_mm256_maskz_rol_epi32(i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_rol_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprold $5, %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_rol_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprold $5, %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x i32> @llvm.fshl.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %1, <8 x i32> zeroinitializer
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <2 x i64> @test_mm_rol_epi64(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_rol_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolq $5, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> <i64 5, i64 5>)
  ret <2 x i64> %0
}

define <2 x i64> @test_mm_mask_rol_epi64(<2 x i64> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_rol_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolq $5, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_rol_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolq $5, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> <i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract, <2 x i64> %0, <2 x i64> %__W
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_rol_epi64(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_rol_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolq $5, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_rol_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolq $5, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> <i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract, <2 x i64> %0, <2 x i64> zeroinitializer
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_rol_epi64(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_rol_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolq $5, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i64> @llvm.fshl.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> <i64 5, i64 5,i64 5, i64 5>)
  ret <4 x i64> %0
}

define <4 x i64> @test_mm256_mask_rol_epi64(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_rol_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolq $5, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_rol_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolq $5, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.fshl.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> <i64 5, i64 5,i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract, <4 x i64> %0, <4 x i64> %__W
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_rol_epi64(i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_rol_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolq $5, %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_rol_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolq $5, %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.fshl.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> <i64 5, i64 5,i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract, <4 x i64> %0, <4 x i64> zeroinitializer
  ret <4 x i64> %2
}

define <2 x i64> @test_mm_rolv_epi32(<2 x i64> %__A, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_rolv_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolvd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> %1)
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm_mask_rolv_epi32(<2 x i64> %__W, i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_rolv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvd %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_rolv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvd %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> %1)
  %3 = bitcast <2 x i64> %__W to <4 x i32>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x i32> %2, <4 x i32> %3
  %6 = bitcast <4 x i32> %5 to <2 x i64>
  ret <2 x i64> %6
}

define <2 x i64> @test_mm_maskz_rolv_epi32(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_maskz_rolv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_rolv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> %1)
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x i32> %2, <4 x i32> zeroinitializer
  %5 = bitcast <4 x i32> %4 to <2 x i64>
  ret <2 x i64> %5
}

define <4 x i64> @test_mm256_rolv_epi32(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_rolv_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolvd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = tail call <8 x i32> @llvm.fshl.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> %1)
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_mm256_mask_rolv_epi32(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_rolv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvd %ymm2, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_rolv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvd %ymm2, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = tail call <8 x i32> @llvm.fshl.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> %1)
  %3 = bitcast <4 x i64> %__W to <8 x i32>
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x i32> %2, <8 x i32> %3
  %6 = bitcast <8 x i32> %5 to <4 x i64>
  ret <4 x i64> %6
}

define <4 x i64> @test_mm256_maskz_rolv_epi32(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_maskz_rolv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvd %ymm1, %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_rolv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvd %ymm1, %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = tail call <8 x i32> @llvm.fshl.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> %1)
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x i32> %2, <8 x i32> zeroinitializer
  %5 = bitcast <8 x i32> %4 to <4 x i64>
  ret <4 x i64> %5
}

define <2 x i64> @test_mm_rolv_epi64(<2 x i64> %__A, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_rolv_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolvq %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> %__B)
  ret <2 x i64> %0
}

define <2 x i64> @test_mm_mask_rolv_epi64(<2 x i64> %__W, i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_rolv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvq %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_rolv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvq %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> %__W
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_rolv_epi64(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_maskz_rolv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvq %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_rolv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvq %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> zeroinitializer
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_rolv_epi64(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_rolv_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolvq %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i64> @llvm.fshl.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> %__B)
  ret <4 x i64> %0
}

define <4 x i64> @test_mm256_mask_rolv_epi64(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_rolv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvq %ymm2, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_rolv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvq %ymm2, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.fshl.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> %__W
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_rolv_epi64(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_maskz_rolv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvq %ymm1, %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_rolv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvq %ymm1, %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.fshl.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> zeroinitializer
  ret <4 x i64> %2
}

define <2 x i64> @test_mm_ror_epi32(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_ror_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprord $5, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_mask_ror_epi32(<2 x i64> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_ror_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprord $5, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_ror_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprord $5, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <2 x i64> %__W to <4 x i32>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract, <4 x i32> %1, <4 x i32> %2
  %5 = bitcast <4 x i32> %4 to <2 x i64>
  ret <2 x i64> %5
}

define <2 x i64> @test_mm_maskz_ror_epi32(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_ror_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprord $5, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_ror_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprord $5, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract, <4 x i32> %1, <4 x i32> zeroinitializer
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <4 x i64> @test_mm256_ror_epi32(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_ror_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprord $5, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_mask_ror_epi32(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_ror_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprord $5, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_ror_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprord $5, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <4 x i64> %__W to <8 x i32>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x i32> %1, <8 x i32> %2
  %5 = bitcast <8 x i32> %4 to <4 x i64>
  ret <4 x i64> %5
}

define <4 x i64> @test_mm256_maskz_ror_epi32(i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_ror_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprord $5, %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_ror_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprord $5, %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %1, <8 x i32> zeroinitializer
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <2 x i64> @test_mm_ror_epi64(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_ror_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorq $5, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> <i64 5, i64 5>)
  ret <2 x i64> %0
}

define <2 x i64> @test_mm_mask_ror_epi64(<2 x i64> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_ror_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorq $5, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_ror_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorq $5, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> <i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract, <2 x i64> %0, <2 x i64> %__W
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_ror_epi64(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_ror_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorq $5, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_ror_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorq $5, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> <i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract, <2 x i64> %0, <2 x i64> zeroinitializer
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_ror_epi64(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_ror_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorq $5, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> <i64 5, i64 5, i64 5, i64 5>)
  ret <4 x i64> %0
}

define <4 x i64> @test_mm256_mask_ror_epi64(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_ror_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorq $5, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_ror_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorq $5, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> <i64 5, i64 5, i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract, <4 x i64> %0, <4 x i64> %__W
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_ror_epi64(i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_ror_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorq $5, %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_ror_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorq $5, %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> <i64 5, i64 5, i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract, <4 x i64> %0, <4 x i64> zeroinitializer
  ret <4 x i64> %2
}

define <2 x i64> @test_mm_rorv_epi32(<2 x i64> %__A, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_rorv_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorvd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = tail call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> %1)
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm_mask_rorv_epi32(<2 x i64> %__W, i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_rorv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvd %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_rorv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvd %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = tail call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> %1)
  %3 = bitcast <2 x i64> %__W to <4 x i32>
  %4 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %4, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = select <4 x i1> %extract.i, <4 x i32> %2, <4 x i32> %3
  %6 = bitcast <4 x i32> %5 to <2 x i64>
  ret <2 x i64> %6
}

define <2 x i64> @test_mm_maskz_rorv_epi32(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_maskz_rorv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_rorv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = bitcast <2 x i64> %__B to <4 x i32>
  %2 = tail call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %0, <4 x i32> %0, <4 x i32> %1)
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x i32> %2, <4 x i32> zeroinitializer
  %5 = bitcast <4 x i32> %4 to <2 x i64>
  ret <2 x i64> %5
}

define <4 x i64> @test_mm256_rorv_epi32(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_rorv_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorvd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = tail call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> %1)
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_mm256_mask_rorv_epi32(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_rorv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvd %ymm2, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_rorv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvd %ymm2, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = tail call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> %1)
  %3 = bitcast <4 x i64> %__W to <8 x i32>
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x i32> %2, <8 x i32> %3
  %6 = bitcast <8 x i32> %5 to <4 x i64>
  ret <4 x i64> %6
}

define <4 x i64> @test_mm256_maskz_rorv_epi32(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_maskz_rorv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvd %ymm1, %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_rorv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvd %ymm1, %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = bitcast <4 x i64> %__B to <8 x i32>
  %2 = tail call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %0, <8 x i32> %0, <8 x i32> %1)
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x i32> %2, <8 x i32> zeroinitializer
  %5 = bitcast <8 x i32> %4 to <4 x i64>
  ret <4 x i64> %5
}

define <2 x i64> @test_mm_rorv_epi64(<2 x i64> %__A, <2 x i64> %__B) {
; CHECK-LABEL: test_mm_rorv_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorvq %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> %__B)
  ret <2 x i64> %0
}

define <2 x i64> @test_mm_mask_rorv_epi64(<2 x i64> %__W, i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_mask_rorv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvq %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_rorv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvq %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> %__W
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_rorv_epi64(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X86-LABEL: test_mm_maskz_rorv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvq %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_rorv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvq %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %__A, <2 x i64> %__A, <2 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> zeroinitializer
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_rorv_epi64(<4 x i64> %__A, <4 x i64> %__B) {
; CHECK-LABEL: test_mm256_rorv_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorvq %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> %__B)
  ret <4 x i64> %0
}

define <4 x i64> @test_mm256_mask_rorv_epi64(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_mask_rorv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvq %ymm2, %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_rorv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvq %ymm2, %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> %__W
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_rorv_epi64(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X86-LABEL: test_mm256_maskz_rorv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvq %ymm1, %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_rorv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvq %ymm1, %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %__A, <4 x i64> %__A, <4 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> zeroinitializer
  ret <4 x i64> %2
}

declare <4 x float> @llvm.x86.sse2.cvtdq2ps(<4 x i32>)
declare <8 x float> @llvm.x86.avx.cvtdq2.ps.256(<8 x i32>)
declare <4 x i32> @llvm.x86.avx512.mask.cvtpd2dq.128(<2 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double>)
declare <4 x float> @llvm.x86.avx512.mask.cvtpd2ps(<2 x double>, <4 x float>, i8)
declare <4 x float> @llvm.x86.avx.cvt.pd2.ps.256(<4 x double>)
declare <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.128(<2 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.256(<4 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float>)
declare <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float>)
declare <4 x i32> @llvm.x86.avx512.mask.cvtps2udq.128(<4 x float>, <4 x i32>, i8)
declare <8 x i32> @llvm.x86.avx512.mask.cvtps2udq.256(<8 x float>, <8 x i32>, i8)
declare <4 x i32> @llvm.x86.avx512.mask.cvttpd2dq.128(<2 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.avx.cvtt.pd2dq.256(<4 x double>)
declare <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.128(<2 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.256(<4 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float>)
declare <8 x i32> @llvm.x86.avx.cvtt.ps2dq.256(<8 x float>)
declare <4 x i32> @llvm.x86.avx512.mask.cvttps2udq.128(<4 x float>, <4 x i32>, i8)
declare <8 x i32> @llvm.x86.avx512.mask.cvttps2udq.256(<8 x float>, <8 x i32>, i8)
declare <8 x i16> @llvm.x86.avx512.mask.pmov.dw.256(<8 x i32>, <8 x i16>, i8)
declare <4 x i32> @llvm.x86.avx512.vpermi2var.d.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.x86.avx512.vpermi2var.d.256(<8 x i32>, <8 x i32>, <8 x i32>)
declare <2 x double> @llvm.x86.avx512.vpermi2var.pd.128(<2 x double>, <2 x i64>, <2 x double>)
declare <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double>, <4 x i64>, <4 x double>)
declare <4 x float> @llvm.x86.avx512.vpermi2var.ps.128(<4 x float>, <4 x i32>, <4 x float>)
declare <8 x float> @llvm.x86.avx512.vpermi2var.ps.256(<8 x float>, <8 x i32>, <8 x float>)
declare <2 x i64> @llvm.x86.avx512.vpermi2var.q.128(<2 x i64>, <2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.x86.avx512.vpermi2var.q.256(<4 x i64>, <4 x i64>, <4 x i64>)
declare <2 x double> @llvm.masked.expandload.v2f64(ptr, <2 x i1>, <2 x double>)
declare <4 x double> @llvm.masked.expandload.v4f64(ptr, <4 x i1>, <4 x double>)
declare <2 x i64> @llvm.masked.expandload.v2i64(ptr, <2 x i1>, <2 x i64>)
declare <4 x i64> @llvm.masked.expandload.v4i64(ptr, <4 x i1>, <4 x i64>)
declare <4 x float> @llvm.masked.expandload.v4f32(ptr, <4 x i1>, <4 x float>)
declare <8 x float> @llvm.masked.expandload.v8f32(ptr, <8 x i1>, <8 x float>)
declare <4 x i32> @llvm.masked.expandload.v4i32(ptr, <4 x i1>, <4 x i32>)
declare <8 x i32> @llvm.masked.expandload.v8i32(ptr, <8 x i1>, <8 x i32>)
declare void @llvm.masked.compressstore.v2f64(<2 x double>, ptr, <2 x i1>)
declare void @llvm.masked.compressstore.v4f64(<4 x double>, ptr, <4 x i1>)
declare void @llvm.masked.compressstore.v2i64(<2 x i64>, ptr, <2 x i1>)
declare void @llvm.masked.compressstore.v4i64(<4 x i64>, ptr, <4 x i1>)
declare void @llvm.masked.compressstore.v4f32(<4 x float>, ptr, <4 x i1>)
declare void @llvm.masked.compressstore.v8f32(<8 x float>, ptr, <8 x i1>)
declare void @llvm.masked.compressstore.v4i32(<4 x i32>, ptr, <4 x i1>)
declare void @llvm.masked.compressstore.v8i32(<8 x i32>, ptr, <8 x i1>)
declare <4 x i32> @llvm.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.fshl.v8i32(<8 x i32>, <8 x i32>, <8 x i32>)
declare <2 x i64> @llvm.fshl.v2i64(<2 x i64>, <2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.fshl.v4i64(<4 x i64>, <4 x i64>, <4 x i64>)
declare <4 x i32> @llvm.fshr.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.fshr.v8i32(<8 x i32>, <8 x i32>, <8 x i32>)
declare <2 x i64> @llvm.fshr.v2i64(<2 x i64>, <2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.fshr.v4i64(<4 x i64>, <4 x i64>, <4 x i64>)

!0 = !{i32 1}
