; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O0 -mtriple=x86_64-unknown-unknown -mattr=+amx-tile,+amx-movrs | FileCheck %s
; RUN: llc < %s -O0 -mtriple=x86_64-unknown-unknown -mattr=+amx-tile,+amx-movrs,+egpr --show-mc-encoding | FileCheck %s --check-prefix=EGPR

define void @test_amx_internal(i16 %m, i16 %n, ptr %buf, i64 %s) {
; CHECK-LABEL: test_amx_internal:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset %rbp, -16
; CHECK-NEXT:    movq %rsp, %rbp
; CHECK-NEXT:    .cfi_def_cfa_register %rbp
; CHECK-NEXT:    andq $-1024, %rsp # imm = 0xFC00
; CHECK-NEXT:    subq $3072, %rsp # imm = 0xC00
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb $1, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movq %rcx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; CHECK-NEXT:    movw %ax, %cx
; CHECK-NEXT:    movw %di, %ax
; CHECK-NEXT:    # implicit-def: $al
; CHECK-NEXT:    movb %al, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; CHECK-NEXT:    tileloaddrs (%rdx,%rsi), %tmm0
; CHECK-NEXT:    movl $64, %esi
; CHECK-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; CHECK-NEXT:    tilestored %tmm0, (%rdx,%rsi)
; CHECK-NEXT:    movq %rbp, %rsp
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    .cfi_def_cfa %rsp, 8
; CHECK-NEXT:    tilerelease
; CHECK-NEXT:    retq
;
; EGPR-LABEL: test_amx_internal:
; EGPR:       # %bb.0: # %entry
; EGPR-NEXT:    pushq %rbp # encoding: [0x55]
; EGPR-NEXT:    .cfi_def_cfa_offset 16
; EGPR-NEXT:    .cfi_offset %rbp, -16
; EGPR-NEXT:    movq %rsp, %rbp # encoding: [0x48,0x89,0xe5]
; EGPR-NEXT:    .cfi_def_cfa_register %rbp
; EGPR-NEXT:    andq $-1024, %rsp # encoding: [0x48,0x81,0xe4,0x00,0xfc,0xff,0xff]
; EGPR-NEXT:    # imm = 0xFC00
; EGPR-NEXT:    subq $3072, %rsp # encoding: [0x48,0x81,0xec,0x00,0x0c,0x00,0x00]
; EGPR-NEXT:    # imm = 0xC00
; EGPR-NEXT:    xorps %xmm0, %xmm0 # encoding: [0x0f,0x57,0xc0]
; EGPR-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp) # encoding: [0x0f,0x11,0x84,0x24,0xc0,0x03,0x00,0x00]
; EGPR-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp) # encoding: [0x0f,0x11,0x84,0x24,0xd0,0x03,0x00,0x00]
; EGPR-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp) # encoding: [0x0f,0x11,0x84,0x24,0xe0,0x03,0x00,0x00]
; EGPR-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp) # encoding: [0x0f,0x11,0x84,0x24,0xf0,0x03,0x00,0x00]
; EGPR-NEXT:    movb $1, {{[0-9]+}}(%rsp) # encoding: [0xc6,0x84,0x24,0xc0,0x03,0x00,0x00,0x01]
; EGPR-NEXT:    movq %rcx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; EGPR-NEXT:    # encoding: [0x48,0x89,0x8c,0x24,0xb8,0x03,0x00,0x00]
; EGPR-NEXT:    movl %esi, %eax # encoding: [0x89,0xf0]
; EGPR-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; EGPR-NEXT:    # encoding: [0x48,0x8b,0xb4,0x24,0xb8,0x03,0x00,0x00]
; EGPR-NEXT:    movw %ax, %cx # encoding: [0x66,0x89,0xc1]
; EGPR-NEXT:    movw %di, %ax # encoding: [0x66,0x89,0xf8]
; EGPR-NEXT:    # implicit-def: $al
; EGPR-NEXT:    movb %al, {{[0-9]+}}(%rsp) # encoding: [0x88,0x84,0x24,0xf0,0x03,0x00,0x00]
; EGPR-NEXT:    movw %cx, {{[0-9]+}}(%rsp) # encoding: [0x66,0x89,0x8c,0x24,0xd0,0x03,0x00,0x00]
; EGPR-NEXT:    ldtilecfg {{[0-9]+}}(%rsp) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x78,0x49,0x84,0x24,0xc0,0x03,0x00,0x00]
; EGPR-NEXT:    tileloaddrs (%rdx,%rsi), %tmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7b,0x4a,0x04,0x32]
; EGPR-NEXT:    movl $64, %esi # encoding: [0xbe,0x40,0x00,0x00,0x00]
; EGPR-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx # encoding: [0x48,0x8d,0x94,0x24,0x00,0x04,0x00,0x00]
; EGPR-NEXT:    tilestored %tmm0, (%rdx,%rsi) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7a,0x4b,0x04,0x32]
; EGPR-NEXT:    movq %rbp, %rsp # encoding: [0x48,0x89,0xec]
; EGPR-NEXT:    popq %rbp # encoding: [0x5d]
; EGPR-NEXT:    .cfi_def_cfa %rsp, 8
; EGPR-NEXT:    tilerelease # encoding: [0xc4,0xe2,0x78,0x49,0xc0]
; EGPR-NEXT:    retq # encoding: [0xc3]
entry:
  %t1 = call x86_amx @llvm.x86.tileloaddrs64.internal(i16 %m, i16 %n, ptr %buf, i64 %s)
  %t2 = call <256 x i32> @llvm.x86.cast.tile.to.vector.v256i32(x86_amx %t1)
  ret void
}
declare x86_amx @llvm.x86.tileloaddrs64.internal(i16, i16, ptr, i64)

define void @test_amx_old(i16 %m, i16 %n, ptr %buf) {
; CHECK-LABEL: test_amx_old:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $32, %eax
; CHECK-NEXT:    tileloaddrs (%rdx,%rax), %tmm2
; CHECK-NEXT:    retq
;
; EGPR-LABEL: test_amx_old:
; EGPR:       # %bb.0: # %entry
; EGPR-NEXT:    movl $32, %eax # encoding: [0xb8,0x20,0x00,0x00,0x00]
; EGPR-NEXT:    tileloaddrs (%rdx,%rax), %tmm2 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7b,0x4a,0x14,0x02]
; EGPR-NEXT:    retq # encoding: [0xc3]
entry:
  call void @llvm.x86.tileloaddrs64(i8 2, ptr %buf, i64 32)
  ret void
}
declare void @llvm.x86.tileloaddrs64(i8 immarg, ptr, i64)

define void @test_amx_t1_internal(i16 %m, i16 %n, ptr %buf, i64 %s) {
; CHECK-LABEL: test_amx_t1_internal:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset %rbp, -16
; CHECK-NEXT:    movq %rsp, %rbp
; CHECK-NEXT:    .cfi_def_cfa_register %rbp
; CHECK-NEXT:    andq $-1024, %rsp # imm = 0xFC00
; CHECK-NEXT:    subq $3072, %rsp # imm = 0xC00
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb $1, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movq %rcx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; CHECK-NEXT:    movw %ax, %cx
; CHECK-NEXT:    movw %di, %ax
; CHECK-NEXT:    # implicit-def: $al
; CHECK-NEXT:    movb %al, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; CHECK-NEXT:    tileloaddrst1 (%rdx,%rsi), %tmm0
; CHECK-NEXT:    movl $64, %esi
; CHECK-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; CHECK-NEXT:    tilestored %tmm0, (%rdx,%rsi)
; CHECK-NEXT:    movq %rbp, %rsp
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    .cfi_def_cfa %rsp, 8
; CHECK-NEXT:    tilerelease
; CHECK-NEXT:    retq
;
; EGPR-LABEL: test_amx_t1_internal:
; EGPR:       # %bb.0: # %entry
; EGPR-NEXT:    pushq %rbp # encoding: [0x55]
; EGPR-NEXT:    .cfi_def_cfa_offset 16
; EGPR-NEXT:    .cfi_offset %rbp, -16
; EGPR-NEXT:    movq %rsp, %rbp # encoding: [0x48,0x89,0xe5]
; EGPR-NEXT:    .cfi_def_cfa_register %rbp
; EGPR-NEXT:    andq $-1024, %rsp # encoding: [0x48,0x81,0xe4,0x00,0xfc,0xff,0xff]
; EGPR-NEXT:    # imm = 0xFC00
; EGPR-NEXT:    subq $3072, %rsp # encoding: [0x48,0x81,0xec,0x00,0x0c,0x00,0x00]
; EGPR-NEXT:    # imm = 0xC00
; EGPR-NEXT:    xorps %xmm0, %xmm0 # encoding: [0x0f,0x57,0xc0]
; EGPR-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp) # encoding: [0x0f,0x11,0x84,0x24,0xc0,0x03,0x00,0x00]
; EGPR-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp) # encoding: [0x0f,0x11,0x84,0x24,0xd0,0x03,0x00,0x00]
; EGPR-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp) # encoding: [0x0f,0x11,0x84,0x24,0xe0,0x03,0x00,0x00]
; EGPR-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp) # encoding: [0x0f,0x11,0x84,0x24,0xf0,0x03,0x00,0x00]
; EGPR-NEXT:    movb $1, {{[0-9]+}}(%rsp) # encoding: [0xc6,0x84,0x24,0xc0,0x03,0x00,0x00,0x01]
; EGPR-NEXT:    movq %rcx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; EGPR-NEXT:    # encoding: [0x48,0x89,0x8c,0x24,0xb8,0x03,0x00,0x00]
; EGPR-NEXT:    movl %esi, %eax # encoding: [0x89,0xf0]
; EGPR-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; EGPR-NEXT:    # encoding: [0x48,0x8b,0xb4,0x24,0xb8,0x03,0x00,0x00]
; EGPR-NEXT:    movw %ax, %cx # encoding: [0x66,0x89,0xc1]
; EGPR-NEXT:    movw %di, %ax # encoding: [0x66,0x89,0xf8]
; EGPR-NEXT:    # implicit-def: $al
; EGPR-NEXT:    movb %al, {{[0-9]+}}(%rsp) # encoding: [0x88,0x84,0x24,0xf0,0x03,0x00,0x00]
; EGPR-NEXT:    movw %cx, {{[0-9]+}}(%rsp) # encoding: [0x66,0x89,0x8c,0x24,0xd0,0x03,0x00,0x00]
; EGPR-NEXT:    ldtilecfg {{[0-9]+}}(%rsp) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x78,0x49,0x84,0x24,0xc0,0x03,0x00,0x00]
; EGPR-NEXT:    tileloaddrst1 (%rdx,%rsi), %tmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x79,0x4a,0x04,0x32]
; EGPR-NEXT:    movl $64, %esi # encoding: [0xbe,0x40,0x00,0x00,0x00]
; EGPR-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx # encoding: [0x48,0x8d,0x94,0x24,0x00,0x04,0x00,0x00]
; EGPR-NEXT:    tilestored %tmm0, (%rdx,%rsi) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7a,0x4b,0x04,0x32]
; EGPR-NEXT:    movq %rbp, %rsp # encoding: [0x48,0x89,0xec]
; EGPR-NEXT:    popq %rbp # encoding: [0x5d]
; EGPR-NEXT:    .cfi_def_cfa %rsp, 8
; EGPR-NEXT:    tilerelease # encoding: [0xc4,0xe2,0x78,0x49,0xc0]
; EGPR-NEXT:    retq # encoding: [0xc3]
entry:
  %t1 = call x86_amx @llvm.x86.tileloaddrst164.internal(i16 %m, i16 %n, ptr %buf, i64 %s)
  %t2 = call <256 x i32> @llvm.x86.cast.tile.to.vector.v256i32(x86_amx %t1)
  ret void
}
declare x86_amx @llvm.x86.tileloaddrst164.internal(i16, i16, ptr, i64)

define void @test_amx_t1_old(i16 %m, i16 %n, ptr %buf) {
; CHECK-LABEL: test_amx_t1_old:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $32, %eax
; CHECK-NEXT:    tileloaddrst1 (%rdx,%rax), %tmm2
; CHECK-NEXT:    retq
;
; EGPR-LABEL: test_amx_t1_old:
; EGPR:       # %bb.0: # %entry
; EGPR-NEXT:    movl $32, %eax # encoding: [0xb8,0x20,0x00,0x00,0x00]
; EGPR-NEXT:    tileloaddrst1 (%rdx,%rax), %tmm2 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x79,0x4a,0x14,0x02]
; EGPR-NEXT:    retq # encoding: [0xc3]
entry:
  call void @llvm.x86.tileloaddrst164(i8 2, ptr %buf, i64 32)
  ret void
}
declare void @llvm.x86.tileloaddrst164(i8 immarg, ptr, i64)
