; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test that we are able to generate the Xqcicm instructions
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcicm -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32IXQCICM

define i32 @select_example(i32 %cond, i32 %x, i32 %y) {
; RV32I-LABEL: select_example:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    andi a3, a0, 1
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    bnez a3, .LBB0_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:  .LBB0_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_example:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    andi a0, a0, 1
; RV32IXQCICM-NEXT:    qc.mveqi a1, a0, 0, a2
; RV32IXQCICM-NEXT:    mv a0, a1
; RV32IXQCICM-NEXT:    ret
entry:
  %cond_trunc = trunc i32 %cond to i1
  %sel = select i1 %cond_trunc, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_eq(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eq:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    beq a0, a1, .LBB1_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB1_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_eq:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mveqi a3, a0, 11, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp eq i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_eq1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eq1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    beq a0, a1, .LBB2_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB2_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_eq1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mveqi a3, a0, 11, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp eq i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ne(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ne:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    bne a0, a1, .LBB3_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB3_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ne:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvnei a3, a0, 11, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ne i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ne1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ne1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    bne a0, a1, .LBB4_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB4_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ne1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvnei a3, a0, 11, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ne i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_slt(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slt:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    blt a0, a1, .LBB5_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB5_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_slt:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlti a3, a0, 11, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp slt i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_slt1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slt1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    blt a1, a0, .LBB6_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB6_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_slt1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlti a2, a0, 12, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp slt i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sle(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sle:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 12
; RV32I-NEXT:    blt a0, a1, .LBB7_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB7_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sle:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlti a3, a0, 12, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sle i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sle1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sle1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 10
; RV32I-NEXT:    blt a1, a0, .LBB8_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB8_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sle1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlti a2, a0, 11, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sle i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sgt(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sgt:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    blt a1, a0, .LBB9_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB9_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sgt:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlti a2, a0, 12, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sgt i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sgt1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sgt1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    blt a0, a1, .LBB10_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB10_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sgt1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlti a3, a0, 11, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sgt i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sge(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sge:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 10
; RV32I-NEXT:    blt a1, a0, .LBB11_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB11_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sge:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlti a2, a0, 11, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sge i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sge1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sge1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 12
; RV32I-NEXT:    blt a0, a1, .LBB12_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB12_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sge1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlti a3, a0, 12, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sge i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ule(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ule:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 12
; RV32I-NEXT:    bltu a0, a1, .LBB13_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB13_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ule:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltui a3, a0, 12, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ule i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ule1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ule1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 10
; RV32I-NEXT:    bltu a1, a0, .LBB14_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB14_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ule1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltui a2, a0, 11, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ule i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ugt(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ugt:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    bltu a1, a0, .LBB15_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB15_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ugt:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltui a2, a0, 12, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ugt i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ugt1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ugt1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    bltu a0, a1, .LBB16_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB16_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ugt1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltui a3, a0, 11, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ugt i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ult(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ult:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    bltu a0, a1, .LBB17_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB17_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ult:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltui a3, a0, 11, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ult i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ult1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ult1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    bltu a1, a0, .LBB18_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB18_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ult1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltui a2, a0, 12, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ult i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_uge(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_uge:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 10
; RV32I-NEXT:    bltu a1, a0, .LBB19_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB19_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_uge:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltui a2, a0, 11, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp uge i32 %a, 11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_uge1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_uge1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, 12
; RV32I-NEXT:    bltu a0, a1, .LBB20_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB20_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_uge1:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltui a3, a0, 12, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp uge i32 11, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_eq_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eq_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    beq a0, a1, .LBB21_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB21_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_eq_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mveq a3, a0, a1, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp eq i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ne_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ne_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bne a0, a1, .LBB22_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB22_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ne_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvne a3, a0, a1, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ne i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_slt_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slt_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    blt a0, a1, .LBB23_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB23_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_slt_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlt a3, a0, a1, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp slt i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sge_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sge_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bge a0, a1, .LBB24_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB24_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sge_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlt a2, a0, a1, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sge i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sgt_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sgt_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    blt a1, a0, .LBB25_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB25_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sgt_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlt a3, a1, a0, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sgt i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_sle_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sle_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bge a1, a0, .LBB26_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB26_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_sle_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvlt a2, a1, a0, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp sle i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ugt_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ugt_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bltu a1, a0, .LBB27_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB27_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ugt_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltu a3, a1, a0, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ugt i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ult_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ult_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bltu a0, a1, .LBB28_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB28_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ult_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltu a3, a0, a1, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ult i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_uge_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_uge_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bgeu a0, a1, .LBB29_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB29_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_uge_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltu a2, a0, a1, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp uge i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ule_reg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ule_reg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bgeu a1, a0, .LBB30_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB30_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ule_reg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    qc.mvltu a2, a1, a0, a3
; RV32IXQCICM-NEXT:    mv a0, a2
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ule i32 %a, %b
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}

define i32 @select_cc_example_ule_neg(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ule_neg:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a1, -10
; RV32I-NEXT:    bltu a0, a1, .LBB31_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:  .LBB31_2: # %entry
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IXQCICM-LABEL: select_cc_example_ule_neg:
; RV32IXQCICM:       # %bb.0: # %entry
; RV32IXQCICM-NEXT:    li a1, -10
; RV32IXQCICM-NEXT:    qc.mvltu a3, a0, a1, a2
; RV32IXQCICM-NEXT:    mv a0, a3
; RV32IXQCICM-NEXT:    ret
entry:
  %cmp = icmp ule i32 %a, -11
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}
