; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -march=nvptx64 --debug-counter=dagcombine=0 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -march=nvptx64 --debug-counter=dagcombine=0 | %ptxas-verify %}

; REQUIRES: asserts
; asserts are required for --debug-counter=dagcombine=0 to have the intended
; effect of disabling DAG combines, which exposes the bug. When combines are
; enabled the bug does not occur.

%struct.1float = type <{ [1 x float] }>

declare i32 @callee(%struct.1float %a)

define i32 @test(%struct.1float alignstack(32) %data) {
; CHECK-LABEL: test(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_param_0];
; CHECK-NEXT:    shr.u32 %r2, %r1, 8;
; CHECK-NEXT:    shr.u32 %r3, %r1, 16;
; CHECK-NEXT:    shr.u32 %r4, %r1, 24;
; CHECK-NEXT:    { // callseq 0, 0
; CHECK-NEXT:    .param .align 1 .b8 param0[4];
; CHECK-NEXT:    st.param.b8 [param0], %r1;
; CHECK-NEXT:    st.param.b8 [param0+1], %r2;
; CHECK-NEXT:    st.param.b8 [param0+2], %r3;
; CHECK-NEXT:    st.param.b8 [param0+3], %r4;
; CHECK-NEXT:    .param .b32 retval0;
; CHECK-NEXT:    call.uni (retval0), callee, (param0);
; CHECK-NEXT:    ld.param.b32 %r5, [retval0];
; CHECK-NEXT:    } // callseq 0
; CHECK-NEXT:    st.param.b32 [func_retval0], %r5;
; CHECK-NEXT:    ret;

  %1 = call i32 @callee(%struct.1float %data)
  ret i32 %1
}
