; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -disable-output -passes="print<scalar-evolution>" < %s 2>&1 | FileCheck %s

define i32 @test_expr_with_constant_1(i32 %x) {
; CHECK-LABEL: 'test_expr_with_constant_1'
; CHECK-NEXT:  Classifying expressions for: @test_expr_with_constant_1
; CHECK-NEXT:    %smax = tail call i32 @llvm.smax.i32(i32 %x, i32 1)
; CHECK-NEXT:    --> (1 smax %x) U: [1,-2147483648) S: [1,-2147483648)
; CHECK-NEXT:    %add = add nsw i32 %smax, -1
; CHECK-NEXT:    --> (-1 + (1 smax %x))<nsw> U: [0,2147483647) S: [0,2147483647)
; CHECK-NEXT:    %udiv = udiv i32 %add, %x
; CHECK-NEXT:    --> 0 U: [0,1) S: [0,1)
; CHECK-NEXT:  Determining loop execution counts for: @test_expr_with_constant_1
;
entry:
  %smax = tail call i32 @llvm.smax.i32(i32 %x, i32 1)
  %add = add nsw i32 %smax, -1
  %udiv = udiv i32 %add, %x
  ret i32 %udiv
}

; Non-1 constant: (-2 + (2 smax %x)) /u %x
define i32 @test_expr_with_constant_2(i32 %x) {
; CHECK-LABEL: 'test_expr_with_constant_2'
; CHECK-NEXT:  Classifying expressions for: @test_expr_with_constant_2
; CHECK-NEXT:    %smax = tail call i32 @llvm.smax.i32(i32 %x, i32 2)
; CHECK-NEXT:    --> (2 smax %x) U: [2,-2147483648) S: [2,-2147483648)
; CHECK-NEXT:    %add = add nsw i32 %smax, -2
; CHECK-NEXT:    --> (-2 + (2 smax %x))<nsw> U: [0,2147483646) S: [0,2147483646)
; CHECK-NEXT:    %udiv = udiv i32 %add, %x
; CHECK-NEXT:    --> 0 U: [0,1) S: [0,1)
; CHECK-NEXT:  Determining loop execution counts for: @test_expr_with_constant_2
;
entry:
  %smax = tail call i32 @llvm.smax.i32(i32 %x, i32 2)
  %add = add nsw i32 %smax, -2
  %udiv = udiv i32 %add, %x
  ret i32 %udiv
}

; Negative test, constants mismatch: (-3 + (2 smax %x)) /u %x
define i32 @test_expr_mismatch_constants(i32 %x) {
; CHECK-LABEL: 'test_expr_mismatch_constants'
; CHECK-NEXT:  Classifying expressions for: @test_expr_mismatch_constants
; CHECK-NEXT:    %smax = tail call i32 @llvm.smax.i32(i32 %x, i32 2)
; CHECK-NEXT:    --> (2 smax %x) U: [2,-2147483648) S: [2,-2147483648)
; CHECK-NEXT:    %add = add nsw i32 %smax, -3
; CHECK-NEXT:    --> (-3 + (2 smax %x))<nsw> U: [-1,2147483645) S: [-1,2147483645)
; CHECK-NEXT:    %udiv = udiv i32 %add, %x
; CHECK-NEXT:    --> ((-3 + (2 smax %x))<nsw> /u %x) U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @test_expr_mismatch_constants
;
entry:
  %smax = tail call i32 @llvm.smax.i32(i32 %x, i32 2)
  %add = add nsw i32 %smax, -3
  %udiv = udiv i32 %add, %x
  ret i32 %udiv
}

; Negative constant: (3 + (-3 smax %x)) /u %x
define i32 @test_expr_negative_constant(i32 %x) {
; CHECK-LABEL: 'test_expr_negative_constant'
; CHECK-NEXT:  Classifying expressions for: @test_expr_negative_constant
; CHECK-NEXT:    %smax = tail call i32 @llvm.smax.i32(i32 %x, i32 -3)
; CHECK-NEXT:    --> (-3 smax %x) U: [-3,-2147483648) S: [-3,-2147483648)
; CHECK-NEXT:    %add = add nsw i32 %smax, 3
; CHECK-NEXT:    --> (3 + (-3 smax %x)) U: [0,-2147483645) S: [0,-2147483645)
; CHECK-NEXT:    %udiv = udiv i32 %add, %x
; CHECK-NEXT:    --> ((3 + (-3 smax %x)) /u %x) U: [0,-2147483645) S: [0,-2147483645)
; CHECK-NEXT:  Determining loop execution counts for: @test_expr_negative_constant
;
entry:
  %smax = tail call i32 @llvm.smax.i32(i32 %x, i32 -3)
  %add = add nsw i32 %smax, 3
  %udiv = udiv i32 %add, %x
  ret i32 %udiv
}

; Negative signed minimum value.
define i8 @text_expr_with_constant_signed_min(i8 %x) {
; CHECK-LABEL: 'text_expr_with_constant_signed_min'
; CHECK-NEXT:  Classifying expressions for: @text_expr_with_constant_signed_min
; CHECK-NEXT:    %smax = tail call i8 @llvm.smax.i8(i8 %x, i8 -128)
; CHECK-NEXT:    --> %x U: full-set S: full-set
; CHECK-NEXT:    %add = add nsw i8 %smax, -128
; CHECK-NEXT:    --> (-128 + %x) U: full-set S: full-set
; CHECK-NEXT:    %udiv = udiv i8 %add, %x
; CHECK-NEXT:    --> ((-128 + %x) /u %x) U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @text_expr_with_constant_signed_min
;
entry:
  %smax = tail call i8 @llvm.smax.i8(i8 %x, i8 128)
  %add = add nsw i8 %smax, -128
  %udiv = udiv i8 %add, %x
  ret i8 %udiv
}
