; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -mattr=+2e3 | FileCheck %s
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky  | FileCheck %s --check-prefix=GENERIC

define i32 @selectRR_eq_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_eq_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_eq_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB0_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB0_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_eq_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_eq_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_eq_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB1_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB1_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_eq_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_eq_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmpne16 a0, a3
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_eq_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 241
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmpne16 a0, l0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB2_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB2_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_eq_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_eq_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_eq_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB3_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB3_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_0_if_true(i1 %c, i32 %q) {
; CHECK-LABEL: selectRI_0_if_true:
; CHECK:       # %bb.0:
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    clrt32 a1
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_0_if_true:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a2, a0
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    btsti16 a2, 0
; GENERIC-NEXT:    bt16 .LBB4_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:  .LBB4_2:
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
  %ret = select i1 %c, i32 0, i32 %q
  ret i32 %ret
}

define i32 @selectRI_0_if_false(i1 %c, i32 %q) {
; CHECK-LABEL: selectRI_0_if_false:
; CHECK:       # %bb.0:
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    clrf32 a1
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_0_if_false:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB5_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:  .LBB5_2:
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
  %ret = select i1 %c, i32 %q, i32 0
  ret i32 %ret
}

define i64 @selectRR_eq_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_eq_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    addu16 a0, sp
; CHECK-NEXT:    mov16 a1, a0
; CHECK-NEXT:    addi16 a0, sp, 8
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    ld16.w a0, (a1, 0)
; CHECK-NEXT:    ld16.w a1, (a1, 4)
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_eq_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    xor16 a1, a3
; GENERIC-NEXT:    xor16 a0, a2
; GENERIC-NEXT:    or16 a0, a1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB6_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 4
; GENERIC-NEXT:    br32 .LBB6_3
; GENERIC-NEXT:  .LBB6_2:
; GENERIC-NEXT:    movi16 a0, 12
; GENERIC-NEXT:  .LBB6_3: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_eq_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_eq_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 4)
; CHECK-NEXT:    ld32.w t1, (sp, 0)
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movf32 a2, t1
; CHECK-NEXT:    movf32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_eq_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 10
; GENERIC-NEXT:    xor16 l0, a0
; GENERIC-NEXT:    or16 l0, a1
; GENERIC-NEXT:    cmpnei16 l0, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB7_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    ld16.w a2, (sp, 8)
; GENERIC-NEXT:  .LBB7_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB7_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a3, (sp, 12)
; GENERIC-NEXT:  .LBB7_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_eq_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_eq_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    xor16 a0, l0
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movf32 a2, t1
; CHECK-NEXT:    movf32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_eq_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 l0, 2
; GENERIC-NEXT:    lsli16 l0, l0, 24
; GENERIC-NEXT:    movi16 l1, 217
; GENERIC-NEXT:    lsli16 l1, l1, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 241
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    xor16 l1, a0
; GENERIC-NEXT:    or16 l1, a1
; GENERIC-NEXT:    cmpnei16 l1, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB8_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    ld16.w a2, (sp, 12)
; GENERIC-NEXT:  .LBB8_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB8_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a3, (sp, 16)
; GENERIC-NEXT:  .LBB8_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_eq_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_eq_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_eq_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB9_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB9_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB9_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB9_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_eq_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_eq_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_eq_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    lsli16 l1, l0, 24
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 255
; GENERIC-NEXT:    lsli16 l2, l1, 8
; GENERIC-NEXT:    or16 l2, l0
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    and16 a0, l2
; GENERIC-NEXT:    and16 l2, a1
; GENERIC-NEXT:    cmpne16 l2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB10_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB10_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_eq_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_eq_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_eq_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    cmpnei16 l1, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB11_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB11_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_eq_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_eq_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei32 a0, 2033
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_eq_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    movi16 a0, 7
; GENERIC-NEXT:    lsli16 a0, a0, 8
; GENERIC-NEXT:    or16 a0, a3
; GENERIC-NEXT:    movi16 a3, 241
; GENERIC-NEXT:    or16 a3, a0
; GENERIC-NEXT:    cmpne16 l1, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB12_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB12_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_eq_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_eq_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_eq_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB13_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB13_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_eq_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_eq_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_eq_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    and16 a1, l0
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB14_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB14_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_eq_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_eq_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_eq_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmpnei16 a3, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB15_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB15_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_eq_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_eq_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei32 a0, 241
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_eq_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 241
; GENERIC-NEXT:    cmpne16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB16_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB16_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_eq_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_eq_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_eq_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB17_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB17_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_eq_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_eq_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    mov16 a0, a3
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_eq_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    xor16 a0, a1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB18_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a3
; GENERIC-NEXT:  .LBB18_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_eq_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_eq_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_eq_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB19_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:  .LBB19_2: # %entry
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_eq_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_eq_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_eq_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB20_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB20_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_eq_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_eq_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_eq_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB21_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB21_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_ne_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_ne_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ne_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB22_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB22_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_ne_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_ne_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ne_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB23_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB23_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_ne_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_ne_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmpne16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ne_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 241
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmpne16 a0, l0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB24_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB24_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_ne_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_ne_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ne_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB25_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB25_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_ne_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_ne_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    addu16 a0, sp
; CHECK-NEXT:    mov16 a1, a0
; CHECK-NEXT:    addi16 a0, sp, 8
; CHECK-NEXT:    movt32 a1, a0
; CHECK-NEXT:    ld16.w a0, (a1, 0)
; CHECK-NEXT:    ld16.w a1, (a1, 4)
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ne_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    xor16 a1, a3
; GENERIC-NEXT:    xor16 a0, a2
; GENERIC-NEXT:    or16 a0, a1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB26_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 4
; GENERIC-NEXT:    br32 .LBB26_3
; GENERIC-NEXT:  .LBB26_2:
; GENERIC-NEXT:    movi16 a0, 12
; GENERIC-NEXT:  .LBB26_3: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_ne_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_ne_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 4)
; CHECK-NEXT:    ld32.w t1, (sp, 0)
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ne_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 10
; GENERIC-NEXT:    xor16 l0, a0
; GENERIC-NEXT:    or16 l0, a1
; GENERIC-NEXT:    cmpnei16 l0, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB27_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    ld16.w a2, (sp, 8)
; GENERIC-NEXT:  .LBB27_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB27_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a3, (sp, 12)
; GENERIC-NEXT:  .LBB27_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_ne_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_ne_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    xor16 a0, l0
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ne_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 l0, 2
; GENERIC-NEXT:    lsli16 l0, l0, 24
; GENERIC-NEXT:    movi16 l1, 217
; GENERIC-NEXT:    lsli16 l1, l1, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 241
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    xor16 l1, a0
; GENERIC-NEXT:    or16 l1, a1
; GENERIC-NEXT:    cmpnei16 l1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB28_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    ld16.w a2, (sp, 12)
; GENERIC-NEXT:  .LBB28_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB28_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a3, (sp, 16)
; GENERIC-NEXT:  .LBB28_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_ne_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_ne_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ne_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB29_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB29_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB29_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB29_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_ne_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_ne_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ne_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    lsli16 l1, l0, 24
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 255
; GENERIC-NEXT:    lsli16 l2, l1, 8
; GENERIC-NEXT:    or16 l2, l0
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    and16 a0, l2
; GENERIC-NEXT:    and16 l2, a1
; GENERIC-NEXT:    cmpne16 l2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB30_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB30_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_ne_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_ne_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ne_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    cmpnei16 l1, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB31_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB31_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_ne_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_ne_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei32 a0, 2033
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ne_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    movi16 a0, 7
; GENERIC-NEXT:    lsli16 a0, a0, 8
; GENERIC-NEXT:    or16 a0, a3
; GENERIC-NEXT:    movi16 a3, 241
; GENERIC-NEXT:    or16 a3, a0
; GENERIC-NEXT:    cmpne16 l1, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB32_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB32_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_ne_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_ne_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ne_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB33_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB33_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_ne_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_ne_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ne_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    and16 a1, l0
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB34_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB34_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_ne_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_ne_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ne_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmpnei16 a3, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB35_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB35_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_ne_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_ne_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei32 a0, 241
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ne_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 241
; GENERIC-NEXT:    cmpne16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB36_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB36_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_ne_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_ne_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ne_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB37_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB37_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_ne_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_ne_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ne_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    xor16 a0, a1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB38_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB38_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_ne_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_ne_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ne_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB39_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB39_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_ne_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_ne_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ne_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB40_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:  .LBB40_2: # %entry
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_ne_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_ne_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ne_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB41_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB41_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_ugt_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_ugt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ugt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB42_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB42_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_ugt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_ugt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ugt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 10
; GENERIC-NEXT:    cmphs16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB43_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB43_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_ugt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_ugt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ugt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 241
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmphs16 l0, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB44_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB44_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_ugt_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_ugt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ugt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB45_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB45_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_ugt_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_ugt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 8
; CHECK-NEXT:    addi16 a0, sp, 16
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ugt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmphs16 a1, a3
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphs16 a0, a2
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB46_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a0, l0
; GENERIC-NEXT:  .LBB46_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB46_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    movi16 a0, 8
; GENERIC-NEXT:    br32 .LBB46_5
; GENERIC-NEXT:  .LBB46_4:
; GENERIC-NEXT:    movi16 a0, 16
; GENERIC-NEXT:  .LBB46_5: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_ugt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_ugt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movi16 l0, 10
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ugt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 l0, 10
; GENERIC-NEXT:    cmphs16 l0, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB47_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB47_6
; GENERIC-NEXT:  .LBB47_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB47_4
; GENERIC-NEXT:  .LBB47_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 12)
; GENERIC-NEXT:  .LBB47_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB47_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB47_2
; GENERIC-NEXT:  .LBB47_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 8)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB47_3
; GENERIC-NEXT:    br32 .LBB47_4
entry:
  %icmp = icmp ugt i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_ugt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_ugt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ugt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 l0, 2
; GENERIC-NEXT:    lsli16 l0, l0, 24
; GENERIC-NEXT:    movi16 l1, 217
; GENERIC-NEXT:    lsli16 l1, l1, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 241
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    cmphs16 l1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB48_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB48_6
; GENERIC-NEXT:  .LBB48_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB48_4
; GENERIC-NEXT:  .LBB48_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 16)
; GENERIC-NEXT:  .LBB48_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB48_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB48_2
; GENERIC-NEXT:  .LBB48_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 12)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB48_3
; GENERIC-NEXT:    br32 .LBB48_4
entry:
  %icmp = icmp ugt i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_ugt_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_ugt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ugt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB49_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB49_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB49_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB49_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_ugt_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_ugt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ugt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    lsli16 l1, l0, 24
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 255
; GENERIC-NEXT:    lsli16 l2, l1, 8
; GENERIC-NEXT:    or16 l2, l0
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    and16 a1, l2
; GENERIC-NEXT:    and16 l2, a0
; GENERIC-NEXT:    cmphs16 l2, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB50_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB50_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_ugt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_ugt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ugt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    movi16 a0, 10
; GENERIC-NEXT:    cmphs16 a0, l1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB51_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB51_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_ugt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_ugt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi32 a3, 2033
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ugt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    movi16 a0, 7
; GENERIC-NEXT:    lsli16 a0, a0, 8
; GENERIC-NEXT:    or16 a0, a3
; GENERIC-NEXT:    movi16 a3, 241
; GENERIC-NEXT:    or16 a3, a0
; GENERIC-NEXT:    cmphs16 a3, l1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB52_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB52_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_ugt_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_ugt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ugt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB53_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB53_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_ugt_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_ugt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ugt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    and16 a1, l0
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB54_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB54_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_ugt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_ugt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ugt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 10
; GENERIC-NEXT:    cmphs16 a0, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB55_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB55_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_ugt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_ugt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 241
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ugt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 241
; GENERIC-NEXT:    cmphs16 a0, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB56_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB56_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_ugt_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_ugt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ugt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB57_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB57_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_ugt_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_ugt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ugt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    bf16 .LBB58_3
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB58_4
; GENERIC-NEXT:  .LBB58_2: # %entry
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB58_3: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB58_2
; GENERIC-NEXT:  .LBB58_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_ugt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_ugt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ugt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB59_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB59_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_ugt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_ugt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ugt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_ugt_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_ugt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ugt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB61_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB61_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_uge_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_uge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_uge_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB62_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB62_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_uge_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_uge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_uge_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 9
; GENERIC-NEXT:    cmphs16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB63_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB63_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_uge_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_uge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2032
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_uge_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 240
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmphs16 l0, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB64_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB64_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_uge_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_uge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_uge_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB65_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB65_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_uge_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_uge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 16
; CHECK-NEXT:    addi16 a0, sp, 24
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_uge_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    cmphs16 a3, a1
; GENERIC-NEXT:    mvcv16 l1
; GENERIC-NEXT:    movi16 l0, 1
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB66_3
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    subu16 l0, l1
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bf16 .LBB66_4
; GENERIC-NEXT:  .LBB66_2:
; GENERIC-NEXT:    movi16 a0, 20
; GENERIC-NEXT:    br32 .LBB66_5
; GENERIC-NEXT:  .LBB66_3:
; GENERIC-NEXT:    subu16 l0, a0
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bt16 .LBB66_2
; GENERIC-NEXT:  .LBB66_4: # %entry
; GENERIC-NEXT:    movi16 a0, 12
; GENERIC-NEXT:  .LBB66_5: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_uge_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_uge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movi16 l0, 9
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_uge_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 l0, 9
; GENERIC-NEXT:    cmphs16 l0, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB67_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB67_6
; GENERIC-NEXT:  .LBB67_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB67_4
; GENERIC-NEXT:  .LBB67_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 12)
; GENERIC-NEXT:  .LBB67_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB67_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB67_2
; GENERIC-NEXT:  .LBB67_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 8)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB67_3
; GENERIC-NEXT:    br32 .LBB67_4
entry:
  %icmp = icmp uge i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_uge_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_uge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2032
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_uge_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 l0, 2
; GENERIC-NEXT:    lsli16 l0, l0, 24
; GENERIC-NEXT:    movi16 l1, 217
; GENERIC-NEXT:    lsli16 l1, l1, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 240
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    cmphs16 l1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB68_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB68_6
; GENERIC-NEXT:  .LBB68_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB68_4
; GENERIC-NEXT:  .LBB68_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 16)
; GENERIC-NEXT:  .LBB68_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB68_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB68_2
; GENERIC-NEXT:  .LBB68_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 12)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB68_3
; GENERIC-NEXT:    br32 .LBB68_4
entry:
  %icmp = icmp uge i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_uge_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_uge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_uge_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB69_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB69_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB69_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB69_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_uge_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_uge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_uge_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    lsli16 l1, l0, 24
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 255
; GENERIC-NEXT:    lsli16 l2, l1, 8
; GENERIC-NEXT:    or16 l2, l0
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    and16 a0, l2
; GENERIC-NEXT:    and16 l2, a1
; GENERIC-NEXT:    cmphs16 l2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB70_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB70_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_uge_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_uge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_uge_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    movi16 a0, 9
; GENERIC-NEXT:    cmphs16 a0, l1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB71_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB71_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_uge_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_uge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi32 a3, 2032
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_uge_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    movi16 a0, 7
; GENERIC-NEXT:    lsli16 a0, a0, 8
; GENERIC-NEXT:    or16 a0, a3
; GENERIC-NEXT:    movi16 a3, 240
; GENERIC-NEXT:    or16 a3, a0
; GENERIC-NEXT:    cmphs16 a3, l1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB72_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB72_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_uge_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_uge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_uge_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB73_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB73_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_uge_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_uge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_uge_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    and16 a1, l0
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB74_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB74_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_uge_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_uge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_uge_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 9
; GENERIC-NEXT:    cmphs16 a0, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB75_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB75_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_uge_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_uge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 240
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_uge_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 240
; GENERIC-NEXT:    cmphs16 a0, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB76_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB76_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_uge_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_uge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_uge_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB77_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB77_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_uge_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_uge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    mov16 a0, a3
; CHECK-NEXT:    movt32 a0, a2
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a0, a3
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_uge_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB78_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a3
; GENERIC-NEXT:  .LBB78_2: # %entry
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB78_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB78_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_uge_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_uge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_uge_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_uge_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_uge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_uge_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB80_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB80_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp uge i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_uge_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_uge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_uge_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB81_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB81_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_ult_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_ult_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ult_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB82_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB82_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_ult_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_ult_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ult_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphsi16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB83_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB83_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_ult_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_ult_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmphs16 a0, a3
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ult_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 241
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmphs16 a0, l0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB84_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB84_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_ult_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_ult_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ult_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB85_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB85_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_ult_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_ult_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 8
; CHECK-NEXT:    addi16 a0, sp, 16
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ult_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmphs16 a3, a1
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB86_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a0, l0
; GENERIC-NEXT:  .LBB86_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB86_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    movi16 a0, 8
; GENERIC-NEXT:    br32 .LBB86_5
; GENERIC-NEXT:  .LBB86_4:
; GENERIC-NEXT:    movi16 a0, 16
; GENERIC-NEXT:  .LBB86_5: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_ult_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_ult_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    ld32.w t0, (sp, 12)
; CHECK-NEXT:    ld32.w t1, (sp, 8)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    st16.w a2, (sp, 0)
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    ld16.w a2, (sp, 0)
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ult_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphsi16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB87_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB87_6
; GENERIC-NEXT:  .LBB87_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB87_4
; GENERIC-NEXT:  .LBB87_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 8)
; GENERIC-NEXT:  .LBB87_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB87_5: # %entry
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB87_2
; GENERIC-NEXT:  .LBB87_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB87_3
; GENERIC-NEXT:    br32 .LBB87_4
entry:
  %icmp = icmp ult i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_ult_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_ult_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    cmphs16 a0, l0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ult_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 l0, 2
; GENERIC-NEXT:    lsli16 l0, l0, 24
; GENERIC-NEXT:    movi16 l1, 217
; GENERIC-NEXT:    lsli16 l1, l1, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 241
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    cmphs16 a0, l1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB88_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB88_6
; GENERIC-NEXT:  .LBB88_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB88_4
; GENERIC-NEXT:  .LBB88_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 16)
; GENERIC-NEXT:  .LBB88_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB88_5: # %entry
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB88_2
; GENERIC-NEXT:  .LBB88_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 12)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB88_3
; GENERIC-NEXT:    br32 .LBB88_4
entry:
  %icmp = icmp ult i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_ult_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_ult_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ult_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB89_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB89_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB89_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB89_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_ult_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_ult_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ult_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    lsli16 l1, l0, 24
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 255
; GENERIC-NEXT:    lsli16 l2, l1, 8
; GENERIC-NEXT:    or16 l2, l0
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    and16 a0, l2
; GENERIC-NEXT:    and16 l2, a1
; GENERIC-NEXT:    cmphs16 l2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB90_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB90_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_ult_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_ult_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ult_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    cmphsi16 l1, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB91_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB91_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_ult_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_ult_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi32 a0, 2033
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ult_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    movi16 a0, 7
; GENERIC-NEXT:    lsli16 a0, a0, 8
; GENERIC-NEXT:    or16 a0, a3
; GENERIC-NEXT:    movi16 a3, 241
; GENERIC-NEXT:    or16 a3, a0
; GENERIC-NEXT:    cmphs16 l1, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB92_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB92_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_ult_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_ult_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ult_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB93_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB93_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_ult_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_ult_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ult_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    and16 a1, l0
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB94_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB94_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_ult_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_ult_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ult_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmphsi16 a3, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB95_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB95_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_ult_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_ult_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi32 a0, 241
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ult_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 241
; GENERIC-NEXT:    cmphs16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB96_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB96_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_ult_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_ult_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ult_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB97_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB97_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_ult_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_ult_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ult_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    mov16 l0, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    bt16 .LBB98_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:  .LBB98_2: # %entry
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bt16 .LBB98_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:  .LBB98_4: # %entry
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_ult_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_ult_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ult_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_ult_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_ult_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ult_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB100_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:  .LBB100_2: # %entry
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ult i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_ult_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_ult_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ult_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB101_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB101_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}

define i32 @selectRR_ule_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_ule_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ule_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB102_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB102_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_ule_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_ule_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ule_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphsi16 a0, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB103_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB103_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_ule_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_ule_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2034
; CHECK-NEXT:    cmphs16 a0, a3
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ule_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 242
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmphs16 a0, l0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB104_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB104_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_ule_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_ule_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ule_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB105_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB105_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_ule_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_ule_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 16
; CHECK-NEXT:    addi16 a0, sp, 24
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ule_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    cmphs16 a1, a3
; GENERIC-NEXT:    mvcv16 l1
; GENERIC-NEXT:    movi16 l0, 1
; GENERIC-NEXT:    cmphs16 a0, a2
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB106_3
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    subu16 l0, l1
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bf16 .LBB106_4
; GENERIC-NEXT:  .LBB106_2:
; GENERIC-NEXT:    movi16 a0, 20
; GENERIC-NEXT:    br32 .LBB106_5
; GENERIC-NEXT:  .LBB106_3:
; GENERIC-NEXT:    subu16 l0, a0
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bt16 .LBB106_2
; GENERIC-NEXT:  .LBB106_4: # %entry
; GENERIC-NEXT:    movi16 a0, 12
; GENERIC-NEXT:  .LBB106_5: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_ule_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_ule_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    ld32.w t0, (sp, 12)
; CHECK-NEXT:    ld32.w t1, (sp, 8)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    st16.w a2, (sp, 0)
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    ld16.w a2, (sp, 0)
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ule_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphsi16 a0, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB107_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB107_6
; GENERIC-NEXT:  .LBB107_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB107_4
; GENERIC-NEXT:  .LBB107_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 8)
; GENERIC-NEXT:  .LBB107_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB107_5: # %entry
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB107_2
; GENERIC-NEXT:  .LBB107_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB107_3
; GENERIC-NEXT:    br32 .LBB107_4
entry:
  %icmp = icmp ule i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_ule_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_ule_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2034
; CHECK-NEXT:    cmphs16 a0, l0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ule_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 l0, 2
; GENERIC-NEXT:    lsli16 l0, l0, 24
; GENERIC-NEXT:    movi16 l1, 217
; GENERIC-NEXT:    lsli16 l1, l1, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 242
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    cmphs16 a0, l1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB108_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB108_6
; GENERIC-NEXT:  .LBB108_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB108_4
; GENERIC-NEXT:  .LBB108_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 16)
; GENERIC-NEXT:  .LBB108_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB108_5: # %entry
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB108_2
; GENERIC-NEXT:  .LBB108_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 12)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB108_3
; GENERIC-NEXT:    br32 .LBB108_4
entry:
  %icmp = icmp ule i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_ule_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_ule_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ule_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB109_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB109_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB109_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB109_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_ule_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_ule_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ule_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    lsli16 l1, l0, 24
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, l1
; GENERIC-NEXT:    movi16 l1, 255
; GENERIC-NEXT:    lsli16 l2, l1, 8
; GENERIC-NEXT:    or16 l2, l0
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    and16 a1, l2
; GENERIC-NEXT:    and16 l2, a0
; GENERIC-NEXT:    cmphs16 l2, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB110_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB110_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_ule_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_ule_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ule_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    cmphsi16 l1, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB111_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB111_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_ule_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_ule_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi32 a0, 2034
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ule_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    lsli16 l1, l0, 8
; GENERIC-NEXT:    or16 l1, a3
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    and16 l1, a0
; GENERIC-NEXT:    movi16 a0, 7
; GENERIC-NEXT:    lsli16 a0, a0, 8
; GENERIC-NEXT:    or16 a0, a3
; GENERIC-NEXT:    movi16 a3, 242
; GENERIC-NEXT:    or16 a3, a0
; GENERIC-NEXT:    cmphs16 l1, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB112_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB112_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_ule_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_ule_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ule_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB113_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB113_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_ule_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_ule_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ule_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 255
; GENERIC-NEXT:    and16 a1, l0
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB114_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB114_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_ule_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_ule_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ule_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmphsi16 a3, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB115_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB115_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_ule_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_ule_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi32 a0, 242
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ule_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 242
; GENERIC-NEXT:    cmphs16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB116_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB116_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_ule_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_ule_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ule_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB117_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB117_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_ule_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_ule_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_ule_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB118_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a3
; GENERIC-NEXT:  .LBB118_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB118_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB118_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_ule_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_ule_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_ule_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB119_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:  .LBB119_2: # %entry
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_ule_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_ule_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_ule_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_ule_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_ule_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_ule_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB121_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB121_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_sgt_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_sgt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sgt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB122_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB122_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_sgt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_sgt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sgt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 10
; GENERIC-NEXT:    cmplt16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB123_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB123_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_sgt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_sgt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sgt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 241
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmplt16 l0, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB124_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB124_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_sgt_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_sgt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sgt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB125_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB125_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_sgt_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_sgt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 12
; CHECK-NEXT:    addi16 a0, sp, 20
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sgt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmplt16 a1, a3
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphs16 a0, a2
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB126_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:  .LBB126_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB126_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    movi16 a0, 8
; GENERIC-NEXT:    br32 .LBB126_5
; GENERIC-NEXT:  .LBB126_4:
; GENERIC-NEXT:    movi16 a0, 16
; GENERIC-NEXT:  .LBB126_5: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_sgt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_sgt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 l0, a1
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movi16 l0, 10
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti16 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sgt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    cmplt16 l0, a1
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    movi16 l1, 10
; GENERIC-NEXT:    cmphs16 l1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB127_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB127_6
; GENERIC-NEXT:  .LBB127_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB127_4
; GENERIC-NEXT:  .LBB127_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 16)
; GENERIC-NEXT:  .LBB127_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB127_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB127_2
; GENERIC-NEXT:  .LBB127_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 12)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB127_3
; GENERIC-NEXT:    br32 .LBB127_4
entry:
  %icmp = icmp sgt i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_sgt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_sgt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 l0, a1
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti16 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sgt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    cmplt16 l0, a1
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    movi16 l1, 2
; GENERIC-NEXT:    lsli16 l1, l1, 24
; GENERIC-NEXT:    movi16 l2, 217
; GENERIC-NEXT:    lsli16 l2, l2, 16
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    movi16 l1, 7
; GENERIC-NEXT:    lsli16 l1, l1, 8
; GENERIC-NEXT:    or16 l1, l2
; GENERIC-NEXT:    movi16 l2, 241
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    cmphs16 l2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB128_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB128_6
; GENERIC-NEXT:  .LBB128_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB128_4
; GENERIC-NEXT:  .LBB128_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 20)
; GENERIC-NEXT:  .LBB128_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB128_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB128_2
; GENERIC-NEXT:  .LBB128_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 16)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB128_3
; GENERIC-NEXT:    br32 .LBB128_4
entry:
  %icmp = icmp sgt i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_sgt_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_sgt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sgt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB129_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB129_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB129_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB129_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_sgt_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_sgt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sgt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a1, a1
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB130_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB130_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_sgt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_sgt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sgt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a3, 10
; GENERIC-NEXT:    cmplt16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB131_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB131_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_sgt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_sgt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi32 a3, 2033
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sgt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 241
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    cmplt16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB132_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB132_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_sgt_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_sgt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sgt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB133_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB133_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_sgt_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_sgt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sgt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a1, a1
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB134_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB134_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_sgt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_sgt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sgt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a3, 10
; GENERIC-NEXT:    cmplt16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB135_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB135_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_sgt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_sgt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a3, 65535
; CHECK-NEXT:    ori32 a3, a3, 65521
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sgt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 l1, a3, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l1
; GENERIC-NEXT:    movi16 l0, 241
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmplt16 l0, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB136_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB136_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_sgt_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_sgt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sgt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB137_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB137_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_sgt_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_sgt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sgt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    mov16 l0, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    bt16 .LBB138_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:  .LBB138_2: # %entry
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bt16 .LBB138_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:  .LBB138_4: # %entry
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_sgt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_sgt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sgt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_sgt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_sgt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sgt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB140_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:  .LBB140_2: # %entry
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_sgt_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_sgt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sgt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB141_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB141_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_sge_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_sge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sge_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB142_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB142_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_sge_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_sge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sge_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a3, 9
; GENERIC-NEXT:    cmplt16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB143_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB143_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_sge_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_sge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2032
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sge_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 240
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmplt16 l0, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB144_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB144_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_sge_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_sge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sge_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB145_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB145_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_sge_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_sge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 a1, sp, 12
; CHECK-NEXT:    addi16 a2, sp, 20
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    ld16.w a0, (a1, 0)
; CHECK-NEXT:    ld16.w a1, (a1, 4)
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sge_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    cmplt16 a3, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB146_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB146_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB146_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    movi16 a0, 4
; GENERIC-NEXT:    br32 .LBB146_5
; GENERIC-NEXT:  .LBB146_4:
; GENERIC-NEXT:    movi16 a0, 12
; GENERIC-NEXT:  .LBB146_5: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_sge_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_sge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 l0, a1
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movi16 l0, 9
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti16 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sge_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    cmplt16 l0, a1
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    movi16 l1, 9
; GENERIC-NEXT:    cmphs16 l1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB147_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB147_6
; GENERIC-NEXT:  .LBB147_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB147_4
; GENERIC-NEXT:  .LBB147_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 16)
; GENERIC-NEXT:  .LBB147_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB147_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB147_2
; GENERIC-NEXT:  .LBB147_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 12)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB147_3
; GENERIC-NEXT:    br32 .LBB147_4
entry:
  %icmp = icmp sge i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_sge_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_sge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 l0, a1
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2032
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti16 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sge_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    cmplt16 l0, a1
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    movi16 l1, 2
; GENERIC-NEXT:    lsli16 l1, l1, 24
; GENERIC-NEXT:    movi16 l2, 217
; GENERIC-NEXT:    lsli16 l2, l2, 16
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    movi16 l1, 7
; GENERIC-NEXT:    lsli16 l1, l1, 8
; GENERIC-NEXT:    or16 l1, l2
; GENERIC-NEXT:    movi16 l2, 240
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    cmphs16 l2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB148_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB148_6
; GENERIC-NEXT:  .LBB148_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB148_4
; GENERIC-NEXT:  .LBB148_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 20)
; GENERIC-NEXT:  .LBB148_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB148_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB148_2
; GENERIC-NEXT:  .LBB148_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 16)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB148_3
; GENERIC-NEXT:    br32 .LBB148_4
entry:
  %icmp = icmp sge i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_sge_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_sge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sge_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB149_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB149_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB149_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB149_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_sge_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_sge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sge_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    sexth16 a1, a1
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB150_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB150_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_sge_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_sge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sge_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a3, 9
; GENERIC-NEXT:    cmplt16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB151_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB151_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_sge_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_sge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi32 a3, 2032
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sge_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 240
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    cmplt16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB152_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB152_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_sge_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_sge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sge_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB153_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB153_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_sge_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_sge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sge_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    sextb16 a1, a1
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB154_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB154_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_sge_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_sge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sge_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a3, 9
; GENERIC-NEXT:    cmplt16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB155_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB155_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_sge_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_sge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a3, 65535
; CHECK-NEXT:    ori32 a3, a3, 65520
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sge_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 l1, a3, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l1
; GENERIC-NEXT:    movi16 l0, 240
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmplt16 l0, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB156_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB156_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_sge_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_sge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sge_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB157_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB157_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_sge_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_sge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sge_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB158_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a3
; GENERIC-NEXT:  .LBB158_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB158_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB158_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_sge_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_sge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sge_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB159_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:  .LBB159_2: # %entry
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_sge_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_sge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sge_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_sge_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_sge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sge_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB161_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB161_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_slt_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_slt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_slt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB162_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB162_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_slt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_slt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_slt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplti16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB163_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB163_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_slt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_slt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmplt16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_slt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 241
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmplt16 a0, l0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB164_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB164_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_slt_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_slt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_slt_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB165_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB165_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_slt_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_slt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 12
; CHECK-NEXT:    addi16 a0, sp, 20
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_slt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmplt16 a3, a1
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB166_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:  .LBB166_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB166_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    movi16 a0, 8
; GENERIC-NEXT:    br32 .LBB166_5
; GENERIC-NEXT:  .LBB166_4:
; GENERIC-NEXT:    movi16 a0, 16
; GENERIC-NEXT:  .LBB166_5: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_slt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_slt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 a1, l0
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 8)
; CHECK-NEXT:    btsti16 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_slt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    cmplt16 a1, l0
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphsi16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB167_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB167_6
; GENERIC-NEXT:  .LBB167_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB167_4
; GENERIC-NEXT:  .LBB167_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 12)
; GENERIC-NEXT:  .LBB167_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB167_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB167_2
; GENERIC-NEXT:  .LBB167_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 8)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB167_3
; GENERIC-NEXT:    br32 .LBB167_4
entry:
  %icmp = icmp slt i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_slt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_slt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 a1, l0
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    cmphs16 a0, l0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti16 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_slt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    cmplt16 a1, l0
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    movi16 l1, 2
; GENERIC-NEXT:    lsli16 l1, l1, 24
; GENERIC-NEXT:    movi16 l2, 217
; GENERIC-NEXT:    lsli16 l2, l2, 16
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    movi16 l1, 7
; GENERIC-NEXT:    lsli16 l1, l1, 8
; GENERIC-NEXT:    or16 l1, l2
; GENERIC-NEXT:    movi16 l2, 241
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    cmphs16 a0, l2
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB168_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB168_6
; GENERIC-NEXT:  .LBB168_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB168_4
; GENERIC-NEXT:  .LBB168_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 20)
; GENERIC-NEXT:  .LBB168_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB168_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB168_2
; GENERIC-NEXT:  .LBB168_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 16)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB168_3
; GENERIC-NEXT:    br32 .LBB168_4
entry:
  %icmp = icmp slt i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_slt_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_slt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_slt_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB169_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB169_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB169_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB169_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_slt_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_slt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_slt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    sexth16 a1, a1
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB170_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB170_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_slt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_slt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_slt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB171_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB171_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_slt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_slt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti32 a0, 2033
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_slt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 241
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    cmplt16 a0, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB172_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB172_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_slt_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_slt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_slt_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB173_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB173_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_slt_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_slt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_slt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    sextb16 a1, a1
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB174_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB174_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_slt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_slt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_slt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB175_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB175_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_slt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_slt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a3, 65535
; CHECK-NEXT:    ori32 a3, a3, 65521
; CHECK-NEXT:    cmplt16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_slt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 l1, a3, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l1
; GENERIC-NEXT:    movi16 l0, 241
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmplt16 a0, l0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB176_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB176_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_slt_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_slt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_slt_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB177_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB177_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_slt_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_slt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_slt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    bf16 .LBB178_3
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB178_4
; GENERIC-NEXT:  .LBB178_2: # %entry
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB178_3: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB178_2
; GENERIC-NEXT:  .LBB178_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_slt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_slt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_slt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB179_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB179_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_slt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_slt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_slt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a0, a1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_slt_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_slt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_slt_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB181_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB181_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}

define i32 @selectRR_sle_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_sle_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sle_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB182_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB182_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_sle_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_sle_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sle_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplti16 a0, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB183_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB183_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_sle_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_sle_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2034
; CHECK-NEXT:    cmplt16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sle_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 24
; GENERIC-NEXT:    movi16 l0, 217
; GENERIC-NEXT:    lsli16 l0, l0, 16
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 7
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 242
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmplt16 a0, l0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB184_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB184_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_sle_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_sle_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sle_i32:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB185_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB185_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_sle_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_sle_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti16 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 a1, sp, 12
; CHECK-NEXT:    addi16 a2, sp, 20
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    ld16.w a0, (a1, 0)
; CHECK-NEXT:    ld16.w a1, (a1, 4)
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sle_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a0, a2
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    cmplt16 a1, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB186_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB186_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB186_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    movi16 a0, 4
; GENERIC-NEXT:    br32 .LBB186_5
; GENERIC-NEXT:  .LBB186_4:
; GENERIC-NEXT:    movi16 a0, 12
; GENERIC-NEXT:  .LBB186_5: # %entry
; GENERIC-NEXT:    addu16 a0, sp
; GENERIC-NEXT:    mov16 a1, a0
; GENERIC-NEXT:    ld16.w a0, (a0, 0)
; GENERIC-NEXT:    ld16.w a1, (a1, 4)
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_sle_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_sle_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 a1, l0
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 8)
; CHECK-NEXT:    btsti16 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sle_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    cmplt16 a1, l0
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphsi16 a0, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB187_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB187_6
; GENERIC-NEXT:  .LBB187_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB187_4
; GENERIC-NEXT:  .LBB187_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 12)
; GENERIC-NEXT:  .LBB187_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB187_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB187_2
; GENERIC-NEXT:  .LBB187_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 8)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB187_3
; GENERIC-NEXT:    br32 .LBB187_4
entry:
  %icmp = icmp sle i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_sle_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_sle_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 a1, l0
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2034
; CHECK-NEXT:    cmphs16 a0, l0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti16 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sle_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 12
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    st16.w l2, (sp, 8) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l2, -4
; GENERIC-NEXT:    .cfi_offset l1, -8
; GENERIC-NEXT:    .cfi_offset l0, -12
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 16
; GENERIC-NEXT:    movi16 l0, 0
; GENERIC-NEXT:    cmplt16 a1, l0
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    movi16 l1, 2
; GENERIC-NEXT:    lsli16 l1, l1, 24
; GENERIC-NEXT:    movi16 l2, 217
; GENERIC-NEXT:    lsli16 l2, l2, 16
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    movi16 l1, 7
; GENERIC-NEXT:    lsli16 l1, l1, 8
; GENERIC-NEXT:    or16 l1, l2
; GENERIC-NEXT:    movi16 l2, 242
; GENERIC-NEXT:    or16 l2, l1
; GENERIC-NEXT:    cmphs16 a0, l2
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB188_5
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB188_6
; GENERIC-NEXT:  .LBB188_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB188_4
; GENERIC-NEXT:  .LBB188_3:
; GENERIC-NEXT:    ld16.w a3, (sp, 20)
; GENERIC-NEXT:  .LBB188_4: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    mov16 a1, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l2, (sp, 8) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 12
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB188_5: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB188_2
; GENERIC-NEXT:  .LBB188_6:
; GENERIC-NEXT:    ld16.w a2, (sp, 16)
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB188_3
; GENERIC-NEXT:    br32 .LBB188_4
entry:
  %icmp = icmp sle i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_sle_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_sle_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sle_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB189_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a1
; GENERIC-NEXT:  .LBB189_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bf16 .LBB189_4
; GENERIC-NEXT:  # %bb.3:
; GENERIC-NEXT:    ld16.w a2, (sp, 4)
; GENERIC-NEXT:  .LBB189_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    mov16 a1, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_sle_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_sle_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sle_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a1, a1
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB190_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB190_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_sle_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_sle_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sle_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB191_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB191_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_sle_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_sle_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti32 a0, 2034
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sle_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a3, 0
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    movi16 l0, 7
; GENERIC-NEXT:    lsli16 l0, l0, 8
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    movi16 a3, 242
; GENERIC-NEXT:    or16 a3, l0
; GENERIC-NEXT:    cmplt16 a0, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB192_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB192_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_sle_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_sle_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sle_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB193_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB193_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_sle_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_sle_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sle_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a1, a1
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB194_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB194_2: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_sle_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_sle_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sle_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB195_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB195_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_sle_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_sle_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a3, 65535
; CHECK-NEXT:    ori32 a3, a3, 65522
; CHECK-NEXT:    cmplt16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sle_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 24
; GENERIC-NEXT:    lsli16 l1, a3, 16
; GENERIC-NEXT:    or16 l1, l0
; GENERIC-NEXT:    lsli16 a3, a3, 8
; GENERIC-NEXT:    or16 a3, l1
; GENERIC-NEXT:    movi16 l0, 242
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    cmplt16 a0, l0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a3, 1
; GENERIC-NEXT:    subu16 a3, a0
; GENERIC-NEXT:    btsti16 a3, 0
; GENERIC-NEXT:    bt16 .LBB196_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB196_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_sle_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_sle_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sle_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB197_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB197_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_sle_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_sle_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    mov16 a0, a3
; CHECK-NEXT:    movt32 a0, a2
; CHECK-NEXT:    btsti16 a1, 0
; CHECK-NEXT:    movt32 a0, a3
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRR_sle_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB198_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a3
; GENERIC-NEXT:  .LBB198_2: # %entry
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB198_4
; GENERIC-NEXT:  # %bb.3: # %entry
; GENERIC-NEXT:    mov16 a3, a2
; GENERIC-NEXT:  .LBB198_4: # %entry
; GENERIC-NEXT:    mov16 a0, a3
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_sle_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_sle_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRI_sle_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_sle_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_sle_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectRX_sle_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB200_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB200_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_sle_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_sle_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti16 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: selectC_sle_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB201_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a2, a1
; GENERIC-NEXT:  .LBB201_2: # %entry
; GENERIC-NEXT:    mov16 a0, a2
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}

define i32 @select_bit_test_eq_0(i32 %0) {
; CHECK-LABEL: select_bit_test_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    btsti16 a0, 17
; CHECK-NEXT:    movi16 a0, 23
; CHECK-NEXT:    movi16 a1, 1
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: select_bit_test_eq_0:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    lsli16 a2, a1, 8
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    and16 a2, a0
; GENERIC-NEXT:    cmpnei16 a2, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB202_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 23
; GENERIC-NEXT:  .LBB202_2:
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
  %2 = and i32 %0, 131072
  %3 = icmp eq i32 %2, 0
  %4 = select i1 %3, i32 1, i32 23
  ret i32 %4
}

define i32 @select_bit_test_ne_0(i32 %0) {
; CHECK-LABEL: select_bit_test_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    btsti16 a0, 17
; CHECK-NEXT:    movi16 a0, 34
; CHECK-NEXT:    movi16 a1, 5
; CHECK-NEXT:    movt32 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: select_bit_test_ne_0:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    lsli16 a2, a1, 8
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    and16 a2, a0
; GENERIC-NEXT:    cmpnei16 a2, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    movi16 a0, 5
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB203_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 34
; GENERIC-NEXT:  .LBB203_2:
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
  %2 = and i32 %0, 131072
  %3 = icmp ne i32 %2, 0
  %4 = select i1 %3, i32 5, i32 34
  ret i32 %4
}

define i32 @select_bit_test_eq_mask(i32 %0) {
; CHECK-LABEL: select_bit_test_eq_mask:
; CHECK:       # %bb.0:
; CHECK-NEXT:    btsti16 a0, 17
; CHECK-NEXT:    movi16 a0, 5
; CHECK-NEXT:    movi16 a1, 34
; CHECK-NEXT:    movt32 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: select_bit_test_eq_mask:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    lsli16 a2, a1, 8
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    and16 a2, a0
; GENERIC-NEXT:    cmpnei16 a2, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    movi16 a0, 34
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB204_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 5
; GENERIC-NEXT:  .LBB204_2:
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
  %2 = and i32 %0, 131072
  %3 = icmp eq i32 %2, 131072
  %4 = select i1 %3, i32 34, i32 5
  ret i32 %4
}

define i32 @select_bit_test_ne_mask(i32 %0) {
; CHECK-LABEL: select_bit_test_ne_mask:
; CHECK:       # %bb.0:
; CHECK-NEXT:    btsti16 a0, 17
; CHECK-NEXT:    movi16 a0, 34
; CHECK-NEXT:    movi16 a1, 5
; CHECK-NEXT:    movt32 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: select_bit_test_ne_mask:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    movi16 a3, 2
; GENERIC-NEXT:    lsli16 a3, a3, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    lsli16 a2, a1, 8
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    and16 a2, a0
; GENERIC-NEXT:    cmpnei16 a2, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    subu16 a1, a0
; GENERIC-NEXT:    movi16 a0, 5
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB205_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 34
; GENERIC-NEXT:  .LBB205_2:
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
  %2 = and i32 %0, 131072
  %3 = icmp eq i32 %2, 131072
  %4 = select i1 %3, i32 5, i32 34
  ret i32 %4
}

define i32 @select_lowbit_test_ne_0(i32 %0) {
; CHECK-LABEL: select_lowbit_test_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi32 a0, a0, 256
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movi16 a0, 34
; CHECK-NEXT:    movi16 a1, 5
; CHECK-NEXT:    movt32 a0, a1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: select_lowbit_test_ne_0:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a3, a1, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    movi16 a2, 1
; GENERIC-NEXT:    lsli16 l0, a2, 8
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    or16 l0, a1
; GENERIC-NEXT:    and16 l0, a0
; GENERIC-NEXT:    cmpnei16 l0, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    subu16 a2, a0
; GENERIC-NEXT:    movi16 a0, 5
; GENERIC-NEXT:    btsti16 a2, 0
; GENERIC-NEXT:    bt16 .LBB206_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 34
; GENERIC-NEXT:  .LBB206_2:
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
  %2 = and i32 %0, 256
  %3 = icmp ne i32 %2, 0
  %4 = select i1 %3, i32 5, i32 34
  ret i32 %4
}
