#!/usr/bin/perl

package eBay::API::XML::Call::GetPopularKeywords;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetPopularKeywords.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetPopularKeywords

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetPopularKeywords inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsRequestType;
use eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetPopularKeywords';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsResponseType';
}

#
# input properties
#

=head2 setCategoryID()

A category ID for which you want keywords returned.
When IncludeChildCategories is true, one and only one
CategoryID is allowed. Otherwise, up
to 100 CategoryIds are allowed.
To retrieve the keywords for root category, set one of
the CategoryIDs to -1 or submit no CategoryIDs at all.

MaxLength: 10

  RequiredInput: No
#    Argument: reference to an array  
                      of 'xs:string'

=cut
       
sub setCategoryID {
   my $self   = shift;
   my $sCategoryID = shift;
   $self->getRequestDataType()->setCategoryID($sCategoryID);
}

=head2 setIncludeChildCategories()

If true, only one CategoryID can be specified, and keywords
are returned for that category and its subcategories.
If false, keywords are returned only for the categories
identified by CategoryID. Default is false.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeChildCategories {
   my $self   = shift;
   my $sIncludeChildCategories = shift;
   $self->getRequestDataType()->setIncludeChildCategories($sIncludeChildCategories);
}

=head2 setMaxKeywordsRetrieved()

The maximum number of keywords to be retrieved per category
for this call.

Max: 1000
Default: 20
Min: 1

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setMaxKeywordsRetrieved {
   my $self   = shift;
   my $sMaxKeywordsRetrieved = shift;
   $self->getRequestDataType()->setMaxKeywordsRetrieved($sMaxKeywordsRetrieved);
}

=head2 setPagination()

Details about how many categories to return per
page and which page to view.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut
       
sub setPagination {
   my $self   = shift;
   my $pPagination = shift;
   $self->getRequestDataType()->setPagination($pPagination);
}



#
# output properties
#

=head2 getCategoryArray()

Organization of keywords by category. For each
category, its ID and its parent's ID and keywords
are listed.

  Returned: Always
#    Returns: 'ns:CategoryArrayType'

=cut
       
sub getCategoryArray {
   my $self = shift;
   return $self->getResponseDataType()->getCategoryArray();
}

=head2 isHasMore()

Indicates whether there are more categories beyond the
subset returned in the last
call to GetPopularKeywords. Returned only when
IncludeChildCategories is true.

  Returned: Conditionally
#    Returns: 'xs:boolean'

=cut
       
sub isHasMore {
   my $self = shift;
   return $self->getResponseDataType()->isHasMore();
}

=head2 getPaginationResult()

Contains information regarding the pagination of data (if pagination is used),
including total number of pages and total number of entries.

  Returned: Conditionally
#    Returns: 'ns:PaginationResultType'

=cut
       
sub getPaginationResult {
   my $self = shift;
   return $self->getResponseDataType()->getPaginationResult();
}





1;   
