use strict;
use warnings;

package Footprintless::Database::DatabasePlugin::Command::db::backup;
$Footprintless::Database::DatabasePlugin::Command::db::backup::VERSION = '0.01';
# ABSTRACT: creates a backup of the database
# PODNAME: Footprintless::Database::DatabasePlugin::Command::db::backup

use parent qw(Footprintless::App::Action);

use Carp;
use Footprintless::App -ignore;
use Log::Any;

my $logger = Log::Any->get_logger();

sub execute {
    my ( $self, $footprintless, $coordinate, $opts, $args ) = @_;

    $logger->debugf( 'options=%s', $opts );
    eval {
        $self->{db}->connect();
        $self->{db}->backup( ( delete( $opts->{file} ) || \*STDOUT ), %$opts );
    };
    my $error = $@;
    $self->{db}->disconnect();
    die($error) if ($error);

    $logger->info('Done...');
}

sub opt_spec {
    return (
        [ 'file=s',           'the output file' ],
        [ 'ignore-all-views', 'will ignore all views' ],
        [ 'ignore-table=s@',  'will ignore the specified table' ],
        [ 'only-table=s@',    'will only backup the specified table' ],
        [ 'live',             'will backup live' ],
    );
}

sub validate_args {
    my ( $self, $footprintless, $coordinate, $opts, $args ) = @_;

    eval { $self->{db} = $footprintless->db($coordinate); };
    croak("invalid coordinate [$coordinate]: $@") if ($@);
}

1;

__END__

=pod

=head1 NAME

Footprintless::Database::DatabasePlugin::Command::db::backup - creates a backup of the database

=head1 VERSION

version 0.01

=head1 AUTHOR

Lucas Theisen <lucastheisen@pastdev.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Lucas Theisen.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Footprintless::Database::DatabasePlugin|Footprintless::Database::DatabasePlugin>

=back

=for Pod::Coverage execute opt_spec usage_desc validate_args

=cut
