#!/usr/bin/perl
#
# 
#
use strict;
use Jcode;
BEGIN {
    if ($] < 5.008001){
        print "1..0 # Skip: Perl 5.8.1 or later required\n";
        exit 0;
    }
    require Test::More;
    Test::More->import(tests => 2);
}


my $str = 'ʡҤ餬ʤäString';
my $re_hira = "([-]+)";
my $j = jcode($str, 'euc');
my ($match) = $j->m($re_hira);
is($match, "Ҥ餬ʤ", qq(m//));
$j->s("","Ҳ̾");
$j->s("Ҥ餬","ʿ̾");
is("$j", "Ҳ̾ʿ̾äString", "s///");

__END__

