/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.metadata.sql.ScriptRunner;
import org.apache.sis.internal.referencing.DeferredCoordinateOperation;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.factory.ConcurrentAuthorityFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.EPSGInstaller;
import org.apache.sis.referencing.factory.sql.InstallationScriptProvider;
import org.apache.sis.referencing.factory.sql.SQLTranslator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;
import org.opengis.util.NameFactory;

public class EPSGFactory
extends ConcurrentAuthorityFactory<EPSGDataAccess>
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
Localized {
    private static final Set<String> CODESPACES = Collections.singleton("EPSG");
    protected final DataSource dataSource;
    protected final NameFactory nameFactory;
    protected final DatumFactory datumFactory;
    protected final CSFactory csFactory;
    protected final CRSFactory crsFactory;
    protected final CoordinateOperationFactory copFactory;
    protected final MathTransformFactory mtFactory;
    private final String catalog;
    private final String schema;
    private final InstallationScriptProvider scriptProvider;
    private volatile SQLTranslator translator;
    private final Locale locale;

    public EPSGFactory(Map<String, ?> map) throws FactoryException {
        super(EPSGDataAccess.class);
        if (map == null) {
            map = Collections.emptyMap();
        }
        DataSource dataSource = (DataSource)map.get("dataSource");
        Locale locale = (Locale)map.get("locale");
        this.schema = (String)map.get("schema");
        this.catalog = (String)map.get("catalog");
        this.scriptProvider = (InstallationScriptProvider)map.get("scriptProvider");
        if (locale == null) {
            locale = Locale.getDefault(Locale.Category.DISPLAY);
        }
        this.locale = locale;
        if (dataSource == null) {
            try {
                dataSource = Initializer.getDataSource();
                if (dataSource == null) {
                    throw new UnavailableFactoryException(Initializer.unspecified(locale));
                }
            }
            catch (Exception exception) {
                throw new UnavailableFactoryException(this.canNotUse(exception), exception);
            }
        }
        this.dataSource = dataSource;
        this.nameFactory = EPSGFactory.factory(NameFactory.class, "nameFactory", map);
        this.datumFactory = EPSGFactory.factory(DatumFactory.class, "datumFactory", map);
        this.csFactory = EPSGFactory.factory(CSFactory.class, "csFactory", map);
        this.crsFactory = EPSGFactory.factory(CRSFactory.class, "crsFactory", map);
        this.copFactory = EPSGFactory.factory(CoordinateOperationFactory.class, "copFactory", map);
        this.mtFactory = EPSGFactory.factory(MathTransformFactory.class, "mtFactory", map);
        super.setTimeout(10L, TimeUnit.SECONDS);
    }

    private static <F> F factory(Class<F> clazz, String string, Map<String, ?> map) {
        F f = clazz.cast(map.get(string));
        return f != null ? f : DefaultFactories.forBuildin(clazz);
    }

    private String canNotUse(Exception exception) {
        String string = Exceptions.getLocalizedMessage(exception, this.locale);
        if (string == null) {
            string = Classes.getShortClassName(exception);
        }
        return this.canNotUse(string);
    }

    private String canNotUse(String string) {
        return Resources.forLocale(this.locale).getString((short)9, "EPSG", string);
    }

    @Override
    public Set<String> getCodeSpaces() {
        return CODESPACES;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void install(Connection connection) throws UnavailableFactoryException {
        Object object;
        ArgumentChecks.ensureNonNull("connection", connection);
        String string = null;
        Exception exception = null;
        try {
            object = new EPSGInstaller(connection);
            Throwable throwable = null;
            try {
                boolean bl = connection.getAutoCommit();
                if (bl) {
                    connection.setAutoCommit(false);
                }
                try {
                    boolean bl2 = false;
                    try {
                        if (!"".equals(this.schema)) {
                            ((EPSGInstaller)object).setSchema(this.schema != null ? this.schema : "EPSG");
                            if (this.catalog != null && !this.catalog.isEmpty()) {
                                ((EPSGInstaller)object).prependNamespace(this.catalog);
                            }
                        }
                        ((EPSGInstaller)object).run(this.scriptProvider, this.locale);
                        bl2 = true;
                    }
                    finally {
                        if (bl) {
                            if (bl2) {
                                connection.commit();
                            } else {
                                connection.rollback();
                            }
                            connection.setAutoCommit(true);
                        }
                    }
                }
                catch (IOException | SQLException exception2) {
                    string = ((EPSGInstaller)object).failure(this.locale, exception2);
                    exception = exception2;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((ScriptRunner)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((ScriptRunner)object).close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            string = Messages.getResources(this.locale).getString((short)2, "EPSG");
            exception = sQLException;
        }
        if (exception != null) {
            object = new UnavailableFactoryException(string, Exceptions.unwrap(exception));
            ((UnavailableFactoryException)object).setUnavailableFactory(this);
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EPSGDataAccess newDataAccess() throws FactoryException {
        UnavailableFactoryException unavailableFactoryException;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            Logging.log(EPSGFactory.class, "newDataAccess", Initializer.connected(connection.getMetaData()));
            SQLTranslator sQLTranslator = this.translator;
            if (sQLTranslator == null) {
                EPSGFactory ePSGFactory = this;
                synchronized (ePSGFactory) {
                    sQLTranslator = this.translator;
                    if (sQLTranslator == null) {
                        sQLTranslator = new SQLTranslator(connection.getMetaData(), this.catalog, this.schema);
                        try {
                            if (!sQLTranslator.isTableFound()) {
                                this.install(connection);
                                sQLTranslator.setup(connection.getMetaData());
                            }
                        }
                        finally {
                            this.translator = sQLTranslator;
                        }
                    }
                }
            }
            if (sQLTranslator.isTableFound()) {
                return this.newDataAccess(connection, sQLTranslator);
            }
            connection.close();
            unavailableFactoryException = new UnavailableFactoryException(this.canNotUse(SQLTranslator.tableNotFound(this.locale)));
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    exception.addSuppressed(sQLException);
                }
            }
            if (exception instanceof FactoryException) {
                throw (FactoryException)exception;
            }
            unavailableFactoryException = new UnavailableFactoryException(this.canNotUse(exception), Exceptions.unwrap(exception));
        }
        unavailableFactoryException.setUnavailableFactory(this);
        throw unavailableFactoryException;
    }

    protected EPSGDataAccess newDataAccess(Connection connection, SQLTranslator sQLTranslator) throws SQLException {
        return new EPSGDataAccess(this, connection, sQLTranslator);
    }

    @Override
    protected boolean canClose(EPSGDataAccess ePSGDataAccess) {
        return ePSGDataAccess.canClose();
    }

    @Override
    protected boolean isCacheable(String string, Object object) {
        return !(object instanceof DeferredCoordinateOperation);
    }
}

