/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.impl.CursorImpl;
import com.healthmarketscience.jackcess.util.ColumnMatcher;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableBuilder
implements Iterable<Row> {
    private final Cursor _cursor;
    private Type _type = Type.SIMPLE;
    private boolean _forward = true;
    private boolean _reset = true;
    private Collection<String> _columnNames;
    private ColumnMatcher _columnMatcher;
    private Object _matchPattern;

    public IterableBuilder(Cursor cursor) {
        this._cursor = cursor;
    }

    public Collection<String> getColumnNames() {
        return this._columnNames;
    }

    public ColumnMatcher getColumnMatcher() {
        return this._columnMatcher;
    }

    public boolean isForward() {
        return this._forward;
    }

    public boolean isReset() {
        return this._reset;
    }

    public Object getMatchPattern() {
        return this._matchPattern;
    }

    public Type getType() {
        return this._type;
    }

    public IterableBuilder forward() {
        return this.setForward(true);
    }

    public IterableBuilder reverse() {
        return this.setForward(false);
    }

    public IterableBuilder setForward(boolean forward) {
        this._forward = forward;
        return this;
    }

    public IterableBuilder reset(boolean reset) {
        this._reset = reset;
        return this;
    }

    public IterableBuilder setColumnNames(Collection<String> columnNames) {
        this._columnNames = columnNames;
        return this;
    }

    public IterableBuilder addColumnNames(Iterable<String> columnNames) {
        if (columnNames != null) {
            for (String name : columnNames) {
                this.addColumnName(name);
            }
        }
        return this;
    }

    public IterableBuilder addColumns(Iterable<? extends Column> cols) {
        if (cols != null) {
            for (Column column : cols) {
                this.addColumnName(column.getName());
            }
        }
        return this;
    }

    public IterableBuilder addColumnNames(String ... columnNames) {
        if (columnNames != null) {
            for (String name : columnNames) {
                this.addColumnName(name);
            }
        }
        return this;
    }

    private void addColumnName(String columnName) {
        if (this._columnNames == null) {
            this._columnNames = new HashSet<String>();
        }
        this._columnNames.add(columnName);
    }

    public IterableBuilder setMatchPattern(Column columnPattern, Object valuePattern) {
        this._type = Type.COLUMN_MATCH;
        this._matchPattern = new AbstractMap.SimpleImmutableEntry<Column, Object>(columnPattern, valuePattern);
        return this;
    }

    public IterableBuilder setMatchPattern(String columnNamePattern, Object valuePattern) {
        return this.setMatchPattern(this._cursor.getTable().getColumn(columnNamePattern), valuePattern);
    }

    public IterableBuilder setMatchPattern(Map<String, ?> rowPattern) {
        this._type = Type.ROW_MATCH;
        this._matchPattern = rowPattern;
        return this;
    }

    public IterableBuilder addMatchPattern(String columnNamePattern, Object valuePattern) {
        this._type = Type.ROW_MATCH;
        HashMap<String, Object> matchPattern = (HashMap<String, Object>)this._matchPattern;
        if (matchPattern == null) {
            this._matchPattern = matchPattern = new HashMap<String, Object>();
        }
        matchPattern.put(columnNamePattern, valuePattern);
        return this;
    }

    public IterableBuilder setColumnMatcher(ColumnMatcher columnMatcher) {
        this._columnMatcher = columnMatcher;
        return this;
    }

    @Override
    public Iterator<Row> iterator() {
        return ((CursorImpl)this._cursor).iterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SIMPLE,
        COLUMN_MATCH,
        ROW_MATCH;

    }
}

