/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.meanSquareOCR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.GUIController;
import net.sourceforge.javaocr.gui.OCRDisplay;
import net.sourceforge.javaocr.gui.meanSquareOCR.TrainingImageSelector;
import net.sourceforge.javaocr.gui.meanSquareOCR.TrainingImageSpec;

public class MeanSquareAnalyzer
extends JPanel {
    public static final long serialVersionUID = 0L;
    private final GUIController guiController;
    private final TrainingImageSelector trainingImageSelector;
    private static Dimension btnSize = new Dimension(150, 25);
    private static final Logger LOG = Logger.getLogger(MeanSquareAnalyzer.class.getName());

    public MeanSquareAnalyzer(GUIController guiController) {
        this.guiController = guiController;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescription(), "North");
        this.trainingImageSelector = new TrainingImageSelector();
        this.add((Component)this.trainingImageSelector, "Center");
        this.add((Component)this.getButtons(), "East");
    }

    private JPanel getButtons() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 1));
        JButton addBtn = new JButton("Add Training Image");
        addBtn.addActionListener(this.getAddBtnListener());
        JButton delBtn = new JButton("Delete Traning Image");
        delBtn.addActionListener(this.getDelBtnListener());
        JButton processBtn = new JButton("Process Image");
        processBtn.addActionListener(this.getProcessBtnListener());
        delBtn.setMinimumSize(btnSize);
        delBtn.setPreferredSize(btnSize);
        delBtn.setMaximumSize(btnSize);
        addBtn.setMinimumSize(btnSize);
        addBtn.setPreferredSize(btnSize);
        addBtn.setMaximumSize(btnSize);
        processBtn.setMinimumSize(btnSize);
        processBtn.setPreferredSize(btnSize);
        processBtn.setMaximumSize(btnSize);
        btnPanel.add(addBtn);
        btnPanel.add(delBtn);
        btnPanel.add(processBtn);
        return btnPanel;
    }

    private JTextArea getDescription() {
        TitledBorder border = new TitledBorder("Description");
        JTextArea textArea = new JTextArea();
        textArea.setBorder(border);
        textArea.setEditable(false);
        textArea.setBackground(this.getBackground());
        String desc = "This feature utilizes a set of training images each with a specific character\nrange to perform mean square character recognition on the target image.";
        textArea.setText(desc);
        return textArea;
    }

    private ActionListener getAddBtnListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeanSquareAnalyzer.this.trainingImageSelector.addTrainingImage();
                MeanSquareAnalyzer.this.guiController.repaint();
            }
        };
    }

    private ActionListener getDelBtnListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeanSquareAnalyzer.this.trainingImageSelector.removeTraningImage();
                MeanSquareAnalyzer.this.guiController.repaint();
            }
        };
    }

    private ActionListener getProcessBtnListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!MeanSquareAnalyzer.this.trainingImageSelector.isTraningImagesValid()) {
                    JOptionPane.showMessageDialog(null, "Check training images!");
                } else if (!MeanSquareAnalyzer.this.trainingImageSelector.isTargetImageValid()) {
                    JOptionPane.showMessageDialog(null, "Check target image!");
                } else {
                    try {
                        ArrayList<TrainingImageSpec> images = MeanSquareAnalyzer.this.trainingImageSelector.getTrainingImages();
                        String targImageLoc = MeanSquareAnalyzer.this.trainingImageSelector.getTargetImageLoc();
                        OCRDisplay ocrDisplay = new OCRDisplay(MeanSquareAnalyzer.this.guiController.performMSEOCR(images, targImageLoc));
                        ocrDisplay.showWindow();
                        JOptionPane.showMessageDialog(null, "Done!");
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Error!");
                        Logger.getLogger(MeanSquareAnalyzer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
    }
}

