/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentMappingBox
extends Box {
    private short[] components;
    private byte[] type;
    private byte[] map;

    public ComponentMappingBox(byte[] data) {
        super(8 + data.length, 1668112752, data);
    }

    public ComponentMappingBox(short[] comp, byte[] t, byte[] m) {
        super(8 + (comp.length << 2), 1668112752, null);
        this.components = comp;
        this.type = t;
        this.map = m;
    }

    public ComponentMappingBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        int len = children.getLength() / 3;
        this.components = new short[len];
        this.type = new byte[len];
        this.map = new byte[len];
        len *= 3;
        int index = 0;
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("Component".equals(name)) {
                this.components[index] = Box.getShortElementValue(child);
            }
            if ("ComponentType".equals(name)) {
                this.type[index] = Box.getByteElementValue(child);
            }
            if (!"ComponentAssociation".equals(name)) continue;
            this.map[index++] = Box.getByteElementValue(child);
        }
    }

    protected void parse(byte[] data) {
        int len = data.length / 4;
        this.components = new short[len];
        this.type = new byte[len];
        this.map = new byte[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            this.components[i] = (short)((data[j++] & 0xFF) << 8 | data[j++] & 0xFF);
            this.type[i] = data[j++];
            this.map[i] = data[j++];
        }
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(node);
        for (int i = 0; i < this.components.length; ++i) {
            IIOMetadataNode child = new IIOMetadataNode("Component");
            Short obj = new Short(this.components[i]);
            child.setUserObject(new Short(this.components[i]));
            child.setNodeValue("" + this.components[i]);
            node.appendChild(child);
            child = new IIOMetadataNode("ComponentType");
            child.setUserObject(new Byte(this.type[i]));
            child.setNodeValue("" + this.type[i]);
            node.appendChild(child);
            child = new IIOMetadataNode("ComponentAssociation");
            child.setUserObject(new Byte(this.map[i]));
            child.setNodeValue("" + this.map[i]);
            node.appendChild(child);
        }
        return node;
    }

    public short[] getComponent() {
        return this.components;
    }

    public byte[] getComponentType() {
        return this.type;
    }

    public byte[] getComponentAssociation() {
        return this.map;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[this.type.length << 2];
        int j = 0;
        for (int i = 0; i < this.type.length; ++i) {
            this.data[j++] = (byte)(this.components[i] >> 8);
            this.data[j++] = (byte)(this.components[i] & 0xFF);
            this.data[j++] = this.type[i];
            this.data[j++] = this.map[i];
        }
    }
}

