/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.characterExtractor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.GUIController;

public class CharExtractionPanel
extends JPanel {
    public static final long serialVersionUID = 0L;
    private JTextField imageLoc;
    private JTextField outputDir;
    private final GUIController guiController;
    private JTextField pixelSize;
    private static final Logger LOG = Logger.getLogger(CharExtractionPanel.class.getName());

    public CharExtractionPanel(GUIController guiController) {
        this.guiController = guiController;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescription(), "North");
        this.add((Component)this.getFileAndFolderSelectionPanel(), "Center");
        this.add((Component)this.getExtractButton(), "East");
    }

    private JTextArea getDescription() {
        TitledBorder border = new TitledBorder("Description");
        JTextArea textArea = new JTextArea();
        textArea.setBorder(border);
        textArea.setEditable(false);
        textArea.setBackground(this.getBackground());
        String desc = "This feature will isolate characters within an image and save them individually\nto the selected output directory.";
        textArea.setText(desc);
        return textArea;
    }

    private JPanel getFileAndFolderSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this.getImageSelectPanel());
        panel.add(this.getOutputDirSelector());
        panel.add(this.getPixelSizeSelectionPanel());
        return panel;
    }

    private JPanel getPixelSizeSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new JLabel("Select Output Character Size In Pixels: "));
        this.pixelSize = new JTextField(5);
        this.pixelSize.setText("75");
        panel.add(this.pixelSize);
        return panel;
    }

    private JPanel getExtractButton() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        JButton btn = new JButton("Extract Characters");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isOk = true;
                int std_size = -1;
                File imageFile = new File(CharExtractionPanel.this.imageLoc.getText());
                File outDir = new File(CharExtractionPanel.this.outputDir.getText());
                if (!imageFile.exists() || !outDir.exists()) {
                    JOptionPane.showMessageDialog(null, "Check image or output directory!");
                    isOk = false;
                }
                try {
                    std_size = Integer.parseInt(CharExtractionPanel.this.pixelSize.getText());
                }
                catch (Exception err) {
                    JOptionPane.showMessageDialog(null, "Input valid size in pixles!");
                    isOk = false;
                }
                if (isOk) {
                    CharExtractionPanel.this.guiController.extractChars(imageFile, outDir, std_size, std_size);
                    JOptionPane.showMessageDialog(null, "Done!");
                }
            }
        });
        btnPanel.add(btn);
        return btnPanel;
    }

    private JPanel getImageSelectPanel() {
        JPanel imageSel = new JPanel();
        imageSel.setLayout(new BoxLayout(imageSel, 0));
        JLabel imgLable = new JLabel("Select Image: ");
        imageSel.add(imgLable);
        this.imageLoc = new JTextField(40);
        imageSel.add(this.imageLoc);
        JButton button = new JButton("Select");
        button.addActionListener(this.getImageSelectAction());
        imageSel.add(button);
        return imageSel;
    }

    private JPanel getOutputDirSelector() {
        JPanel dirSelectPanel = new JPanel();
        dirSelectPanel.setLayout(new BoxLayout(dirSelectPanel, 0));
        JLabel dirLabel = new JLabel("Select Output Dir: ");
        dirSelectPanel.add(dirLabel);
        this.outputDir = new JTextField(40);
        dirSelectPanel.add(this.outputDir);
        JButton button = new JButton("Select");
        button.addActionListener(this.getOutDirSelectAction());
        dirSelectPanel.add(button);
        return dirSelectPanel;
    }

    private ActionListener getImageSelectAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    CharExtractionPanel.this.imageLoc.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }

    private ActionListener getOutDirSelectAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    CharExtractionPanel.this.outputDir.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }
}

