/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

class AutoPageNumberUtils {
    private static final String[] ALPHABET = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int MAX = 26;

    AutoPageNumberUtils() {
    }

    public static String asAlphaNumeric(int i) {
        StringBuffer sbuff = new StringBuffer();
        int index = i % 26;
        int ratio = i / 26;
        if (index == 0) {
            --ratio;
            index = 26;
        }
        for (int j = 0; j <= ratio; ++j) {
            sbuff.append(ALPHABET[index - 1]);
        }
        return sbuff.toString();
    }

    public static String asAlphaNumericLower(int i) {
        return AutoPageNumberUtils.asAlphaNumeric(i).toLowerCase();
    }

    public static String asRomanNumerals(int i) {
        if (i <= 0) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i + ")");
        }
        if (i > 3999) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i + ")");
        }
        StringBuffer sbuff = new StringBuffer();
        i = AutoPageNumberUtils.i2r(sbuff, i, "M", 1000, "CM", 900, "D", 500, "CD", 400);
        i = AutoPageNumberUtils.i2r(sbuff, i, "C", 100, "XC", 90, "L", 50, "XL", 40);
        for (i = AutoPageNumberUtils.i2r(sbuff, i, "X", 10, "IX", 9, "V", 5, "IV", 4); i >= 1; --i) {
            sbuff.append("I");
        }
        return sbuff.toString();
    }

    public static String asRomanNumeralsLower(int i) {
        return AutoPageNumberUtils.asRomanNumerals(i).toLowerCase();
    }

    private static int i2r(StringBuffer sbuff, int i, String tens, int iTens, String nines, int iNines, String fives, int iFives, String fours, int iFours) {
        while (i >= iTens) {
            sbuff.append(tens);
            i -= iTens;
        }
        if (i >= iNines) {
            sbuff.append(nines);
            i -= iNines;
        }
        if (i >= iFives) {
            sbuff.append(fives);
            i -= iFives;
        }
        if (i >= iFours) {
            sbuff.append(fours);
            i -= iFours;
        }
        return i;
    }
}

