package DBIx::Model::Column;
use strict;
use warnings;
use Types::Standard qw/ArrayRef Bool Int Str Undef/;

our $VERSION = '0.0.1';
our $INLINE  = {
    chain => {
        is  => 'rw',
        isa => Int,
    },
    table => {
        is       => 'ro',
        required => 1,
        weaken   => 1,
    },
    name => {
        is       => 'ro',
        isa      => Str,
        required => 1,
    },
    name_lc => {
        is       => 'ro',
        init_arg => undef,
        default  => sub { lc $_[0]->name },
    },
    full_name => {
        is       => 'ro',
        init_arg => undef,
        default  => sub { $_[0]->table->name . '.' . $_[0]->name },
    },
    full_name_lc => {
        is       => 'ro',
        init_arg => undef,
        default  => sub { lc $_[0]->full_name },
    },
    primary => {
        is      => 'ro',
        isa     => Bool,
        default => sub { 0 },
    },
    ref_count => {
        is      => 'rw',
        isa     => Int,
        default => 0,
    },
    size => {
        is  => 'ro',
        isa => Int | Undef,
    },
    target_count => {
        is      => 'rw',
        isa     => Int,
        default => 0,
    },
    type => {
        is       => 'ro',
        isa      => Str,
        required => 1,
    },
    nullable => {
        is       => 'ro',
        isa      => Bool,
        required => 1,
    },
};

sub as_string {
    my $self   = shift;
    my $prefix = shift;
    my $str    = $prefix . $self->name . ' ' . $self->type;
    $str .= '(' . $self->size . ')' if $self->size;
    $str .= ' NOT NULL' unless $self->nullable;
    return $str;
}

sub bump_ref_count {
    my $self = shift;
    $self->ref_count( $self->ref_count + 1 );
    $self->table->bump_ref_count;
}

sub bump_target_count {
    my $self = shift;
    $self->target_count( $self->target_count + 1 );
    $self->table->bump_target_count;
}

### DO NOT EDIT BELOW! (generated by Class::Inline v0.0.1)
#<<<
  require Carp;require Scalar::Util;our@ATTRS_UNEX=(undef);sub new {my$class=
  shift;my$self={@_ ? @_ > 1 ? @_ : %{$_[0]}: ()};map {local$Carp::CarpLevel=
  $Carp::CarpLevel + 1;Carp::croak(
  "missing attribute DBIx::Model::Column::$_ is required")unless exists$self->
  {$_}}'name','nullable','table','type';map {delete$self->{$_}}'full_name',
  'full_name_lc','name_lc';if (@ATTRS_UNEX){map {local$Carp::CarpLevel=
  $Carp::CarpLevel + 1;Carp::carp(
  "DBIx::Model::Column attribute '$_' unexpected");delete$self->{$_ }}sort
  grep {not exists$INLINE->{$_ }}keys %$self}else {@ATTRS_UNEX=map {delete
  $self->{$_ };$_}grep {not exists$INLINE->{$_ }}keys %$self}bless$self,ref
  $class || $class;map {$self->{$_ }=eval {$INLINE->{$_ }->{'isa'}->($self->{
  $_ })};Carp::croak(qq{DBIx::Model::Column::$_ value invalid ($@)})if $@}grep
  {exists$self->{$_ }}'chain','name','nullable','primary','ref_count','size',
  'target_count','type';map {Scalar::Util::weaken($self->{$_ })}grep {exists(
  $self->{$_})&& defined$self->{$_ }}'table';my@check=('DBIx::Model::Column');
  my@parents;while (@check){no strict 'refs';my$c=shift@check;push@parents,@{
  $c .'::ISA'};push@check,@{$c .'::ISA'}}map {$_->BUILD()if exists &{$_.
  '::BUILD'}}reverse@parents;$self->BUILD()if exists &{'BUILD'};$self}sub __ro
  {my (undef,undef,undef,$sub)=caller(1);local$Carp::CarpLevel=
  $Carp::CarpLevel + 1;Carp::croak("attribute $sub is read-only (value: '" .(
  $_[1]// 'undef')."')")}sub chain {if (@_ > 1){$_[0]{'chain'}=eval {$INLINE->
  {'chain'}->{'isa'}->($_[1])};Carp::croak(
  'invalid (DBIx::Model::Column::chain) value: '.$@)if $@;return $_[0]}$_[0]{
  'chain'}// undef}sub full_name {$_[0]->__ro($_[1])if @_ > 1;$_[0]{
  'full_name'}//= $INLINE->{'full_name'}->{'default'}->($_[0])}sub
  full_name_lc {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'full_name_lc'}//= $INLINE->
  {'full_name_lc'}->{'default'}->($_[0])}sub name {$_[0]->__ro($_[1])if @_ > 1
  ;$_[0]{'name'}}sub name_lc {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'name_lc'}//=
  $INLINE->{'name_lc'}->{'default'}->($_[0])}sub nullable {$_[0]->__ro($_[1])
  if @_ > 1;$_[0]{'nullable'}}sub primary {$_[0]->__ro($_[1])if @_ > 1;$_[0]{
  'primary'}//= eval {$INLINE->{'primary'}->{'isa'}->($INLINE->{'primary'}->{
  'default'}->($_[0]))};Carp::croak(
  'invalid (DBIx::Model::Column::primary) default value: ' .$@)if $@;$_[0]{
  'primary'}}sub ref_count {if (@_ > 1){$_[0]{'ref_count'}=eval {$INLINE->{
  'ref_count'}->{'isa'}->($_[1])};Carp::croak(
  'invalid (DBIx::Model::Column::ref_count) value: '.$@)if $@;return $_[0]}$_[
  0]{'ref_count'}//= eval {$INLINE->{'ref_count'}->{'isa'}->($INLINE->{
  'ref_count'}->{'default'})};Carp::croak(
  'invalid (DBIx::Model::Column::ref_count) default value: ' .$@)if $@;$_[0]{
  'ref_count'}}sub size {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'size'}// undef}sub
  table {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'table'}}sub target_count {if (@_ >
  1){$_[0]{'target_count'}=eval {$INLINE->{'target_count'}->{'isa'}->($_[1])};
  Carp::croak('invalid (DBIx::Model::Column::target_count) value: '.$@)if $@;
  return $_[0]}$_[0]{'target_count'}//= eval {$INLINE->{'target_count'}->{
  'isa'}->($INLINE->{'target_count'}->{'default'})};Carp::croak(
  'invalid (DBIx::Model::Column::target_count) default value: ' .$@)if $@;$_[0
  ]{'target_count'}}sub type {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'type'}}
#>>>
### DO NOT EDIT ABOVE! (generated by Class::Inline v0.0.1)

1;
