# Generated by default/object.tt
package Paws::Config::AggregateConformancePackCompliance;
  use Moose;
  has ComplianceType => (is => 'ro', isa => 'Str');
  has CompliantRuleCount => (is => 'ro', isa => 'Int');
  has NonCompliantRuleCount => (is => 'ro', isa => 'Int');
  has TotalRuleCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Config::AggregateConformancePackCompliance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Config::AggregateConformancePackCompliance object:

  $service_obj->Method(Att1 => { ComplianceType => $value, ..., TotalRuleCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Config::AggregateConformancePackCompliance object:

  $result = $service_obj->Method(...);
  $result->Att1->ComplianceType

=head1 DESCRIPTION

Provides the number of compliant and noncompliant rules within a
conformance pack. Also provides the compliance status of the
conformance pack and the total rule count which includes compliant
rules, noncompliant rules, and rules that cannot be evaluated due to
insufficient data.

A conformance pack is compliant if all of the rules in a conformance
packs are compliant. It is noncompliant if any of the rules are not
compliant. The compliance status of a conformance pack is
INSUFFICIENT_DATA only if all rules within a conformance pack cannot be
evaluated due to insufficient data. If some of the rules in a
conformance pack are compliant but the compliance status of other rules
in that same conformance pack is INSUFFICIENT_DATA, the conformance
pack shows compliant.

=head1 ATTRIBUTES


=head2 ComplianceType => Str

The compliance status of the conformance pack.


=head2 CompliantRuleCount => Int

The number of compliant AWS Config Rules.


=head2 NonCompliantRuleCount => Int

The number of noncompliant AWS Config Rules.


=head2 TotalRuleCount => Int

Total number of compliant rules, noncompliant rules, and the rules that
do not have any applicable resources to evaluate upon resulting in
insufficient data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Config>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

