#!perl

use strict;
use warnings;
use utf8;
use Number::Phone::JP::AreaCode qw/address_by_area_code/;

use Test::More;
use Test::Deep;

cmp_deeply address_by_area_code(1456), {
    addresses => [
        '北海道新冠郡新冠町里平',
        '北海道沙流郡日高町',
    ],
    local_code_digits => '1',
};
cmp_deeply address_by_area_code(124), {
    addresses => [
        '北海道芦別市',
    ],
    local_code_digits => '2',
};
cmp_deeply address_by_area_code('0124'), {
    addresses => [
        '北海道芦別市',
    ],
    local_code_digits => '2',
};
cmp_deeply address_by_area_code(6), {
    addresses => [
        '兵庫県尼崎市',
        '大阪府八尾市竹渕',
        '大阪府八尾市竹渕東',
        '大阪府八尾市竹渕西',
        '大阪府吹田市',
        '大阪府大阪市',
        '大阪府守口市',
        '大阪府摂津市一津屋',
        '大阪府摂津市三島',
        '大阪府摂津市別府',
        '大阪府摂津市北別府町',
        '大阪府摂津市千里丘',
        '大阪府摂津市千里丘東五丁目',
        '大阪府摂津市千里丘東四丁目',
        '大阪府摂津市南別府町',
        '大阪府摂津市南千里丘',
        '大阪府摂津市庄屋',
        '大阪府摂津市新在家',
        '大阪府摂津市東一津屋',
        '大阪府摂津市東別府',
        '大阪府摂津市東正雀',
        '大阪府摂津市正雀',
        '大阪府摂津市正雀本町',
        '大阪府摂津市浜町',
        '大阪府摂津市西一津屋',
        '大阪府東大阪市',
        '大阪府東大阪市岩田町三丁目',
        '大阪府池田市空港',
        '大阪府豊中市',
        '大阪府門真市一番町',
        '大阪府門真市中町',
        '大阪府門真市元町',
        '大阪府門真市古川町',
        '大阪府門真市向島町',
        '大阪府門真市垣内町',
        '大阪府門真市堂山町',
        '大阪府門真市大倉町',
        '大阪府門真市寿町',
        '大阪府門真市小路町',
        '大阪府門真市幸福町',
        '大阪府門真市御堂町',
        '大阪府門真市新橋町',
        '大阪府門真市月出町',
        '大阪府門真市末広町',
        '大阪府門真市本町',
        '大阪府門真市東田町',
        '大阪府門真市松生町',
        '大阪府門真市松葉町',
        '大阪府門真市柳田町',
        '大阪府門真市柳町',
        '大阪府門真市栄町',
        '大阪府門真市桑才新町',
        '大阪府門真市殿島町',
        '大阪府門真市泉町',
        '大阪府門真市浜町',
        '大阪府門真市深田町',
        '大阪府門真市石原町',
        '大阪府門真市速見町'
    ],
    local_code_digits => '4',
};

ok !address_by_area_code(9999);

done_testing;

