package WWW::UsePerl::Server::Model::DB;
use strict;
use warnings;
use base 'Catalyst::Model::DBIC::Schema';

my $config = WWW::UsePerl::Server->config;

__PACKAGE__->config(
    schema_class => 'WWW::UsePerl::Server::Schema',
    connect_info => {
        dsn         => $config->{db_dsn},
        user        => $config->{db_user},
        password    => $config->{db_password},
        quote_names => q{1},
    }
);

=head1 NAME

WWW::UsePerl::Server::Model::DB - Catalyst DBIC Schema Model

=head1 SYNOPSIS

See L<WWW::UsePerl::Server>

=head1 DESCRIPTION

L<Catalyst::Model::DBIC::Schema> Model using schema L<WWW::UsePerl::Server::Schema>

=head1 GENERATED BY

Catalyst::Helper::Model::DBIC::Schema - 0.55

=head1 AUTHOR

Leon Brocard

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
