# Generated by default/object.tt
package Paws::NetworkFirewall::RulesSourceList;
  use Moose;
  has GeneratedRulesType => (is => 'ro', isa => 'Str', required => 1);
  has Targets => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has TargetTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::RulesSourceList

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::RulesSourceList object:

  $service_obj->Method(Att1 => { GeneratedRulesType => $value, ..., TargetTypes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::RulesSourceList object:

  $result = $service_obj->Method(...);
  $result->Att1->GeneratedRulesType

=head1 DESCRIPTION

Stateful inspection criteria for a domain list rule group.

For HTTPS traffic, domain filtering is SNI-based. It uses the server
name indicator extension of the TLS handshake.

By default, Network Firewall domain list inspection only includes
traffic coming from the VPC where you deploy the firewall. To inspect
traffic from IP addresses outside of the deployment VPC, you set the
C<HOME_NET> rule variable to include the CIDR range of the deployment
VPC plus the other CIDR ranges. For more information, see RuleVariables
in this guide and Stateful domain list rule groups in AWS Network
Firewall
(https://docs.aws.amazon.com/network-firewall/latest/developerguide/stateful-rule-groups-domain-names.html)
in the I<Network Firewall Developer Guide>

=head1 ATTRIBUTES


=head2 B<REQUIRED> GeneratedRulesType => Str

Whether you want to allow or deny access to the domains in your target
list.


=head2 B<REQUIRED> Targets => ArrayRef[Str|Undef]

The domains that you want to inspect for in your traffic flows. To
provide multiple domains, separate them with commas. Valid domain
specifications are the following:

=over

=item *

Explicit names. For example, C<abc.example.com> matches only the domain
C<abc.example.com>.

=item *

Names that use a domain wildcard, which you indicate with an initial
'C<.>'. For example,C<.example.com> matches C<example.com> and matches
all subdomains of C<example.com>, such as C<abc.example.com> and
C<www.example.com>.

=back



=head2 B<REQUIRED> TargetTypes => ArrayRef[Str|Undef]

The protocols you want to inspect. Specify C<TLS_SNI> for C<HTTPS>.
Specity C<HTTP_HOST> for C<HTTP>. You can specify either or both.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

