#!/usr/bin/perl

use strict;
use warnings;

use Net::DRI;
use Net::DRI::Data::Raw;
use DateTime::Duration;

use Test::More tests => 4;
eval { no warnings; require Test::LongString; Test::LongString->import(max => 100); $Test::LongString::Context=50; };
if ( $@ ) { no strict 'refs'; *{'main::is_string'}=\&main::is; }

our $E1='<?xml version="1.0" encoding="UTF-8" standalone="no"?><epp xmlns="urn:ietf:params:xml:ns:epp-1.0">';
our $E2='</epp>';
our $TRID='<trID><clTRID>ABC-12345</clTRID><svTRID>54322-XYZ</svTRID></trID>';

our ($R1,$R2);
sub mysend { my ($transport,$count,$msg)=@_; $R1=$msg->as_string(); return 1; }
sub myrecv { return Net::DRI::Data::Raw->new_from_string($R2? $R2 : $E1.'<response>'.r().$TRID.'</response>'.$E2); }
sub r
{
    my ($c,$m)=@_;
    return '<result code="'.($c || 1000).'"><msg>'.($m || 'Command completed successfully').'</msg></result>';
}
my $dri=Net::DRI::TrapExceptions->new({cache_ttl => 10});
$dri->{trid_factory}=sub { return 'ABC-12345'; };
$dri->add_registry('CentralNic');
$dri->target('CentralNic')->add_current_profile('p1','epp',{f_send=>\&mysend,f_recv=>\&myrecv},{extensions=>[qw/CentralNic::RegType/]});

my $rc;

####################################################################################################

$R2='';
$rc=$dri->domain_check('example.eu.com', { registration_type => 'foobar' });
is_string($R1,$E1.'<command><check><domain:check xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>example.eu.com</domain:name></domain:check></check><extension><regType:check xmlns:regType="urn:ietf:params:xml:ns:regtype-0.2"><regType:type>foobar</regType:type></regType:check></extension><clTRID>ABC-12345</clTRID></command>'.$E2,'domain_check build');


$R2=$E1.'<response>'.r().'<resData><domain:infData xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>example.eu.com</domain:name><domain:roid>EXAMPLE1-REP</domain:roid><domain:status s="ok" /><domain:registrant>jd1234</domain:registrant><domain:contact type="admin">sh8013</domain:contact><domain:contact type="tech">sh8013</domain:contact><domain:ns><domain:hostObj>ns1.example.com</domain:hostObj><domain:hostObj>ns1.example.net</domain:hostObj></domain:ns><domain:clID>ClientX</domain:clID><domain:crID>ClientY</domain:crID><domain:crDate>1999-04-03T22:00:00.0Z</domain:crDate><domain:upID>ClientX</domain:upID><domain:upDate>1999-12-03T09:00:00.0Z</domain:upDate><domain:exDate>2005-04-03T22:00:00.0Z</domain:exDate><domain:trDate>2000-04-08T09:00:00.0Z</domain:trDate><domain:authInfo><domain:pw>2fooBAR</domain:pw></domain:authInfo></domain:infData></resData><extension><regType:infData xmlns:regType="urn:ietf:params:xml:ns:regtype-0.2"><regType:type>foobar</regType:type></regType:infData></extension>'.$TRID.'</response>'.$E2;
$rc=$dri->domain_info('example.eu.com');
is($rc->get_data('registration_type'),'foobar','domain_info get_data(registration_type)');


$R2='';
my $c1=$dri->local_object('contact')->srid('jd1234');
my $c2=$dri->local_object('contact')->srid('sh8013');
my $cs=$dri->local_object('contactset','registrant',$c1,'admin',$c2,'tech',$c2);
$rc=$dri->domain_create('example.eu.com',{pure_create=>1,
                                          duration=>DateTime::Duration->new(years=>2),
                                          ns=>$dri->local_object('hosts')->set(['ns1.example.net'],['ns2.example.net']),
                                          contact=>$cs,
                                          auth=>{pw=>'2fooBAR'},
                                          registration_type => 'foobar',
                                         });
is_string($R1,$E1.'<command><create><domain:create xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>example.eu.com</domain:name><domain:period unit="y">2</domain:period><domain:ns><domain:hostObj>ns1.example.net</domain:hostObj><domain:hostObj>ns2.example.net</domain:hostObj></domain:ns><domain:registrant>jd1234</domain:registrant><domain:contact type="admin">sh8013</domain:contact><domain:contact type="tech">sh8013</domain:contact><domain:authInfo><domain:pw>2fooBAR</domain:pw></domain:authInfo></domain:create></create><extension><regType:create xmlns:regType="urn:ietf:params:xml:ns:regtype-0.2"><regType:type>foobar</regType:type></regType:create></extension><clTRID>ABC-12345</clTRID></command></epp>','domain_create build');


$R2='';
my $toc=$dri->local_object('changes', 'registration_type', 'set', 'foobar');
$rc=$dri->domain_update('example.eu.com', $toc);
is_string($R1,$E1.'<command><update><domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>example.eu.com</domain:name></domain:update></update><extension><regType:update xmlns:regType="urn:ietf:params:xml:ns:regtype-0.2"><regType:chg><regType:type>foobar</regType:type></regType:chg></regType:update></extension><clTRID>ABC-12345</clTRID></command></epp>','domain_update build');

exit 0;
