package Net::Async::Spotify::API::Generated::Follow;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::API::Base);

use Future::AsyncAwait;

=encoding utf8

=head1 NAME

Net::Async::Spotify::API::Generated::Follow - Package representing Spotify Follow API

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#reference-index
Check C<crawl-api-doc.pl> for more information.

=head1 METHODS

=cut

sub mapping { shift->{mapping} }

=head2 check_current_user_follows

check_current_user_follows - Get Following State for Artists/Users

Check to see if the current user is following one or more artists or other Spotify users.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials. Requires the user-follow-read scope.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the artist or the user Spotify IDs to check. For example: ids=74ASZWbe4lXaubB36ztrGX,08td7MxkoHQkXnWAYD8d6Q. A maximum of 50 IDs can be sent in one request.

=item type

Type: string | Required: required
The ID type: either artist or user.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK and the response body contains a JSON array of true or false values, in the same order in which the ids were specified.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub check_current_user_follows {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{check_current_user_follows}{method} // 'GET';
    $request->{uri}    = $mapping->{check_current_user_follows}{uri} // 'https://api.spotify.com/v1/me/following/contains';
    $request->{param}  = $mapping->{check_current_user_follows}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
            'type' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{check_current_user_follows}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 check_if_user_follows_playlist

check_if_user_follows_playlist - Check if Users Follow a Playlist

Check to see if one or more Spotify users are following a specified playlist.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials. Requires the playlist-read-private scope if a private playlist is requested.

=back

=head3 path_parameter

=over 4

=item playlist_id

Type: string | Required: required
The Spotify ID of the playlist.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of Spotify User IDs ; the ids of the users that you want to check to see if they follow the playlist. Maximum: 5 ids.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK and the response body contains a JSON array of true or false values, in the same order in which the ids were specified.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub check_if_user_follows_playlist {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{check_if_user_follows_playlist}{method} // 'GET';
    $request->{uri}    = $mapping->{check_if_user_follows_playlist}{uri} // 'https://api.spotify.com/v1/playlists/{playlist_id}/followers/contains';
    $request->{param}  = $mapping->{check_if_user_follows_playlist}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'playlist_id' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{check_if_user_follows_playlist}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 follow_artists_users

follow_artists_users - Follow Artists or Users

Add the current user as a follower of one or more artists or other Spotify users.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials. Requires the user-follow-modify scope.

=item Content-Type

Type: string | Required: optional
Required if IDs are passed in the request body, otherwise ignored. The content type of the request body: application/json

=back

=head3 json_body_parameter

=over 4

=item ids

Type: array[string] | Required: required
A JSON array of the artist or user Spotify IDs.
For example: {ids:["74ASZWbe4lXaubB36ztrGX", "08td7MxkoHQkXnWAYD8d6Q"]}. A maximum of 50 IDs can be sent in one request. Note: if the ids parameter is present in the query string, any IDs listed here in the body will be ignored.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the artist or the user Spotify IDs.
For example: ids=74ASZWbe4lXaubB36ztrGX,08td7MxkoHQkXnWAYD8d6Q. A maximum of 50 IDs can be sent in one request.

=item type

Type: string | Required: required
The ID type: either artist or user.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 204 No Content and the response body is empty.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub follow_artists_users {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{follow_artists_users}{method} // 'PUT';
    $request->{uri}    = $mapping->{follow_artists_users}{uri} // 'https://api.spotify.com/v1/me/following';
    $request->{param}  = $mapping->{follow_artists_users}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'optional',
            },
        },
        json_body_parameter => {
            'ids' => {
                type     => 'array[string]',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
            'type' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{follow_artists_users}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 follow_playlist

follow_playlist - Follow a Playlist

Add the current user as a follower of a playlist.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The access token must have been issued on behalf of the user.Following a playlist publicly requires authorization of the playlist-modify-public scope; following a playlist privately requires the playlist-modify-private scope. See Using Scopes.Note that the scopes you provide relate only to whether the current user is following the playlist publicly or privately (i.e. showing others what they are following), not whether the playlist itself is public or private.

=item Content-Type

Type: string | Required: required
The content type of the request body: application/json

=back

=head3 json_body_parameter

=over 4

=item public

Type: boolean | Required: optional
Defaults to true. If true the playlist will be included in user’s public playlists, if false it will remain private.

=back

=head3 path_parameter

=over 4

=item playlist_id

Type: string | Required: required
The Spotify ID of the playlist. Any playlist can be followed, regardless of its public/private status, as long as you know its playlist ID.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK and the response body is empty.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub follow_playlist {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{follow_playlist}{method} // 'PUT';
    $request->{uri}    = $mapping->{follow_playlist}{uri} // 'https://api.spotify.com/v1/playlists/{playlist_id}/followers';
    $request->{param}  = $mapping->{follow_playlist}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'required',
            },
        },
        json_body_parameter => {
            'public' => {
                type     => 'boolean',
                required => 'optional',
            },
        },
        path_parameter => {
            'playlist_id' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{follow_playlist}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_followed

get_followed - Get User's Followed Artists

Get the current user’s followed artists.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials. Requires the user-follow-modify scope.

=back

=head3 query_parameter

=over 4

=item after

Type: string | Required: optional
The last artist ID retrieved from the previous request.

=item limit

Type: integer | Required: optional
The maximum number of items to return. Default: 20. Minimum: 1. Maximum: 50.

=item type

Type: string | Required: required
The ID type: currently only artist is supported.

=back

and Response Objects being:

- paging object


On success, the HTTP status code in the response header is 200 OK and the response body contains an artists object.
The artists object in turn contains a cursor-based paging object of Artists.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_followed {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_followed}{method} // 'GET';
    $request->{uri}    = $mapping->{get_followed}{uri} // 'https://api.spotify.com/v1/me/following';
    $request->{param}  = $mapping->{get_followed}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'after' => {
                type     => 'string',
                required => 'optional',
            },
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'type' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{get_followed}{response} // [
        'paging object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 unfollow_artists_users

unfollow_artists_users - Unfollow Artists or Users

Remove the current user as a follower of one or more artists or other Spotify users.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials. Requires the user-follow-modify scope.

=item Content-Type

Type: string | Required: optional
Required if IDs are passed in the request body, otherwise ignored. The content type of the request body: application/json.

=back

=head3 json_body_parameter

=over 4

=item ids

Type: array[string] | Required: optional
A JSON array of the artist or user Spotify IDs. For example: {ids:["74ASZWbe4lXaubB36ztrGX", "08td7MxkoHQkXnWAYD8d6Q"]}. A maximum of 50 IDs can be sent in one request. Note: if the ids parameter is present in the query string, any IDs listed here in the body will be ignored.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the artist or the user Spotify IDs. For example: ids=74ASZWbe4lXaubB36ztrGX,08td7MxkoHQkXnWAYD8d6Q. A maximum of 50 IDs can be sent in one request.

=item type

Type: string | Required: required
The ID type: either artist or user.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 204 No Content and the response body is empty.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub unfollow_artists_users {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{unfollow_artists_users}{method} // 'DELETE';
    $request->{uri}    = $mapping->{unfollow_artists_users}{uri} // 'https://api.spotify.com/v1/me/following';
    $request->{param}  = $mapping->{unfollow_artists_users}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'optional',
            },
        },
        json_body_parameter => {
            'ids' => {
                type     => 'array[string]',
                required => 'optional',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
            'type' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{unfollow_artists_users}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 unfollow_playlist

unfollow_playlist - Unfollow Playlist

Remove the current user as a follower of a playlist.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The access token must have been issued on behalf of the user.Unfollowing a publicly followed playlist for a user requires authorization of the playlist-modify-public scope; unfollowing a privately followed playlist requires the playlist-modify-private scope. See Using Scopes.Note that the scopes you provide relate only to whether the current user is following the playlist publicly or privately (i.e. showing others what they are following), not whether the playlist itself is public or private.

=back

=head3 path_parameter

=over 4

=item playlist_id

Type: string | Required: required
The Spotify ID of the playlist that is to be no longer followed.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK and the response body is empty.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub unfollow_playlist {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{unfollow_playlist}{method} // 'DELETE';
    $request->{uri}    = $mapping->{unfollow_playlist}{uri} // 'https://api.spotify.com/v1/playlists/{playlist_id}/followers';
    $request->{param}  = $mapping->{unfollow_playlist}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'playlist_id' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{unfollow_playlist}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

1;
