# Generated by default/object.tt
package Paws::DLM::EventParameters;
  use Moose;
  has DescriptionRegex => (is => 'ro', isa => 'Str', required => 1);
  has EventType => (is => 'ro', isa => 'Str', required => 1);
  has SnapshotOwner => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::DLM::EventParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DLM::EventParameters object:

  $service_obj->Method(Att1 => { DescriptionRegex => $value, ..., SnapshotOwner => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DLM::EventParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->DescriptionRegex

=head1 DESCRIPTION

Specifies an event that triggers an event-based policy.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DescriptionRegex => Str

The snapshot description that can trigger the policy. The description
pattern is specified using a regular expression. The policy runs only
if a snapshot with a description that matches the specified pattern is
shared with your account.

For example, specifying C<^.*Created for policy:
policy-1234567890abcdef0.*$> configures the policy to run only if
snapshots created by policy C<policy-1234567890abcdef0> are shared with
your account.


=head2 B<REQUIRED> EventType => Str

The type of event. Currently, only snapshot sharing events are
supported.


=head2 B<REQUIRED> SnapshotOwner => ArrayRef[Str|Undef]

The IDs of the AWS accounts that can trigger policy by sharing
snapshots with your account. The policy only runs if one of the
specified AWS accounts shares a snapshot with your account.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DLM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

