/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageNode;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandlersManager;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;

public class PDDocument
implements Pageable {
    private COSDocument document;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;
    private PDEncryptionDictionary encParameters = null;
    private SecurityHandler securityHandler = null;
    private Map pageMap = null;
    private boolean allSecurityToBeRemoved = false;

    public PDDocument() throws IOException {
        this.document = new COSDocument();
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        trailer.setItem(COSName.ROOT, (COSBase)rootDictionary);
        rootDictionary.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        rootDictionary.setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        rootDictionary.setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.KIDS, (COSBase)kidsArray);
        pages.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    private void generatePageMap() {
        this.pageMap = new HashMap();
        COSArray pageNodes = ((COSArrayList)this.getDocumentCatalog().getPages().getKids()).toList();
        for (int arrayCounter = 0; arrayCounter < pageNodes.size(); ++arrayCounter) {
            this.parseCatalogObject((COSObject)pageNodes.get(arrayCounter));
        }
    }

    private void parseCatalogObject(COSObject thePageOrArrayObject) {
        block6: {
            COSBase kidsBase;
            block7: {
                int kidsCount;
                int arrayCount;
                block5: {
                    COSBase arrayCountBase = thePageOrArrayObject.getItem(COSName.COUNT);
                    arrayCount = -1;
                    if (arrayCountBase instanceof COSInteger) {
                        arrayCount = ((COSInteger)arrayCountBase).intValue();
                    }
                    kidsBase = thePageOrArrayObject.getItem(COSName.KIDS);
                    kidsCount = -1;
                    if (kidsBase instanceof COSArray) {
                        kidsCount = ((COSArray)kidsBase).size();
                    }
                    if (arrayCount != -1 && kidsCount != -1) break block5;
                    String objStr = String.valueOf(thePageOrArrayObject.getObjectNumber().intValue());
                    String genStr = String.valueOf(thePageOrArrayObject.getGenerationNumber().intValue());
                    this.getPageMap().put(objStr + "," + genStr, new Integer(this.getPageMap().size() + 1));
                    break block6;
                }
                if (arrayCount != kidsCount) break block7;
                COSArray kidsArray = (COSArray)kidsBase;
                for (int i = 0; i < kidsArray.size(); ++i) {
                    COSObject thisObject = (COSObject)kidsArray.get(i);
                    String objStr = String.valueOf(thisObject.getObjectNumber().intValue());
                    String genStr = String.valueOf(thisObject.getGenerationNumber().intValue());
                    this.getPageMap().put(objStr + "," + genStr, new Integer(this.getPageMap().size() + 1));
                }
                break block6;
            }
            COSArray list = null;
            if (kidsBase instanceof COSArray) {
                list = (COSArray)kidsBase;
            }
            if (list == null) break block6;
            for (int arrayCounter = 0; arrayCounter < list.size(); ++arrayCounter) {
                this.parseCatalogObject((COSObject)list.get(arrayCounter));
            }
        }
    }

    public final Map getPageMap() {
        if (this.pageMap == null) {
            this.generatePageMap();
        }
        return this.pageMap;
    }

    public void addPage(PDPage page) {
        PDPageNode rootPages = this.getDocumentCatalog().getPages();
        rootPages.getKids().add(page);
        page.setParent(rootPages);
        rootPages.updateCount();
    }

    public boolean removePage(PDPage page) {
        PDPageNode parent = page.getParent();
        boolean retval = parent.getKids().remove(page);
        if (retval) {
            this.getDocumentCatalog().getPages().updateCount();
        }
        return retval;
    }

    public boolean removePage(int pageNumber) {
        boolean removed = false;
        List allPages = this.getDocumentCatalog().getAllPages();
        if (allPages.size() > pageNumber) {
            PDPage page = (PDPage)allPages.get(pageNumber);
            removed = this.removePage(page);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDPage importPage(PDPage page) throws IOException {
        PDPage importedPage = new PDPage(new COSDictionary(page.getCOSDictionary()));
        InputStream is = null;
        OutputStream os = null;
        try {
            PDStream src = page.getContents();
            PDStream dest = new PDStream(new COSStream(src.getStream(), this.document.getScratchFile()));
            importedPage.setContents(dest);
            os = dest.createOutputStream();
            byte[] buf = new byte[10240];
            int amountRead = 0;
            is = src.createInputStream();
            while ((amountRead = is.read(buf, 0, 10240)) > -1) {
                os.write(buf, 0, amountRead);
            }
            this.addPage(importedPage);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return importedPage;
    }

    public PDDocument(COSDocument doc) {
        this.document = doc;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(COSName.INFO, (COSBase)infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.INFO, (COSBase)info.getDictionary());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = infoDic == null ? new PDDocumentCatalog(this) : new PDDocumentCatalog(this, infoDic);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryptionDictionary getEncryptionDictionary() throws IOException {
        if (this.encParameters == null && this.isEncrypted()) {
            this.encParameters = new PDEncryptionDictionary(this.document.getEncryptionDictionary());
        }
        return this.encParameters;
    }

    public void setEncryptionDictionary(PDEncryptionDictionary encDictionary) throws IOException {
        this.encParameters = encDictionary;
    }

    public boolean isUserPassword(String password) throws IOException, CryptographyException {
        return false;
    }

    public boolean isOwnerPassword(String password) throws IOException, CryptographyException {
        return false;
    }

    public void decrypt(String password) throws CryptographyException, IOException, InvalidPasswordException {
        try {
            StandardDecryptionMaterial m = new StandardDecryptionMaterial(password);
            this.openProtection(m);
            this.document.dereferenceObjectStreams();
        }
        catch (BadSecurityHandlerException e) {
            throw new CryptographyException(e);
        }
    }

    public boolean wasDecryptedWithOwnerPassword() {
        return false;
    }

    public void encrypt(String ownerPassword, String userPassword) throws CryptographyException, IOException {
        try {
            StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword, new AccessPermission());
            this.protect(policy);
        }
        catch (BadSecurityHandlerException e) {
            throw new CryptographyException(e);
        }
    }

    public String getOwnerPasswordForEncryption() {
        return null;
    }

    public String getUserPasswordForEncryption() {
        return null;
    }

    public boolean willEncryptWhenSaving() {
        return false;
    }

    public void clearWillEncryptWhenSaving() {
    }

    public static PDDocument load(URL url) throws IOException {
        return PDDocument.load(url.openStream());
    }

    public static PDDocument load(URL url, boolean force) throws IOException {
        return PDDocument.load(url.openStream(), force);
    }

    public static PDDocument load(URL url, RandomAccess scratchFile) throws IOException {
        return PDDocument.load(url.openStream(), scratchFile);
    }

    public static PDDocument load(String filename) throws IOException {
        return PDDocument.load(new FileInputStream(filename));
    }

    public static PDDocument load(String filename, boolean force) throws IOException {
        return PDDocument.load((InputStream)new FileInputStream(filename), force);
    }

    public static PDDocument load(String filename, RandomAccess scratchFile) throws IOException {
        return PDDocument.load((InputStream)new FileInputStream(filename), scratchFile);
    }

    public static PDDocument load(File file) throws IOException {
        return PDDocument.load(new FileInputStream(file));
    }

    public static PDDocument load(File file, RandomAccess scratchFile) throws IOException {
        return PDDocument.load(new FileInputStream(file));
    }

    public static PDDocument load(InputStream input) throws IOException {
        return PDDocument.load(input, null);
    }

    public static PDDocument load(InputStream input, boolean force) throws IOException {
        return PDDocument.load(input, null, force);
    }

    public static PDDocument load(InputStream input, RandomAccess scratchFile) throws IOException {
        PDFParser parser = new PDFParser(new BufferedInputStream(input), scratchFile);
        parser.parse();
        return parser.getPDDocument();
    }

    public static PDDocument load(InputStream input, RandomAccess scratchFile, boolean force) throws IOException {
        PDFParser parser = new PDFParser(new BufferedInputStream(input), scratchFile, force);
        parser.parse();
        return parser.getPDDocument();
    }

    public void save(String fileName) throws IOException, COSVisitorException {
        this.save(new FileOutputStream(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException, COSVisitorException {
        this.getDocumentCatalog().getPages().updateCount();
        COSWriter writer = null;
        try {
            writer = new COSWriter(output);
            writer.write(this);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public int getPageCount() {
        return this.getNumberOfPages();
    }

    public int getNumberOfPages() {
        PDDocumentCatalog cat = this.getDocumentCatalog();
        return (int)cat.getPages().getCount();
    }

    public PageFormat getPageFormat(int pageIndex) {
        PDPage page = (PDPage)this.getDocumentCatalog().getAllPages().get(pageIndex);
        Dimension mediaBox = page.findMediaBox().createDimension();
        Dimension cropBox = page.findCropBox().createDimension();
        double diffWidth = 0.0;
        double diffHeight = 0.0;
        double mediaWidth = mediaBox.getWidth();
        double mediaHeight = mediaBox.getHeight();
        double cropWidth = cropBox.getWidth();
        double cropHeight = cropBox.getHeight();
        if (!mediaBox.equals(cropBox)) {
            diffWidth = (mediaWidth - cropWidth) / 2.0;
            diffHeight = (mediaHeight - cropHeight) / 2.0;
        }
        Paper paper = new Paper();
        paper.setImageableArea(diffWidth, diffHeight, cropWidth, cropHeight);
        paper.setSize(mediaWidth, mediaHeight);
        PageFormat format = new PageFormat();
        format.setPaper(paper);
        return format;
    }

    public Printable getPrintable(int pageIndex) {
        return (Printable)this.getDocumentCatalog().getAllPages().get(pageIndex);
    }

    public void print(PrinterJob printJob) throws PrinterException {
        if (printJob == null) {
            throw new PrinterException("The delivered printJob is null.");
        }
        AccessPermission currentPermissions = this.getCurrentAccessPermission();
        if (!currentPermissions.canPrint()) {
            throw new PrinterException("You do not have permission to print this document.");
        }
        printJob.setPageable(this);
        if (printJob.printDialog()) {
            printJob.print();
        }
    }

    public void print() throws PrinterException {
        this.print(PrinterJob.getPrinterJob());
    }

    public void silentPrint() throws PrinterException {
        this.silentPrint(PrinterJob.getPrinterJob());
    }

    public void silentPrint(PrinterJob printJob) throws PrinterException {
        if (printJob == null) {
            throw new PrinterException("The delivered printJob is null.");
        }
        AccessPermission currentPermissions = this.getCurrentAccessPermission();
        if (!currentPermissions.canPrint()) {
            throw new PrinterException("You do not have permission to print this document.");
        }
        printJob.setPageable(this);
        printJob.print();
    }

    public void close() throws IOException {
        this.document.close();
    }

    public void protect(ProtectionPolicy pp) throws BadSecurityHandlerException {
        SecurityHandler handler;
        this.securityHandler = handler = SecurityHandlersManager.getInstance().getSecurityHandler(pp);
    }

    public void openProtection(DecryptionMaterial pm) throws BadSecurityHandlerException, IOException, CryptographyException {
        PDEncryptionDictionary dict = this.getEncryptionDictionary();
        if (dict.getFilter() == null) {
            throw new RuntimeException("This document does not need to be decrypted");
        }
        this.securityHandler = SecurityHandlersManager.getInstance().getSecurityHandler(dict.getFilter());
        this.securityHandler.decryptDocument(this, pm);
        this.document.dereferenceObjectStreams();
        this.document.setEncryptionDictionary(null);
    }

    public AccessPermission getCurrentAccessPermission() {
        if (this.securityHandler == null) {
            return AccessPermission.getOwnerAccessPermission();
        }
        return this.securityHandler.getCurrentAccessPermission();
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public boolean isAllSecurityToBeRemoved() {
        return this.allSecurityToBeRemoved;
    }

    public void setAllSecurityToBeRemoved(boolean allSecurityToBeRemoved) {
        this.allSecurityToBeRemoved = allSecurityToBeRemoved;
    }
}

