/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.fmrc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.fmr.FmrcCoordSys;
import ucar.nc2.dt.fmrc.FmrcInventory;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmrcDefinition
implements FmrcCoordSys {
    private static Logger log = LoggerFactory.getLogger(FmrcDefinition.class);
    private List<VertTimeCoord> vertTimeCoords;
    private List<ForecastModelRunInventory.TimeCoord> timeCoords;
    private List<ForecastModelRunInventory.EnsCoord> ensCoords;
    private List<RunSeq> runSequences;
    private String name;
    private String suffixFilter;
    private int runseq_num = 0;
    private Calendar cal = new GregorianCalendar();
    static boolean showState = false;
    public static String[] fmrcDatasets = new String[]{"NCEP/GFS/Alaska_191km", "NCEP/GFS/CONUS_80km", "NCEP/GFS/CONUS_95km", "NCEP/GFS/CONUS_191km", "NCEP/GFS/Global_0p5deg", "NCEP/GFS/Global_onedeg", "NCEP/GFS/Global_2p5deg", "NCEP/GFS/Hawaii_160km", "NCEP/GFS/N_Hemisphere_381km", "NCEP/GFS/Puerto_Rico_191km", "NCEP/NAM/Alaska_11km", "NCEP/NAM/Alaska_22km", "NCEP/NAM/Alaska_45km/noaaport", "NCEP/NAM/Alaska_45km/conduit", "NCEP/NAM/Alaska_95km", "NCEP/NAM/CONUS_12km/conduit", "NCEP/NAM/CONUS_20km/surface", "NCEP/NAM/CONUS_20km/selectsurface", "NCEP/NAM/CONUS_20km/noaaport", "NCEP/NAM/CONUS_40km/conduit", "NCEP/NAM/CONUS_80km", "NCEP/NAM/Polar_90km", "NCEP/RUC2/CONUS_20km/surface", "NCEP/RUC2/CONUS_20km/pressure", "NCEP/RUC2/CONUS_20km/hybrid", "NCEP/RUC2/CONUS_40km", "NCEP/RUC/CONUS_80km", "NCEP/DGEX/CONUS_12km", "NCEP/DGEX/Alaska_12km", "NCEP/SREF/CONUS_40km/ensprod", "NCEP/SREF/CONUS_40km/ensprod_biasc", "NCEP/SREF/Alaska_45km/ensprod", "NCEP/SREF/PacificNE_0p4/ensprod", "NCEP/NDFD/CONUS_5km", "NCEP/WW3/Alaskan_4minute", "NCEP/WW3/Alaskan_10minute", "NCEP/WW3/Atlantic_4minute", "NCEP/WW3/Atlantic_10minute", "NCEP/WW3/EasternPacific_10minute", "NCEP/WW3/Global_30minute", "NCEP/WW3/WestCoast_4minute", "NCEP/WW3/WestCoast_10minute"};
    public static String[] fmrcDatasets_41 = new String[]{"NCEP/GFS/Alaska_191km", "NCEP/GFS/CONUS_80km", "NCEP/GFS/CONUS_95km", "NCEP/GFS/CONUS_191km", "NCEP/GFS/Global_0p5deg", "NCEP/GFS/Global_onedeg", "NCEP/GFS/Global_2p5deg", "NCEP/GFS/Hawaii_160km", "NCEP/GFS/N_Hemisphere_381km", "NCEP/GFS/Puerto_Rico_191km", "NCEP/NAM/Alaska_11km", "NCEP/NAM/Alaska_22km", "NCEP/NAM/Alaska_45km/noaaport", "NCEP/NAM/Alaska_45km/conduit", "NCEP/NAM/Alaska_95km", "NCEP/NAM/CONUS_12km/conduit", "NCEP/NAM/CONUS_20km/surface", "NCEP/NAM/CONUS_20km/selectsurface", "NCEP/NAM/CONUS_20km/noaaport", "NCEP/NAM/CONUS_40km/conduit", "NCEP/NAM/CONUS_80km", "NCEP/NAM/Polar_90km", "NCEP/RUC2/CONUS_20km/surface", "NCEP/RUC2/CONUS_20km/pressure", "NCEP/RUC2/CONUS_20km/hybrid", "NCEP/RUC2/CONUS_40km", "NCEP/RUC/CONUS_80km", "NCEP/DGEX/CONUS_12km", "NCEP/DGEX/Alaska_12km", "NCEP/NDFD/CONUS_5km"};
    private static String fmrcDefinitionDir = "C:/dev/tds/thredds/tds/src/main/webapp/WEB-INF/altContent/idd/thredds/modelInventory/";
    private static String[] fmrcDefinitionFiles;
    private static String[] exampleFiles;

    public FmrcDefinition() {
        this.cal.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String getSuffixFilter() {
        return this.suffixFilter;
    }

    public List<RunSeq> getRunSequences() {
        return this.runSequences;
    }

    @Override
    public boolean hasVariable(String searchName) {
        return this.findGridByName(searchName) != null;
    }

    @Override
    public FmrcCoordSys.VertCoord findVertCoordForVariable(String searchName) {
        Grid grid = this.findGridByName(searchName);
        return grid.vtc == null ? null : ((Grid)grid).vtc.vc;
    }

    @Override
    public FmrcCoordSys.TimeCoord findTimeCoordForVariable(String searchName, Date runTime) {
        for (RunSeq runSeq : this.runSequences) {
            Grid grid = runSeq.findGrid(searchName);
            if (null == grid) continue;
            ForecastModelRunInventory.TimeCoord from = runSeq.findTimeCoordByRuntime(runTime);
            return new ForecastModelRunInventory.TimeCoord(runSeq.num, from);
        }
        return null;
    }

    private ForecastModelRunInventory.TimeCoord findTimeCoord(String id) {
        for (ForecastModelRunInventory.TimeCoord tc : this.timeCoords) {
            if (!tc.getId().equals(id)) continue;
            return tc;
        }
        return null;
    }

    public RunSeq findSeqForVariable(String name) {
        for (RunSeq runSeq : this.runSequences) {
            if (runSeq.findGrid(name) == null) continue;
            return runSeq;
        }
        return null;
    }

    Grid findGridByName(String name) {
        for (RunSeq runSeq : this.runSequences) {
            Grid grid = runSeq.findGrid(name);
            if (null == grid) continue;
            return grid;
        }
        return null;
    }

    VertTimeCoord findVertCoord(String id) {
        if (id == null) {
            return null;
        }
        for (VertTimeCoord vc : this.vertTimeCoords) {
            if (!vc.getId().equals(id)) continue;
            return vc;
        }
        return null;
    }

    VertTimeCoord findVertCoordByName(String name) {
        for (VertTimeCoord vc : this.vertTimeCoords) {
            if (!vc.getName().equals(name)) continue;
            return vc;
        }
        return null;
    }

    boolean replaceVertCoord(ForecastModelRunInventory.VertCoord vc) {
        for (VertTimeCoord vtc : this.vertTimeCoords) {
            if (!vtc.getName().equals(vc.getName())) continue;
            vtc.vc.values1 = vc.values1;
            vtc.vc.values2 = vc.values2;
            vtc.vc.setId(vc.getId());
            vtc.vc.setUnits(vc.getUnits());
            return true;
        }
        this.vertTimeCoords.add(new VertTimeCoord(vc));
        return false;
    }

    private ForecastModelRunInventory.EnsCoord findEnsCoord(String id) {
        if (id == null) {
            return null;
        }
        for (ForecastModelRunInventory.EnsCoord ec : this.ensCoords) {
            if (!ec.getId().equals(id)) continue;
            return ec;
        }
        return null;
    }

    public String writeDefinitionXML() {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.makeDefinitionXML());
    }

    public void writeDefinitionXML(OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.makeDefinitionXML(), os);
    }

    public Document makeDefinitionXML() {
        StringBuilder sbuff;
        Element rootElem = new Element("fmrcDefinition");
        Document doc = new Document(rootElem);
        if (this.name != null) {
            rootElem.setAttribute("dataset", this.name);
        }
        if (null != this.suffixFilter) {
            rootElem.setAttribute("suffixFilter", this.suffixFilter);
        }
        Collections.sort(this.ensCoords);
        for (ForecastModelRunInventory.EnsCoord ec : this.ensCoords) {
            Element ecElem = new Element("ensCoord");
            rootElem.addContent(ecElem);
            ecElem.setAttribute("id", ec.getId());
            ecElem.setAttribute("name", ec.getName());
            ecElem.setAttribute("product_definition", Integer.toString(ec.getPDN()));
            sbuff = new StringBuilder();
            int[] ensTypes = ec.getEnsTypes();
            for (int j = 0; j < ensTypes.length; ++j) {
                if (j > 0) {
                    sbuff.append(" ");
                }
                sbuff.append(Integer.toString(ensTypes[j]));
            }
            ecElem.addContent(sbuff.toString());
        }
        Collections.sort(this.vertTimeCoords);
        for (VertTimeCoord vtc : this.vertTimeCoords) {
            ForecastModelRunInventory.VertCoord vc = vtc.vc;
            Element vcElem = new Element("vertCoord");
            rootElem.addContent(vcElem);
            vcElem.setAttribute("id", vc.getId());
            vcElem.setAttribute("name", vc.getName());
            if (null != vc.getUnits()) {
                vcElem.setAttribute("units", vc.getUnits());
            }
            StringBuilder sbuff2 = new StringBuilder();
            double[] values1 = vc.getValues1();
            double[] values2 = vc.getValues2();
            for (int j = 0; j < values1.length; ++j) {
                if (j > 0) {
                    sbuff2.append(" ");
                }
                sbuff2.append(Double.toString(values1[j]));
                if (values2 == null) continue;
                sbuff2.append(",");
                sbuff2.append(Double.toString(values2[j]));
            }
            vcElem.addContent(sbuff2.toString());
        }
        Collections.sort(this.timeCoords);
        for (ForecastModelRunInventory.TimeCoord tc : this.timeCoords) {
            Element offsetElem = new Element("offsetHours");
            rootElem.addContent(offsetElem);
            offsetElem.setAttribute("id", tc.getId());
            sbuff = new StringBuilder();
            double[] offset = tc.getOffsetHours();
            for (int j = 0; j < offset.length; ++j) {
                if (j > 0) {
                    sbuff.append(" ");
                }
                sbuff.append(Double.toString(offset[j]));
            }
            offsetElem.addContent(sbuff.toString());
        }
        for (RunSeq runSeq : this.runSequences) {
            Element seqElem = new Element("runSequence");
            rootElem.addContent(seqElem);
            if (runSeq.isAll) {
                seqElem.setAttribute("allUseSeq", runSeq.allUseOffset.getId());
            } else {
                for (Run run : runSeq.runs) {
                    Element runElem = new Element("run");
                    seqElem.addContent(runElem);
                    runElem.setAttribute("runHour", Double.toString(run.runHour));
                    runElem.setAttribute("offsetHourSeq", run.tc.getId());
                }
            }
            for (Grid grid : runSeq.vars) {
                Element varElem = new Element("variable");
                seqElem.addContent(varElem);
                varElem.setAttribute("name", grid.name);
                if (grid.ec != null) {
                    varElem.setAttribute("ensCoord", grid.ec.getId());
                }
                if (grid.vtc == null) continue;
                varElem.setAttribute("vertCoord", grid.vtc.getId());
                if (((Grid)grid).vtc.restrictList == null) continue;
                Iterator<String> iter = ((Grid)grid).vtc.restrictList.iterator();
                while (iter.hasNext()) {
                    Element vtElem = new Element("vertCoord");
                    varElem.addContent(vtElem);
                    vtElem.setAttribute("restrict", iter.next());
                    vtElem.setText(iter.next());
                }
            }
        }
        return doc;
    }

    public boolean readDefinitionXML(String xmlLocation) throws IOException {
        int count;
        Document doc;
        File xml = new File(xmlLocation);
        if (!xml.exists()) {
            return false;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(xmlLocation));
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element rootElem = doc.getRootElement();
        this.name = rootElem.getAttributeValue("name");
        this.suffixFilter = rootElem.getAttributeValue("suffixFilter");
        this.ensCoords = new ArrayList<ForecastModelRunInventory.EnsCoord>();
        List eList = rootElem.getChildren("ensCoord");
        for (Element ecElem : eList) {
            ForecastModelRunInventory.EnsCoord ec = new ForecastModelRunInventory.EnsCoord();
            ec.setId(ecElem.getAttributeValue("id"));
            ec.setName(ecElem.getAttributeValue("name"));
            ec.setPDN(Integer.parseInt(ecElem.getAttributeValue("product_definition")));
            String values = ecElem.getText();
            StringTokenizer stoke = new StringTokenizer(values);
            int n = stoke.countTokens();
            ec.setNEnsembles(n);
            int[] ensType = new int[n];
            int count2 = 0;
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                int pos = toke.indexOf(44);
                if (pos < 0) {
                    ensType[count2] = Integer.parseInt(toke);
                }
                ++count2;
            }
            ec.setEnsTypes(ensType);
            this.ensCoords.add(ec);
        }
        this.vertTimeCoords = new ArrayList<VertTimeCoord>();
        List vList = rootElem.getChildren("vertCoord");
        for (Element vcElem : vList) {
            ForecastModelRunInventory.VertCoord vc = new ForecastModelRunInventory.VertCoord();
            vc.setId(vcElem.getAttributeValue("id"));
            vc.setName(vcElem.getAttributeValue("name"));
            vc.setUnits(vcElem.getAttributeValue("units"));
            String values = vcElem.getText();
            StringTokenizer stoke = new StringTokenizer(values);
            int n = stoke.countTokens();
            double[] values1 = new double[n];
            double[] values2 = null;
            count = 0;
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                int pos = toke.indexOf(44);
                if (pos < 0) {
                    values1[count] = Double.parseDouble(toke);
                } else {
                    if (values2 == null) {
                        values2 = new double[n];
                    }
                    String val1 = toke.substring(0, pos);
                    String val2 = toke.substring(pos + 1);
                    values1[count] = Double.parseDouble(val1);
                    values2[count] = Double.parseDouble(val2);
                }
                ++count;
            }
            vc.setValues1(values1);
            if (values2 != null) {
                vc.setValues2(values2);
            }
            VertTimeCoord vtc = new VertTimeCoord(vc);
            this.vertTimeCoords.add(vtc);
        }
        this.timeCoords = new ArrayList<ForecastModelRunInventory.TimeCoord>();
        List tList = rootElem.getChildren("offsetHours");
        for (Element timeElem : tList) {
            ForecastModelRunInventory.TimeCoord tc = new ForecastModelRunInventory.TimeCoord();
            this.timeCoords.add(tc);
            tc.setId(timeElem.getAttributeValue("id"));
            String values = timeElem.getText();
            StringTokenizer stoke = new StringTokenizer(values);
            int n = stoke.countTokens();
            double[] offset = new double[n];
            count = 0;
            while (stoke.hasMoreTokens()) {
                offset[count++] = Double.parseDouble(stoke.nextToken());
            }
            tc.setOffsetHours(offset);
        }
        this.runSequences = new ArrayList<RunSeq>();
        List runseqList = rootElem.getChildren("runSequence");
        for (Element runseqElem : runseqList) {
            RunSeq rseq;
            String allUseId = runseqElem.getAttributeValue("allUseSeq");
            if (allUseId != null) {
                rseq = new RunSeq(allUseId);
            } else {
                ArrayList<Run> runs = new ArrayList<Run>();
                List runList = runseqElem.getChildren("run");
                for (Element runElem : runList) {
                    String id = runElem.getAttributeValue("offsetHourSeq");
                    ForecastModelRunInventory.TimeCoord tc = this.findTimeCoord(id);
                    String hour = runElem.getAttributeValue("runHour");
                    Run run = new Run(tc, Double.parseDouble(hour));
                    runs.add(run);
                }
                rseq = new RunSeq(runs);
            }
            this.runSequences.add(rseq);
            List varList = runseqElem.getChildren("variable");
            for (Element varElem : varList) {
                String name = varElem.getAttributeValue("name");
                Grid grid = new Grid(name);
                rseq.vars.add(grid);
                grid.ec = this.findEnsCoord(varElem.getAttributeValue("ensCoord"));
                grid.vtc = this.findVertCoord(varElem.getAttributeValue("vertCoord"));
                List rList = varElem.getChildren("vertTimeCoord");
                if (rList.size() <= 0) continue;
                grid.vtc = new VertTimeCoord(((Grid)grid).vtc.vc, rseq);
                for (Element vtElem : rList) {
                    String vertCoords = vtElem.getAttributeValue("restrict");
                    String timeCoords = vtElem.getText();
                    grid.vtc.addRestriction(vertCoords, timeCoords);
                }
            }
            Collections.sort(rseq.vars);
        }
        return true;
    }

    public void makeFromCollectionInventory(FmrcInventory fmrc) {
        this.name = fmrc.getName();
        this.timeCoords = fmrc.getTimeCoords();
        this.ensCoords = fmrc.getEnsCoords();
        this.vertTimeCoords = new ArrayList<VertTimeCoord>();
        for (int i = 0; i < fmrc.getVertCoords().size(); ++i) {
            ForecastModelRunInventory.VertCoord vc = fmrc.getVertCoords().get(i);
            this.vertTimeCoords.add(new VertTimeCoord(vc));
        }
        this.runSequences = new ArrayList<RunSeq>();
        List<FmrcInventory.RunSeq> seqs = fmrc.getRunSequences();
        for (FmrcInventory.RunSeq invSeq : seqs) {
            RunSeq runSeq;
            boolean isAll = true;
            ForecastModelRunInventory.TimeCoord oneTc = null;
            for (int j = 0; j < invSeq.runs.size(); ++j) {
                FmrcInventory.Run run = invSeq.runs.get(j);
                if (j == 0) {
                    oneTc = run.tc;
                    continue;
                }
                if (oneTc == run.tc) continue;
                isAll = false;
            }
            if (isAll) {
                runSeq = new RunSeq(oneTc.getId());
            } else {
                ArrayList<Run> runs = new ArrayList<Run>();
                for (FmrcInventory.Run invRun : invSeq.runs) {
                    Run run = new Run(invRun.tc, this.getHour(invRun.runTime));
                    runs.add(run);
                }
                runSeq = new RunSeq(runs);
            }
            this.runSequences.add(runSeq);
            List<FmrcInventory.UberGrid> vars = invSeq.getVariables();
            for (FmrcInventory.UberGrid uv : vars) {
                Grid grid = new Grid(uv.getName());
                runSeq.vars.add(grid);
                if (uv.vertCoordUnion != null) {
                    grid.vtc = new VertTimeCoord(uv.vertCoordUnion);
                }
                if (uv.ensCoordUnion == null) continue;
                grid.ec = uv.ensCoordUnion;
            }
        }
        Collections.sort(this.vertTimeCoords);
    }

    public void addVertCoordsFromCollectionInventory(FmrcInventory fmrc) {
        this.vertTimeCoords = new ArrayList<VertTimeCoord>();
        for (int i = 0; i < fmrc.getVertCoords().size(); ++i) {
            ForecastModelRunInventory.VertCoord vc = fmrc.getVertCoords().get(i);
            this.vertTimeCoords.add(new VertTimeCoord(vc));
        }
        List<FmrcInventory.RunSeq> seqs = fmrc.getRunSequences();
        for (FmrcInventory.RunSeq invSeq : seqs) {
            List<FmrcInventory.UberGrid> vars = invSeq.getVariables();
            for (FmrcInventory.UberGrid uv : vars) {
                if (uv.vertCoordUnion == null) continue;
                String sname = uv.getName();
                Grid grid = this.findGridByName(sname);
                grid.vtc = new VertTimeCoord(uv.vertCoordUnion);
            }
        }
    }

    private double getHour(Date d) {
        this.cal.setTime(d);
        int hour = this.cal.get(11);
        double min = this.cal.get(12);
        return (double)hour + min / 60.0;
    }

    static void convertIds(String datasetName, String defName) throws IOException {
        System.out.println(datasetName);
        ForecastModelRunInventory fmrInv = ForecastModelRunInventory.open(null, datasetName, 2, true);
        FmrcDefinition fmrDef = new FmrcDefinition();
        fmrDef.readDefinitionXML(defName);
        boolean changed = false;
        HashMap<String, Grid> hash = new HashMap<String, Grid>();
        for (RunSeq runSeq : fmrDef.runSequences) {
            for (Grid gridDef : runSeq.vars) {
                String munged = StringUtil.replace(gridDef.name, '_', "");
                hash.put(munged, gridDef);
            }
        }
        List<ForecastModelRunInventory.TimeCoord> fmrInvTimeCoords = fmrInv.getTimeCoords();
        for (ForecastModelRunInventory.TimeCoord tc : fmrInvTimeCoords) {
            List<ForecastModelRunInventory.Grid> fmrInvGrids = tc.getGrids();
            for (ForecastModelRunInventory.Grid invGrid : fmrInvGrids) {
                Grid defGrid = fmrDef.findGridByName(invGrid.name);
                if (null != defGrid) continue;
                String munged = StringUtil.replace(invGrid.name, "-", "");
                Grid gridDefnew = (Grid)hash.get(munged = StringUtil.replace(munged, "_", ""));
                if (gridDefnew != null) {
                    System.out.println(" replace " + gridDefnew.name + " with " + invGrid.name);
                    gridDefnew.name = invGrid.name;
                    changed = false;
                    continue;
                }
                System.out.println("*** cant find replacement for grid= " + invGrid.name + " in the definition");
            }
        }
        if (changed) {
            int pos = defName.lastIndexOf("/");
            String newDef = defName.substring(0, pos) + "/new/" + defName.substring(pos);
            FileOutputStream fout = new FileOutputStream(newDef);
            fmrDef.writeDefinitionXML(fout);
        }
    }

    static void convert(String datasetName, String defName) throws IOException {
        System.out.println(datasetName);
        ForecastModelRunInventory fmrInv = ForecastModelRunInventory.open(null, datasetName, 2, true);
        FmrcDefinition fmrDef = new FmrcDefinition();
        fmrDef.readDefinitionXML(defName);
        List<ForecastModelRunInventory.VertCoord> vcList = fmrInv.getVertCoords();
        for (ForecastModelRunInventory.VertCoord vc : vcList) {
            CoordinateAxis1D axis = vc.axis;
            if (axis == null) {
                System.out.println("*** No Axis " + vc.getName());
                continue;
            }
            if (showState) {
                System.out.print(" " + vc.getName() + " contig= " + axis.isContiguous());
            }
            boolean ok = fmrDef.replaceVertCoord(vc);
            if (!showState) continue;
            System.out.println(" = " + ok);
        }
        Collections.sort(fmrDef.vertTimeCoords);
        for (RunSeq runSeq : fmrDef.runSequences) {
            for (Grid gridDef : runSeq.vars) {
                ForecastModelRunInventory.Grid gridInv = fmrInv.findGrid(gridDef.name);
                if (gridInv == null) {
                    System.out.println("*** cant find def grid= " + gridDef.name + " in the inventory ");
                    continue;
                }
                if (gridInv.vc == null) continue;
                VertTimeCoord new_vtc = fmrDef.findVertCoordByName(gridInv.vc.getName());
                if (new_vtc == null) {
                    System.out.println("*** cant find VertCoord= " + gridInv.vc.getName());
                    continue;
                }
                gridDef.vtc = new_vtc;
                if (!showState) continue;
                System.out.println(" ok= " + gridDef.name);
            }
        }
        int pos = defName.lastIndexOf("/");
        String newDef = defName.substring(0, pos) + "/new/" + defName.substring(pos);
        FileOutputStream fout = new FileOutputStream(newDef);
        fmrDef.writeDefinitionXML(fout);
        List<ForecastModelRunInventory.TimeCoord> fmrInvTimeCoords = fmrInv.getTimeCoords();
        for (ForecastModelRunInventory.TimeCoord tc : fmrInvTimeCoords) {
            List<ForecastModelRunInventory.Grid> fmrInvGrids = tc.getGrids();
            for (ForecastModelRunInventory.Grid invGrid : fmrInvGrids) {
                ForecastModelRunInventory.VertCoord def_vc;
                Grid defGrid = fmrDef.findGridByName(invGrid.name);
                if (null == defGrid) {
                    System.out.println("*** cant find inv grid= " + invGrid.name + " in the definition");
                    continue;
                }
                ForecastModelRunInventory.VertCoord inv_vc = invGrid.vc;
                if (inv_vc == null && defGrid.vtc == null) continue;
                if (inv_vc != null && defGrid.vtc == null) {
                    System.out.println("*** mismatch " + invGrid.name + " VertCoord: inv= " + inv_vc.getSize() + ", no def ");
                    continue;
                }
                if (inv_vc == null && defGrid.vtc != null) {
                    def_vc = ((Grid)defGrid).vtc.vc;
                    System.out.println("*** mismatch " + invGrid.name + " VertCoord: def= " + def_vc.getSize() + ", no inv ");
                    continue;
                }
                def_vc = ((Grid)defGrid).vtc.vc;
                if (inv_vc.getSize() == def_vc.getSize()) continue;
                System.out.println("*** mismatch " + invGrid.name + " VertCoord size: inv= " + inv_vc.getSize() + ", def = " + def_vc.getSize());
            }
        }
    }

    static void showVertCoords(String datasetName, String defName) throws IOException {
        System.out.println("--------------------------------------");
        System.out.println(defName);
        FmrcDefinition fmrDef = new FmrcDefinition();
        fmrDef.readDefinitionXML(defName);
        System.out.println(datasetName);
        ForecastModelRunInventory fmrInv = ForecastModelRunInventory.open(null, datasetName, 2, true);
        List<ForecastModelRunInventory.VertCoord> vcList = fmrInv.getVertCoords();
        for (ForecastModelRunInventory.VertCoord vc : vcList) {
            boolean got;
            CoordinateAxis1D axis = vc.axis;
            if (axis == null) {
                System.out.println(" No Axis " + vc.getName());
            } else if (axis.isInterval()) {
                System.out.println(" Layer " + vc.getName() + " contig= " + axis.isContiguous());
                FmrcDefinition.findGridsForVertCoord(fmrDef, vc);
            }
            if (got = fmrDef.findVertCoordByName(vc.getName()) != null) continue;
            System.out.println(" ***NOT " + vc.getName());
        }
    }

    static void findGridsForVertCoord(FmrcDefinition fmrDef, ForecastModelRunInventory.VertCoord vc) {
        for (RunSeq runSeq : fmrDef.runSequences) {
            for (Grid grid : runSeq.vars) {
                List<String> restrictList;
                if (grid.vtc == null || ((Grid)grid).vtc.vc != vc || (restrictList = ((Grid)grid).vtc.restrictList) == null || restrictList.size() <= 0) continue;
                System.out.println(" TimeVertCoord refers to this vertical coordinate");
            }
        }
    }

    public static String[] getDefinitionFiles() {
        if (fmrcDefinitionFiles == null) {
            fmrcDefinitionFiles = new String[fmrcDatasets.length];
            int count = 0;
            for (String ds : fmrcDatasets) {
                FmrcDefinition.fmrcDefinitionFiles[count++] = fmrcDefinitionDir + StringUtil.replace(ds, '/', "-") + ".fmrcDefinition.xml";
            }
        }
        return fmrcDefinitionFiles;
    }

    public static void main(String[] args) throws IOException {
        for (int i = 0; i < exampleFiles.length; i += 2) {
            FmrcDefinition.convertIds(exampleFiles[i], exampleFiles[i + 1]);
        }
    }

    static {
        exampleFiles = new String[]{"R:/testdata/motherlode/grid/RUC2_CONUS_20km_surface_20060825_1400.grib2", "R:/testdata/motherlode/grid/modelDefs/NCEP-RUC2-CONUS_20km-surface.fmrcDefinition.xml"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VertTimeCoord
    implements Comparable {
        ForecastModelRunInventory.VertCoord vc;
        ForecastModelRunInventory.TimeCoord tc;
        int ntimes;
        int nverts;
        double[][] vcForTimeIndex;
        List<String> restrictList;

        VertTimeCoord(ForecastModelRunInventory.VertCoord vc) {
            this.vc = vc;
            this.ntimes = this.tc == null ? 1 : this.tc.getOffsetHours().length;
            this.nverts = vc.getValues1().length;
        }

        VertTimeCoord(ForecastModelRunInventory.VertCoord vc, RunSeq runSeq) {
            if (runSeq.isAll) {
                this.tc = runSeq.allUseOffset;
            } else {
                HashSet<Double> valueSet = new HashSet<Double>();
                for (Run run : runSeq.runs) {
                    this.addValues(valueSet, run.tc.getOffsetHours());
                }
                List<Double> valueList = Arrays.asList(valueSet.toArray(new Double[valueSet.size()]));
                Collections.sort(valueList);
                double[] values = new double[valueList.size()];
                for (int i = 0; i < valueList.size(); ++i) {
                    values[i] = valueList.get(i);
                }
                this.tc = new ForecastModelRunInventory.TimeCoord();
                this.tc.setOffsetHours(values);
                this.tc.setId("union");
            }
            this.vc = vc;
            this.ntimes = this.tc == null ? 1 : this.tc.getOffsetHours().length;
            this.nverts = vc.getValues1().length;
        }

        private void addValues(Set<Double> valueSet, double[] values) {
            for (double value : values) {
                valueSet.add(value);
            }
        }

        String getId() {
            return this.vc.getId();
        }

        String getName() {
            return this.vc.getName();
        }

        void addRestriction(String vertCoordsString, String timeCoords) {
            StringTokenizer stoker = new StringTokenizer(vertCoordsString, " ,");
            int n = stoker.countTokens();
            double[] vertCoords = new double[n];
            int count = 0;
            while (stoker.hasMoreTokens()) {
                vertCoords[count++] = Double.parseDouble(stoker.nextToken());
            }
            if (this.vcForTimeIndex == null) {
                this.restrictList = new ArrayList<String>();
                this.vcForTimeIndex = new double[this.ntimes][];
                for (int i = 0; i < this.vcForTimeIndex.length; ++i) {
                    this.vcForTimeIndex[i] = this.vc.getValues1();
                }
            }
            this.restrictList.add(vertCoordsString);
            this.restrictList.add(timeCoords);
            stoker = new StringTokenizer(timeCoords, " ,");
            while (stoker.hasMoreTokens()) {
                double hour = Double.parseDouble(stoker.nextToken());
                int index = this.tc.findIndex(hour);
                if (index < 0) {
                    log.error("hour Offset" + hour + " not found in TimeCoord " + this.tc.getId());
                }
                this.vcForTimeIndex[index] = vertCoords;
            }
        }

        double[] getVertCoords(double offsetHour) {
            if (this.tc == null || null == this.vcForTimeIndex) {
                return this.vc.getValues1();
            }
            int index = this.tc.findIndex(offsetHour);
            if (index < 0) {
                return new double[0];
            }
            return this.vcForTimeIndex[index];
        }

        int countVertCoords(double offsetHour) {
            if (this.tc == null || null == this.vcForTimeIndex) {
                return this.vc.getValues1().length;
            }
            int index = this.tc.findIndex(offsetHour);
            if (index < 0) {
                return 0;
            }
            return this.vcForTimeIndex[index].length;
        }

        public int compareTo(Object o) {
            VertTimeCoord other = (VertTimeCoord)o;
            return this.getName().compareTo(other.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RunSeq {
        private boolean isAll = false;
        private ForecastModelRunInventory.TimeCoord allUseOffset;
        private List<Run> runs = new ArrayList<Run>();
        private List<Grid> vars = new ArrayList<Grid>();
        private int num = 0;

        RunSeq(String id) {
            this.isAll = true;
            this.allUseOffset = FmrcDefinition.this.findTimeCoord(id);
            this.num = FmrcDefinition.this.runseq_num++;
        }

        RunSeq(List<Run> runs) {
            this.runs = runs;
            this.num = FmrcDefinition.this.runseq_num++;
            int matchIndex = 0;
            Run last = runs.get(runs.size() - 1);
            double runHour = last.runHour;
            while (runHour < 24.0) {
                Run match = runs.get(matchIndex);
                Run next = runs.get(matchIndex + 1);
                double incr = next.runHour - match.runHour;
                if (incr <= 0.0) break;
                runs.add(new Run(next.tc, runHour += incr));
                ++matchIndex;
            }
        }

        public String getName() {
            return this.num == 0 ? "time" : "time" + this.num;
        }

        public ForecastModelRunInventory.TimeCoord findTimeCoordByRuntime(Date runTime) {
            if (this.isAll) {
                return this.allUseOffset;
            }
            double hour = FmrcDefinition.this.getHour(runTime);
            Run run = this.findRun(hour);
            if (run == null) {
                return null;
            }
            return run.tc;
        }

        Run findRun(double hour) {
            for (Run run : this.runs) {
                if (run.runHour != hour) continue;
                return run;
            }
            return null;
        }

        public Grid findGrid(String name) {
            if (name == null) {
                return null;
            }
            for (Grid grid : this.vars) {
                if (!name.equals(grid.name)) continue;
                return grid;
            }
            return null;
        }
    }

    class Run {
        double runHour;
        ForecastModelRunInventory.TimeCoord tc;

        Run(ForecastModelRunInventory.TimeCoord tc, double runHour) {
            this.tc = tc;
            this.runHour = runHour;
        }
    }

    public static class Grid
    implements Comparable {
        private String name;
        private VertTimeCoord vtc = null;
        private ForecastModelRunInventory.EnsCoord ec = null;

        Grid(String name) {
            this.name = name;
        }

        public FmrcCoordSys.EnsCoord getEnsTimeCoord() {
            return this.ec;
        }

        public VertTimeCoord getVertTimeCoord() {
            return this.vtc;
        }

        public int countVertCoords(double offsetHour) {
            return this.vtc == null ? 1 : this.vtc.countVertCoords(offsetHour);
        }

        public double[] getVertCoords(double hourOffset) {
            if (this.vtc == null) {
                double[] result = new double[]{-0.0};
                return result;
            }
            return this.vtc.getVertCoords(hourOffset);
        }

        public int compareTo(Object o) {
            Grid other = (Grid)o;
            return this.name.compareTo(other.name);
        }
    }
}

