package Bencher::Scenario::Algorithm::Diff::Diff;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Bencher-ScenarioBundle-Algorithm-Diff'; # DIST
our $VERSION = '0.003'; # VERSION

our $scenario = {
    summary => "Benchmark Algorithm::Diff's diff(), sdiff(), compact_diff(), LCS(), LCSidx(), LCS_length()",
    participants => [
        {fcall_template=>'Algorithm::Diff::diff(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::sdiff(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::compact_diff(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::LCS(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::LCSidx(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::LCS_length(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::XS::compact_diff(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::XS::LCSidx(<ary1>, <ary2>)'},
    ],
    datasets => [
        {name=>'empty'        , args=>{ary1=>[], ary2=>[]}},
        {name=>'insert 1x1'   , args=>{ary1=>[], ary2=>[1]}},
        {name=>'insert 1x10'  , args=>{ary1=>[], ary2=>[1..10]}},
        {name=>'insert 10x1'  , args=>{ary1=>[1..10], ary2=>[map {$_,$_+10} 1..10]}},
        {name=>'delete 1x1'   , args=>{ary1=>[1], ary2=>[]}},
        {name=>'delete 1x10'  , args=>{ary1=>[1..10], ary2=>[]}},
        {name=>'delete 10x1'  , args=>{ary1=>[map {$_,$_+10} 1..10], ary2=>[1..10]}},

        {name=>'insert+delete 150x1'  , args=>{ary1=>[qw/a b d/ x 50], ary2=>[qw/b a d c/ x 50]}},
    ],
};

1;
# ABSTRACT: Benchmark Algorithm::Diff's diff(), sdiff(), compact_diff(), LCS(), LCSidx(), LCS_length()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Algorithm::Diff::Diff - Benchmark Algorithm::Diff's diff(), sdiff(), compact_diff(), LCS(), LCSidx(), LCS_length()

=head1 VERSION

This document describes version 0.003 of Bencher::Scenario::Algorithm::Diff::Diff (from Perl distribution Bencher-ScenarioBundle-Algorithm-Diff), released on 2024-05-06.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Algorithm::Diff::Diff

To run module startup overhead benchmark:

 % bencher --module-startup -m Algorithm::Diff::Diff

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Algorithm::Diff> 1.201

L<Algorithm::Diff::XS> 1.201

=head1 BENCHMARK PARTICIPANTS

=over

=item * Algorithm::Diff::diff (perl_code)

Function call template:

 Algorithm::Diff::diff(<ary1>, <ary2>)



=item * Algorithm::Diff::sdiff (perl_code)

Function call template:

 Algorithm::Diff::sdiff(<ary1>, <ary2>)



=item * Algorithm::Diff::compact_diff (perl_code)

Function call template:

 Algorithm::Diff::compact_diff(<ary1>, <ary2>)



=item * Algorithm::Diff::LCS (perl_code)

Function call template:

 Algorithm::Diff::LCS(<ary1>, <ary2>)



=item * Algorithm::Diff::LCSidx (perl_code)

Function call template:

 Algorithm::Diff::LCSidx(<ary1>, <ary2>)



=item * Algorithm::Diff::LCS_length (perl_code)

Function call template:

 Algorithm::Diff::LCS_length(<ary1>, <ary2>)



=item * Algorithm::Diff::XS::compact_diff (perl_code)

Function call template:

 Algorithm::Diff::XS::compact_diff(<ary1>, <ary2>)



=item * Algorithm::Diff::XS::LCSidx (perl_code)

Function call template:

 Algorithm::Diff::XS::LCSidx(<ary1>, <ary2>)



=back

=head1 BENCHMARK DATASETS

=over

=item * empty

=item * insert 1x1

=item * insert 1x10

=item * insert 10x1

=item * delete 1x1

=item * delete 1x10

=item * delete 10x1

=item * insert+delete 150x1

=back

=head1 BENCHMARK SAMPLE RESULTS

=head2 Sample benchmark #1

Run on: perl: I<< v5.38.2 >>, CPU: I<< Intel(R) Core(TM) i5-7200U CPU @ 2.50GHz (2 cores) >>, OS: I<< GNU/Linux Ubuntu version 20.04 >>, OS kernel: I<< Linux version 5.4.0-164-generic >>.

Benchmark command (default options):

 % bencher -m Algorithm::Diff::Diff

Result formatted as table:

 #table1#
 +-----------------------------------+---------------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+
 | participant                       | dataset             | rate (/s) | time (ms) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +-----------------------------------+---------------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+
 | Algorithm::Diff::LCSidx           | insert+delete 150x1 |        90 |  10       |                 0.00% |            625580.07% |   0.00018 |      20 |
 | Algorithm::Diff::LCS              | insert+delete 150x1 |        99 |  10       |                11.16% |            562788.61% | 5.4e-05   |      23 |
 | Algorithm::Diff::sdiff            | insert+delete 150x1 |       100 |   9.8     |                15.07% |            543653.06% | 2.1e-05   |      20 |
 | Algorithm::Diff::compact_diff     | insert+delete 150x1 |       110 |   9.5     |                18.28% |            528873.02% | 2.2e-05   |      20 |
 | Algorithm::Diff::diff             | insert+delete 150x1 |       108 |   9.29    |                21.21% |            516096.37% | 7.1e-06   |      20 |
 | Algorithm::Diff::LCS_length       | insert+delete 150x1 |       109 |   9.21    |                22.26% |            511647.66% | 7.3e-06   |      20 |
 | Algorithm::Diff::XS::compact_diff | insert+delete 150x1 |      2800 |   0.36    |              3025.59% |             19917.96% | 4.8e-07   |      20 |
 | Algorithm::Diff::XS::LCSidx       | insert+delete 150x1 |      3380 |   0.296   |              3704.42% |             16346.12% | 2.1e-07   |      21 |
 | Algorithm::Diff::sdiff            | insert 10x1         |     22000 |   0.045   |             25121.36% |              2380.75% | 6.9e-08   |      20 |
 | Algorithm::Diff::sdiff            | delete 10x1         |     24100 |   0.0414  |             27090.21% |              2201.12% | 2.7e-08   |      20 |
 | Algorithm::Diff::diff             | insert 10x1         |     25000 |   0.04    |             27859.09% |              2137.84% | 5.6e-08   |      28 |
 | Algorithm::Diff::diff             | delete 10x1         |     26000 |   0.039   |             28935.18% |              2054.90% | 7.4e-08   |      21 |
 | Algorithm::Diff::compact_diff     | insert 10x1         |     28700 |   0.0348  |             32243.68% |              1834.47% | 3.2e-08   |      21 |
 | Algorithm::Diff::compact_diff     | delete 10x1         |     31000 |   0.032   |             34657.80% |              1700.11% | 4.7e-08   |      25 |
 | Algorithm::Diff::LCSidx           | insert 10x1         |     36000 |   0.028   |             40444.50% |              1443.19% | 5.3e-08   |      20 |
 | Algorithm::Diff::LCS              | insert 10x1         |     36300 |   0.0276  |             40737.95% |              1432.10% | 2.1e-08   |      20 |
 | Algorithm::Diff::XS::compact_diff | insert 10x1         |     38000 |   0.027   |             42293.92% |              1375.87% | 2.9e-08   |      20 |
 | Algorithm::Diff::LCS              | delete 10x1         |     38900 |   0.0257  |             43664.41% |              1329.65% | 2.4e-08   |      20 |
 | Algorithm::Diff::LCSidx           | delete 10x1         |     40400 |   0.0247  |             45442.90% |              1273.83% | 1.2e-08   |      20 |
 | Algorithm::Diff::LCS_length       | insert 10x1         |     44000 |   0.0227  |             49448.79% |              1162.76% | 1.7e-08   |      20 |
 | Algorithm::Diff::XS::compact_diff | delete 10x1         |     44000 |   0.023   |             49771.60% |              1154.58% | 2.5e-08   |      20 |
 | Algorithm::Diff::LCS_length       | delete 10x1         |     51000 |   0.0196  |             57302.37% |               989.99% | 1.2e-08   |      20 |
 | Algorithm::Diff::XS::LCSidx       | insert 10x1         |     55000 |   0.0182  |             61796.45% |               910.85% | 1.6e-08   |      20 |
 | Algorithm::Diff::sdiff            | insert 1x10         |     61000 |   0.017   |             68063.45% |               817.91% | 2.4e-08   |      20 |
 | Algorithm::Diff::XS::LCSidx       | delete 10x1         |     65700 |   0.0152  |             73850.74% |               746.08% | 1.1e-08   |      25 |
 | Algorithm::Diff::diff             | insert 1x10         |     68100 |   0.0147  |             76575.92% |               716.01% | 7.4e-09   |      20 |
 | Algorithm::Diff::sdiff            | delete 1x10         |     76000 |   0.013   |             85737.81% |               628.91% | 1.8e-08   |      21 |
 | Algorithm::Diff::diff             | delete 1x10         |     81000 |   0.012   |             90815.38% |               588.20% | 1.3e-08   |      20 |
 | Algorithm::Diff::compact_diff     | insert 1x10         |    130000 |   0.0078  |            143868.04% |               334.60% | 9.3e-09   |      20 |
 | Algorithm::Diff::XS::compact_diff | insert 1x10         |    130000 |   0.0077  |            145492.64% |               329.75% |   9e-09   |      20 |
 | Algorithm::Diff::sdiff            | delete 1x1          |    134000 |   0.00748 |            150376.00% |               315.80% | 3.8e-09   |      20 |
 | Algorithm::Diff::diff             | insert 1x1          |    140000 |   0.0074  |            152608.02% |               309.72% |   1e-08   |      20 |
 | Algorithm::Diff::sdiff            | insert 1x1          |    136000 |   0.00735 |            153131.97% |               308.32% | 4.3e-09   |      20 |
 | Algorithm::Diff::diff             | delete 1x1          |    145000 |   0.00688 |            163476.07% |               282.50% | 6.3e-09   |      20 |
 | Algorithm::Diff::LCSidx           | insert 1x10         |    150000 |   0.0068  |            165857.51% |               277.01% | 7.4e-09   |      20 |
 | Algorithm::Diff::XS::LCSidx       | insert 1x10         |    149000 |   0.00669 |            168217.26% |               271.73% | 4.6e-09   |      22 |
 | Algorithm::Diff::LCS              | insert 1x10         |    153000 |   0.00655 |            171729.01% |               264.13% |   4e-09   |      23 |
 | Algorithm::Diff::LCS_length       | insert 1x10         |    158000 |   0.00631 |            178200.17% |               250.91% | 5.5e-09   |      22 |
 | Algorithm::Diff::sdiff            | empty               |    166000 |   0.00604 |            186440.24% |               235.41% |   2e-09   |      21 |
 | Algorithm::Diff::diff             | empty               |    180000 |   0.0057  |            197163.59% |               217.18% | 1.2e-08   |      20 |
 | Algorithm::Diff::compact_diff     | delete 1x10         |    203000 |   0.00493 |            228458.43% |               173.75% | 2.8e-09   |      20 |
 | Algorithm::Diff::XS::compact_diff | delete 1x10         |    204000 |   0.0049  |            229850.80% |               172.09% |   3e-09   |      20 |
 | Algorithm::Diff::LCSidx           | delete 1x10         |    250000 |   0.004   |            281227.75% |               122.40% | 5.8e-09   |      20 |
 | Algorithm::Diff::XS::compact_diff | insert 1x1          |    257000 |   0.00389 |            289384.43% |               116.14% | 2.5e-09   |      21 |
 | Algorithm::Diff::XS::LCSidx       | delete 1x10         |    259000 |   0.00386 |            291709.75% |               114.41% | 1.2e-09   |      20 |
 | Algorithm::Diff::compact_diff     | insert 1x1          |    262000 |   0.00381 |            295140.99% |               111.92% | 1.8e-09   |      20 |
 | Algorithm::Diff::LCS              | delete 1x10         |    267000 |   0.00375 |            299978.88% |               108.51% | 2.5e-09   |      20 |
 | Algorithm::Diff::XS::compact_diff | delete 1x1          |    284000 |   0.00353 |            319176.25% |                95.97% | 9.8e-10   |      20 |
 | Algorithm::Diff::LCS_length       | delete 1x10         |    285000 |   0.00351 |            320463.80% |                95.18% | 1.3e-09   |      20 |
 | Algorithm::Diff::compact_diff     | delete 1x1          |    290000 |   0.0035  |            323764.89% |                93.19% | 4.3e-09   |      20 |
 | Algorithm::Diff::compact_diff     | empty               |    330000 |   0.0031  |            366765.27% |                70.55% | 4.4e-09   |      20 |
 | Algorithm::Diff::XS::compact_diff | empty               |    326000 |   0.00307 |            367206.02% |                70.34% | 2.5e-09   |      20 |
 | Algorithm::Diff::LCSidx           | insert 1x1          |    360000 |   0.0028  |            401372.09% |                55.85% | 3.4e-09   |      20 |
 | Algorithm::Diff::XS::LCSidx       | insert 1x1          |    370000 |   0.00271 |            416053.08% |                50.35% | 2.5e-09   |      20 |
 | Algorithm::Diff::LCS              | insert 1x1          |    385000 |   0.0026  |            433664.64% |                44.24% |   2e-09   |      20 |
 | Algorithm::Diff::LCSidx           | delete 1x1          |    400000 |   0.0025  |            450623.23% |                38.82% | 1.8e-09   |      20 |
 | Algorithm::Diff::XS::LCSidx       | delete 1x1          |    416000 |   0.00241 |            467741.43% |                33.74% | 1.6e-09   |      22 |
 | Algorithm::Diff::LCS              | delete 1x1          |    420000 |   0.0024  |            476739.39% |                31.21% | 2.8e-09   |      20 |
 | Algorithm::Diff::LCS_length       | insert 1x1          |    424000 |   0.00236 |            476931.14% |                31.16% | 1.4e-09   |      20 |
 | Algorithm::Diff::LCSidx           | empty               |    440000 |   0.0023  |            497789.71% |                25.67% |   3e-09   |      20 |
 | Algorithm::Diff::XS::LCSidx       | empty               |    470000 |   0.0021  |            527960.11% |                18.49% | 3.4e-09   |      20 |
 | Algorithm::Diff::LCS_length       | delete 1x1          |    485000 |   0.00206 |            546366.86% |                14.50% | 1.4e-09   |      20 |
 | Algorithm::Diff::LCS              | empty               |    490000 |   0.00204 |            551089.99% |                13.51% | 8.5e-10   |      20 |
 | Algorithm::Diff::LCS_length       | empty               |    556000 |   0.0018  |            625580.07% |                 0.00% | 6.5e-10   |      22 |
 +-----------------------------------+---------------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

                                   Rate  AD:L insert+delete 150x1  AD:L insert+delete 150x1  AD:s insert+delete 150x1  AD:c_d insert+delete 150x1  AD:d insert+delete 150x1  AD:L_l insert+delete 150x1  ADX:c_d insert+delete 150x1  ADX:L insert+delete 150x1  AD:s insert 10x1  AD:s delete 10x1  AD:d insert 10x1  AD:d delete 10x1  AD:c_d insert 10x1  AD:c_d delete 10x1  AD:L insert 10x1  AD:L insert 10x1  ADX:c_d insert 10x1  AD:L delete 10x1  AD:L delete 10x1  ADX:c_d delete 10x1  AD:L_l insert 10x1  AD:L_l delete 10x1  ADX:L insert 10x1  AD:s insert 1x10  ADX:L delete 10x1  AD:d insert 1x10  AD:s delete 1x10  AD:d delete 1x10  AD:c_d insert 1x10  ADX:c_d insert 1x10  AD:s delete 1x1  AD:d insert 1x1  AD:s insert 1x1  AD:d delete 1x1  AD:L insert 1x10  ADX:L insert 1x10  AD:L insert 1x10  AD:L_l insert 1x10  AD:s empty  AD:d empty  AD:c_d delete 1x10  ADX:c_d delete 1x10  AD:L delete 1x10  ADX:c_d insert 1x1  ADX:L delete 1x10  AD:c_d insert 1x1  AD:L delete 1x10  ADX:c_d delete 1x1  AD:L_l delete 1x10  AD:c_d delete 1x1  AD:c_d empty  ADX:c_d empty  AD:L insert 1x1  ADX:L insert 1x1  AD:L insert 1x1  AD:L delete 1x1  ADX:L delete 1x1  AD:L delete 1x1  AD:L_l insert 1x1  AD:L empty  ADX:L empty  AD:L_l delete 1x1  AD:L empty  AD:L_l empty 
  AD:L insert+delete 150x1         90/s                        --                        0%                       -1%                         -5%                       -7%                         -7%                         -96%                       -97%              -99%              -99%              -99%              -99%                -99%                -99%              -99%              -99%                 -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%               -99%              -99%                -99%        -99%        -99%                -99%                 -99%              -99%                -99%               -99%               -99%              -99%                -99%                -99%               -99%          -99%           -99%             -99%              -99%             -99%             -99%              -99%             -99%               -99%        -99%         -99%               -99%        -99%          -99% 
  AD:L insert+delete 150x1         99/s                        0%                        --                       -1%                         -5%                       -7%                         -7%                         -96%                       -97%              -99%              -99%              -99%              -99%                -99%                -99%              -99%              -99%                 -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%               -99%              -99%                -99%        -99%        -99%                -99%                 -99%              -99%                -99%               -99%               -99%              -99%                -99%                -99%               -99%          -99%           -99%             -99%              -99%             -99%             -99%              -99%             -99%               -99%        -99%         -99%               -99%        -99%          -99% 
  AD:s insert+delete 150x1        100/s                        2%                        2%                        --                         -3%                       -5%                         -6%                         -96%                       -96%              -99%              -99%              -99%              -99%                -99%                -99%              -99%              -99%                 -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%               -99%              -99%                -99%        -99%        -99%                -99%                 -99%              -99%                -99%               -99%               -99%              -99%                -99%                -99%               -99%          -99%           -99%             -99%              -99%             -99%             -99%              -99%             -99%               -99%        -99%         -99%               -99%        -99%          -99% 
  AD:c_d insert+delete 150x1      110/s                        5%                        5%                        3%                          --                       -2%                         -3%                         -96%                       -96%              -99%              -99%              -99%              -99%                -99%                -99%              -99%              -99%                 -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%               -99%              -99%                -99%        -99%        -99%                -99%                 -99%              -99%                -99%               -99%               -99%              -99%                -99%                -99%               -99%          -99%           -99%             -99%              -99%             -99%             -99%              -99%             -99%               -99%        -99%         -99%               -99%        -99%          -99% 
  AD:d insert+delete 150x1        108/s                        7%                        7%                        5%                          2%                        --                          0%                         -96%                       -96%              -99%              -99%              -99%              -99%                -99%                -99%              -99%              -99%                 -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%               -99%              -99%                -99%        -99%        -99%                -99%                 -99%              -99%                -99%               -99%               -99%              -99%                -99%                -99%               -99%          -99%           -99%             -99%              -99%             -99%             -99%              -99%             -99%               -99%        -99%         -99%               -99%        -99%          -99% 
  AD:L_l insert+delete 150x1      109/s                        8%                        8%                        6%                          3%                        0%                          --                         -96%                       -96%              -99%              -99%              -99%              -99%                -99%                -99%              -99%              -99%                 -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%               -99%              -99%                -99%        -99%        -99%                -99%                 -99%              -99%                -99%               -99%               -99%              -99%                -99%                -99%               -99%          -99%           -99%             -99%              -99%             -99%             -99%              -99%             -99%               -99%        -99%         -99%               -99%        -99%          -99% 
  ADX:c_d insert+delete 150x1    2800/s                     2677%                     2677%                     2622%                       2538%                     2480%                       2458%                           --                       -17%              -87%              -88%              -88%              -89%                -90%                -91%              -92%              -92%                 -92%              -92%              -93%                 -93%                -93%                -94%               -94%              -95%               -95%              -95%              -96%              -96%                -97%                 -97%             -97%             -97%             -97%             -98%              -98%               -98%              -98%                -98%        -98%        -98%                -98%                 -98%              -98%                -98%               -98%               -98%              -98%                -99%                -99%               -99%          -99%           -99%             -99%              -99%             -99%             -99%              -99%             -99%               -99%        -99%         -99%               -99%        -99%          -99% 
  ADX:L insert+delete 150x1      3380/s                     3278%                     3278%                     3210%                       3109%                     3038%                       3011%                          21%                         --              -84%              -86%              -86%              -86%                -88%                -89%              -90%              -90%                 -90%              -91%              -91%                 -92%                -92%                -93%               -93%              -94%               -94%              -95%              -95%              -95%                -97%                 -97%             -97%             -97%             -97%             -97%              -97%               -97%              -97%                -97%        -97%        -98%                -98%                 -98%              -98%                -98%               -98%               -98%              -98%                -98%                -98%               -98%          -98%           -98%             -99%              -99%             -99%             -99%              -99%             -99%               -99%        -99%         -99%               -99%        -99%          -99% 
  AD:s insert 10x1              22000/s                    22122%                    22122%                    21677%                      21011%                    20544%                      20366%                         700%                       557%                --               -7%              -11%              -13%                -22%                -28%              -37%              -38%                 -40%              -42%              -45%                 -48%                -49%                -56%               -59%              -62%               -66%              -67%              -71%              -73%                -82%                 -82%             -83%             -83%             -83%             -84%              -84%               -85%              -85%                -85%        -86%        -87%                -89%                 -89%              -91%                -91%               -91%               -91%              -91%                -92%                -92%               -92%          -93%           -93%             -93%              -93%             -94%             -94%              -94%             -94%               -94%        -94%         -95%               -95%        -95%          -96% 
  AD:s delete 10x1              24100/s                    24054%                    24054%                    23571%                      22846%                    22339%                      22146%                         769%                       614%                8%                --               -3%               -5%                -15%                -22%              -32%              -33%                 -34%              -37%              -40%                 -44%                -45%                -52%               -56%              -58%               -63%              -64%              -68%              -71%                -81%                 -81%             -81%             -82%             -82%             -83%              -83%               -83%              -84%                -84%        -85%        -86%                -88%                 -88%              -90%                -90%               -90%               -90%              -90%                -91%                -91%               -91%          -92%           -92%             -93%              -93%             -93%             -93%              -94%             -94%               -94%        -94%         -94%               -95%        -95%          -95% 
  AD:d insert 10x1              25000/s                    24900%                    24900%                    24400%                      23650%                    23124%                      22925%                         800%                       640%               12%                3%                --               -2%                -13%                -19%              -30%              -31%                 -32%              -35%              -38%                 -42%                -43%                -51%               -54%              -57%               -62%              -63%              -67%              -70%                -80%                 -80%             -81%             -81%             -81%             -82%              -83%               -83%              -83%                -84%        -84%        -85%                -87%                 -87%              -90%                -90%               -90%               -90%              -90%                -91%                -91%               -91%          -92%           -92%             -93%              -93%             -93%             -93%              -93%             -94%               -94%        -94%         -94%               -94%        -94%          -95% 
  AD:d delete 10x1              26000/s                    25541%                    25541%                    25028%                      24258%                    23720%                      23515%                         823%                       658%               15%                6%                2%                --                -10%                -17%              -28%              -29%                 -30%              -34%              -36%                 -41%                -41%                -49%               -53%              -56%               -61%              -62%              -66%              -69%                -80%                 -80%             -80%             -81%             -81%             -82%              -82%               -82%              -83%                -83%        -84%        -85%                -87%                 -87%              -89%                -90%               -90%               -90%              -90%                -90%                -91%               -91%          -92%           -92%             -92%              -93%             -93%             -93%              -93%             -93%               -93%        -94%         -94%               -94%        -94%          -95% 
  AD:c_d insert 10x1            28700/s                    28635%                    28635%                    28060%                      27198%                    26595%                      26365%                         934%                       750%               29%               18%               14%               12%                  --                 -8%              -19%              -20%                 -22%              -26%              -29%                 -33%                -34%                -43%               -47%              -51%               -56%              -57%              -62%              -65%                -77%                 -77%             -78%             -78%             -78%             -80%              -80%               -80%              -81%                -81%        -82%        -83%                -85%                 -85%              -88%                -88%               -88%               -89%              -89%                -89%                -89%               -89%          -91%           -91%             -91%              -92%             -92%             -92%              -93%             -93%               -93%        -93%         -93%               -94%        -94%          -94% 
  AD:c_d delete 10x1            31000/s                    31150%                    31150%                    30525%                      29587%                    28931%                      28681%                        1025%                       825%               40%               29%               25%               21%                  8%                  --              -12%              -13%                 -15%              -19%              -22%                 -28%                -29%                -38%               -43%              -46%               -52%              -54%              -59%              -62%                -75%                 -75%             -76%             -76%             -77%             -78%              -78%               -79%              -79%                -80%        -81%        -82%                -84%                 -84%              -87%                -87%               -87%               -88%              -88%                -88%                -89%               -89%          -90%           -90%             -91%              -91%             -91%             -92%              -92%             -92%               -92%        -92%         -93%               -93%        -93%          -94% 
  AD:L insert 10x1              36000/s                    35614%                    35614%                    34900%                      33828%                    33078%                      32792%                        1185%                       957%               60%               47%               42%               39%                 24%                 14%                --               -1%                  -3%               -8%              -11%                 -17%                -18%                -30%               -35%              -39%               -45%              -47%              -53%              -57%                -72%                 -72%             -73%             -73%             -73%             -75%              -75%               -76%              -76%                -77%        -78%        -79%                -82%                 -82%              -85%                -86%               -86%               -86%              -86%                -87%                -87%               -87%          -88%           -89%             -90%              -90%             -90%             -91%              -91%             -91%               -91%        -91%         -92%               -92%        -92%          -93% 
  AD:L insert 10x1              36300/s                    36131%                    36131%                    35407%                      34320%                    33559%                      33269%                        1204%                       972%               63%               50%               44%               41%                 26%                 15%                1%                --                  -2%               -6%              -10%                 -16%                -17%                -28%               -34%              -38%               -44%              -46%              -52%              -56%                -71%                 -72%             -72%             -73%             -73%             -75%              -75%               -75%              -76%                -77%        -78%        -79%                -82%                 -82%              -85%                -85%               -86%               -86%              -86%                -87%                -87%               -87%          -88%           -88%             -89%              -90%             -90%             -90%              -91%             -91%               -91%        -91%         -92%               -92%        -92%          -93% 
  ADX:c_d insert 10x1           38000/s                    36937%                    36937%                    36196%                      35085%                    34307%                      34011%                        1233%                       996%               66%               53%               48%               44%                 28%                 18%                3%                2%                   --               -4%               -8%                 -14%                -15%                -27%               -32%              -37%               -43%              -45%              -51%              -55%                -71%                 -71%             -72%             -72%             -72%             -74%              -74%               -75%              -75%                -76%        -77%        -78%                -81%                 -81%              -85%                -85%               -85%               -85%              -86%                -86%                -87%               -87%          -88%           -88%             -89%              -89%             -90%             -90%              -91%             -91%               -91%        -91%         -92%               -92%        -92%          -93% 
  AD:L delete 10x1              38900/s                    38810%                    38810%                    38032%                      36864%                    36047%                      35736%                        1300%                      1051%               75%               61%               55%               51%                 35%                 24%                8%                7%                   5%                --               -3%                 -10%                -11%                -23%               -29%              -33%               -40%              -42%              -49%              -53%                -69%                 -70%             -70%             -71%             -71%             -73%              -73%               -73%              -74%                -75%        -76%        -77%                -80%                 -80%              -84%                -84%               -84%               -85%              -85%                -86%                -86%               -86%          -87%           -88%             -89%              -89%             -89%             -90%              -90%             -90%               -90%        -91%         -91%               -91%        -92%          -92% 
  AD:L delete 10x1              40400/s                    40385%                    40385%                    39576%                      38361%                    37511%                      37187%                        1357%                      1098%               82%               67%               61%               57%                 40%                 29%               13%               11%                   9%                4%                --                  -6%                 -8%                -20%               -26%              -31%               -38%              -40%              -47%              -51%                -68%                 -68%             -69%             -70%             -70%             -72%              -72%               -72%              -73%                -74%        -75%        -76%                -80%                 -80%              -83%                -84%               -84%               -84%              -84%                -85%                -85%               -85%          -87%           -87%             -88%              -89%             -89%             -89%              -90%             -90%               -90%        -90%         -91%               -91%        -91%          -92% 
  ADX:c_d delete 10x1           44000/s                    43378%                    43378%                    42508%                      41204%                    40291%                      39943%                        1465%                      1186%               95%               80%               73%               69%                 51%                 39%               21%               19%                  17%               11%                7%                   --                 -1%                -14%               -20%              -26%               -33%              -36%              -43%              -47%                -66%                 -66%             -67%             -67%             -68%             -70%              -70%               -70%              -71%                -72%        -73%        -75%                -78%                 -78%              -82%                -83%               -83%               -83%              -83%                -84%                -84%               -84%          -86%           -86%             -87%              -88%             -88%             -89%              -89%             -89%               -89%        -90%         -90%               -91%        -91%          -92% 
  AD:L_l insert 10x1            44000/s                    43952%                    43952%                    43071%                      41750%                    40825%                      40472%                        1485%                      1203%               98%               82%               76%               71%                 53%                 40%               23%               21%                  18%               13%                8%                   1%                  --                -13%               -19%              -25%               -33%              -35%              -42%              -47%                -65%                 -66%             -67%             -67%             -67%             -69%              -70%               -70%              -71%                -72%        -73%        -74%                -78%                 -78%              -82%                -82%               -82%               -83%              -83%                -84%                -84%               -84%          -86%           -86%             -87%              -88%             -88%             -88%              -89%             -89%               -89%        -89%         -90%               -90%        -91%          -92% 
  AD:L_l delete 10x1            51000/s                    50920%                    50920%                    49900%                      48369%                    47297%                      46889%                        1736%                      1410%              129%              111%              104%               98%                 77%                 63%               42%               40%                  37%               31%               26%                  17%                 15%                  --                -7%              -13%               -22%              -25%              -33%              -38%                -60%                 -60%             -61%             -62%             -62%             -64%              -65%               -65%              -66%                -67%        -69%        -70%                -74%                 -75%              -79%                -80%               -80%               -80%              -80%                -81%                -82%               -82%          -84%           -84%             -85%              -86%             -86%             -87%              -87%             -87%               -87%        -88%         -89%               -89%        -89%          -90% 
  ADX:L insert 10x1             55000/s                    54845%                    54845%                    53746%                      52097%                    50943%                      50504%                        1878%                      1526%              147%              127%              119%              114%                 91%                 75%               53%               51%                  48%               41%               35%                  26%                 24%                  7%                 --               -6%               -16%              -19%              -28%              -34%                -57%                 -57%             -58%             -59%             -59%             -62%              -62%               -63%              -64%                -65%        -66%        -68%                -72%                 -73%              -78%                -78%               -78%               -79%              -79%                -80%                -80%               -80%          -82%           -83%             -84%              -85%             -85%             -86%              -86%             -86%               -87%        -87%         -88%               -88%        -88%          -90% 
  AD:s insert 1x10              61000/s                    58723%                    58723%                    57547%                      55782%                    54547%                      54076%                        2017%                      1641%              164%              143%              135%              129%                104%                 88%               64%               62%                  58%               51%               45%                  35%                 33%                 15%                 7%                --               -10%              -13%              -23%              -29%                -54%                 -54%             -56%             -56%             -56%             -59%              -60%               -60%              -61%                -62%        -64%        -66%                -71%                 -71%              -76%                -77%               -77%               -77%              -77%                -79%                -79%               -79%          -81%           -81%             -83%              -84%             -84%             -85%              -85%             -85%               -86%        -86%         -87%               -87%        -88%          -89% 
  ADX:L delete 10x1             65700/s                    65689%                    65689%                    64373%                      62400%                    61018%                      60492%                        2268%                      1847%              196%              172%              163%              156%                128%                110%               84%               81%                  77%               69%               62%                  51%                 49%                 28%                19%               11%                 --               -3%              -14%              -21%                -48%                 -49%             -50%             -51%             -51%             -54%              -55%               -55%              -56%                -58%        -60%        -62%                -67%                 -67%              -73%                -74%               -74%               -74%              -75%                -76%                -76%               -76%          -79%           -79%             -81%              -82%             -82%             -83%              -84%             -84%               -84%        -84%         -86%               -86%        -86%          -88% 
  AD:d insert 1x10              68100/s                    67927%                    67927%                    66566%                      64525%                    63097%                      62553%                        2348%                      1913%              206%              181%              172%              165%                136%                117%               90%               87%                  83%               74%               68%                  56%                 54%                 33%                23%               15%                 3%                --              -11%              -18%                -46%                 -47%             -49%             -49%             -50%             -53%              -53%               -54%              -55%                -57%        -58%        -61%                -66%                 -66%              -72%                -73%               -73%               -74%              -74%                -75%                -76%               -76%          -78%           -79%             -80%              -81%             -82%             -82%              -83%             -83%               -83%        -84%         -85%               -85%        -86%          -87% 
  AD:s delete 1x10              76000/s                    76823%                    76823%                    75284%                      72976%                    71361%                      70746%                        2669%                      2176%              246%              218%              207%              200%                167%                146%              115%              112%                 107%               97%               90%                  76%                 74%                 50%                40%               30%                16%               13%                --               -7%                -40%                 -40%             -42%             -43%             -43%             -47%              -47%               -48%              -49%                -51%        -53%        -56%                -62%                 -62%              -69%                -70%               -70%               -70%              -71%                -72%                -73%               -73%          -76%           -76%             -78%              -79%             -80%             -80%              -81%             -81%               -81%        -82%         -83%               -84%        -84%          -86% 
  AD:d delete 1x10              81000/s                    83233%                    83233%                    81566%                      79066%                    77316%                      76650%                        2900%                      2366%              275%              244%              233%              225%                190%                166%              133%              129%                 125%              114%              105%                  91%                 89%                 63%                51%               41%                26%               22%                8%                --                -35%                 -35%             -37%             -38%             -38%             -42%              -43%               -44%              -45%                -47%        -49%        -52%                -58%                 -59%              -66%                -67%               -67%               -68%              -68%                -70%                -70%               -70%          -74%           -74%             -76%              -77%             -78%             -79%              -79%             -80%               -80%        -80%         -82%               -82%        -83%          -85% 
  AD:c_d insert 1x10           130000/s                   128105%                   128105%                   125541%                     121694%                   119002%                     117976%                        4515%                      3694%              476%              430%              412%              400%                346%                310%              258%              253%                 246%              229%              216%                 194%                191%                151%               133%              117%                94%               88%               66%               53%                  --                  -1%              -4%              -5%              -5%             -11%              -12%               -14%              -16%                -19%        -22%        -26%                -36%                 -37%              -48%                -50%               -50%               -51%              -51%                -54%                -55%               -55%          -60%           -60%             -64%              -65%             -66%             -67%              -69%             -69%               -69%        -70%         -73%               -73%        -73%          -76% 
  ADX:c_d insert 1x10          130000/s                   129770%                   129770%                   127172%                     123276%                   120549%                     119510%                        4575%                      3744%              484%              437%              419%              406%                351%                315%              263%              258%                 250%              233%              220%                 198%                194%                154%               136%              120%                97%               90%               68%               55%                  1%                   --              -2%              -3%              -4%             -10%              -11%               -13%              -14%                -18%        -21%        -25%                -35%                 -36%              -48%                -49%               -49%               -50%              -51%                -54%                -54%               -54%          -59%           -60%             -63%              -64%             -66%             -67%              -68%             -68%               -69%        -70%         -72%               -73%        -73%          -76% 
  AD:s delete 1x1              134000/s                   133589%                   133589%                   130916%                     126905%                   124097%                     123028%                        4712%                      3857%              501%              453%              434%              421%                365%                327%              274%              268%                 260%              243%              230%                 207%                203%                162%               143%              127%               103%               96%               73%               60%                  4%                   2%               --              -1%              -1%              -8%               -9%               -10%              -12%                -15%        -19%        -23%                -34%                 -34%              -46%                -47%               -48%               -49%              -49%                -52%                -53%               -53%          -58%           -58%             -62%              -63%             -65%             -66%              -67%             -67%               -68%        -69%         -71%               -72%        -72%          -75% 
  AD:d insert 1x1              140000/s                   135035%                   135035%                   132332%                     128278%                   125440%                     124359%                        4764%                      3899%              508%              459%              440%              427%                370%                332%              278%              272%                 264%              247%              233%                 210%                206%                164%               145%              129%               105%               98%               75%               62%                  5%                   4%               1%               --               0%              -7%               -8%                -9%              -11%                -14%        -18%        -22%                -33%                 -33%              -45%                -47%               -47%               -48%              -49%                -52%                -52%               -52%          -58%           -58%             -62%              -63%             -64%             -66%              -67%             -67%               -68%        -68%         -71%               -72%        -72%          -75% 
  AD:s insert 1x1              136000/s                   135954%                   135954%                   133233%                     129151%                   126294%                     125206%                        4797%                      3927%              512%              463%              444%              430%                373%                335%              280%              275%                 267%              249%              236%                 212%                208%                166%               147%              131%               106%              100%               76%               63%                  6%                   4%               1%               0%               --              -6%               -7%                -8%              -10%                -14%        -17%        -22%                -32%                 -33%              -45%                -47%               -47%               -48%              -48%                -51%                -52%               -52%          -57%           -58%             -61%              -63%             -64%             -65%              -67%             -67%               -67%        -68%         -71%               -71%        -72%          -75% 
  AD:d delete 1x1              145000/s                   145248%                   145248%                   142341%                     137981%                   134929%                     133766%                        5132%                      4202%              554%              501%              481%              466%                405%                365%              306%              301%                 292%              273%              259%                 234%                229%                184%               164%              147%               120%              113%               88%               74%                 13%                  11%               8%               7%               6%               --               -1%                -2%               -4%                 -8%        -12%        -17%                -28%                 -28%              -41%                -43%               -43%               -44%              -45%                -48%                -48%               -49%          -54%           -55%             -59%              -60%             -62%             -63%              -64%             -65%               -65%        -66%         -69%               -70%        -70%          -73% 
  AD:L insert 1x10             150000/s                   146958%                   146958%                   144017%                     139605%                   136517%                     135341%                        5194%                      4252%              561%              508%              488%              473%                411%                370%              311%              305%                 297%              277%              263%                 238%                233%                188%               167%              150%               123%              116%               91%               76%                 14%                  13%              10%               8%               8%               1%                --                -1%               -3%                 -7%        -11%        -16%                -27%                 -27%              -41%                -42%               -43%               -43%              -44%                -48%                -48%               -48%          -54%           -54%             -58%              -60%             -61%             -63%              -64%             -64%               -65%        -66%         -69%               -69%        -70%          -73% 
  ADX:L insert 1x10            149000/s                   149376%                   149376%                   146387%                     141902%                   138763%                     137568%                        5281%                      4324%              572%              518%              497%              482%                420%                378%              318%              312%                 303%              284%              269%                 243%                239%                192%               172%              154%               127%              119%               94%               79%                 16%                  15%              11%              10%               9%               2%                1%                 --               -2%                 -5%         -9%        -14%                -26%                 -26%              -40%                -41%               -42%               -43%              -43%                -47%                -47%               -47%          -53%           -54%             -58%              -59%             -61%             -62%              -63%             -64%               -64%        -65%         -68%               -69%        -69%          -73% 
  AD:L insert 1x10             153000/s                   152571%                   152571%                   149518%                     144938%                   141732%                     140510%                        5396%                      4419%              587%              532%              510%              495%                431%                388%              327%              321%                 312%              292%              277%                 251%                246%                199%               177%              159%               132%              124%               98%               83%                 19%                  17%              14%              12%              12%               5%                3%                 2%                --                 -3%         -7%        -12%                -24%                 -25%              -38%                -40%               -41%               -41%              -42%                -46%                -46%               -46%          -52%           -53%             -57%              -58%             -60%             -61%              -63%             -63%               -63%        -64%         -67%               -68%        -68%          -72% 
  AD:L_l insert 1x10           158000/s                   158378%                   158378%                   155209%                     150454%                   147126%                     145858%                        5605%                      4590%              613%              556%              533%              518%                451%                407%              343%              337%                 327%              307%              291%                 264%                259%                210%               188%              169%               140%              132%              106%               90%                 23%                  22%              18%              17%              16%               9%                7%                 6%                3%                  --         -4%         -9%                -21%                 -22%              -36%                -38%               -38%               -39%              -40%                -44%                -44%               -44%          -50%           -51%             -55%              -57%             -58%             -60%              -61%             -61%               -62%        -63%         -66%               -67%        -67%          -71% 
  AD:s empty                   166000/s                   165462%                   165462%                   162151%                     157184%                   153707%                     152383%                        5860%                      4800%              645%              585%              562%              545%                476%                429%              363%              356%                 347%              325%              308%                 280%                275%                224%               201%              181%               151%              143%              115%               98%                 29%                  27%              23%              22%              21%              13%               12%                10%                8%                  4%          --         -5%                -18%                 -18%              -33%                -35%               -36%               -36%              -37%                -41%                -41%               -42%          -48%           -49%             -53%              -55%             -56%             -58%              -60%             -60%               -60%        -61%         -65%               -65%        -66%          -70% 
  AD:d empty                   180000/s                   175338%                   175338%                   171829%                     166566%                   162882%                     161478%                        6215%                      5092%              689%              626%              601%              584%                510%                461%              391%              384%                 373%              350%              333%                 303%                298%                243%               219%              198%               166%              157%              128%              110%                 36%                  35%              31%              29%              28%              20%               19%                17%               14%                 10%          5%          --                -13%                 -14%              -29%                -31%               -32%               -33%              -34%                -38%                -38%               -38%          -45%           -46%             -50%              -52%             -54%             -56%              -57%             -57%               -58%        -59%         -63%               -63%        -64%          -68% 
  AD:c_d delete 1x10           203000/s                   202739%                   202739%                   198682%                     192597%                   188338%                     186715%                        7202%                      5904%              812%              739%              711%              691%                605%                549%              467%              459%                 447%              421%              401%                 366%                360%                297%               269%              244%               208%              198%              163%              143%                 58%                  56%              51%              50%              49%              39%               37%                35%               32%                 27%         22%         15%                  --                   0%              -18%                -21%               -21%               -22%              -23%                -28%                -28%               -29%          -37%           -37%             -43%              -45%             -47%             -49%              -51%             -51%               -52%        -53%         -57%               -58%        -58%          -63% 
  ADX:c_d delete 1x10          204000/s                   203981%                   203981%                   199900%                     193777%                   189491%                     187859%                        7246%                      5940%              818%              744%              716%              695%                610%                553%              471%              463%                 451%              424%              404%                 369%                363%                300%               271%              246%               210%              200%              165%              144%                 59%                  57%              52%              51%              50%              40%               38%                36%               33%                 28%         23%         16%                  0%                   --              -18%                -20%               -21%               -22%              -23%                -27%                -28%               -28%          -36%           -37%             -42%              -44%             -46%             -48%              -50%             -51%               -51%        -53%         -57%               -57%        -58%          -63% 
  AD:L delete 1x10             250000/s                   249900%                   249900%                   244900%                     237400%                   232149%                     230150%                        8900%                      7300%             1025%              935%              900%              875%                769%                700%              600%              590%                 575%              542%              517%                 475%                467%                389%               355%              325%               280%              267%              225%              200%                 95%                  92%              86%              85%              83%              72%               70%                67%               63%                 57%         51%         42%                 23%                  22%                --                 -2%                -3%                -4%               -6%                -11%                -12%               -12%          -22%           -23%             -30%              -32%             -35%             -37%              -39%             -40%               -41%        -42%         -47%               -48%        -49%          -55% 
  ADX:c_d insert 1x1           257000/s                   256969%                   256969%                   251828%                     244115%                   238717%                     236660%                        9154%                      7509%             1056%              964%              928%              902%                794%                722%              619%              609%                 594%              560%              534%                 491%                483%                403%               367%              337%               290%              277%              234%              208%                100%                  97%              92%              90%              88%              76%               74%                71%               68%                 62%         55%         46%                 26%                  25%                2%                  --                 0%                -2%               -3%                 -9%                 -9%               -10%          -20%           -21%             -28%              -30%             -33%             -35%              -38%             -38%               -39%        -40%         -46%               -47%        -47%          -53% 
  ADX:L delete 1x10            259000/s                   258967%                   258967%                   253786%                     246013%                   240573%                     238501%                        9226%                      7568%             1065%              972%              936%              910%                801%                729%              625%              615%                 599%              565%              539%                 495%                488%                407%               371%              340%               293%              280%              236%              210%                102%                  99%              93%              91%              90%              78%               76%                73%               69%                 63%         56%         47%                 27%                  26%                3%                  0%                 --                -1%               -2%                 -8%                 -9%                -9%          -19%           -20%             -27%              -29%             -32%             -35%              -37%             -37%               -38%        -40%         -45%               -46%        -47%          -53% 
  AD:c_d insert 1x1            262000/s                   262367%                   262367%                   257117%                     249243%                   243732%                     241632%                        9348%                      7669%             1081%              986%              949%              923%                813%                739%              634%              624%                 608%              574%              548%                 503%                495%                414%               377%              346%               298%              285%              241%              214%                104%                 102%              96%              94%              92%              80%               78%                75%               71%                 65%         58%         49%                 29%                  28%                4%                  2%                 1%                 --               -1%                 -7%                 -7%                -8%          -18%           -19%             -26%              -28%             -31%             -34%              -36%             -37%               -38%        -39%         -44%               -45%        -46%          -52% 
  AD:L delete 1x10             267000/s                   266566%                   266566%                   261233%                     253233%                   247633%                     245500%                        9500%                      7793%             1100%             1004%              966%              940%                827%                753%              646%              636%                 620%              585%              558%                 513%                505%                422%               385%              353%               305%              292%              246%              220%                108%                 105%              99%              97%              96%              83%               81%                78%               74%                 68%         61%         52%                 31%                  30%                6%                  3%                 2%                 1%                --                 -5%                 -6%                -6%          -17%           -18%             -25%              -27%             -30%             -33%              -35%             -36%               -37%        -38%         -44%               -45%        -45%          -52% 
  ADX:c_d delete 1x1           284000/s                   283186%                   283186%                   277520%                     269021%                   263072%                     260806%                       10098%                      8285%             1174%             1072%             1033%             1004%                885%                806%              693%              681%                 664%              628%              599%                 551%                543%                455%               415%              381%               330%              316%              268%              239%                120%                 118%             111%             109%             108%              94%               92%                89%               85%                 78%         71%         61%                 39%                  38%               13%                 10%                 9%                 7%                6%                  --                  0%                 0%          -12%           -13%             -20%              -23%             -26%             -29%              -31%             -32%               -33%        -34%         -40%               -41%        -42%          -49% 
  AD:L_l delete 1x10           285000/s                   284800%                   284800%                   279102%                     270555%                   264572%                     262293%                       10156%                      8333%             1182%             1079%             1039%             1011%                891%                811%              697%              686%                 669%              632%              603%                 555%                546%                458%               418%              384%               333%              318%              270%              241%                122%                 119%             113%             110%             109%              96%               93%                90%               86%                 79%         72%         62%                 40%                  39%               13%                 10%                 9%                 8%                6%                  0%                  --                 0%          -11%           -12%             -20%              -22%             -25%             -28%              -31%             -31%               -32%        -34%         -40%               -41%        -41%          -48% 
  AD:c_d delete 1x1            290000/s                   285614%                   285614%                   279900%                     271328%                   265328%                     263042%                       10185%                      8357%             1185%             1082%             1042%             1014%                894%                814%              700%              688%                 671%              634%              605%                 557%                548%                459%               420%              385%               334%              320%              271%              242%                122%                 120%             113%             111%             110%              96%               94%                91%               87%                 80%         72%         62%                 40%                  39%               14%                 11%                10%                 8%                7%                  0%                  0%                 --          -11%           -12%             -20%              -22%             -25%             -28%              -31%             -31%               -32%        -34%         -40%               -41%        -41%          -48% 
  AD:c_d empty                 330000/s                   322480%                   322480%                   316029%                     306351%                   299577%                     296996%                       11512%                      9448%             1351%             1235%             1190%             1158%               1022%                932%              803%              790%                 770%              729%              696%                 641%                632%                532%               487%              448%               390%              374%              319%              287%                151%                 148%             141%             138%             137%             121%              119%               115%              111%                103%         94%         83%                 59%                  58%               29%                 25%                24%                22%               20%                 13%                 13%                12%            --             0%              -9%              -12%             -16%             -19%              -22%             -22%               -23%        -25%         -32%               -33%        -34%          -41% 
  ADX:c_d empty                326000/s                   325632%                   325632%                   319118%                     309346%                   302505%                     299900%                       11626%                      9541%             1365%             1248%             1202%             1170%               1033%                942%              812%              799%                 779%              737%              704%                 649%                639%                538%               492%              453%               395%              378%              323%              290%                154%                 150%             143%             141%             139%             124%              121%               117%              113%                105%         96%         85%                 60%                  59%               30%                 26%                25%                24%               22%                 14%                 14%                14%            0%             --              -8%              -11%             -15%             -18%              -21%             -21%               -23%        -25%         -31%               -32%        -33%          -41% 
  AD:L insert 1x1              360000/s                   357042%                   357042%                   349900%                     339185%                   331685%                     328828%                       12757%                     10471%             1507%             1378%             1328%             1292%               1142%               1042%              900%              885%                 864%              817%              782%                 721%                710%                600%               550%              507%               442%              425%              364%              328%                178%                 175%             167%             164%             162%             145%              142%               138%              133%                125%        115%        103%                 76%                  75%               42%                 38%                37%                36%               33%                 26%                 25%                25%           10%             9%               --               -3%              -7%             -10%              -13%             -14%               -15%        -17%         -25%               -26%        -27%          -35% 
  ADX:L insert 1x1             370000/s                   368903%                   368903%                   361523%                     350453%                   342704%                     339752%                       13184%                     10822%             1560%             1427%             1376%             1339%               1184%               1080%              933%              918%                 896%              848%              811%                 748%                737%                623%               571%              527%               460%              442%              379%              342%                187%                 184%             176%             173%             171%             153%              150%               146%              141%                132%        122%        110%                 81%                  80%               47%                 43%                42%                40%               38%                 30%                 29%                29%           14%            13%               3%                --              -4%              -7%              -11%             -11%               -12%        -15%         -22%               -23%        -24%          -33% 
  AD:L insert 1x1              385000/s                   384515%                   384515%                   376823%                     365284%                   357207%                     354130%                       13746%                     11284%             1630%             1492%             1438%             1400%               1238%               1130%              976%              961%                 938%              888%              850%                 784%                773%                653%               600%              553%               484%              465%              400%              361%                200%                 196%             187%             184%             182%             164%              161%               157%              151%                142%        132%        119%                 89%                  88%               53%                 49%                48%                46%               44%                 35%                 35%                34%           19%            18%               7%                4%               --              -3%               -7%              -7%                -9%        -11%         -19%               -20%        -21%          -30% 
  AD:L delete 1x1              400000/s                   399900%                   399900%                   391900%                     379900%                   371499%                     368300%                       14300%                     11740%             1700%             1555%             1500%             1460%               1291%               1180%             1019%             1003%                 979%              927%              887%                 819%                808%                684%               628%              580%               508%              488%              419%              380%                211%                 208%             199%             196%             194%             175%              171%               167%              162%                152%        141%        128%                 97%                  96%               60%                 55%                54%                52%               50%                 41%                 40%                39%           24%            22%              11%                8%               4%               --               -3%              -4%                -5%         -8%         -16%               -17%        -18%          -28% 
  ADX:L delete 1x1             416000/s                   414837%                   414837%                   406539%                     394090%                   385377%                     382057%                       14837%                     12182%             1767%             1617%             1559%             1518%               1343%               1227%             1061%             1045%                1020%              966%              924%                 854%                841%                713%               655%              605%               530%              509%              439%              397%                223%                 219%             210%             207%             204%             185%              182%               177%              171%                161%        150%        136%                104%                 103%               65%                 61%                60%                58%               55%                 46%                 45%                45%           28%            27%              16%               12%               7%               3%                --               0%                -2%         -4%         -12%               -14%        -15%          -25% 
  AD:L delete 1x1              420000/s                   416566%                   416566%                   408233%                     395733%                   386983%                     383650%                       14900%                     12233%             1775%             1625%             1566%             1525%               1350%               1233%             1066%             1050%                1025%              970%              929%                 858%                845%                716%               658%              608%               533%              512%              441%              400%                225%                 220%             211%             208%             206%             186%              183%               178%              172%                162%        151%        137%                105%                 104%               66%                 62%                60%                58%               56%                 47%                 46%                45%           29%            27%              16%               12%               8%               4%                0%               --                -1%         -4%         -12%               -14%        -14%          -25% 
  AD:L_l insert 1x1            424000/s                   423628%                   423628%                   415154%                     402442%                   393544%                     390154%                       15154%                     12442%             1806%             1654%             1594%             1552%               1374%               1255%             1086%             1069%                1044%              988%              946%                 874%                861%                730%               671%              620%               544%              522%              450%              408%                230%                 226%             216%             213%             211%             191%              188%               183%              177%                167%        155%        141%                108%                 107%               69%                 64%                63%                61%               58%                 49%                 48%                48%           31%            30%              18%               14%              10%               5%                2%               1%                 --         -2%         -11%               -12%        -13%          -23% 
  AD:L empty                   440000/s                   434682%                   434682%                   425986%                     412943%                   403813%                     400334%                       15552%                     12769%             1856%             1700%             1639%             1595%               1413%               1291%             1117%             1100%                1073%             1017%              973%                 900%                886%                752%               691%              639%               560%              539%              465%              421%                239%                 234%             225%             221%             219%             199%              195%               190%              184%                174%        162%        147%                114%                 113%               73%                 69%                67%                65%               63%                 53%                 52%                52%           34%            33%              21%               17%              13%               8%                4%               4%                 2%          --          -8%               -10%        -11%          -21% 
  ADX:L empty                  470000/s                   476090%                   476090%                   466566%                     452280%                   442280%                     438471%                       17042%                     13995%             2042%             1871%             1804%             1757%               1557%               1423%             1233%             1214%                1185%             1123%             1076%                 995%                980%                833%               766%              709%               623%              600%              519%              471%                271%                 266%             256%             252%             250%             227%              223%               218%              211%                200%        187%        171%                134%                 133%               90%                 85%                83%                81%               78%                 68%                 67%                66%           47%            46%              33%               29%              23%              19%               14%              14%                12%          9%           --                -1%         -2%          -14% 
  AD:L_l delete 1x1            485000/s                   485336%                   485336%                   475628%                     461065%                   450870%                     446987%                       17375%                     14268%             2084%             1909%             1841%             1793%               1589%               1453%             1259%             1239%                1210%             1147%             1099%                1016%               1001%                851%               783%              725%               637%              613%              531%              482%                278%                 273%             263%             259%             256%             233%              230%               224%              217%                206%        193%        176%                139%                 137%               94%                 88%                87%                84%               82%                 71%                 70%                69%           50%            49%              35%               31%              26%              21%               16%              16%                14%         11%           1%                 --          0%          -12% 
  AD:L empty                   490000/s                   490096%                   490096%                   480292%                     465586%                   455292%                     451370%                       17547%                     14409%             2105%             1929%             1860%             1811%               1605%               1468%             1272%             1252%                1223%             1159%             1110%                1027%               1012%                860%               792%              733%               645%              620%              537%              488%                282%                 277%             266%             262%             260%             237%              233%               227%              221%                209%        196%        179%                141%                 140%               96%                 90%                89%                86%               83%                 73%                 72%                71%           51%            50%              37%               32%              27%              22%               18%              17%                15%         12%           2%                 0%          --          -11% 
  AD:L_l empty                 556000/s                   555455%                   555455%                   544344%                     527677%                   516011%                     511566%                       19900%                     16344%             2400%             2200%             2122%             2066%               1833%               1677%             1455%             1433%                1400%             1327%             1272%                1177%               1161%                988%               911%              844%               744%              716%              622%              566%                333%                 327%             315%             311%             308%             282%              277%               271%              263%                250%        235%        216%                173%                 172%              122%                116%               114%               111%              108%                 96%                 95%                94%           72%            70%              55%               50%              44%              38%               33%              33%                31%         27%          16%                14%         13%            -- 
 
 Legends:
   AD:L delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::LCSidx
   AD:L delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::LCS
   AD:L delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::LCS
   AD:L empty: dataset=empty participant=Algorithm::Diff::LCS
   AD:L insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::LCS
   AD:L insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::LCS
   AD:L insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::LCS
   AD:L insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::LCS
   AD:L_l delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::LCS_length
   AD:L_l delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::LCS_length
   AD:L_l delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::LCS_length
   AD:L_l empty: dataset=empty participant=Algorithm::Diff::LCS_length
   AD:L_l insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::LCS_length
   AD:L_l insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::LCS_length
   AD:L_l insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::LCS_length
   AD:L_l insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::LCS_length
   AD:c_d delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::compact_diff
   AD:c_d delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::compact_diff
   AD:c_d delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::compact_diff
   AD:c_d empty: dataset=empty participant=Algorithm::Diff::compact_diff
   AD:c_d insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::compact_diff
   AD:c_d insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::compact_diff
   AD:c_d insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::compact_diff
   AD:c_d insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::compact_diff
   AD:d delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::diff
   AD:d delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::diff
   AD:d delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::diff
   AD:d empty: dataset=empty participant=Algorithm::Diff::diff
   AD:d insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::diff
   AD:d insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::diff
   AD:d insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::diff
   AD:d insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::diff
   AD:s delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::sdiff
   AD:s delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::sdiff
   AD:s delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::sdiff
   AD:s empty: dataset=empty participant=Algorithm::Diff::sdiff
   AD:s insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::sdiff
   AD:s insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::sdiff
   AD:s insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::sdiff
   AD:s insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::sdiff
   ADX:L delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:L delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:L delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::XS::LCSidx
   ADX:L empty: dataset=empty participant=Algorithm::Diff::XS::LCSidx
   ADX:L insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:L insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:L insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::XS::LCSidx
   ADX:L insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:c_d delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d empty: dataset=empty participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::XS::compact_diff

=head2 Sample benchmark #2

Benchmark command (benchmarking module startup overhead):

 % bencher -m Algorithm::Diff::Diff --module-startup

Result formatted as table:

 #table2#
 +---------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | participant         | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +---------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | Algorithm::Diff::XS |     20    |             13.85 |                 0.00% |               187.29% |   0.00026 |      20 |
 | Algorithm::Diff     |     12    |              5.85 |                48.08% |                94.02% | 5.7e-05   |      20 |
 | perl -e1 (baseline) |      6.15 |              0    |               187.29% |                 0.00% |   6e-06   |      20 |
 +---------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

                          Rate  AD:X   A:D  perl -e1 (baseline) 
  AD:X                  50.0/s    --  -40%                 -69% 
  A:D                   83.3/s   66%    --                 -48% 
  perl -e1 (baseline)  162.6/s  225%   95%                   -- 
 
 Legends:
   A:D: mod_overhead_time=5.85 participant=Algorithm::Diff
   AD:X: mod_overhead_time=13.85 participant=Algorithm::Diff::XS
   perl -e1 (baseline): mod_overhead_time=0 participant=perl -e1 (baseline)

To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-ScenarioBundle-Algorithm-Diff>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Algorithm-Diff>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023, 2017 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-ScenarioBundle-Algorithm-Diff>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
